/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.png;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.image.png.TextReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class TextualChunks
extends Metadata {
    private Queue<Chunk> queue;
    private List<Chunk> chunks;
    private Map<String, String> keyValMap;

    public TextualChunks() {
        super(MetadataType.PNG_TEXTUAL);
        this.queue = new LinkedList<Chunk>();
        this.chunks = new ArrayList<Chunk>();
        this.keyValMap = new HashMap<String, String>();
    }

    public TextualChunks(Collection<Chunk> chunks) {
        super(MetadataType.PNG_TEXTUAL);
        TextualChunks.validateChunks(chunks);
        this.queue = new LinkedList<Chunk>(chunks);
        this.chunks = new ArrayList<Chunk>();
        this.keyValMap = new HashMap<String, String>();
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>(this.chunks);
        chunkList.addAll(this.queue);
        return chunkList;
    }

    public Map<String, String> getKeyValMap() {
        this.ensureDataRead();
        return Collections.unmodifiableMap(this.keyValMap);
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        this.ensureDataRead();
        ArrayList<MetadataEntry> entries = new ArrayList<MetadataEntry>();
        for (Map.Entry<String, String> entry : this.keyValMap.entrySet()) {
            entries.add(new MetadataEntry(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableCollection(entries).iterator();
    }

    public void addChunk(Chunk chunk) {
        TextualChunks.validateChunkType(chunk.getChunkType());
        this.queue.offer(chunk);
    }

    @Override
    public void read() throws IOException {
        if (this.queue.size() > 0) {
            TextReader reader = new TextReader();
            for (Chunk chunk : this.queue) {
                reader.setInput(chunk);
                String key = reader.getKeyword();
                String text = reader.getText();
                String oldText = this.keyValMap.get(key);
                this.keyValMap.put(key, oldText == null ? text : oldText + "; " + text);
                this.chunks.add(chunk);
            }
            this.queue.clear();
        }
    }

    private static void validateChunks(Collection<Chunk> chunks) {
        for (Chunk chunk : chunks) {
            TextualChunks.validateChunkType(chunk.getChunkType());
        }
    }

    private static void validateChunkType(ChunkType chunkType) {
        if (chunkType != ChunkType.TEXT && chunkType != ChunkType.ITXT && chunkType != ChunkType.ZTXT) {
            throw new IllegalArgumentException("Expect Textual chunk!");
        }
    }
}

