/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.meta.xmp;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataEntry;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.string.XMLUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class XMP
extends Metadata {
    private Document xmpDocument;
    private Document extendedXmpDocument;
    private Document mergedXmpDocument;
    private boolean hasExtendedXmp;
    private byte[] extendedXmpData;
    private String xmp;

    public static void showXMP(XMP xmp) {
        XMLUtils.showXML(xmp.getMergedDocument());
    }

    public XMP(byte[] data) {
        super(MetadataType.XMP, ArrayUtils.trim(data));
    }

    public XMP(String xmp) {
        this(xmp, null);
    }

    public XMP(String xmp, String extendedXmp) {
        super(MetadataType.XMP);
        if (xmp == null) {
            throw new IllegalArgumentException("Input XMP string is null");
        }
        this.xmp = xmp;
        if (extendedXmp != null) {
            try {
                this.setExtendedXMPData(XMLUtils.serializeToByteArray(XMLUtils.createXML(extendedXmp)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public byte[] getData() {
        byte[] data = super.getData();
        if (data != null && !this.hasExtendedXmp) {
            return data;
        }
        try {
            return XMLUtils.serializeToByteArray(this.getMergedDocument());
        }
        catch (IOException e) {
            return null;
        }
    }

    public byte[] getExtendedXmpData() {
        return this.extendedXmpData;
    }

    public Document getExtendedXmpDocument() {
        if (this.hasExtendedXmp && this.extendedXmpDocument == null) {
            this.extendedXmpDocument = XMLUtils.createXML(this.extendedXmpData);
        }
        return this.extendedXmpDocument;
    }

    public Document getMergedDocument() {
        if (this.mergedXmpDocument != null) {
            return this.mergedXmpDocument;
        }
        if (this.getExtendedXmpDocument() != null) {
            this.mergedXmpDocument = XMLUtils.createDocumentNode();
            Document rootDoc = this.getXmpDocument();
            NodeList children = rootDoc.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node importedNode = this.mergedXmpDocument.importNode(children.item(i), true);
                this.mergedXmpDocument.appendChild(importedNode);
            }
            XMLUtils.removeAttribute(this.mergedXmpDocument, "rdf:Description", "xmpNote:HasExtendedXMP");
            NodeList list = this.extendedXmpDocument.getElementsByTagName("rdf:RDF").item(0).getChildNodes();
            Element rdf = (Element)this.mergedXmpDocument.getElementsByTagName("rdf:RDF").item(0);
            for (int i = 0; i < list.getLength(); ++i) {
                Node curr = list.item(i);
                Node newNode = this.mergedXmpDocument.importNode(curr, true);
                rdf.appendChild(newNode);
            }
            return this.mergedXmpDocument;
        }
        return this.getXmpDocument();
    }

    public Document getXmpDocument() {
        this.ensureDataRead();
        return this.xmpDocument;
    }

    public boolean hasExtendedXmp() {
        return this.hasExtendedXmp;
    }

    @Override
    public Iterator<MetadataEntry> iterator() {
        Document doc = this.getMergedDocument();
        MetadataEntry dummy = new MetadataEntry("XMP", " Document", true);
        this.addNodeToEntry(doc, dummy);
        return Collections.unmodifiableCollection(dummy.getMetadataEntries()).iterator();
    }

    private void addNodeToEntry(Node node, MetadataEntry entry) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 9: {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this.addNodeToEntry(child, entry);
                    }
                    break;
                }
                case 10: {
                    DocumentType doctype = (DocumentType)node;
                    entry.addEntry(new MetadataEntry("!DOCTYPE", doctype.getName()));
                    break;
                }
                case 1: {
                    Element ele = (Element)node;
                    NamedNodeMap attrs = ele.getAttributes();
                    StringBuilder attributes = new StringBuilder();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node a = attrs.item(i);
                        attributes.append(a.getNodeName()).append("=").append("'" + a.getNodeValue()).append("' ");
                    }
                    MetadataEntry element = new MetadataEntry(ele.getTagName(), attributes.toString().trim(), true);
                    entry.addEntry(element);
                    for (Node child = ele.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this.addNodeToEntry(child, element);
                    }
                    break;
                }
                case 3: {
                    Text textNode = (Text)node;
                    String text = textNode.getData().trim();
                    if (text == null || text.length() <= 0) break;
                    entry.addEntry(new MetadataEntry(text, ""));
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    entry.addEntry(new MetadataEntry("?" + pi.getTarget(), pi.getData() + "?"));
                    break;
                }
                case 5: {
                    entry.addEntry(new MetadataEntry("&" + node.getNodeName() + ";", ""));
                    break;
                }
                case 4: {
                    CDATASection cdata = (CDATASection)node;
                    entry.addEntry(new MetadataEntry("![CDATA[" + cdata.getData() + "]]", ""));
                    break;
                }
                case 8: {
                    Comment c = (Comment)node;
                    entry.addEntry(new MetadataEntry("!--" + c.getData() + "--", ""));
                    break;
                }
            }
        }
    }

    @Override
    public void read() throws IOException {
        if (!this.isDataRead) {
            if (this.xmp != null) {
                this.xmpDocument = XMLUtils.createXML(this.xmp);
            } else if (this.data != null) {
                this.xmpDocument = XMLUtils.createXML(this.data);
            }
            this.isDataRead = true;
        }
    }

    public void setExtendedXMPData(byte[] extendedXmpData) {
        this.extendedXmpData = extendedXmpData;
        this.hasExtendedXmp = true;
    }

    @Override
    public abstract void write(OutputStream var1) throws IOException;
}

