/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.options;

import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.options.ImageOptions;
import guilibshadow.cafe4j.image.tiff.TiffFieldEnum;
import guilibshadow.cafe4j.io.ByteOrder;

public class TIFFOptions
extends ImageOptions {
    private boolean isApplyPredictor;
    private TiffFieldEnum.Compression tiffCompression = TiffFieldEnum.Compression.PACKBITS;
    private TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.UNKNOWN;
    private TiffFieldEnum.ResolutionUnit resolutionUnit = TiffFieldEnum.ResolutionUnit.RESUNIT_INCH;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int defalteCompressionLevel = 4;
    private boolean writeICCProfile;
    private int jpegQuality = 90;
    private int xResolution = 72;
    private int yResolution = 72;

    public TIFFOptions() {
    }

    public TIFFOptions(TIFFOptions options) {
        this.isApplyPredictor = options.isApplyPredictor;
        this.tiffCompression = options.tiffCompression;
        this.photoMetric = options.photoMetric;
        this.resolutionUnit = options.resolutionUnit;
        this.byteOrder = options.byteOrder;
        this.defalteCompressionLevel = options.defalteCompressionLevel;
        this.writeICCProfile = options.writeICCProfile;
        this.jpegQuality = options.jpegQuality;
        this.xResolution = options.xResolution;
        this.yResolution = options.yResolution;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getDeflateCompressionLevel() {
        return this.defalteCompressionLevel;
    }

    @Override
    public ImageType getImageType() {
        return ImageType.TIFF;
    }

    public int getJPEGQuality() {
        return this.jpegQuality;
    }

    public TiffFieldEnum.PhotoMetric getPhotoMetric() {
        return this.photoMetric;
    }

    public TiffFieldEnum.Compression getTiffCompression() {
        return this.tiffCompression;
    }

    public TiffFieldEnum.ResolutionUnit getResolutionUnit() {
        return this.resolutionUnit;
    }

    public int getXResolution() {
        return this.xResolution;
    }

    public int getYResolution() {
        return this.yResolution;
    }

    public boolean isApplyPredictor() {
        return this.isApplyPredictor;
    }

    public boolean writeICCProfile() {
        return this.writeICCProfile;
    }

    public void setApplyPredictor(boolean isApplyPredictor) {
        this.isApplyPredictor = isApplyPredictor;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setDeflateCompressionLevel(int deflateCompressionLevel) {
        if (deflateCompressionLevel >= 0 && deflateCompressionLevel <= 9) {
            this.defalteCompressionLevel = deflateCompressionLevel;
        }
    }

    public void setJPEGQuality(int quality) {
        this.jpegQuality = quality;
    }

    public void setPhotoMetric(TiffFieldEnum.PhotoMetric photoMetric) {
        this.photoMetric = photoMetric;
    }

    public void setResolutionUnit(TiffFieldEnum.ResolutionUnit resolutionUnit) {
        this.resolutionUnit = resolutionUnit;
    }

    public void setTiffCompression(TiffFieldEnum.Compression tiffCompression) {
        this.tiffCompression = tiffCompression;
    }

    public void setWriteICCProfile(boolean writeICCProfile) {
        this.writeICCProfile = writeICCProfile;
    }

    public void setXResolution(int xResolution) {
        if (xResolution > 0) {
            this.xResolution = xResolution;
        }
    }

    public void setYResolution(int yResolution) {
        if (yResolution > 0) {
            this.yResolution = yResolution;
        }
    }
}

