/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.cafe4j.util.LangUtils;
import guilibshadow.cafe4j.util.zip.CRC32;
import java.io.IOException;
import java.io.OutputStream;

public class Chunk
implements Comparable<Chunk> {
    private final long length;
    private final ChunkType chunkType;
    private final byte[] data;
    private final long crc;

    @Override
    public int compareTo(Chunk that) {
        return this.chunkType.getRanking() - that.chunkType.getRanking();
    }

    public Chunk(ChunkType chunkType, long length, byte[] data, long crc) {
        this.length = length;
        this.chunkType = chunkType;
        this.data = data;
        this.crc = crc;
    }

    public ChunkType getChunkType() {
        return this.chunkType;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public long getCRC() {
        return this.crc;
    }

    public boolean isValidCRC() {
        return Chunk.calculateCRC(this.chunkType.getValue(), this.data) == this.crc;
    }

    public void write(OutputStream os) throws IOException {
        IOUtils.writeIntMM(os, (int)this.length);
        IOUtils.writeIntMM(os, this.chunkType.getValue());
        IOUtils.write(os, this.data);
        IOUtils.writeIntMM(os, (int)this.crc);
    }

    public String toString() {
        return this.chunkType.toString();
    }

    public boolean equals(Object that) {
        long otherCRC;
        if (!(that instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)that;
        long thisCRC = Chunk.calculateCRC(this.getChunkType().getValue(), this.getData());
        return thisCRC == (otherCRC = Chunk.calculateCRC(other.getChunkType().getValue(), other.getData()));
    }

    public int hashCode() {
        return LangUtils.longToIntHashCode(Chunk.calculateCRC(this.getChunkType().getValue(), this.getData()));
    }

    public static long calculateCRC(int chunkValue, byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(ArrayUtils.toByteArrayMM(chunkValue));
        crc32.update(data);
        return crc32.getValue();
    }

    public static long calculateCRC(int chunkValue, byte[] data, int offset, int length) {
        CRC32 crc32 = new CRC32();
        crc32.update(ArrayUtils.toByteArrayMM(chunkValue));
        crc32.update(data, offset, length);
        return crc32.getValue();
    }
}

