/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import java.util.HashMap;
import java.util.Map;

public enum ChunkType {
    IHDR("IHDR", 1229472850, Attribute.CRITICAL, 1),
    IDAT("IDAT", 1229209940, Attribute.CRITICAL, 60),
    IEND("IEND", 1229278788, Attribute.CRITICAL, 100),
    PLTE("PLTE", 1347179589, Attribute.CRITICAL, 40),
    TEXT("tEXt", 1950701684, Attribute.ANCILLARY, 20),
    ZTXT("zTXt", 2052348020, Attribute.ANCILLARY, 20),
    ITXT("iTXt", 1767135348, Attribute.ANCILLARY, 20),
    TRNS("tRNS", 1951551059, Attribute.ANCILLARY, 50),
    GAMA("gAMA", 1732332865, Attribute.ANCILLARY, 30),
    CHRM("cHRM", 1665684045, Attribute.ANCILLARY, 30),
    SRGB("sRGB", 1934772034, Attribute.ANCILLARY, 30),
    ICCP("iCCP", 1766015824, Attribute.ANCILLARY, 30),
    BKGD("bKGD", 1649100612, Attribute.ANCILLARY, 50),
    PHYS("pHYs", 1883789683, Attribute.ANCILLARY, 30),
    SBIT("sBIT", 1933723988, Attribute.ANCILLARY, 30),
    SPLT("sPLT", 1934642260, Attribute.ANCILLARY, 30),
    HIST("hIST", 1749635924, Attribute.ANCILLARY, 50),
    TIME("tIME", 1950960965, Attribute.ANCILLARY, 20),
    UNKNOWN("UNKNOWN", 0, Attribute.ANCILLARY, 99);

    private static final Map<String, ChunkType> stringMap;
    private static final Map<Integer, ChunkType> intMap;
    private final Attribute attribute;
    private final String name;
    private final int value;
    private final int ranking;

    private ChunkType(String name, int value, Attribute attribute, int ranking) {
        this.name = name;
        this.value = value;
        this.attribute = attribute;
        this.ranking = ranking;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public int getRanking() {
        return this.ranking;
    }

    public String toString() {
        return this.name;
    }

    public static boolean containsIgnoreCase(String name) {
        return stringMap.containsKey(name.toUpperCase());
    }

    public static ChunkType fromString(String name) {
        return stringMap.get(name.toUpperCase());
    }

    public static ChunkType fromInt(int value) {
        ChunkType chunkType = intMap.get(value);
        if (chunkType == null) {
            return UNKNOWN;
        }
        return chunkType;
    }

    static {
        stringMap = new HashMap<String, ChunkType>();
        intMap = new HashMap<Integer, ChunkType>();
        for (ChunkType chunk : ChunkType.values()) {
            stringMap.put(chunk.toString().toUpperCase(), chunk);
            intMap.put(chunk.getValue(), chunk);
        }
    }

    public static enum Attribute {
        CRITICAL{

            @Override
            public String[] getNames() {
                return (String[])CRITICAL_NAMES.clone();
            }

            @Override
            public int[] getValues() {
                return (int[])CRITICAL_VALUES.clone();
            }
        }
        ,
        ANCILLARY{

            @Override
            public String[] getNames() {
                return (String[])ANCILLARY_NAMES.clone();
            }

            @Override
            public int[] getValues() {
                return (int[])ANCILLARY_VALUES.clone();
            }
        };

        private static final String[] CRITICAL_NAMES;
        private static final String[] ANCILLARY_NAMES;
        private static final int[] CRITICAL_VALUES;
        private static final int[] ANCILLARY_VALUES;

        public abstract String[] getNames();

        public abstract int[] getValues();

        static {
            CRITICAL_NAMES = new String[]{"IHDR", "IDAT", "IEND", "PLTE"};
            ANCILLARY_NAMES = new String[]{"tEXt", "zTXt", "iTXt", "tRNS", "gAMA", "cHRM", "sRGB", "iCCP", "bKGD", "pHYs", "sBIT", "sPLT", "hIST", "tIME"};
            CRITICAL_VALUES = new int[]{1229472850, 1229209940, 1229278788, 1347179589};
            ANCILLARY_VALUES = new int[]{1950701684, 2052348020, 1767135348, 1951551059, 1732332865, 1665684045, 1934772034, 1766015824, 1649100612, 1883789683, 1933723988, 1934642260, 1749635924, 1950960965};
        }
    }
}

