/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

public class Filter {
    public static final int NONE = 0;
    public static final int SUB = 1;
    public static final int UP = 2;
    public static final int AVERAGE = 3;
    public static final int PAETH = 4;

    public static void defilter_average(int bytesPerPixel, int bytesPerScanLine, byte[] sample, int offset) {
        int i;
        int previous = 0;
        int upper = 0;
        int end = offset + bytesPerScanLine;
        int subStart = offset + bytesPerPixel;
        if (offset < bytesPerScanLine) {
            for (int i2 = subStart; i2 < end; ++i2) {
                previous = sample[i2 - bytesPerPixel] & 0xFF;
                sample[i2] = (byte)((sample[i2] & 0xFF) + (previous >> 1));
            }
            return;
        }
        for (i = offset; i < subStart; ++i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) + (upper >> 1));
        }
        for (i = subStart; i < end; ++i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            previous = sample[i - bytesPerPixel] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) + (upper + previous >> 1));
        }
    }

    public static void defilter_paeth(int bytesPerPixel, int bytesPerScanLine, byte[] sample, int offset) {
        int i;
        int previous = 0;
        int upper = 0;
        int upper_previous = 0;
        int end = offset + bytesPerScanLine;
        int subStart = offset + bytesPerPixel;
        if (offset < bytesPerScanLine) {
            for (int i2 = subStart; i2 < end; ++i2) {
                previous = sample[i2 - bytesPerPixel] & 0xFF;
                sample[i2] = (byte)((sample[i2] & 0xFF) + previous);
            }
            return;
        }
        for (i = offset; i < subStart; ++i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) + upper);
        }
        for (i = subStart; i < end; ++i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            previous = sample[i - bytesPerPixel] & 0xFF;
            upper_previous = sample[i - bytesPerScanLine - bytesPerPixel] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) + Filter.paeth_predictor(previous, upper, upper_previous));
        }
    }

    public static void defilter_sub(int bytesPerPixel, int bytesPerScanLine, byte[] sample, int offset) {
        int end = offset + bytesPerScanLine;
        for (int i = offset + bytesPerPixel; i < end; ++i) {
            sample[i] = (byte)((sample[i] & 0xFF) + (sample[i - bytesPerPixel] & 0xFF));
        }
    }

    public static void defilter_up(int bytesPerScanLine, byte[] sample, int offset) {
        if (offset < bytesPerScanLine) {
            return;
        }
        int end = offset + bytesPerScanLine;
        for (int i = offset; i < end; ++i) {
            sample[i] = (byte)((sample[i] & 0xFF) + (sample[i - bytesPerScanLine] & 0xFF));
        }
    }

    public static void filter_average(int bytesPerPixel, int bytesPerScanLine, byte[] sample, int offset) {
        int i;
        int previous = 0;
        int upper = 0;
        int end = offset + bytesPerScanLine;
        int subStart = offset + bytesPerPixel;
        if (offset < bytesPerScanLine) {
            for (int i2 = end - 1; i2 >= subStart; --i2) {
                previous = sample[i2 - bytesPerPixel] & 0xFF;
                sample[i2] = (byte)((sample[i2] & 0xFF) - (previous >> 1));
            }
            return;
        }
        for (i = end - 1; i >= subStart; --i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            previous = sample[i - bytesPerPixel] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) - (upper + previous >> 1));
        }
        for (i = subStart - 1; i >= offset; --i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) - (upper >> 1));
        }
    }

    public static void filter_paeth(int bytesPerPixel, int bytesPerScanLine, byte[] sample, int offset) {
        int i;
        int previous = 0;
        int upper = 0;
        int upper_left = 0;
        int subStart = offset + bytesPerPixel;
        int end = offset + bytesPerScanLine;
        if (offset < bytesPerScanLine) {
            for (int i2 = end - 1; i2 >= subStart; --i2) {
                previous = sample[i2 - bytesPerPixel] & 0xFF;
                sample[i2] = (byte)((sample[i2] & 0xFF) - previous);
            }
            return;
        }
        for (i = end - 1; i >= subStart; --i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            previous = sample[i - bytesPerPixel] & 0xFF;
            upper_left = sample[i - bytesPerScanLine - bytesPerPixel] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) - Filter.paeth_predictor(previous, upper, upper_left));
        }
        for (i = subStart - 1; i >= offset; --i) {
            upper = sample[i - bytesPerScanLine] & 0xFF;
            sample[i] = (byte)((sample[i] & 0xFF) - upper);
        }
    }

    public static void filter_sub(int bytesPerPixel, int bytesPerScanLine, byte[] sample, int offset) {
        int start = offset + bytesPerPixel;
        int end = offset + bytesPerScanLine;
        for (int i = end - 1; i >= start; --i) {
            sample[i] = (byte)((sample[i] & 0xFF) - (sample[i - bytesPerPixel] & 0xFF));
        }
    }

    public static void filter_up(int bytesPerScanLine, byte[] sample, int offset) {
        if (offset < bytesPerScanLine) {
            return;
        }
        int start = offset - bytesPerScanLine;
        int end = offset + bytesPerScanLine;
        for (int i = offset; i < end; ++i) {
            sample[i] = (byte)((sample[i] & 0xFF) - (sample[start++] & 0xFF));
        }
    }

    private static int paeth_predictor(int left, int above, int upper_left) {
        int p_upper_left;
        int p = left + above - upper_left;
        int p_left = p > left ? p - left : left - p;
        int p_above = p > above ? p - above : above - p;
        int n = p_upper_left = p > upper_left ? p - upper_left : upper_left - p;
        if (p_left <= p_above && p_left <= p_upper_left) {
            return left;
        }
        if (p_above <= p_upper_left) {
            return above;
        }
        return upper_left;
    }

    private Filter() {
    }
}

