/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkBuilder;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Builder;
import java.io.ByteArrayOutputStream;
import java.util.zip.Deflater;

public class IDATBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private ByteArrayOutputStream bout = new ByteArrayOutputStream(4096);
    private Deflater deflater = new Deflater(5);
    private boolean finish;

    public IDATBuilder() {
        super(ChunkType.IDAT);
    }

    public IDATBuilder(int compressionLevel) {
        super(ChunkType.IDAT);
        this.deflater = new Deflater(compressionLevel);
    }

    public IDATBuilder data(byte[] data, int offset, int length) {
        this.bout.write(data, offset, length);
        return this;
    }

    public IDATBuilder data(byte[] data) {
        return this.data(data, 0, data.length);
    }

    @Override
    protected byte[] buildData() {
        int bytesCompressed;
        this.deflater.setInput(this.bout.toByteArray());
        this.bout.reset();
        byte[] buffer = new byte[4096];
        if (this.finish) {
            this.deflater.finish();
        }
        while (!this.deflater.finished() && (bytesCompressed = this.deflater.deflate(buffer)) > 0) {
            this.bout.write(buffer, 0, bytesCompressed);
        }
        byte[] temp = this.bout.toByteArray();
        this.bout.reset();
        return temp;
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }
}

