/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.Reader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class IDATReader
implements Reader {
    private byte[] rawData;
    private ByteArrayOutputStream byteOutput = null;

    public IDATReader() {
        this(8192);
    }

    public IDATReader(int bufLen) {
        this.byteOutput = new ByteArrayOutputStream(bufLen);
    }

    public IDATReader addChunk(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IDAT) {
            throw new IllegalArgumentException("Not a valid IDAT chunk.");
        }
        try {
            this.byteOutput.write(chunk.getData());
        }
        catch (IOException e) {
            throw new RuntimeException("IDATReader: error adding new chunk");
        }
        return this;
    }

    public byte[] getData() throws IOException {
        if (this.rawData == null) {
            this.read();
        }
        return (byte[])this.rawData.clone();
    }

    @Override
    public void read() throws IOException {
        BufferedInputStream bin = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(this.byteOutput.toByteArray())));
        this.rawData = IOUtils.inputStreamToByteArray(bin);
        bin.close();
    }
}

