/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Reader;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.IOException;

public class IENDReader
implements Reader {
    private Chunk chunk;
    private static final Logger LOGGER = LoggerFactory.getLogger(IENDReader.class);

    public IENDReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IEND) {
            throw new IllegalArgumentException("Not a valid IEND chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException("IENDReader: error reading chunk");
        }
    }

    @Override
    public void read() throws IOException {
        if (this.chunk.getData().length != 0) {
            LOGGER.warn("Warning: IEND data field is not empty!");
        }
    }
}

