/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkBuilder;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.image.png.ColorType;
import guilibshadow.cafe4j.util.Builder;

public class IHDRBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private int width = 0;
    private int height = 0;
    private int bitDepth = 0;
    private int colorType = 0;
    private int compressionMethod = 0;
    private int filterMethod = 0;
    private int interlaceMethod = 0;

    public IHDRBuilder width(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width: " + width);
        }
        this.width = width;
        return this;
    }

    public IHDRBuilder height(int height) {
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height: " + height);
        }
        this.height = height;
        return this;
    }

    public IHDRBuilder bitDepth(int bitDepth) {
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                this.bitDepth = bitDepth;
                return this;
            }
        }
        throw new IllegalArgumentException("Invalid bitDepth: " + bitDepth);
    }

    public IHDRBuilder colorType(ColorType colorType) {
        switch (colorType) {
            case GRAY_SCALE: 
            case TRUE_COLOR: 
            case INDEX_COLOR: 
            case GRAY_SCALE_WITH_ALPHA: 
            case TRUE_COLOR_WITH_ALPHA: {
                this.colorType = colorType.getValue();
                return this;
            }
        }
        throw new IllegalArgumentException("Invalid colorType: " + (Object)((Object)colorType));
    }

    public IHDRBuilder compressionMethod(int compressionMethod) {
        if (compressionMethod != 0) {
            throw new IllegalArgumentException("Invalid comressionMethod" + compressionMethod);
        }
        this.compressionMethod = compressionMethod;
        return this;
    }

    public IHDRBuilder filterMethod(int filterMethod) {
        if (filterMethod != 0) {
            throw new IllegalArgumentException("Invalid filterMethod: " + filterMethod);
        }
        this.filterMethod = filterMethod;
        return this;
    }

    public IHDRBuilder interlaceMethod(int interlaceMethod) {
        if (interlaceMethod != 0 && interlaceMethod != 1) {
            throw new IllegalArgumentException("Invalid interlaceMethod" + interlaceMethod);
        }
        this.interlaceMethod = interlaceMethod;
        return this;
    }

    public IHDRBuilder() {
        super(ChunkType.IHDR);
    }

    @Override
    protected byte[] buildData() {
        byte[] data = new byte[]{(byte)(this.width >>> 24), (byte)(this.width >>> 16), (byte)(this.width >>> 8), (byte)this.width, (byte)(this.height >>> 24), (byte)(this.height >>> 16), (byte)(this.height >>> 8), (byte)this.height, (byte)this.bitDepth, (byte)this.colorType, (byte)this.compressionMethod, (byte)this.filterMethod, (byte)this.interlaceMethod};
        return data;
    }
}

