/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;

public class IHDRReader
implements Reader {
    private int width = 0;
    private int height = 0;
    private byte bitDepth = 0;
    private byte colorType = 0;
    private byte compressionMethod = 0;
    private byte filterMethod = 0;
    private byte interlaceMethod = 0;
    private Chunk chunk;

    public IHDRReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.IHDR) {
            throw new IllegalArgumentException("Not a valid IHDR chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException("IHDRReader: error reading chunk");
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte getBitDepth() {
        return this.bitDepth;
    }

    public byte getColorType() {
        return this.colorType;
    }

    public byte getCompressionMethod() {
        return this.compressionMethod;
    }

    public byte getFilterMethod() {
        return this.filterMethod;
    }

    public byte getInterlaceMethod() {
        return this.interlaceMethod;
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.chunk.getData();
        this.width = IOUtils.readIntMM(data, 0);
        this.height = IOUtils.readIntMM(data, 4);
        this.bitDepth = data[8];
        this.colorType = data[9];
        this.compressionMethod = data[10];
        this.filterMethod = data[11];
        this.interlaceMethod = data[12];
    }
}

