/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkBuilder;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Builder;

public class PLTEBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private byte[] redMap;
    private byte[] greenMap;
    private byte[] blueMap;

    public PLTEBuilder() {
        super(ChunkType.PLTE);
    }

    public PLTEBuilder redMap(byte[] redMap) {
        this.redMap = redMap;
        return this;
    }

    public PLTEBuilder greenMap(byte[] greenMap) {
        this.greenMap = greenMap;
        return this;
    }

    public PLTEBuilder blueMap(byte[] blueMap) {
        this.blueMap = blueMap;
        return this;
    }

    @Override
    protected byte[] buildData() {
        int mapLen = this.redMap.length;
        byte[] colorMap = new byte[3 * mapLen];
        int j = colorMap.length - 1;
        for (int i = mapLen - 1; i >= 0; --i) {
            colorMap[j--] = this.blueMap[i];
            colorMap[j--] = this.greenMap[i];
            colorMap[j--] = this.redMap[i];
        }
        return colorMap;
    }
}

