/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;

public class PLTEReader
implements Reader {
    private byte[] redMap;
    private byte[] greenMap;
    private byte[] blueMap;
    private Chunk chunk;

    public PLTEReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.PLTE) {
            throw new IllegalArgumentException("Not a valid PLTE chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException("PLTEReader: error reading chunk");
        }
    }

    public byte[] getRedMap() {
        return this.redMap;
    }

    public byte[] getGreenMap() {
        return this.greenMap;
    }

    public byte[] getBlueMap() {
        return this.blueMap;
    }

    @Override
    public void read() throws IOException {
        byte[] colorMap = this.chunk.getData();
        int mapLen = colorMap.length;
        if (mapLen % 3 != 0) {
            throw new IllegalArgumentException("Invalid colorMap length: " + mapLen);
        }
        this.redMap = new byte[mapLen / 3];
        this.greenMap = new byte[mapLen / 3];
        this.blueMap = new byte[mapLen / 3];
        int i = mapLen - 1;
        for (int j = this.redMap.length - 1; j >= 0; --j) {
            this.blueMap[j] = colorMap[i--];
            this.greenMap[j] = colorMap[i--];
            this.redMap[j] = colorMap[i--];
        }
    }
}

