/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.icc.ICCProfile;
import guilibshadow.cafe4j.image.meta.png.PngXMP;
import guilibshadow.cafe4j.image.meta.png.TIMEChunk;
import guilibshadow.cafe4j.image.meta.png.TextualChunks;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.image.png.ICCPBuilder;
import guilibshadow.cafe4j.image.png.TextBuilder;
import guilibshadow.cafe4j.image.png.TextReader;
import guilibshadow.cafe4j.image.png.UnknownChunk;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.string.XMLUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ICC_Profile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import org.w3c.dom.Document;

public class PNGTweaker {
    private static final long SIGNATURE = -8552249625308161526L;
    private static Set<ChunkType> REMOVABLE = EnumSet.range(ChunkType.TEXT, ChunkType.TIME);
    private static final Logger LOGGER = LoggerFactory.getLogger(PNGTweaker.class);

    public static void dumpTextChunks(Chunk[] chunks) throws IOException {
        TextReader reader = new TextReader();
        for (Chunk chunk : chunks) {
            if (chunk.getChunkType() != ChunkType.TEXT && chunk.getChunkType() != ChunkType.ITXT && chunk.getChunkType() != ChunkType.ZTXT) continue;
            reader.setInput(chunk);
            LOGGER.info("{}: {}", (Object)reader.getKeyword(), (Object)reader.getText());
        }
    }

    public static void dumpTextChunks(InputStream is) throws IOException {
        LOGGER.info("\n{}", (Object)PNGTweaker.readTextChunks(is));
    }

    public static void insertChunk(Chunk chunk, InputStream is, OutputStream os) throws IOException {
        PNGTweaker.insertChunks(is, os, chunk);
    }

    public static void insertChunks(InputStream is, OutputStream os, Chunk ... chunks) throws IOException {
        List<Chunk> list = PNGTweaker.readChunks(is);
        Collections.addAll(list, chunks);
        IOUtils.writeLongMM(os, -8552249625308161526L);
        PNGTweaker.serializeChunks(list, os);
    }

    public static void insertChunks(List<Chunk> chunks, InputStream is, OutputStream os) throws IOException {
        List<Chunk> list = PNGTweaker.readChunks(is);
        list.addAll(chunks);
        IOUtils.writeLongMM(os, -8552249625308161526L);
        PNGTweaker.serializeChunks(list, os);
    }

    public static void insertComments(InputStream is, OutputStream os, List<String> comments) throws IOException {
        TextBuilder txtBuilder = new TextBuilder(ChunkType.TEXT);
        int numOfComments = comments.size();
        Chunk[] chunks = new Chunk[numOfComments];
        for (int i = 0; i < numOfComments; ++i) {
            chunks[i] = txtBuilder.keyword("Comment").text(comments.get(i)).build();
        }
        PNGTweaker.insertChunks(is, os, chunks);
    }

    public static void insertICCProfile(String profile_name, byte[] icc_profile, InputStream is, OutputStream os) throws IOException {
        ICCPBuilder builder = new ICCPBuilder();
        builder.name(profile_name);
        builder.data(icc_profile);
        PNGTweaker.insertChunk(builder.build(), is, os);
    }

    public static void insertICCProfile(String profile_name, ICC_Profile icc_profile, InputStream is, OutputStream os) throws IOException {
        PNGTweaker.insertICCProfile(profile_name, icc_profile.getData(), is, os);
    }

    public static void insertTextChunk(ChunkType type, String keyword, String text, InputStream is, OutputStream os) throws IOException {
        if (type == null || keyword == null || text == null) {
            throw new IllegalArgumentException("Argument(s) are null");
        }
        PNGTweaker.insertChunk(new TextBuilder(type).keyword(keyword).text(text).build(), is, os);
    }

    public static void insertTextChunks(TextualChunks textualChunks, InputStream is, OutputStream os) throws IOException {
        if (textualChunks == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        PNGTweaker.insertChunks(textualChunks.getChunks(), is, os);
    }

    public static void insertXMP(InputStream is, OutputStream os, XMP xmp) throws IOException {
        PNGTweaker.insert(is, os, XMLUtils.serializeToString(xmp.getMergedDocument()));
    }

    public static void insertXMP(InputStream is, OutputStream os, String xmp) throws IOException {
        Document doc = XMLUtils.createXML(xmp);
        XMLUtils.insertLeadingPI(doc, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(doc, "xpacket", "end='r'");
        String newXmp = XMLUtils.serializeToString(doc);
        PNGTweaker.insert(is, os, newXmp);
    }

    private static void insert(InputStream is, OutputStream os, String xmp) throws IOException {
        List<Chunk> chunks = PNGTweaker.readChunks(is);
        ListIterator<Chunk> itr = chunks.listIterator();
        while (itr.hasNext()) {
            Chunk chunk = itr.next();
            if (chunk.getChunkType() != ChunkType.ITXT) continue;
            TextReader reader = new TextReader(chunk);
            if (reader.getKeyword().equals("XML:com.adobe.xmp")) {
                // empty if block
            }
            itr.remove();
        }
        Chunk xmpChunk = new TextBuilder(ChunkType.ITXT).keyword("XML:com.adobe.xmp").text(xmp).build();
        chunks.add(xmpChunk);
        IOUtils.writeLongMM(os, -8552249625308161526L);
        PNGTweaker.serializeChunks(chunks, os);
    }

    public static List<Chunk> mergeIDATChunks(List<Chunk> chunks) {
        ListIterator<Chunk> iter = chunks.listIterator();
        byte[] data = new byte[]{};
        while (iter.hasNext()) {
            Chunk chunk = (Chunk)iter.next();
            if (chunk.getChunkType() != ChunkType.IDAT) continue;
            data = ArrayUtils.concat(data, new byte[][]{chunk.getData()});
            iter.remove();
        }
        chunks.add(new Chunk(ChunkType.IDAT, data.length, data, Chunk.calculateCRC(ChunkType.IDAT.getValue(), data)));
        return chunks;
    }

    public static byte[] readICCProfileChunk(InputStream is) throws IOException {
        int data_len = 0;
        int chunk_value = 0;
        byte[] buf = null;
        long signature = IOUtils.readLongMM(is);
        if (signature != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(is) != 13 || IOUtils.readIntMM(is) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        buf = new byte[17];
        IOUtils.readFully(is, buf, 0, 17);
        while (true) {
            data_len = IOUtils.readIntMM(is);
            chunk_value = IOUtils.readIntMM(is);
            if (chunk_value == ChunkType.IEND.getValue()) break;
            ChunkType chunk = ChunkType.fromInt(chunk_value);
            switch (chunk) {
                case ICCP: {
                    buf = new byte[data_len];
                    IOUtils.readFully(is, buf);
                    IOUtils.skipFully(is, 4);
                    return PNGTweaker.readICCProfile(buf);
                }
            }
            buf = new byte[data_len + 4];
            IOUtils.readFully(is, buf, 0, data_len + 4);
        }
        IOUtils.readIntMM(is);
        return null;
    }

    public static String readTextChunks(File file) throws IOException {
        return PNGTweaker.readTextChunks(new FileInputStream(file));
    }

    public static String readTextChunks(InputStream is) throws IOException {
        int data_len = 0;
        int chunk_value = 0;
        byte[] buf = null;
        StringBuilder sb = new StringBuilder(1024);
        long signature = IOUtils.readLongMM(is);
        if (signature != -8552249625308161526L) {
            throw new RuntimeException("ReadTextChunks: Invalid PNG signature");
        }
        if (IOUtils.readIntMM(is) != 13 || IOUtils.readIntMM(is) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("ReadTextChunks: Invalid PNG header");
        }
        buf = new byte[17];
        IOUtils.readFully(is, buf, 0, 17);
        block5: while (true) {
            data_len = IOUtils.readIntMM(is);
            chunk_value = IOUtils.readIntMM(is);
            if (chunk_value == ChunkType.IEND.getValue()) break;
            ChunkType chunk = ChunkType.fromInt(chunk_value);
            switch (chunk) {
                case ZTXT: {
                    sb.append("zTXt chunk:\n");
                    sb.append("**********************\n");
                    buf = new byte[data_len];
                    IOUtils.readFully(is, buf);
                    int keyword_len = 0;
                    while (buf[keyword_len] != 0) {
                        ++keyword_len;
                    }
                    sb.append(new String(buf, 0, keyword_len, "UTF-8"));
                    sb.append(": ");
                    InflaterInputStream ii = new InflaterInputStream(new ByteArrayInputStream(buf, keyword_len + 2, data_len - keyword_len - 2));
                    InputStreamReader ir = new InputStreamReader((InputStream)ii, "UTF-8");
                    BufferedReader br = new BufferedReader(ir);
                    String read = null;
                    while ((read = br.readLine()) != null) {
                        sb.append(read);
                        sb.append("\n");
                    }
                    sb.append("**********************\n");
                    br.close();
                    IOUtils.skipFully(is, 4);
                    continue block5;
                }
                case TEXT: {
                    sb.append("tEXt chunk:\n");
                    sb.append("**********************\n");
                    buf = new byte[data_len];
                    IOUtils.readFully(is, buf);
                    int keyword_len = 0;
                    while (buf[keyword_len] != 0) {
                        ++keyword_len;
                    }
                    sb.append(new String(buf, 0, keyword_len, "UTF-8"));
                    sb.append(": ");
                    sb.append(new String(buf, keyword_len + 1, data_len - keyword_len - 1, "UTF-8"));
                    sb.append("\n**********************\n");
                    IOUtils.skipFully(is, 4);
                    continue block5;
                }
                case ITXT: {
                    String read;
                    BufferedReader br;
                    InputStreamReader ir;
                    InflaterInputStream ii;
                    sb.append("iTXt chunk:\n");
                    sb.append("**********************\n");
                    buf = new byte[data_len];
                    IOUtils.readFully(is, buf);
                    int keyword_len = 0;
                    int trans_keyword_len = 0;
                    int lang_flg_len = 0;
                    boolean compr = false;
                    while (buf[keyword_len] != 0) {
                        ++keyword_len;
                    }
                    sb.append(new String(buf, 0, keyword_len, "UTF-8"));
                    if (buf[++keyword_len] == 1) {
                        compr = true;
                    }
                    ++keyword_len;
                    while (buf[++keyword_len] != 0) {
                        ++lang_flg_len;
                    }
                    sb.append("(");
                    if (lang_flg_len > 0) {
                        sb.append(new String(buf, keyword_len - lang_flg_len, lang_flg_len, "UTF-8"));
                    }
                    while (buf[++keyword_len] != 0) {
                        ++trans_keyword_len;
                    }
                    if (trans_keyword_len > 0) {
                        sb.append(" ");
                        sb.append(new String(buf, keyword_len - trans_keyword_len, trans_keyword_len, "UTF-8"));
                    }
                    sb.append("): ");
                    if (compr) {
                        ii = new InflaterInputStream(new ByteArrayInputStream(buf, keyword_len + 1, data_len - keyword_len - 1));
                        ir = new InputStreamReader((InputStream)ii, "UTF-8");
                        br = new BufferedReader(ir);
                        read = null;
                        while ((read = br.readLine()) != null) {
                            sb.append(read);
                            sb.append("\n");
                        }
                        br.close();
                    } else {
                        sb.append(new String(buf, keyword_len + 1, data_len - keyword_len - 1, "UTF-8"));
                        sb.append("\n");
                    }
                    sb.append("**********************\n");
                    IOUtils.skipFully(is, 4);
                    continue block5;
                }
            }
            buf = new byte[data_len + 4];
            IOUtils.readFully(is, buf, 0, data_len + 4);
        }
        IOUtils.readIntMM(is);
        return sb.toString();
    }

    public static String readTextChunks(String fileName) throws IOException {
        FileInputStream fi = new FileInputStream(fileName);
        String text = PNGTweaker.readTextChunks(fi);
        fi.close();
        return text;
    }

    public static List<Chunk> readChunks(InputStream is) throws IOException {
        ArrayList<Chunk> list = new ArrayList<Chunk>();
        int data_len = 0;
        int chunk_type = 0;
        byte[] buf = null;
        long signature = IOUtils.readLongMM(is);
        if (signature != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(is) != 13 || IOUtils.readIntMM(is) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        buf = new byte[13];
        IOUtils.readFully(is, buf, 0, 13);
        list.add(new Chunk(ChunkType.IHDR, 13L, buf, IOUtils.readUnsignedIntMM(is)));
        while (true) {
            data_len = IOUtils.readIntMM(is);
            chunk_type = IOUtils.readIntMM(is);
            if (chunk_type == ChunkType.IEND.getValue()) break;
            ChunkType chunkType = ChunkType.fromInt(chunk_type);
            buf = new byte[data_len];
            IOUtils.readFully(is, buf, 0, data_len);
            if (chunkType == ChunkType.UNKNOWN) {
                list.add(new UnknownChunk(data_len, chunk_type, buf, IOUtils.readUnsignedIntMM(is)));
                continue;
            }
            list.add(new Chunk(chunkType, data_len, buf, IOUtils.readUnsignedIntMM(is)));
        }
        list.add(new Chunk(ChunkType.IEND, data_len, new byte[0], IOUtils.readUnsignedIntMM(is)));
        return list;
    }

    private static byte[] readICCProfile(byte[] buf) throws IOException {
        if (buf == null) {
            throw new IllegalArgumentException("Input array is null");
        }
        int profileName_len = 0;
        while (buf[profileName_len] != 0) {
            ++profileName_len;
        }
        String profileName = new String(buf, 0, profileName_len, "UTF-8");
        InflaterInputStream ii = new InflaterInputStream(new ByteArrayInputStream(buf, profileName_len + 2, buf.length - profileName_len - 2));
        LOGGER.info("ICCProfile name: {}", (Object)profileName);
        byte[] icc_profile = IOUtils.readFully((InputStream)ii, 4096);
        LOGGER.info("ICCProfile length: {}", (Object)icc_profile.length);
        return icc_profile;
    }

    public static Map<MetadataType, Metadata> readMetadata(InputStream is) throws IOException {
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        List<Chunk> chunks = PNGTweaker.readChunks(is);
        Iterator<Chunk> iter = chunks.iterator();
        TextualChunks textualChunk = null;
        while (iter.hasNext()) {
            Chunk chunk = iter.next();
            ChunkType type = chunk.getChunkType();
            long length = chunk.getLength();
            if (type == ChunkType.ICCP) {
                metadataMap.put(MetadataType.ICC_PROFILE, new ICCProfile(PNGTweaker.readICCProfile(chunk.getData())));
            } else if (type == ChunkType.TEXT || type == ChunkType.ITXT || type == ChunkType.ZTXT) {
                if (textualChunk == null) {
                    textualChunk = new TextualChunks();
                }
                textualChunk.addChunk(chunk);
            } else if (type == ChunkType.TIME) {
                metadataMap.put(MetadataType.PNG_TIME, new TIMEChunk(chunk));
            }
            LOGGER.info("{} ({}) | {} bytes | 0x{} (CRC)", new Object[]{type.getName(), type.getAttribute(), length, Long.toHexString(chunk.getCRC())});
        }
        if (textualChunk != null) {
            metadataMap.put(MetadataType.PNG_TEXTUAL, textualChunk);
            Map<String, String> keyValMap = textualChunk.getKeyValMap();
            for (Map.Entry<String, String> entry : keyValMap.entrySet()) {
                if (!entry.getKey().equals("XML:com.adobe.xmp")) continue;
                metadataMap.put(MetadataType.XMP, new PngXMP(entry.getValue()));
            }
        }
        is.close();
        return metadataMap;
    }

    public static void removeAncillaryChunks(InputStream is, Set<ChunkType> chunkTypes) throws IOException {
        File dir = new File(".");
        if (chunkTypes != null) {
            REMOVABLE = EnumSet.noneOf(ChunkType.class);
            for (ChunkType type : chunkTypes) {
                if (type.getAttribute() != ChunkType.Attribute.ANCILLARY) continue;
                REMOVABLE.add(type);
            }
        }
        String outFileName = "slim.png";
        PNGTweaker.removeChunks(is, dir, outFileName);
        LOGGER.info(">>{}", (Object)outFileName);
        LOGGER.info("************************");
    }

    public static List<Chunk> removeAncillaryChunks(List<Chunk> chunks) throws Exception {
        return PNGTweaker.removeChunks(chunks, REMOVABLE);
    }

    public static void removeAncillaryChunks(String fileOrDirectoryName, Set<ChunkType> chunkTypes) throws IOException {
        File dir = new File(".");
        File[] files = null;
        if (!StringUtils.isNullOrEmpty(fileOrDirectoryName) && (files = new File[]{new File(fileOrDirectoryName)})[0].isDirectory()) {
            dir = files[0];
            files = null;
        }
        if (files == null) {
            files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith("png");
                }
            });
        }
        if (chunkTypes != null) {
            REMOVABLE = EnumSet.noneOf(ChunkType.class);
            for (ChunkType type : chunkTypes) {
                if (type.getAttribute() != ChunkType.Attribute.ANCILLARY) continue;
                REMOVABLE.add(type);
            }
        }
        FileInputStream fs = null;
        for (int i = files.length - 1; i >= 0; --i) {
            String outFileName = files[i].getName();
            outFileName = outFileName.substring(0, outFileName.lastIndexOf(46)) + "_slim.png";
            LOGGER.info("<<{}", (Object)files[i].getName());
            fs = new FileInputStream(files[i]);
            PNGTweaker.removeChunks(fs, dir, outFileName);
            LOGGER.info(">>{}", (Object)outFileName);
            LOGGER.info("************************");
            fs.close();
        }
    }

    private static void removeChunks(InputStream is, File outfileDir, String outfileName) throws IOException {
        int data_len = 0;
        int chunk_value = 0;
        byte[] buf = null;
        long signature = IOUtils.readLongMM(is);
        if (signature != -8552249625308161526L) {
            throw new RuntimeException("Invalid PNG signature");
        }
        if (IOUtils.readIntMM(is) != 13 || IOUtils.readIntMM(is) != ChunkType.IHDR.getValue()) {
            throw new RuntimeException("Invalid PNG header");
        }
        FileOutputStream fs = new FileOutputStream(new File(outfileDir, outfileName));
        IOUtils.writeLongMM(fs, -8552249625308161526L);
        IOUtils.writeIntMM(fs, 13);
        IOUtils.writeIntMM(fs, ChunkType.IHDR.getValue());
        buf = new byte[17];
        IOUtils.readFully(is, buf, 0, 17);
        IOUtils.write((OutputStream)fs, buf);
        while (true) {
            data_len = IOUtils.readIntMM(is);
            chunk_value = IOUtils.readIntMM(is);
            if (chunk_value == ChunkType.IEND.getValue()) break;
            if (REMOVABLE.contains((Object)ChunkType.fromInt(chunk_value))) {
                LOGGER.info("{} Chunk removed!", (Object)ChunkType.fromInt(chunk_value));
                IOUtils.skipFully(is, data_len + 4);
                continue;
            }
            buf = new byte[data_len + 4];
            IOUtils.readFully(is, buf, 0, data_len + 4);
            IOUtils.writeIntMM(fs, data_len);
            IOUtils.writeIntMM(fs, chunk_value);
            IOUtils.write((OutputStream)fs, buf);
        }
        IOUtils.writeIntMM(fs, data_len);
        IOUtils.writeIntMM(fs, ChunkType.IEND.getValue());
        int crc = IOUtils.readIntMM(is);
        IOUtils.writeIntMM(fs, crc);
        fs.close();
    }

    public static List<Chunk> removeChunks(List<Chunk> chunks, ChunkType chunkType) {
        ListIterator<Chunk> iter = chunks.listIterator();
        while (iter.hasNext()) {
            Chunk chunk = (Chunk)iter.next();
            if (chunk.getChunkType() != chunkType) continue;
            iter.remove();
        }
        return chunks;
    }

    public static List<Chunk> removeChunks(List<Chunk> chunks, Set<ChunkType> chunkTypeSet) {
        ListIterator<Chunk> iter = chunks.listIterator();
        while (iter.hasNext()) {
            Chunk chunk = (Chunk)iter.next();
            if (!chunkTypeSet.contains((Object)chunk.getChunkType())) continue;
            iter.remove();
        }
        return chunks;
    }

    public static List<Chunk> removeTextChunks(List<Chunk> chunks) {
        ListIterator<Chunk> iter = chunks.listIterator();
        while (iter.hasNext()) {
            Chunk chunk = (Chunk)iter.next();
            if (chunk.getChunkType() != ChunkType.TEXT && chunk.getChunkType() != ChunkType.ZTXT && chunk.getChunkType() != ChunkType.ITXT) continue;
            iter.remove();
        }
        return chunks;
    }

    public static void serializeChunks(List<Chunk> chunks, OutputStream os) throws IOException {
        Collections.sort(chunks);
        for (Chunk chunk : chunks) {
            chunk.write(os);
        }
    }

    public static void showICCProfile(InputStream is) throws IOException {
        byte[] icc_profile = PNGTweaker.readICCProfileChunk(is);
        if (icc_profile != null) {
            ICCProfile.showProfile(icc_profile);
        }
    }

    public static List<Chunk> splitIDATChunk(Chunk chunk, int size) {
        if (chunk.getChunkType() != ChunkType.IDAT) {
            throw new IllegalArgumentException("Not a valid IDAT chunk.");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid IDAT chunk size: " + size);
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        byte[] data = chunk.getData();
        int dataLen = data.length;
        int mod = dataLen % size;
        int nSplits = dataLen / size;
        byte[] buffer = new byte[size];
        byte[] leftOver = new byte[mod];
        for (int i = 0; i < nSplits; ++i) {
            buffer = ArrayUtils.subArray(data, i * size, size);
            chunks.add(new Chunk(ChunkType.IDAT, size, buffer, Chunk.calculateCRC(ChunkType.IDAT.getValue(), buffer)));
        }
        if (mod != 0) {
            leftOver = ArrayUtils.subArray(data, dataLen - mod, mod);
            chunks.add(new Chunk(ChunkType.IDAT, mod, leftOver, Chunk.calculateCRC(ChunkType.IDAT.getValue(), leftOver)));
        }
        return chunks;
    }

    public static List<Chunk> splitIDATChunks(List<Chunk> chunks, int size) {
        ArrayList<Chunk> listIDAT = new ArrayList<Chunk>();
        ListIterator<Chunk> iter = chunks.listIterator();
        while (iter.hasNext()) {
            Chunk chunk = iter.next();
            if (chunk.getChunkType() != ChunkType.IDAT) continue;
            listIDAT.addAll(PNGTweaker.splitIDATChunk(chunk, size));
            iter.remove();
        }
        chunks.addAll(listIDAT);
        return chunks;
    }

    private PNGTweaker() {
    }
}

