/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;

public class SRGBReader
implements Reader {
    private Chunk chunk;
    private byte renderingIntent;

    public SRGBReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.SRGB) {
            throw new IllegalArgumentException("Not a valid sRGB chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException("SRGBReader: error reading chunk");
        }
    }

    public byte getRenderingIntent() {
        return this.renderingIntent;
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.chunk.getData();
        this.renderingIntent = data.length > 0 ? data[0] : (byte)-1;
    }
}

