/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkBuilder;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Builder;
import java.util.Calendar;

public class TIMEBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;

    public TIMEBuilder() {
        super(ChunkType.TIME);
    }

    public TIMEBuilder calendar(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        return this;
    }

    public TIMEBuilder year(int year) {
        if (year > Short.MAX_VALUE || year < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Year out of range: -32768 - 32767");
        }
        this.year = year;
        return this;
    }

    public TIMEBuilder month(int month) {
        if (month > 12 || month < 1) {
            throw new IllegalArgumentException("Month out of range: 1-12");
        }
        this.month = month;
        return this;
    }

    public TIMEBuilder day(int day) {
        if (day > 31 || day < 1) {
            throw new IllegalArgumentException("Day out of range: 1-31");
        }
        this.day = day;
        return this;
    }

    public TIMEBuilder hour(int hour) {
        if (hour > 23 || hour < 0) {
            throw new IllegalArgumentException("Hour out of range: 0-23");
        }
        this.hour = hour;
        return this;
    }

    public TIMEBuilder minute(int minute) {
        if (minute > 59 || minute < 0) {
            throw new IllegalArgumentException("Minute out of range: 0-59");
        }
        this.minute = minute;
        return this;
    }

    public TIMEBuilder second(int second) {
        if (second > 60 || second < 0) {
            throw new IllegalArgumentException("Second out of range: 0-60");
        }
        this.second = second;
        return this;
    }

    @Override
    protected byte[] buildData() {
        return new byte[]{(byte)(this.year >>> 8), (byte)this.year, (byte)this.month, (byte)this.day, (byte)this.hour, (byte)this.minute, (byte)this.second};
    }
}

