/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Reader;
import java.io.IOException;

public class TIMEReader
implements Reader {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private Chunk chunk;

    public TIMEReader(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.TIME) {
            throw new IllegalArgumentException("Not a valid tIME chunk.");
        }
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException("TIMEReader: error reading chunk");
        }
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getMonth() {
        return this.month;
    }

    public int getSecond() {
        return this.second;
    }

    public int getYear() {
        return this.year;
    }

    @Override
    public void read() throws IOException {
        byte[] data = this.chunk.getData();
        if (data.length < 7) {
            throw new RuntimeException("TimeReader: input data too short");
        }
        this.year = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        this.month = data[2] & 0xFF;
        this.day = data[3] & 0xFF;
        this.hour = data[4] & 0xFF;
        this.minute = data[5] & 0xFF;
        this.second = data[6] & 0xFF;
    }
}

