/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkBuilder;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Builder;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.DeflaterOutputStream;

public class TextBuilder
extends ChunkBuilder
implements Builder<Chunk> {
    private boolean compressed;
    private String keyword;
    private String text;

    public TextBuilder(ChunkType chunkType) {
        super(chunkType);
        if (chunkType != ChunkType.TEXT && chunkType != ChunkType.ITXT && chunkType != ChunkType.ZTXT) {
            throw new IllegalArgumentException("Expect Textual chunk!");
        }
    }

    @Override
    protected byte[] buildData() {
        byte[] data = null;
        ChunkType chunkType = this.getChunkType();
        StringBuilder sb = new StringBuilder(this.keyword);
        sb.append('\u0000');
        switch (chunkType) {
            case TEXT: {
                sb.append(this.text);
                try {
                    data = sb.toString().getBytes("iso-8859-1");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case ZTXT: {
                try {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream(1024);
                    sb.append('\u0000');
                    bo.write(sb.toString().getBytes("iso-8859-1"));
                    DeflaterOutputStream ds = new DeflaterOutputStream(bo);
                    OutputStreamWriter or = new OutputStreamWriter((OutputStream)ds, "iso-8859-1");
                    BufferedWriter br = new BufferedWriter(or);
                    br.write(this.text);
                    br.flush();
                    br.close();
                    data = bo.toByteArray();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case ITXT: {
                try {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream(1024);
                    bo.write(sb.toString().getBytes("iso-8859-1"));
                    OutputStreamWriter or = null;
                    if (this.compressed) {
                        bo.write(new byte[]{1, 0, 0, 0});
                        or = new OutputStreamWriter((OutputStream)new DeflaterOutputStream(bo), "UTF-8");
                    } else {
                        bo.write(new byte[]{0, 0, 0, 0});
                        or = new OutputStreamWriter((OutputStream)bo, "UTF-8");
                    }
                    BufferedWriter br = new BufferedWriter(or);
                    br.write(this.text);
                    br.flush();
                    br.close();
                    data = bo.toByteArray();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
        }
        return data;
    }

    public TextBuilder keyword(String keyword) {
        this.keyword = keyword.trim().replaceAll("\\s+", " ");
        return this;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public TextBuilder text(String text) {
        this.text = text;
        return this;
    }
}

