/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.png;

import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.util.Reader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.InflaterInputStream;

public class TextReader
implements Reader {
    private String keyword;
    private String text;
    private Chunk chunk;

    public TextReader() {
    }

    public TextReader(Chunk chunk) {
        this.setInput(chunk);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void read() throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        byte[] data = this.chunk.getData();
        switch (this.chunk.getChunkType()) {
            case ZTXT: {
                int keyword_len = 0;
                while (data[keyword_len] != 0) {
                    ++keyword_len;
                }
                this.keyword = new String(data, 0, keyword_len, "UTF-8");
                InflaterInputStream ii = new InflaterInputStream(new ByteArrayInputStream(data, keyword_len + 2, data.length - keyword_len - 2));
                InputStreamReader ir = new InputStreamReader((InputStream)ii, "UTF-8");
                BufferedReader br = new BufferedReader(ir);
                String read = null;
                while ((read = br.readLine()) != null) {
                    sb.append(read);
                    sb.append("\n");
                }
                br.close();
                if (sb.length() < 1) break;
                sb.deleteCharAt(sb.length() - 1);
                break;
            }
            case TEXT: {
                int keyword_len = 0;
                while (data[keyword_len] != 0) {
                    ++keyword_len;
                }
                this.keyword = new String(data, 0, keyword_len, "UTF-8");
                sb.append(new String(data, keyword_len + 1, data.length - keyword_len - 1, "UTF-8"));
                break;
            }
            case ITXT: {
                int keyword_len = 0;
                int trans_keyword_len = 0;
                int lang_flg_len = 0;
                boolean compr = false;
                while (data[keyword_len] != 0) {
                    ++keyword_len;
                }
                sb.append(new String(data, 0, keyword_len, "UTF-8"));
                if (data[++keyword_len] == 1) {
                    compr = true;
                }
                ++keyword_len;
                while (data[++keyword_len] != 0) {
                    ++lang_flg_len;
                }
                sb.append("(");
                if (lang_flg_len > 0) {
                    sb.append(new String(data, keyword_len - lang_flg_len, lang_flg_len, "UTF-8"));
                }
                while (data[++keyword_len] != 0) {
                    ++trans_keyword_len;
                }
                if (trans_keyword_len > 0) {
                    sb.append(" ");
                    sb.append(new String(data, keyword_len - trans_keyword_len, trans_keyword_len, "UTF-8"));
                }
                sb.append(")");
                this.keyword = sb.toString().replaceFirst("\\(\\)", "");
                sb.setLength(0);
                if (compr) {
                    InflaterInputStream ii = new InflaterInputStream(new ByteArrayInputStream(data, keyword_len + 1, data.length - keyword_len - 1));
                    InputStreamReader ir = new InputStreamReader((InputStream)ii, "UTF-8");
                    BufferedReader br = new BufferedReader(ir);
                    String read = null;
                    while ((read = br.readLine()) != null) {
                        sb.append(read);
                        sb.append("\n");
                    }
                    br.close();
                } else {
                    sb.append(new String(data, keyword_len + 1, data.length - keyword_len - 1, "UTF-8"));
                    sb.append("\n");
                }
                if (sb.length() < 1) break;
                sb.deleteCharAt(sb.length() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid textual chunk.");
            }
        }
        this.text = sb.toString();
    }

    public void setInput(Chunk chunk) {
        TextReader.validate(chunk);
        this.chunk = chunk;
        try {
            this.read();
        }
        catch (IOException e) {
            throw new RuntimeException("TextReader: error reading chunk");
        }
    }

    private static void validate(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException("Input chunk is null");
        }
        if (chunk.getChunkType() != ChunkType.TEXT && chunk.getChunkType() != ChunkType.ZTXT && chunk.getChunkType() != ChunkType.ITXT) {
            throw new IllegalArgumentException("Not a valid textual chunk.");
        }
    }
}

