/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.quant;

import guilibshadow.cafe4j.image.quant.NeuQuant;
import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.URL;

public class NQCanvas
extends Canvas {
    private static final long serialVersionUID = -5075876371476649415L;
    private NeuQuant nq = null;
    private int w = 0;
    private int h = 0;
    private Image image = null;
    private String url = null;

    public NQCanvas(String url) {
        this.url = url;
    }

    public void set() {
        try {
            System.out.println("Fetching " + this.url + " ...");
            Image img = null;
            try {
                URL u = new URL(this.url);
                img = Toolkit.getDefaultToolkit().getImage(u);
            }
            catch (Exception ee) {
                img = Toolkit.getDefaultToolkit().getImage(this.url);
            }
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(img, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("w = " + img.getWidth(this));
            System.out.println("h = " + img.getHeight(this));
            this.set(img);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public void set(Image img) throws IOException {
        this.w = img.getWidth(this);
        this.h = img.getHeight(this);
        int[] pixels = new int[this.w * this.h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.w, this.h, pixels, 0, this.w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new IOException("Image pixel grab aborted or errored");
        }
        this.nq = new NeuQuant(pixels);
        pixels = this.nq.quantize();
        this.image = this.createImage(new MemoryImageSource(this.w, this.h, pixels, 0, this.w));
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.image == null) {
            this.set();
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public static void main(String[] args) {
        NQCanvas canvas = new NQCanvas(args[0]);
        Frame frame = new Frame("NeuQuant Test");
        frame.setSize(500, 500);
        frame.add(canvas);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("Closing program");
                System.exit(0);
            }
        });
    }
}

