/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.quant;

import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;

public class NeuQuant {
    public static final int ncycles = 100;
    public static final int netsize = 256;
    public static final int specials = 3;
    public static final int bgColour = 2;
    public static final int cutnetsize = 253;
    public static final int maxnetpos = 255;
    public static final int initrad = 32;
    public static final int radiusbiasshift = 6;
    public static final int radiusbias = 64;
    public static final int initBiasRadius = 2048;
    public static final int radiusdec = 30;
    public static final int alphabiasshift = 10;
    public static final int initalpha = 1024;
    public static final double gamma = 1024.0;
    public static final double beta = 9.765625E-4;
    public static final double betagamma = 1.0;
    public static final int prime1 = 499;
    public static final int prime2 = 491;
    public static final int prime3 = 487;
    public static final int prime4 = 503;
    public static final int maxprime = 503;
    private double[][] network = new double[256][3];
    private int[] netindex = new int[256];
    private double[] bias = new double[256];
    private double[] freq = new double[256];
    private int samplefac = 0;
    private int[] pixels = null;
    private int[][] colormap = new int[256][4];
    private int transparent_color = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(NeuQuant.class);

    public NeuQuant(Image im, int w, int h) {
        this(1);
        this.setPixels(im, w, h);
        this.setUpArrays();
    }

    public NeuQuant(int sample, Image im, int w, int h) {
        this(sample);
        this.setPixels(im, w, h);
        this.setUpArrays();
    }

    public NeuQuant(int[] pixels) {
        this(1, pixels);
    }

    public NeuQuant(int sample, int[] pixels) {
        this(sample);
        this.pixels = pixels;
    }

    private NeuQuant(int sample) {
        if (sample < 1) {
            throw new IllegalArgumentException("Sample must be 1..30");
        }
        if (sample > 30) {
            throw new IllegalArgumentException("Sample must be 1..30");
        }
        this.samplefac = sample;
    }

    public int getColorCount() {
        return 256;
    }

    public int[][] getColourMap() {
        return this.colormap;
    }

    private void setUpArrays() {
        int i;
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 255.0;
        this.network[1][1] = 255.0;
        this.network[1][2] = 255.0;
        for (i = 0; i < 3; ++i) {
            this.freq[i] = 0.00390625;
            this.bias[i] = 0.0;
        }
        for (i = 3; i < 256; ++i) {
            double[] p = this.network[i];
            p[0] = 255.0 * (double)(i - 3) / 253.0;
            p[1] = 255.0 * (double)(i - 3) / 253.0;
            p[2] = 255.0 * (double)(i - 3) / 253.0;
            this.freq[i] = 0.00390625;
            this.bias[i] = 0.0;
        }
    }

    private void setPixels(Image im, int w, int h) {
        if (w * h < 503) {
            throw new IllegalArgumentException("Image is too small");
        }
        int[] pixels = null;
        if (im instanceof BufferedImage) {
            pixels = IMGUtils.getRGB((BufferedImage)im);
        } else {
            pixels = new int[w * h];
            PixelGrabber pg = new PixelGrabber(im, 0, 0, w, h, pixels, 0, w);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                System.err.println("interrupted waiting for pixels!");
            }
            if ((pg.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
            }
        }
    }

    public int[] quantize() {
        this.learn();
        this.fix();
        this.inxbuild();
        for (int i = 0; i < this.pixels.length; ++i) {
            int alfa = this.pixels[i] >> 24 & 0xFF;
            int r = this.pixels[i] >> 16 & 0xFF;
            int g = this.pixels[i] >> 8 & 0xFF;
            int b = this.pixels[i] & 0xFF;
            int idx = this.inxsearch(b, g, r);
            int bb = this.colormap[idx][0];
            int gg = this.colormap[idx][1];
            int rr = this.colormap[idx][2];
            this.pixels[i] = alfa << 24 | rr << 16 | gg << 8 | bb;
        }
        return this.pixels;
    }

    public int quantize(byte[] newPixels, int[] colorMap, int[] colorInfo) {
        int i;
        this.learn();
        this.fix();
        this.inxbuild();
        for (i = 0; i < this.pixels.length; ++i) {
            int rgb = this.pixels[i];
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            newPixels[i] = rgb >>> 24 < 128 ? -1 : (byte)this.inxsearch(b, g, r);
        }
        for (i = 0; i < 256; ++i) {
            int b = this.colormap[i][0];
            int g = this.colormap[i][1];
            int r = this.colormap[i][2];
            int a = this.colormap[i][3];
            colorMap[i] = a << 24 | r << 16 | g << 8 | b;
        }
        int bitsPerPixel = 0;
        while (1 << bitsPerPixel < 256) {
            ++bitsPerPixel;
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = -1;
        if (this.transparent_color >= 0) {
            colorMap[255] = this.transparent_color;
            colorInfo[1] = 255;
        }
        return this.transparent_color >= 0 ? 255 : 256;
    }

    public int quantize(int[] colorMap, int[] colorInfo) {
        this.learn();
        this.fix();
        this.inxbuild();
        for (int i = 0; i < 256; ++i) {
            int b = this.colormap[i][0];
            int g = this.colormap[i][1];
            int r = this.colormap[i][2];
            int a = this.colormap[i][3];
            colorMap[i] = a << 24 | r << 16 | g << 8 | b;
        }
        int bitsPerPixel = 0;
        while (1 << bitsPerPixel < 256) {
            ++bitsPerPixel;
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = -1;
        if (this.transparent_color >= 0) {
            colorMap[255] = this.transparent_color;
            colorInfo[1] = 255;
        }
        return this.transparent_color >= 0 ? 255 : 256;
    }

    private void altersingle(double alpha, int i, double b, double g, double r) {
        double[] n = this.network[i];
        n[0] = n[0] - alpha * (n[0] - b);
        n[1] = n[1] - alpha * (n[1] - g);
        n[2] = n[2] - alpha * (n[2] - r);
    }

    private void alterneigh(double alpha, int rad, int i, double b, double g, double r) {
        int hi;
        int lo = i - rad;
        if (lo < 2) {
            lo = 2;
        }
        if ((hi = i + rad) > 256) {
            hi = 256;
        }
        int j = i + 1;
        int k = i - 1;
        int q = 0;
        while (j < hi || k > lo) {
            double[] p;
            double a = alpha * (double)(rad * rad - q * q) / (double)(rad * rad);
            ++q;
            if (j < hi) {
                p = this.network[j];
                p[0] = p[0] - a * (p[0] - b);
                p[1] = p[1] - a * (p[1] - g);
                p[2] = p[2] - a * (p[2] - r);
                ++j;
            }
            if (k <= lo) continue;
            p = this.network[k];
            p[0] = p[0] - a * (p[0] - b);
            p[1] = p[1] - a * (p[1] - g);
            p[2] = p[2] - a * (p[2] - r);
            --k;
        }
    }

    private int contest(double b, double g, double r) {
        int bestpos;
        double bestd;
        double bestbiasd = bestd = 3.4028234663852886E38;
        int bestbiaspos = bestpos = -1;
        for (int i = 3; i < 256; ++i) {
            double biasdist;
            double a;
            double[] n = this.network[i];
            double dist = n[0] - b;
            if (dist < 0.0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0.0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0.0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i;
            }
            if ((biasdist = dist - this.bias[i]) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i;
            }
            int n2 = i;
            this.freq[n2] = this.freq[n2] - 9.765625E-4 * this.freq[i];
            int n3 = i;
            this.bias[n3] = this.bias[n3] + 1.0 * this.freq[i];
        }
        int n = bestpos;
        this.freq[n] = this.freq[n] + 9.765625E-4;
        int n4 = bestpos;
        this.bias[n4] = this.bias[n4] - 1.0;
        return bestbiaspos;
    }

    private int specialFind(double b, double g, double r) {
        for (int i = 0; i < 3; ++i) {
            double[] n = this.network[i];
            if (n[0] != b || n[1] != g || n[2] != r) continue;
            return i;
        }
        return -1;
    }

    private void learn() {
        int biasRadius = 2048;
        int alphadec = 30 + (this.samplefac - 1) / 3;
        int lengthcount = this.pixels.length;
        int samplepixels = lengthcount / this.samplefac;
        int delta = samplepixels / 100;
        int alpha = 1024;
        int i = 0;
        int rad = biasRadius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        LOGGER.info("beginning 1D learning: samplepixels = {} rad = {}", (Object)samplepixels, (Object)rad);
        int step = 0;
        int pos = 0;
        step = lengthcount % 499 != 0 ? 499 : (lengthcount % 491 != 0 ? 491 : (lengthcount % 487 != 0 ? 487 : 503));
        i = 0;
        while (i < samplepixels) {
            int j;
            int p = this.pixels[pos];
            if (p >>> 24 < 128 && this.transparent_color < 0) {
                this.transparent_color = p;
            }
            double r = p >> 16 & 0xFF;
            double g = p >> 8 & 0xFF;
            double b = p & 0xFF;
            if (i == 0) {
                this.network[2][0] = b;
                this.network[2][1] = g;
                this.network[2][2] = r;
            }
            int n = j = (j = this.specialFind(b, g, r)) < 0 ? this.contest(b, g, r) : j;
            if (j >= 3) {
                double a = 1.0 * (double)alpha / 1024.0;
                this.altersingle(a, j, b, g, r);
                if (rad > 0) {
                    this.alterneigh(a, rad, j, b, g, r);
                }
            }
            pos += step;
            while (pos >= lengthcount) {
                pos -= lengthcount;
            }
            if (++i % delta != 0) continue;
            alpha -= alpha / alphadec;
            if ((rad = (biasRadius -= biasRadius / 30) >> 6) > 1) continue;
            rad = 0;
        }
        LOGGER.info("finished 1D learning: final alpha = {} !", (Object)(1.0 * (double)alpha / 1024.0));
    }

    private void fix() {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x = (int)(0.5 + this.network[i][j]);
                if (x < 0) {
                    x = 0;
                }
                if (x > 255) {
                    x = 255;
                }
                this.colormap[i][j] = x;
            }
            this.colormap[i][3] = i;
        }
    }

    private void inxbuild() {
        int previouscol = 0;
        int startpos = 0;
        for (int i = 0; i < 256; ++i) {
            int j;
            int[] p = this.colormap[i];
            int[] q = null;
            int smallpos = i;
            int smallval = p[1];
            for (j = i + 1; j < 256; ++j) {
                q = this.colormap[j];
                if (q[1] >= smallval) continue;
                smallpos = j;
                smallval = q[1];
            }
            q = this.colormap[smallpos];
            if (i != smallpos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval == previouscol) continue;
            this.netindex[previouscol] = startpos + i >> 1;
            for (j = previouscol + 1; j < smallval; ++j) {
                this.netindex[j] = i;
            }
            previouscol = smallval;
            startpos = i;
        }
        this.netindex[previouscol] = startpos + 255 >> 1;
        for (int j = previouscol + 1; j < 256; ++j) {
            this.netindex[j] = 255;
        }
    }

    private int inxsearch(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        int i = this.netindex[g];
        int j = i - 1;
        while (i < 256 || j >= 0) {
            int a;
            int dist;
            int[] p;
            if (i < 256) {
                p = this.colormap[i];
                dist = p[1] - g;
                if (dist >= bestd) {
                    i = 256;
                } else {
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestd) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            bestd = dist;
                            best = i;
                        }
                    }
                    ++i;
                }
            }
            if (j < 0) continue;
            p = this.colormap[j];
            dist = g - p[1];
            if (dist >= bestd) {
                j = -1;
                continue;
            }
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = p[0] - b) < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                a = p[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) < bestd) {
                    bestd = dist;
                    best = j;
                }
            }
            --j;
        }
        return best;
    }
}

