/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.quant;

public class WuQuant {
    private static final int MAXCOLOR = 256;
    private static final int RED = 2;
    private static final int GREEN = 1;
    private static final int BLUE = 0;
    private static int QUANT_SIZE = 33;
    private int size;
    private int lut_size;
    private int[] qadd;
    private int[] pixels;
    private int transparent_color = -1;
    private float[][][] m2 = new float[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] wt = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] mr = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] mg = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];
    private long[][][] mb = new long[QUANT_SIZE][QUANT_SIZE][QUANT_SIZE];

    public WuQuant(int[] pixels, int lut_size) {
        this.pixels = pixels;
        this.size = pixels.length;
        this.lut_size = lut_size;
    }

    public int quantize(byte[] newPixels, int[] lut, int[] colorInfo) {
        int k;
        int i;
        Box[] cube = new Box[256];
        int[] tag = new int[QUANT_SIZE * QUANT_SIZE * QUANT_SIZE];
        float[] vv = new float[256];
        this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        for (i = 0; i < 256; ++i) {
            cube[i] = new Box();
        }
        cube[0].b0 = 0;
        cube[0].g0 = 0;
        cube[0].r0 = 0;
        cube[0].g1 = cube[0].b1 = QUANT_SIZE - 1;
        cube[0].r1 = cube[0].b1;
        int next = 0;
        if (this.transparent_color >= 0) {
            --this.lut_size;
        }
        for (i = 1; i < this.lut_size; ++i) {
            if (this.Cut(cube[next], cube[i])) {
                vv[next] = cube[next].vol > 1 ? this.Var(cube[next]) : 0.0f;
                vv[i] = cube[i].vol > 1 ? this.Var(cube[i]) : 0.0f;
            } else {
                vv[next] = 0.0f;
                --i;
            }
            next = 0;
            float temp = vv[0];
            for (k = 1; k <= i; ++k) {
                if (!(vv[k] > temp)) continue;
                temp = vv[k];
                next = k;
            }
            if (!(temp <= 0.0f)) continue;
            k = i + 1;
            break;
        }
        for (k = 0; k < this.lut_size; ++k) {
            this.Mark(cube[k], k, tag);
            long weight = this.Vol(cube[k], this.wt);
            if (weight > 0L) {
                int lut_r = (int)(this.Vol(cube[k], this.mr) / weight);
                int lut_g = (int)(this.Vol(cube[k], this.mg) / weight);
                int lut_b = (int)(this.Vol(cube[k], this.mb) / weight);
                lut[k] = 0xFF000000 | lut_r << 16 | lut_g << 8 | lut_b;
                continue;
            }
            lut[k] = 0;
        }
        for (i = 0; i < this.size; ++i) {
            newPixels[i] = this.pixels[i] >>> 24 < 128 ? (byte)this.lut_size : (byte)tag[this.qadd[i]];
        }
        int bitsPerPixel = 0;
        while (1 << bitsPerPixel < this.lut_size) {
            ++bitsPerPixel;
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = -1;
        if (this.transparent_color >= 0) {
            lut[this.lut_size] = this.transparent_color;
            colorInfo[1] = this.lut_size;
        }
        return this.lut_size;
    }

    public int quantize(int[] lut, int[] colorInfo) {
        int k;
        int i;
        Box[] cube = new Box[256];
        float[] vv = new float[256];
        this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
        for (i = 0; i < 256; ++i) {
            cube[i] = new Box();
        }
        cube[0].b0 = 0;
        cube[0].g0 = 0;
        cube[0].r0 = 0;
        cube[0].g1 = cube[0].b1 = QUANT_SIZE - 1;
        cube[0].r1 = cube[0].b1;
        int next = 0;
        if (this.transparent_color >= 0) {
            --this.lut_size;
        }
        for (i = 1; i < this.lut_size; ++i) {
            if (this.Cut(cube[next], cube[i])) {
                vv[next] = cube[next].vol > 1 ? this.Var(cube[next]) : 0.0f;
                vv[i] = cube[i].vol > 1 ? this.Var(cube[i]) : 0.0f;
            } else {
                vv[next] = 0.0f;
                --i;
            }
            next = 0;
            float temp = vv[0];
            for (k = 1; k <= i; ++k) {
                if (!(vv[k] > temp)) continue;
                temp = vv[k];
                next = k;
            }
            if (!(temp <= 0.0f)) continue;
            k = i + 1;
            break;
        }
        for (k = 0; k < this.lut_size; ++k) {
            long weight = this.Vol(cube[k], this.wt);
            if (weight > 0L) {
                int lut_r = (int)(this.Vol(cube[k], this.mr) / weight);
                int lut_g = (int)(this.Vol(cube[k], this.mg) / weight);
                int lut_b = (int)(this.Vol(cube[k], this.mb) / weight);
                lut[k] = 0xFF000000 | lut_r << 16 | lut_g << 8 | lut_b;
                continue;
            }
            lut[k] = 0;
        }
        int bitsPerPixel = 0;
        while (1 << bitsPerPixel < this.lut_size) {
            ++bitsPerPixel;
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = -1;
        if (this.transparent_color >= 0) {
            lut[this.lut_size] = this.transparent_color;
            colorInfo[1] = this.lut_size;
        }
        return this.lut_size;
    }

    private void Hist3d(long[][][] vwt, long[][][] vmr, long[][][] vmg, long[][][] vmb, float[][][] m2) {
        int i;
        int[] table = new int[256];
        for (i = 0; i < 256; ++i) {
            table[i] = i * i;
        }
        this.qadd = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            int rgb = this.pixels[i];
            if (rgb >>> 24 < 128 && this.transparent_color < 0) {
                this.transparent_color = rgb;
            }
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int inr = (r >> 3) + 1;
            int ing = (g >> 3) + 1;
            int inb = (b >> 3) + 1;
            this.qadd[i] = (inr << 10) + (inr << 6) + inr + (ing << 5) + ing + inb;
            long[] lArray = vwt[inr][ing];
            int n = inb;
            lArray[n] = lArray[n] + 1L;
            long[] lArray2 = vmr[inr][ing];
            int n2 = inb;
            lArray2[n2] = lArray2[n2] + (long)r;
            long[] lArray3 = vmg[inr][ing];
            int n3 = inb;
            lArray3[n3] = lArray3[n3] + (long)g;
            long[] lArray4 = vmb[inr][ing];
            int n4 = inb;
            lArray4[n4] = lArray4[n4] + (long)b;
            float[] fArray = m2[inr][ing];
            int n5 = inb;
            fArray[n5] = fArray[n5] + (float)(table[r] + table[g] + table[b]);
        }
    }

    private void M3d(long[][][] vwt, long[][][] vmr, long[][][] vmg, long[][][] vmb, float[][][] m2) {
        int[] area = new int[QUANT_SIZE];
        int[] area_r = new int[QUANT_SIZE];
        int[] area_g = new int[QUANT_SIZE];
        int[] area_b = new int[QUANT_SIZE];
        float[] area2 = new float[QUANT_SIZE];
        for (int r = 1; r < QUANT_SIZE; ++r) {
            for (int i = 0; i < QUANT_SIZE; ++i) {
                area_b[i] = 0;
                area_g[i] = 0;
                area_r[i] = 0;
                area[i] = 0;
                area2[i] = 0;
            }
            for (int g = 1; g < QUANT_SIZE; ++g) {
                int line_b = 0;
                int line_g = 0;
                int line_r = 0;
                int line = 0;
                float line2 = 0;
                for (int b = 1; b < QUANT_SIZE; ++b) {
                    line = (int)((long)line + vwt[r][g][b]);
                    line_r = (int)((long)line_r + vmr[r][g][b]);
                    line_g = (int)((long)line_g + vmg[r][g][b]);
                    line_b = (int)((long)line_b + vmb[r][g][b]);
                    line2 += m2[r][g][b];
                    int n = b;
                    area[n] = area[n] + line;
                    int n2 = b;
                    area_r[n2] = area_r[n2] + line_r;
                    int n3 = b;
                    area_g[n3] = area_g[n3] + line_g;
                    int n4 = b;
                    area_b[n4] = area_b[n4] + line_b;
                    int n5 = b;
                    area2[n5] = area2[n5] + line2;
                    vwt[r][g][b] = vwt[r - 1][g][b] + (long)area[b];
                    vmr[r][g][b] = vmr[r - 1][g][b] + (long)area_r[b];
                    vmg[r][g][b] = vmg[r - 1][g][b] + (long)area_g[b];
                    vmb[r][g][b] = vmb[r - 1][g][b] + (long)area_b[b];
                    m2[r][g][b] = m2[r - 1][g][b] + area2[b];
                }
            }
        }
    }

    private long Vol(Box cube, long[][][] mmt) {
        return mmt[cube.r1][cube.g1][cube.b1] - mmt[cube.r1][cube.g1][cube.b0] - mmt[cube.r1][cube.g0][cube.b1] + mmt[cube.r1][cube.g0][cube.b0] - mmt[cube.r0][cube.g1][cube.b1] + mmt[cube.r0][cube.g1][cube.b0] + mmt[cube.r0][cube.g0][cube.b1] - mmt[cube.r0][cube.g0][cube.b0];
    }

    private long Bottom(Box cube, int dir, long[][][] mmt) {
        switch (dir) {
            case 2: {
                return -mmt[cube.r0][cube.g1][cube.b1] + mmt[cube.r0][cube.g1][cube.b0] + mmt[cube.r0][cube.g0][cube.b1] - mmt[cube.r0][cube.g0][cube.b0];
            }
            case 1: {
                return -mmt[cube.r1][cube.g0][cube.b1] + mmt[cube.r1][cube.g0][cube.b0] + mmt[cube.r0][cube.g0][cube.b1] - mmt[cube.r0][cube.g0][cube.b0];
            }
            case 0: {
                return -mmt[cube.r1][cube.g1][cube.b0] + mmt[cube.r1][cube.g0][cube.b0] + mmt[cube.r0][cube.g1][cube.b0] - mmt[cube.r0][cube.g0][cube.b0];
            }
        }
        return 0L;
    }

    private long Top(Box cube, int dir, int pos, long[][][] mmt) {
        switch (dir) {
            case 2: {
                return mmt[pos][cube.g1][cube.b1] - mmt[pos][cube.g1][cube.b0] - mmt[pos][cube.g0][cube.b1] + mmt[pos][cube.g0][cube.b0];
            }
            case 1: {
                return mmt[cube.r1][pos][cube.b1] - mmt[cube.r1][pos][cube.b0] - mmt[cube.r0][pos][cube.b1] + mmt[cube.r0][pos][cube.b0];
            }
            case 0: {
                return mmt[cube.r1][cube.g1][pos] - mmt[cube.r1][cube.g0][pos] - mmt[cube.r0][cube.g1][pos] + mmt[cube.r0][cube.g0][pos];
            }
        }
        return 0L;
    }

    private float Var(Box cube) {
        float dr = this.Vol(cube, this.mr);
        float dg = this.Vol(cube, this.mg);
        float db = this.Vol(cube, this.mb);
        float xx = this.m2[cube.r1][cube.g1][cube.b1] - this.m2[cube.r1][cube.g1][cube.b0] - this.m2[cube.r1][cube.g0][cube.b1] + this.m2[cube.r1][cube.g0][cube.b0] - this.m2[cube.r0][cube.g1][cube.b1] + this.m2[cube.r0][cube.g1][cube.b0] + this.m2[cube.r0][cube.g0][cube.b1] - this.m2[cube.r0][cube.g0][cube.b0];
        return xx - (dr * dr + dg * dg + db * db) / (float)this.Vol(cube, this.wt);
    }

    private float Maximize(Box cube, int dir, int first, int last, int[] cut, long whole_r, long whole_g, long whole_b, long whole_w) {
        long base_r = this.Bottom(cube, dir, this.mr);
        long base_g = this.Bottom(cube, dir, this.mg);
        long base_b = this.Bottom(cube, dir, this.mb);
        long base_w = this.Bottom(cube, dir, this.wt);
        float max = 0.0f;
        cut[0] = -1;
        for (int i = first; i < last; ++i) {
            long half_r = base_r + this.Top(cube, dir, i, this.mr);
            long half_g = base_g + this.Top(cube, dir, i, this.mg);
            long half_b = base_b + this.Top(cube, dir, i, this.mb);
            long half_w = base_w + this.Top(cube, dir, i, this.wt);
            if (half_w == 0L) continue;
            float temp = (float)(half_r * half_r + half_g * half_g + half_b * half_b) / (float)half_w;
            half_r = whole_r - half_r;
            half_g = whole_g - half_g;
            half_b = whole_b - half_b;
            if ((half_w = whole_w - half_w) == 0L || !((temp += (float)(half_r * half_r + half_g * half_g + half_b * half_b) / (float)half_w) > max)) continue;
            max = temp;
            cut[0] = i;
        }
        return max;
    }

    private boolean Cut(Box set1, Box set2) {
        int dir;
        int[] cutr = new int[1];
        int[] cutg = new int[1];
        int[] cutb = new int[1];
        long whole_r = this.Vol(set1, this.mr);
        long whole_g = this.Vol(set1, this.mg);
        long whole_b = this.Vol(set1, this.mb);
        long whole_w = this.Vol(set1, this.wt);
        float maxr = this.Maximize(set1, 2, set1.r0 + 1, set1.r1, cutr, whole_r, whole_g, whole_b, whole_w);
        float maxg = this.Maximize(set1, 1, set1.g0 + 1, set1.g1, cutg, whole_r, whole_g, whole_b, whole_w);
        float maxb = this.Maximize(set1, 0, set1.b0 + 1, set1.b1, cutb, whole_r, whole_g, whole_b, whole_w);
        if (maxr >= maxg && maxr >= maxb) {
            dir = 2;
            if (cutr[0] < 0) {
                return false;
            }
        } else {
            dir = maxg >= maxr && maxg >= maxb ? 1 : 0;
        }
        set2.r1 = set1.r1;
        set2.g1 = set1.g1;
        set2.b1 = set1.b1;
        switch (dir) {
            case 2: {
                set2.r0 = set1.r1 = cutr[0];
                set2.g0 = set1.g0;
                set2.b0 = set1.b0;
                break;
            }
            case 1: {
                set2.g0 = set1.g1 = cutg[0];
                set2.r0 = set1.r0;
                set2.b0 = set1.b0;
                break;
            }
            case 0: {
                set2.b0 = set1.b1 = cutb[0];
                set2.r0 = set1.r0;
                set2.g0 = set1.g0;
            }
        }
        set1.vol = (set1.r1 - set1.r0) * (set1.g1 - set1.g0) * (set1.b1 - set1.b0);
        set2.vol = (set2.r1 - set2.r0) * (set2.g1 - set2.g0) * (set2.b1 - set2.b0);
        return true;
    }

    private void Mark(Box cube, int label, int[] tag) {
        for (int r = cube.r0 + 1; r <= cube.r1; ++r) {
            for (int g = cube.g0 + 1; g <= cube.g1; ++g) {
                for (int b = cube.b0 + 1; b <= cube.b1; ++b) {
                    tag[(r << 10) + (r << 6) + r + (g << 5) + g + b] = label;
                }
            }
        }
    }

    private static final class Box {
        int r0;
        int r1;
        int g0;
        int g1;
        int b0;
        int b1;
        int vol;

        private Box() {
        }
    }
}

