/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.bmp.BmpCompression;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.Arrays;

public class BMPReader
extends ImageReader {
    private static final int END_OF_LINE = 0;
    private static final int END_OF_BITMAP = 1;
    private static final int DELTA = 2;
    private int bytePerScanLine;
    private int alignment = 0;
    private int compression = 0;
    BitmapHeader bitmapHeader;
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPReader.class);

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        this.bitmapHeader = new BitmapHeader();
        this.bitmapHeader.readHeader(is);
        this.width = this.bitmapHeader.imageWidth;
        this.height = this.bitmapHeader.imageHeight;
        this.compression = this.bitmapHeader.compression;
        if (this.height < 0) {
            this.alignment = 1;
            this.height = -this.height;
        }
        LOGGER.info("Scanline alignment: {}", (Object)(this.alignment == 0 ? "BOTTOM_UP" : "TOP_DOWN"));
        this.bitsPerPixel = this.bitmapHeader.bitCount;
        int bitPerWidth = this.width * this.bitsPerPixel;
        this.bytePerScanLine = bitPerWidth % 32 == 0 ? bitPerWidth >>> 3 : (bitPerWidth >>> 3) + (4 - (bitPerWidth >>> 3) % 4);
        switch (this.bitmapHeader.bitCount) {
            case 1: {
                return this.readIndexColorBitmap(is);
            }
            case 4: 
            case 8: {
                if (this.compression == BmpCompression.BI_RLE4.getValue() || this.compression == BmpCompression.BI_RLE8.getValue()) {
                    return this.readCompressedIndexColorBitmap(is);
                }
                return this.readIndexColorBitmap(is);
            }
            case 16: {
                LOGGER.error("16 bit BMP, decoding not implemented!");
                return null;
            }
            case 24: {
                return this.read24bitTrueColorBitmap(is);
            }
            case 32: {
                return this.read32bitTrueColorBitmap(is);
            }
        }
        LOGGER.error("Unsupported bitmap format!");
        return null;
    }

    private void readPalette(InputStream is) throws Exception {
        int index = 0;
        int nindex = 0;
        int numOfColors = this.bitmapHeader.colorsUsed == 0 ? 1 << this.bitsPerPixel : this.bitmapHeader.colorsUsed;
        byte[] brgb = new byte[numOfColors * 4];
        this.rgbColorPalette = new int[numOfColors];
        IOUtils.readFully(is, brgb, 0, numOfColors * 4);
        for (int i = 0; i < numOfColors; ++i) {
            this.rgbColorPalette[index++] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex + 1] & 0xFF) << 8 | (brgb[nindex + 2] & 0xFF) << 16;
            nindex += 4;
        }
        IOUtils.skipFully(is, this.bitmapHeader.dataOffSet - numOfColors * 4 - this.bitmapHeader.infoHeaderLen - 14);
    }

    private BufferedImage read24bitTrueColorBitmap(InputStream is) throws Exception {
        int startIndex;
        int i;
        LOGGER.info("24 bits bitmap color image!");
        int npad = this.bytePerScanLine - 3 * this.width;
        if (npad == 4) {
            npad = 0;
        }
        IOUtils.skipFully(is, this.bitmapHeader.dataOffSet - 54);
        int bytePerWidth = this.bytePerScanLine - npad;
        byte[] buffer = new byte[this.bytePerScanLine];
        byte[] pixels = new byte[bytePerWidth * this.height];
        LOGGER.info("Scanline padding: {}", (Object)npad);
        if (this.alignment == 0) {
            i = 0;
            startIndex = (this.height - 1) * bytePerWidth;
            while (i < this.height) {
                IOUtils.readFully(is, buffer);
                System.arraycopy(buffer, 0, pixels, startIndex, bytePerWidth);
                ++i;
                startIndex -= bytePerWidth;
            }
        } else {
            i = 0;
            startIndex = 0;
            while (i < this.height) {
                IOUtils.readFully(is, buffer);
                System.arraycopy(buffer, 0, pixels, startIndex, bytePerWidth);
                ++i;
                startIndex += bytePerWidth;
            }
        }
        is.close();
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        int[] off = new int[]{2, 1, 0};
        int numOfBands = 3;
        int trans = 1;
        WritableRaster raster = Raster.createInterleavedRaster(db, this.width, this.height, bytePerWidth, numOfBands, off, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, trans, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage read32bitTrueColorBitmap(InputStream is) throws Exception {
        int j;
        int i;
        int index;
        LOGGER.info("32 bits bitmap color image!");
        byte[] brgb = new byte[this.bytePerScanLine];
        int[] pix = new int[this.width * this.height];
        IOUtils.skipFully(is, this.bitmapHeader.dataOffSet - 54);
        if (this.alignment == 0) {
            index = 0;
            for (i = 1; i <= this.height; ++i) {
                IOUtils.readFully(is, brgb, 0, this.bytePerScanLine);
                index = this.width * (this.height - i);
                int nindex = 0;
                for (j = 0; j < this.width; ++j) {
                    pix[index++] = brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16 | 0xFF000000;
                    ++nindex;
                }
            }
        } else {
            index = 0;
            for (i = 0; i < this.height; ++i) {
                IOUtils.readFully(is, brgb, 0, this.bytePerScanLine);
                int nindex = 0;
                for (j = 0; j < this.width; ++j) {
                    pix[index++] = brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16 | 0xFF000000;
                    ++nindex;
                }
            }
        }
        is.close();
        DataBufferInt db = new DataBufferInt(pix, pix.length);
        WritableRaster raster = Raster.createPackedRaster(db, this.width, this.height, this.width, new int[]{0xFF0000, 65280, 255}, null);
        DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage read32bitTrueColorBitmap2(InputStream is) throws Exception {
        int j;
        int i;
        int index;
        LOGGER.info("32 bits bitmap color image!");
        IOUtils.skipFully(is, this.bitmapHeader.dataOffSet - 54);
        int bytePerWidth = this.bytePerScanLine;
        byte[] buffer = new byte[this.bytePerScanLine];
        byte[] pixels = new byte[bytePerWidth * this.height];
        Arrays.fill(pixels, (byte)-1);
        if (this.alignment == 0) {
            index = 0;
            for (i = 1; i <= this.height; ++i) {
                IOUtils.readFully(is, buffer);
                index = bytePerWidth * (this.height - i);
                j = 0;
                while (j < bytePerWidth) {
                    pixels[index++] = buffer[j++];
                    pixels[index++] = buffer[j++];
                    pixels[index++] = buffer[j++];
                    ++j;
                    ++index;
                }
            }
        } else {
            index = 0;
            for (i = 0; i < this.height; ++i) {
                IOUtils.readFully(is, buffer);
                j = 0;
                while (j < bytePerWidth) {
                    pixels[index++] = buffer[j++];
                    pixels[index++] = buffer[j++];
                    pixels[index++] = buffer[j++];
                    ++j;
                    ++index;
                }
            }
        }
        is.close();
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        int[] off = new int[]{2, 1, 0, 3};
        int numOfBands = 4;
        int trans = 1;
        int[] nBits = new int[]{8, 8, 8, 8};
        WritableRaster raster = Raster.createInterleavedRaster(db, this.width, this.height, this.bytePerScanLine, numOfBands, off, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, true, false, trans, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage readCompressedIndexColorBitmap(InputStream is) throws Exception {
        byte[] pixels = null;
        if (this.bitsPerPixel == 8) {
            pixels = this.read256ColorCompressedBitmap(is);
        } else if (this.bitsPerPixel == 4) {
            pixels = this.read16ColorCompressedBitmap(is);
        } else {
            throw new IllegalArgumentException("Invalid bitsPerPixel: " + this.bitsPerPixel);
        }
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        WritableRaster raster = null;
        if (this.bitsPerPixel != 8) {
            raster = Raster.createPackedRaster(db, this.width, this.height, this.bitsPerPixel, null);
        } else {
            int[] off = new int[]{0};
            raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, off, null);
        }
        IndexColorModel cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage readIndexColorBitmap(InputStream is) throws Exception {
        int startIndex;
        int i;
        LOGGER.info("{} color bitmap color image!", (Object)(1 << this.bitsPerPixel));
        this.readPalette(is);
        int npad = 0;
        switch (this.bitsPerPixel) {
            case 1: {
                npad = (32 - this.width % 32) / 8;
                break;
            }
            case 4: {
                npad = (32 - this.width * 4 % 32) / 8;
                break;
            }
            case 8: {
                npad = this.bytePerScanLine - this.width;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid bitsPerPixel: " + this.bitsPerPixel + " for BMP indexColor image!");
            }
        }
        if (npad == 4) {
            npad = 0;
        }
        int bytePerWidth = this.bytePerScanLine - npad;
        byte[] buffer = new byte[this.bytePerScanLine];
        byte[] pixels = new byte[bytePerWidth * this.height];
        LOGGER.info("Scanline padding: {}", (Object)npad);
        if (this.alignment == 0) {
            i = 0;
            startIndex = (this.height - 1) * bytePerWidth;
            while (i < this.height) {
                IOUtils.readFully(is, buffer);
                System.arraycopy(buffer, 0, pixels, startIndex, bytePerWidth);
                ++i;
                startIndex -= bytePerWidth;
            }
        } else {
            i = 0;
            startIndex = 0;
            while (i < this.height) {
                IOUtils.readFully(is, buffer);
                System.arraycopy(buffer, 0, pixels, startIndex, bytePerWidth);
                ++i;
                startIndex += bytePerWidth;
            }
        }
        is.close();
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        WritableRaster raster = null;
        if (this.bitsPerPixel != 8) {
            raster = Raster.createPackedRaster(db, this.width, this.height, this.bitsPerPixel, null);
        } else {
            int[] off = new int[]{0};
            raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, off, null);
        }
        IndexColorModel cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private byte[] read256ColorCompressedBitmap(InputStream is) throws Exception {
        LOGGER.info("256 color bitmap color image!");
        LOGGER.info("compressed format!");
        this.readPalette(is);
        int index = 0;
        int nindex = 0;
        int len = 0;
        int esc = 0;
        int count = 0;
        int vert_offset = 0;
        int horz_offset = 0;
        int horz = 0;
        int vert = this.height - 1;
        int bufferSize = 2048;
        boolean done_with_bitmap = false;
        byte[] brgb = new byte[bufferSize];
        int readSize = is.read(brgb, 0, bufferSize);
        byte[] pixels = new byte[this.width * this.height];
        index = this.width * vert + horz;
        do {
            if (nindex >= readSize) {
                readSize = is.read(brgb, 0, bufferSize);
                nindex = 0;
            }
            len = brgb[nindex++] & 0xFF;
            if (nindex >= readSize) {
                readSize = is.read(brgb, 0, bufferSize);
                nindex = 0;
            }
            if (len == 0) {
                esc = brgb[nindex++] & 0xFF;
                if (nindex >= readSize) {
                    readSize = is.read(brgb, 0, bufferSize);
                    nindex = 0;
                }
                if (esc > 2) {
                    count = 0;
                    for (int k = 1; k <= esc; ++k) {
                        pixels[index++] = brgb[nindex++];
                        if (nindex >= readSize) {
                            readSize = is.read(brgb, 0, bufferSize);
                            nindex = 0;
                        }
                        ++count;
                        if (++horz >= this.width) break;
                    }
                    if (count % 2 != 0) {
                        ++nindex;
                    }
                }
                if (esc == 2) {
                    LOGGER.info("found delta");
                    horz_offset = brgb[nindex++] & 0xFF;
                    if (nindex >= readSize) {
                        readSize = is.read(brgb, 0, bufferSize);
                        nindex = 0;
                    }
                    vert_offset = brgb[nindex++] & 0xFF;
                    if (nindex >= readSize) {
                        readSize = is.read(brgb, 0, bufferSize);
                        nindex = 0;
                    }
                    index = this.width * (vert -= vert_offset) + (horz += horz_offset);
                }
                if (esc == 0) {
                    horz = 0;
                    index = this.width * --vert + horz;
                }
                if (esc == 1) {
                    done_with_bitmap = true;
                }
            } else {
                byte b = brgb[nindex++];
                if (nindex >= readSize) {
                    readSize = is.read(brgb, 0, bufferSize);
                    nindex = 0;
                }
                for (int l = 0; l < len; ++l) {
                    pixels[index++] = b;
                    if (++horz >= this.width) break;
                }
            }
            if (vert >= 0) continue;
            done_with_bitmap = true;
        } while (!done_with_bitmap);
        is.close();
        return pixels;
    }

    private byte[] read16ColorCompressedBitmap(InputStream is) throws Exception {
        LOGGER.info("16 color bitmap color image!");
        LOGGER.info("compressed format!");
        this.readPalette(is);
        int nindex = 0;
        int index = 0;
        int horz = 0;
        int vert = this.height - 1;
        int horz_offset = 0;
        int vert_offset = 0;
        int count = 0;
        int counter = 0;
        int len = 0;
        int esc = 0;
        int bufferSize = 2048;
        boolean done_with_bitmap = false;
        byte[] brgb = new byte[bufferSize];
        int readSize = is.read(brgb, 0, bufferSize);
        byte[] pixels = new byte[this.width * this.height];
        index = this.width * vert + horz;
        do {
            int b;
            if (nindex >= readSize) {
                readSize = is.read(brgb, 0, bufferSize);
                nindex = 0;
            }
            len = brgb[nindex++] & 0xFF;
            if (nindex >= readSize) {
                readSize = is.read(brgb, 0, bufferSize);
                nindex = 0;
            }
            if (len == 0) {
                esc = brgb[nindex++] & 0xFF;
                if (nindex >= readSize) {
                    readSize = is.read(brgb, 0, bufferSize);
                    nindex = 0;
                }
                if (esc == 1) {
                    done_with_bitmap = true;
                }
                if (esc == 2) {
                    LOGGER.info("found delta");
                    horz_offset = brgb[nindex++] & 0xFF;
                    if (nindex >= readSize) {
                        readSize = is.read(brgb, 0, bufferSize);
                        nindex = 0;
                    }
                    vert_offset = brgb[nindex++] & 0xFF;
                    if (nindex >= readSize) {
                        readSize = is.read(brgb, 0, bufferSize);
                        nindex = 0;
                    }
                    index = this.width * (vert -= vert_offset) + (horz += horz_offset);
                }
                if (esc == 0) {
                    horz = 0;
                    index = this.width * --vert + horz;
                }
                if (esc > 2) {
                    count = 0;
                    do {
                        b = brgb[nindex++] & 0xFF;
                        if (nindex >= readSize) {
                            readSize = is.read(brgb, 0, bufferSize);
                            nindex = 0;
                        }
                        ++count;
                        pixels[index++] = (byte)(b >>> 4 & 0xF);
                        ++counter;
                        if (++horz >= this.width) break;
                        if (counter >= esc) continue;
                        pixels[index++] = (byte)(b & 0xF);
                        ++counter;
                        ++horz;
                    } while (horz < this.width && counter < esc);
                    counter = 0;
                    if (count % 2 != 0) {
                        ++nindex;
                    }
                }
            } else {
                b = brgb[nindex++] & 0xFF;
                if (nindex >= readSize) {
                    readSize = is.read(brgb, 0, bufferSize);
                    nindex = 0;
                }
                do {
                    pixels[index++] = (byte)(b >>> 4 & 0xF);
                    ++counter;
                    if (++horz >= this.width) break;
                    if (counter >= len) continue;
                    pixels[index++] = (byte)(b & 0xF);
                    ++counter;
                    if (++horz >= this.width) break;
                } while (counter < len);
                counter = 0;
            }
            if (vert >= 0) continue;
            done_with_bitmap = true;
        } while (!done_with_bitmap);
        is.close();
        return ArrayUtils.packByteArray(pixels, this.width, 0, this.bitsPerPixel, pixels.length);
    }

    private static class BitmapHeader {
        short signiture;
        int fileSize;
        short reserved1;
        short reserved2;
        int dataOffSet;
        int infoHeaderLen;
        int imageWidth;
        int imageHeight;
        short planes;
        short bitCount;
        int compression;
        int imageSize;
        int xResolution;
        int yResolution;
        int colorsUsed;
        int colorsImportant;

        private BitmapHeader() {
        }

        void readHeader(InputStream is) throws Exception {
            int nindex = 0;
            byte[] bhdr = new byte[18];
            IOUtils.readFully(is, bhdr, 0, 18);
            this.signiture = (short)(bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8);
            this.fileSize = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.reserved1 = (short)(bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8);
            this.reserved2 = (short)(bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8);
            this.dataOffSet = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.infoHeaderLen = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            bhdr = new byte[this.infoHeaderLen - 4];
            IOUtils.readFully(is, bhdr, 0, this.infoHeaderLen - 4);
            nindex = 0;
            this.imageWidth = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.imageHeight = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.planes = (short)(bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8);
            this.bitCount = (short)(bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8);
            this.compression = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.imageSize = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.xResolution = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.yResolution = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.colorsUsed = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
            this.colorsImportant = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8 | (bhdr[nindex++] & 0xFF) << 16 | (bhdr[nindex++] & 0xFF) << 24;
        }
    }
}

