/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.compression.lzw.LZWTreeDecoder;
import guilibshadow.cafe4j.image.gif.GIFFrame;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GIFReader
extends ImageReader {
    private GifHeader gifHeader;
    protected int logicalScreenWidth;
    protected int logicalScreenHeight;
    private Color backgroundColor = new Color(255, 255, 255);
    private int[] globalColorPalette;
    protected int disposalMethod = 0;
    protected int userInputFlag = 0;
    protected int transparencyFlag = 0;
    protected int transparent_color = -1;
    protected int delay;
    protected int colorsUsed;
    protected int image_x;
    protected int image_y;
    private List<GIFFrame> gifFrames;
    private List<BufferedImage> frames;
    private BufferedImage baseImage;
    private static final Logger LOGGER = LoggerFactory.getLogger(GIFReader.class);

    private byte[] decodeLZW(InputStream is) throws Exception {
        int dimension = this.width * this.height;
        byte[] temp_ = new byte[dimension];
        int min_code_size = is.read();
        LZWTreeDecoder decoder = new LZWTreeDecoder(is, min_code_size);
        decoder.decode(temp_, 0, dimension);
        return temp_;
    }

    private byte[] decodeLZWInterLaced(InputStream is) throws Exception {
        int index = 0;
        int index2 = 0;
        int[] passParam = new int[]{0, 8, 4, 8, 2, 4, 1, 2};
        int[] passStart = new int[]{0, this.width * passParam[2], this.width * passParam[4], this.width * passParam[6]};
        int[] passInc = new int[]{this.width * passParam[1], this.width * passParam[3], this.width * passParam[5], this.width * passParam[7]};
        int[] passHeight = new int[]{(this.height - 1 >> 3) + 1, this.height + 3 >> 3, this.height + 1 >> 2, this.height >> 1};
        int min_code_size = is.read();
        int dimension = this.width * this.height;
        byte[] buf = new byte[dimension];
        byte[] temp_ = new byte[dimension];
        LZWTreeDecoder decoder = new LZWTreeDecoder(is, min_code_size);
        decoder.decode(buf, 0, dimension);
        for (int pass = 1; pass < 5; ++pass) {
            index = passStart[pass - 1];
            int inc = passInc[pass - 1] - this.width;
            int row = 0;
            while (row < passHeight[pass - 1]) {
                int col = 0;
                while (col < this.width) {
                    temp_[index] = buf[index2];
                    ++col;
                    ++index;
                    ++index2;
                }
                ++row;
                index += inc;
            }
        }
        return temp_;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    protected BufferedImage getFrameAsBufferedImage(InputStream is) throws Exception {
        byte[] pixels = this.readFrame(is);
        if (pixels == null) {
            return null;
        }
        int[] off = new int[]{0};
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        WritableRaster raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, off, null);
        IndexColorModel cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, this.transparent_color, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    protected BufferedImage getFrameAsBufferedImageEx(InputStream is) throws Exception {
        int maxHeight;
        BufferedImage bi = this.getFrameAsBufferedImage(is);
        if (bi == null) {
            return null;
        }
        int maxWidth = this.width < this.logicalScreenWidth ? this.width : this.logicalScreenWidth;
        int n = maxHeight = this.height < this.logicalScreenHeight ? this.height : this.logicalScreenHeight;
        if (this.baseImage == null) {
            this.baseImage = new BufferedImage(this.logicalScreenWidth, this.logicalScreenHeight, 2);
        }
        Rectangle area = new Rectangle(this.image_x, this.image_y, maxWidth, maxHeight);
        BufferedImage backup = new BufferedImage(maxWidth, maxHeight, 2);
        backup.setData(this.baseImage.getData(area));
        Graphics2D g = this.baseImage.createGraphics();
        g.drawImage((Image)bi, this.image_x, this.image_y, null);
        BufferedImage clone = new BufferedImage(this.logicalScreenWidth, this.logicalScreenHeight, 2);
        clone.setData(this.baseImage.getData());
        if (this.disposalMethod != 1 && this.disposalMethod != 0) {
            if (this.disposalMethod == 2) {
                Composite oldComposite = g.getComposite();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(this.image_x, this.image_y, this.width, this.height);
                g.setComposite(oldComposite);
            } else if (this.disposalMethod == 3) {
                Composite oldComposite = g.getComposite();
                g.setComposite(AlphaComposite.Src);
                g.drawImage((Image)backup, this.image_x, this.image_y, null);
                g.setComposite(oldComposite);
            } else {
                this.baseImage = new BufferedImage(this.logicalScreenWidth, this.logicalScreenHeight, 2);
                g = this.baseImage.createGraphics();
            }
        }
        return clone;
    }

    @Override
    public int getFrameCount() {
        if (this.frames != null) {
            return this.frames.size();
        }
        return super.getFrameCount();
    }

    @Override
    public BufferedImage getFrame(int i) {
        if (this.frames == null) {
            return null;
        }
        if (i >= 0 && i < this.frames.size()) {
            return this.frames.get(i);
        }
        throw new IllegalArgumentException("Frame index " + i + " out of bounds");
    }

    @Override
    public List<BufferedImage> getFrames() {
        if (this.frames != null) {
            return Collections.unmodifiableList(this.frames);
        }
        return Collections.emptyList();
    }

    public GIFFrame getGIFFrame(int i) {
        if (this.gifFrames == null) {
            return null;
        }
        if (i < 0 || i >= this.gifFrames.size()) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.gifFrames.get(i);
    }

    public List<GIFFrame> getGIFFrames() {
        if (this.gifFrames != null) {
            return Collections.unmodifiableList(this.gifFrames);
        }
        return Collections.emptyList();
    }

    public int getLogicalScreenHeight() {
        return this.logicalScreenHeight;
    }

    public int getLogicalScreenWidth() {
        return this.logicalScreenWidth;
    }

    public int getTransparentColor() {
        if (this.transparent_color >= 0) {
            return this.rgbColorPalette[this.transparent_color] & 0xFFFFFF;
        }
        return -1;
    }

    public boolean isTransparent() {
        return this.transparencyFlag == 1;
    }

    private byte[] readFrame(InputStream is) throws Exception {
        if (this.gifHeader == null && !this.readGlobalScopeData(is)) {
            return null;
        }
        this.resetFrameParameters();
        int image_separator = 0;
        do {
            if ((image_separator = is.read()) == -1 || image_separator == 59) {
                LOGGER.info("End of stream!");
                return null;
            }
            if (image_separator != 33) continue;
            int func = is.read();
            int len = is.read();
            if (func == 249) {
                int packedFields = is.read();
                this.disposalMethod = (packedFields & 0x1C) >> 2;
                LOGGER.info("Disposal method: {}", (Object)(this.disposalMethod == 0 ? "UNSPECIFIED" : (this.disposalMethod == 1 ? "LEAVE_AS_IS" : (this.disposalMethod == 2 ? "RESTORE_TO_BACKGROUND" : (this.disposalMethod == 3 ? "RESTORE_TO_PREVIOUS" : "TO_BE_DEFINED")))));
                this.userInputFlag = (packedFields & 2) >> 1;
                LOGGER.info("User input flag: {}", (Object)(this.userInputFlag == 0 ? "INPUT_NONE" : "INPUT_SET"));
                this.delay = IOUtils.readUnsignedShort(is);
                LOGGER.info("Delay: {} miliseconds", (Object)(this.delay * 10));
                int transparent_color_index = is.read();
                if ((packedFields & 1) == 1) {
                    this.transparencyFlag = 1;
                    LOGGER.info("transparent gif...");
                    this.transparent_color = transparent_color_index;
                }
                len = is.read();
            }
            while (len != 0) {
                IOUtils.skipFully(is, len);
                len = is.read();
            }
        } while (image_separator != 44);
        byte flags2 = this.readImageDescriptor(is);
        boolean hasLocalColorMap = false;
        if ((flags2 & 0x80) == 128) {
            hasLocalColorMap = true;
            LOGGER.info("local color map is present");
            this.bitsPerPixel = (flags2 & 7) + 1;
            this.colorsUsed = 1 << this.bitsPerPixel;
            LOGGER.info("{} color image", (Object)this.colorsUsed);
            this.readLocalPalette(is, this.colorsUsed);
        }
        if (!hasLocalColorMap) {
            this.rgbColorPalette = this.globalColorPalette;
        }
        if (this.transparencyFlag == 1 && this.transparent_color < this.colorsUsed) {
            int n = this.transparent_color;
            this.rgbColorPalette[n] = this.rgbColorPalette[n] & 0xFFFFFF;
        }
        if ((flags2 & 0x40) == 64) {
            LOGGER.info("Interlaced gif image!");
            return this.decodeLZWInterLaced(is);
        }
        return this.decodeLZW(is);
    }

    private void readGlobalPalette(InputStream is, int num_of_color) throws Exception {
        int index1 = 0;
        int bytes2read = num_of_color * 3;
        byte[] brgb = new byte[bytes2read];
        IOUtils.readFully(is, brgb, 0, bytes2read);
        this.globalColorPalette = new int[num_of_color];
        for (int i = 0; i < num_of_color; ++i) {
            this.globalColorPalette[i] = 0xFF000000 | (brgb[index1++] & 0xFF) << 16 | (brgb[index1++] & 0xFF) << 8 | brgb[index1++] & 0xFF;
        }
    }

    private boolean readGlobalScopeData(InputStream is) throws Exception {
        this.gifHeader = new GifHeader();
        this.gifHeader.readHeader(is);
        this.logicalScreenWidth = this.gifHeader.screen_width;
        this.logicalScreenHeight = this.gifHeader.screen_height;
        String signature = new String(this.gifHeader.signature) + new String(this.gifHeader.version);
        LOGGER.info(signature);
        if (!signature.equalsIgnoreCase("GIF87a") && !signature.equalsIgnoreCase("GIF89a")) {
            LOGGER.warn("Only GIF87a and GIF89a is supported by this decoder!");
            return false;
        }
        byte flags = this.gifHeader.flags;
        if ((flags & 0x80) == 128) {
            LOGGER.info("a global color map is present!");
            this.bitsPerPixel = (flags & 7) + 1;
            this.colorsUsed = 1 << this.bitsPerPixel;
            LOGGER.info("{} color image", (Object)this.colorsUsed);
            int bitsPerColor = ((flags & 0x70) >> 4) + 1;
            this.readGlobalPalette(is, this.colorsUsed);
            int bgcolor = this.gifHeader.bgcolor & 0xFF;
            if (bgcolor < this.colorsUsed) {
                this.backgroundColor = new Color(this.globalColorPalette[bgcolor]);
            }
        }
        return true;
    }

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        this.frames = new ArrayList<BufferedImage>();
        this.gifFrames = new ArrayList<GIFFrame>();
        BufferedImage bi = null;
        while ((bi = this.getFrameAsBufferedImageEx(is)) != null) {
            this.gifFrames.add(new GIFFrame(bi, this.image_x, this.image_y, this.delay, this.disposalMethod, this.userInputFlag, this.transparencyFlag, this.transparent_color));
            this.frames.add(bi);
        }
        return this.frames.get(0);
    }

    private byte readImageDescriptor(InputStream is) throws Exception {
        int nindex = 0;
        byte[] ides = new byte[9];
        IOUtils.readFully(is, ides, 0, 9);
        this.image_x = ides[nindex++] & 0xFF | (ides[nindex++] & 0xFF) << 8;
        this.image_y = ides[nindex++] & 0xFF | (ides[nindex++] & 0xFF) << 8;
        this.width = ides[nindex++] & 0xFF | (ides[nindex++] & 0xFF) << 8;
        this.height = ides[nindex++] & 0xFF | (ides[nindex++] & 0xFF) << 8;
        return ides[nindex++];
    }

    private void readLocalPalette(InputStream is, int num_of_color) throws Exception {
        int index1 = 0;
        int bytes2read = num_of_color * 3;
        byte[] brgb = new byte[bytes2read];
        IOUtils.readFully(is, brgb, 0, bytes2read);
        this.rgbColorPalette = new int[num_of_color];
        for (int i = 0; i < num_of_color; ++i) {
            this.rgbColorPalette[i] = 0xFF000000 | (brgb[index1++] & 0xFF) << 16 | (brgb[index1++] & 0xFF) << 8 | brgb[index1++] & 0xFF;
        }
    }

    private void resetFrameParameters() {
        this.disposalMethod = 0;
        this.userInputFlag = 0;
        this.transparencyFlag = 0;
        this.transparent_color = -1;
        this.delay = 0;
        this.image_x = 0;
        this.image_y = 0;
        this.width = 0;
        this.height = 0;
    }

    private static class GifHeader {
        private byte[] signature = new byte[3];
        private byte[] version = new byte[3];
        private int screen_width;
        private int screen_height;
        private byte flags;
        private byte bgcolor;
        private byte aspectRatio;

        private GifHeader() {
        }

        void readHeader(InputStream is) throws Exception {
            int i;
            int nindex = 0;
            byte[] bhdr = new byte[13];
            IOUtils.readFully(is, bhdr, 0, 13);
            for (i = 0; i < 3; ++i) {
                this.signature[i] = bhdr[nindex++];
            }
            for (i = 0; i < 3; ++i) {
                this.version[i] = bhdr[nindex++];
            }
            this.screen_width = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8;
            this.screen_height = bhdr[nindex++] & 0xFF | (bhdr[nindex++] & 0xFF) << 8;
            this.flags = bhdr[nindex++];
            this.bgcolor = bhdr[nindex++];
            this.aspectRatio = bhdr[nindex++];
        }
    }
}

