/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.compression.UnsupportedCompressionException;
import guilibshadow.cafe4j.image.compression.huffman.HuffmanTbl;
import guilibshadow.cafe4j.image.jpeg.Component;
import guilibshadow.cafe4j.image.jpeg.DHTReader;
import guilibshadow.cafe4j.image.jpeg.DQTReader;
import guilibshadow.cafe4j.image.jpeg.HTable;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.QTable;
import guilibshadow.cafe4j.image.jpeg.SOFReader;
import guilibshadow.cafe4j.image.jpeg.SOSReader;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.adobe.IRB;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.meta.icc.ICCProfile;
import guilibshadow.cafe4j.image.meta.iptc.IPTC;
import guilibshadow.cafe4j.image.meta.jpeg.JpegExif;
import guilibshadow.cafe4j.image.meta.jpeg.JpegXMP;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.string.XMLUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class JPGReader
extends ImageReader {
    private Map<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
    private ByteArrayOutputStream iccProfileStream = null;
    private ByteArrayOutputStream eightBIMStream = null;
    private byte[] extendedXMP = null;
    private String xmpGUID = "";
    private int[][] quant_tbl = new int[4][];
    private HuffmanTbl[] dc_hufftbl = new HuffmanTbl[4];
    private HuffmanTbl[] ac_hufftbl = new HuffmanTbl[4];
    private Map<Integer, Component> components = new HashMap<Integer, Component>(4);
    private static final Logger LOGGER = LoggerFactory.getLogger(JPGReader.class);

    public BufferedImage read1(InputStream is) throws Exception {
        XMP xmp;
        boolean finished = false;
        int length = 0;
        ArrayList<SOFReader> readers = new ArrayList<SOFReader>();
        if (Marker.fromShort(IOUtils.readShortMM(is)) != Marker.SOI) {
            throw new IllegalArgumentException("Invalid JPEG image, expected SOI marker not found!");
        }
        short marker = IOUtils.readShortMM(is);
        block13: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case PADDING: {
                    int nextByte = 0;
                    while ((nextByte = IOUtils.read(is)) == 255) {
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block13;
                }
                case DQT: {
                    this.read_DQT(is);
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case DHT: {
                    this.read_DHT(is);
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case SOS: {
                    SOFReader reader = (SOFReader)readers.get(readers.size() - 1);
                    marker = this.readSOS(is, reader);
                    continue block13;
                }
                case SOF0: 
                case SOF1: 
                case SOF2: {
                    readers.add(this.readSOF(is, emarker));
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case SOF3: 
                case SOF5: 
                case SOF6: 
                case SOF7: 
                case SOF9: 
                case SOF10: 
                case SOF11: 
                case SOF13: 
                case SOF14: 
                case SOF15: {
                    throw new UnsupportedCompressionException(emarker.getDescription() + " is not supported by this decoder!");
                }
                case APP1: {
                    this.readAPP1(is);
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case APP2: {
                    this.readAPP2(is);
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case APP13: {
                    this.readAPP13(is);
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
                case APP14: {
                    this.readAPP14(is);
                    marker = IOUtils.readShortMM(is);
                    continue block13;
                }
            }
            length = IOUtils.readUnsignedShortMM(is);
            byte[] buf = new byte[length - 2];
            IOUtils.readFully(is, buf);
            marker = IOUtils.readShortMM(is);
        }
        if (this.extendedXMP != null && (xmp = (XMP)this.metadataMap.get((Object)MetadataType.XMP)) != null) {
            xmp.setExtendedXMPData(this.extendedXMP);
        }
        if (this.iccProfileStream != null) {
            ICCProfile icc_profile = new ICCProfile(this.iccProfileStream.toByteArray());
            this.metadataMap.put(MetadataType.ICC_PROFILE, icc_profile);
        }
        if (this.eightBIMStream != null) {
            IRB irb = new IRB(this.eightBIMStream.toByteArray());
            this.metadataMap.put(MetadataType.PHOTOSHOP_IRB, irb);
            _8BIM iptc = irb.get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (iptc != null) {
                this.metadataMap.put(MetadataType.IPTC, new IPTC(iptc.getData()));
            }
        }
        return null;
    }

    private void readAPP1(InputStream is) throws IOException {
        int i;
        byte[] guid;
        int length = IOUtils.readUnsignedShortMM(is);
        byte[] temp = new byte[length - 2];
        IOUtils.readFully(is, temp);
        if (temp.length >= "Exif\u0000\u0000".length() && new String(temp, 0, "Exif\u0000\u0000".length()).equals("Exif\u0000\u0000")) {
            JpegExif exif = new JpegExif(ArrayUtils.subArray(temp, "Exif\u0000\u0000".length(), length - "Exif\u0000\u0000".length() - 2));
            this.metadataMap.put(MetadataType.EXIF, exif);
        } else if (temp.length >= "http://ns.adobe.com/xap/1.0/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xap/1.0/\u0000".length()).equals("http://ns.adobe.com/xap/1.0/\u0000") || temp.length >= "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length() && new String(temp, 0, "XMP\u0000://ns.adobe.com/xap/1.0/\u0000".length()).equals("XMP\u0000://ns.adobe.com/xap/1.0/\u0000")) {
            JpegXMP xmp = new JpegXMP(ArrayUtils.subArray(temp, "http://ns.adobe.com/xap/1.0/\u0000".length(), length - "http://ns.adobe.com/xap/1.0/\u0000".length() - 2));
            this.metadataMap.put(MetadataType.XMP, xmp);
            this.xmpGUID = XMLUtils.getAttribute(xmp.getXmpDocument(), "rdf:Description", "xmpNote:HasExtendedXMP");
        } else if (temp.length >= "http://ns.adobe.com/xmp/extension/\u0000".length() && new String(temp, 0, "http://ns.adobe.com/xmp/extension/\u0000".length()).equals("http://ns.adobe.com/xmp/extension/\u0000") && Arrays.equals(guid = ArrayUtils.subArray(temp, i = "http://ns.adobe.com/xmp/extension/\u0000".length(), 32), this.xmpGUID.getBytes())) {
            long extendedXMPLength = IOUtils.readUnsignedIntMM(temp, i += 32);
            i += 4;
            if (this.extendedXMP == null) {
                this.extendedXMP = new byte[(int)extendedXMPLength];
            }
            long offset = IOUtils.readUnsignedIntMM(temp, i);
            byte[] xmpBytes = ArrayUtils.subArray(temp, i += 4, length - "http://ns.adobe.com/xmp/extension/\u0000".length() - 42);
            System.arraycopy(xmpBytes, 0, this.extendedXMP, (int)offset, xmpBytes.length);
        }
    }

    private void readAPP2(InputStream is) throws IOException {
        int len = "ICC_PROFILE\u0000".length();
        byte[] temp = new byte[len];
        int length = IOUtils.readUnsignedShortMM(is);
        IOUtils.readFully(is, temp);
        if (Arrays.equals(temp, "ICC_PROFILE\u0000".getBytes())) {
            temp = new byte[length - len - 2];
            IOUtils.readFully(is, temp);
            if (this.iccProfileStream == null) {
                this.iccProfileStream = new ByteArrayOutputStream();
            }
            this.iccProfileStream.write(ArrayUtils.subArray(temp, 2, length - len - 4));
        } else {
            IOUtils.skipFully(is, length - len - 2);
        }
    }

    private void readAPP13(InputStream is) throws IOException {
        int len = "Photoshop 3.0\u0000".length();
        byte[] temp = new byte[len];
        int length = IOUtils.readUnsignedShortMM(is);
        IOUtils.readFully(is, temp);
        if (Arrays.equals(temp, "Photoshop 3.0\u0000".getBytes())) {
            temp = new byte[length - len - 2];
            IOUtils.readFully(is, temp);
            if (this.eightBIMStream == null) {
                this.eightBIMStream = new ByteArrayOutputStream();
            }
            this.eightBIMStream.write(temp);
        } else {
            IOUtils.skipFully(is, length - len - 2);
        }
    }

    private void readAPP14(InputStream is) throws IOException {
        String[] app14Info = new String[]{"DCTEncodeVersion: ", "APP14Flags0: ", "APP14Flags1: ", "ColorTransform: "};
        int expectedLen = 14;
        int length = IOUtils.readUnsignedShortMM(is);
        if (length >= expectedLen) {
            byte[] data = new byte[length - 2];
            IOUtils.readFully(is, data, 0, length - 2);
            byte[] buf = ArrayUtils.subArray(data, 0, 5);
            if (Arrays.equals(buf, "Adobe".getBytes())) {
                int i = 0;
                int j = 5;
                while (i < 3) {
                    LOGGER.info("{}{}", (Object)app14Info[i], (Object)StringUtils.shortToHexStringMM(IOUtils.readShortMM(data, j)));
                    ++i;
                    j += 2;
                }
                LOGGER.debug("{}{}", (Object)app14Info[3], (Object)((data[11] & 0xFF) == 0 ? "Unknown (RGB or CMYK)" : ((data[11] & 0xFF) == 1 ? "YCbCr" : "YCCK")));
            }
        }
    }

    private void read_DQT(InputStream is) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        DQTReader reader = new DQTReader(new Segment(Marker.DQT, len, buf));
        List<QTable> qTables = reader.getTables();
        for (QTable table : qTables) {
            int destination_id = table.getID();
            this.quant_tbl[destination_id] = table.getData();
        }
        LOGGER.debug("\n{}", (Object)JPGReader.qTablesToString(qTables));
    }

    private static String qTablesToString(List<QTable> qTables) {
        StringBuilder qtTables = new StringBuilder();
        qtTables.append("Quantization table information =>:\n");
        int count = 0;
        for (QTable table : qTables) {
            int j;
            int QT_precision = table.getPrecision();
            int[] qTable = table.getData();
            qtTables.append("precision of QT is " + QT_precision + "\n");
            qtTables.append("Quantization table #" + table.getID() + ":\n");
            if (QT_precision == 0) {
                for (j = 0; j < 64; ++j) {
                    if (j != 0 && j % 8 == 0) {
                        qtTables.append("\n");
                    }
                    qtTables.append(qTable[j] + " ");
                }
            } else {
                for (j = 0; j < 64; ++j) {
                    if (j != 0 && j % 8 == 0) {
                        qtTables.append("\n");
                    }
                    qtTables.append(qTable[j] + " ");
                }
            }
            ++count;
            qtTables.append("\n");
            qtTables.append("***************************\n");
        }
        qtTables.append("Total number of Quantation tables: " + count + "\n");
        qtTables.append("End of quantization table information\n");
        return qtTables.toString();
    }

    private void read_DHT(InputStream is) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        DHTReader reader = new DHTReader(new Segment(Marker.DHT, len, buf));
        List<HTable> dcTables = reader.getDCTables();
        List<HTable> acTables = reader.getACTables();
        for (HTable table : dcTables) {
            this.dc_hufftbl[table.getID()] = new HuffmanTbl(table.getBits(), table.getValues());
        }
        for (HTable table : acTables) {
            this.ac_hufftbl[table.getID()] = new HuffmanTbl(table.getBits(), table.getValues());
        }
        LOGGER.debug("\n{}", (Object)JPGReader.hTablesToString(dcTables));
        LOGGER.debug("\n{}", (Object)JPGReader.hTablesToString(acTables));
    }

    private static String hTablesToString(List<HTable> hTables) {
        String[] HT_class_table = new String[]{"DC Component", "AC Component"};
        StringBuilder hufTable = new StringBuilder();
        hufTable.append("Huffman table information =>:\n");
        for (HTable table : hTables) {
            hufTable.append("Class: " + table.getClazz() + " (" + HT_class_table[table.getClazz()] + ")\n");
            hufTable.append("Huffman table #: " + table.getID() + "\n");
            byte[] bits = table.getBits();
            byte[] values = table.getValues();
            int count = 0;
            for (int i = 0; i < bits.length; ++i) {
                count += bits[i] & 0xFF;
            }
            hufTable.append("Number of codes: " + count + "\n");
            if (count > 256) {
                throw new RuntimeException("Invalid huffman code count: " + count);
            }
            int j = 0;
            for (int i = 0; i < 16; ++i) {
                hufTable.append("Codes of length " + (i + 1) + " (" + (bits[i] & 0xFF) + " total): [ ");
                for (int k = 0; k < (bits[i] & 0xFF); ++k) {
                    hufTable.append((values[j++] & 0xFF) + " ");
                }
                hufTable.append("]\n");
            }
            hufTable.append("<= End of Huffman table information>>\n");
        }
        return hufTable.toString();
    }

    private SOFReader readSOF(InputStream is, Marker marker) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        Segment segment = new Segment(marker, len, buf);
        SOFReader reader = new SOFReader(segment);
        LOGGER.debug("\n{}", (Object)JPGReader.sofToString(reader));
        return reader;
    }

    private static String sofToString(SOFReader reader) {
        StringBuilder sof = new StringBuilder();
        sof.append("SOF information =>\n");
        sof.append("Precision: " + reader.getPrecision() + "\n");
        sof.append("Image height: " + reader.getFrameHeight() + "\n");
        sof.append("Image width: " + reader.getFrameWidth() + "\n");
        sof.append("# of Components: " + reader.getNumOfComponents() + "\n");
        sof.append("(1 = grey scaled, 3 = color YCbCr or YIQ, 4 = color CMYK)\n");
        for (Component component : reader.getComponents()) {
            sof.append("\n");
            sof.append("Component ID: " + component.getId() + "\n");
            sof.append("Herizontal sampling factor: " + component.getHSampleFactor() + "\n");
            sof.append("Vertical sampling factor: " + component.getVSampleFactor() + "\n");
            sof.append("Quantization table #: " + component.getQTableNumber() + "\n");
            sof.append("DC table number: " + component.getDCTableNumber() + "\n");
            sof.append("AC table number: " + component.getACTableNumber() + "\n");
        }
        sof.append("<= End of SOF information\n");
        return sof.toString();
    }

    private short readSOS(InputStream is, SOFReader sofReader) throws IOException {
        int len = IOUtils.readUnsignedShortMM(is);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully(is, buf);
        Segment segment = new Segment(Marker.SOS, len, buf);
        new SOSReader(segment, sofReader);
        int nextByte = 0;
        short marker = 0;
        block3: while ((nextByte = IOUtils.read(is)) != -1) {
            if (nextByte != 255) continue;
            nextByte = IOUtils.read(is);
            if (nextByte == -1) {
                return Marker.EOI.getValue();
            }
            if (nextByte == 0) continue;
            marker = (short)(0xFF00 | nextByte);
            switch (Marker.fromShort(marker)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (nextByte == -1) {
            return Marker.EOI.getValue();
        }
        if (Marker.fromShort(marker) == Marker.UNKNOWN) {
            return Marker.EOI.getValue();
        }
        return marker;
    }

    public Map<MetadataType, Metadata> getMetadata() {
        return this.metadataMap;
    }

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        return ImageIO.read(is);
    }
}

