/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.image.util.BytePacker;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;

public class PCXReader
extends ImageReader {
    short bytesPerLine = 0;
    byte NPlanes = 0;
    PcxHeader pcxHeader;
    private static final Logger LOGGER = LoggerFactory.getLogger(PCXReader.class);

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        this.pcxHeader = new PcxHeader();
        this.pcxHeader.readHeader(is);
        this.width = this.pcxHeader.xmax - this.pcxHeader.xmin + 1;
        this.height = this.pcxHeader.ymax - this.pcxHeader.ymin + 1;
        this.bytesPerLine = this.pcxHeader.bytes_per_line;
        this.rgbColorPalette = this.pcxHeader.colorPalette;
        this.NPlanes = this.pcxHeader.color_plane;
        this.bitsPerPixel = this.pcxHeader.bits_per_pixel * this.pcxHeader.color_plane;
        if (this.pcxHeader.bits_per_pixel == 8 && this.pcxHeader.color_plane == 1) {
            return this.read256ColorPcx(is);
        }
        if (this.pcxHeader.bits_per_pixel == 8 && this.pcxHeader.color_plane == 3) {
            return this.readTrueColorPcx(is);
        }
        if (this.NPlanes == 1) {
            switch (this.bitsPerPixel) {
                case 4: {
                    LOGGER.info("16 color pcx image, 4 bits per pixel, 1 color plane!");
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Invalid bitsPerPixel: " + this.bitsPerPixel + " for one plane PCX image");
                }
                case 2: {
                    LOGGER.info("4 color pcx image, 2 bits per pixel, 1 color plane!");
                    break;
                }
                case 1: {
                    LOGGER.info("2 color pcx image, 1 bits per pixel, 1 color plane!");
                    break;
                }
            }
            return this.readOnePlaneEgaPcx(is);
        }
        if (this.pcxHeader.bits_per_pixel == 1) {
            switch (this.NPlanes) {
                case 4: {
                    LOGGER.info("16 color image, 1 bit per plane, 4 planes!");
                    break;
                }
                case 3: {
                    LOGGER.info("8 color image, 1 bit per plane, 3 planes!");
                    break;
                }
                case 2: {
                    LOGGER.info("4 color image, 1 bit per plane, 2 planes!");
                    break;
                }
            }
            return this.readOneBitEgaPcx(is);
        }
        LOGGER.error("unimplemented for this format!");
        return null;
    }

    private void readPalette(byte[] buf) throws Exception {
        int index = 0;
        int nindex = 0;
        for (int i = 0; i < buf.length; i += 3) {
            this.rgbColorPalette[index++] = 0xFF000000 | (buf[nindex++] & 0xFF) << 16 | (buf[nindex++] & 0xFF) << 8 | buf[nindex++] & 0xFF;
        }
    }

    private void readPalette(InputStream is, int color_tb_bytes) throws Exception {
        int index = 0;
        int nindex = 0;
        byte[] buf = new byte[color_tb_bytes];
        is.read(buf, 0, color_tb_bytes);
        for (int i = 0; i < color_tb_bytes; i += 3) {
            this.rgbColorPalette[index++] = 0xFF000000 | (buf[nindex++] & 0xFF) << 16 | (buf[nindex++] & 0xFF) << 8 | buf[nindex++] & 0xFF;
        }
    }

    private BufferedImage readTrueColorPcx(InputStream is) throws Exception {
        byte[] brgb = IOUtils.readFully(is, 4096);
        byte[] pixels = new byte[this.bytesPerLine * this.NPlanes * this.height];
        LOGGER.info("true color pcx image!");
        this.readScanLines(brgb, brgb.length, pixels);
        is.close();
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        int trans = 1;
        int[] nBits = new int[]{8, 8, 8};
        WritableRaster raster = Raster.createBandedRaster(db, this.width, this.height, this.bytesPerLine * 3, new int[]{0, 0, 0}, new int[]{0, this.bytesPerLine, this.bytesPerLine * 2}, null);
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, false, false, trans, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private void readScanLines(byte[] brgb, int buf_len, byte[] pixels) throws Exception {
        int counter = 0;
        int bt = 0;
        int bt1 = 0;
        int index = 0;
        int nindex = 0;
        int num_of_rep = 0;
        int totalBytes = this.NPlanes * this.bytesPerLine;
        block0: for (int i = 0; i < this.height; ++i) {
            do {
                if (((bt = brgb[nindex++] & 0xFF) & 0xC0) == 192) {
                    num_of_rep = bt & 0x3F;
                    bt1 = brgb[nindex++] & 0xFF;
                    for (int k = 0; k < num_of_rep && counter < totalBytes; ++k, ++counter) {
                        pixels[index++] = (byte)bt1;
                    }
                    if (nindex < buf_len) continue;
                    break block0;
                }
                pixels[index++] = (byte)bt;
                ++counter;
                if (nindex >= buf_len) break block0;
            } while (counter < totalBytes);
            counter = 0;
        }
    }

    private BufferedImage read256ColorPcx(InputStream is) throws Exception {
        int totalBytes = this.bytesPerLine * this.NPlanes;
        byte[] pixels = new byte[totalBytes * this.height];
        byte[] data = IOUtils.readFully(is, 4096);
        int colorsUsed = 1 << this.NPlanes * this.pcxHeader.bits_per_pixel;
        int color_tb_bytes = 3 * colorsUsed;
        this.rgbColorPalette = new int[colorsUsed];
        int buf_len = data.length - color_tb_bytes;
        byte[] brgb = ArrayUtils.subArray(data, 0, buf_len);
        this.readPalette(ArrayUtils.subArray(data, buf_len, color_tb_bytes));
        LOGGER.info("256 color pcx image!");
        this.readScanLines(brgb, buf_len, pixels);
        is.close();
        int[] off = new int[]{0};
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        WritableRaster raster = Raster.createInterleavedRaster(db, this.width, this.height, (int)this.bytesPerLine, 1, off, null);
        IndexColorModel cm = new IndexColorModel(8, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage readOneBitEgaPcx(InputStream is) throws Exception {
        int index = 0;
        int counter = 0;
        int abyte = 0;
        int nindex = 0;
        int bt = 0;
        int bt1 = 0;
        int totalBytes = 0;
        int num_of_rep = 0;
        byte[] brgb = IOUtils.readFully(is, 4096);
        int buf_len = brgb.length;
        totalBytes = this.bytesPerLine * this.NPlanes;
        int[] buf = new int[totalBytes];
        BytePacker bytePacker = new BytePacker(this.bitsPerPixel, this.width, this.width * this.height);
        block0: for (int i = 0; i < this.height; ++i) {
            int k;
            do {
                if (((bt = brgb[nindex++] & 0xFF) & 0xC0) == 192) {
                    num_of_rep = bt & 0x3F;
                    bt1 = brgb[nindex++] & 0xFF;
                    for (k = 0; k < num_of_rep && index < totalBytes; ++k) {
                        buf[index++] = bt1;
                    }
                    if (nindex < buf_len) continue;
                    break block0;
                }
                buf[index++] = bt;
                if (nindex >= buf_len) break block0;
            } while (index < totalBytes);
            block3: for (k = 0; k < this.bytesPerLine; ++k) {
                for (int l = 7; l >= 0; --l) {
                    for (int m = 0; m < this.NPlanes; ++m) {
                        abyte |= (buf[k + this.bytesPerLine * m] >> l & 1) << m;
                    }
                    bytePacker.packByte(abyte);
                    abyte = 0;
                    if (++counter % this.width == 0) break block3;
                }
            }
            index = 0;
        }
        is.close();
        byte[] pixels = bytePacker.getPackedBytes();
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        WritableRaster raster = Raster.createPackedRaster(db, this.width, this.height, this.bitsPerPixel, null);
        IndexColorModel cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private BufferedImage readOnePlaneEgaPcx(InputStream is) throws Exception {
        byte[] brgb = IOUtils.readFully(is, 4096);
        byte[] pixels = new byte[this.bytesPerLine * this.height];
        this.readScanLines(brgb, brgb.length, pixels);
        is.close();
        DataBufferByte db = new DataBufferByte(pixels, pixels.length);
        WritableRaster raster = Raster.createPackedRaster(db, this.width, this.height, this.bitsPerPixel, null);
        if (this.bitsPerPixel == 1) {
            int[] BW_palette = new int[]{-16777216, -1};
            this.rgbColorPalette = BW_palette;
        }
        IndexColorModel cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
        return new BufferedImage(cm, raster, false, null);
    }

    private static class PcxHeader {
        byte manufacturer;
        byte version;
        byte encoding;
        byte bits_per_pixel;
        short xmin;
        short ymin;
        short xmax;
        short ymax;
        short hres;
        short vres;
        int[] colorPalette = new int[16];
        byte reserved;
        byte color_plane;
        short bytes_per_line;
        short palette_type;
        byte[] filler = new byte[58];

        private PcxHeader() {
        }

        void readHeader(InputStream is) throws Exception {
            int i;
            int nindex = 0;
            byte[] buf = new byte[128];
            IOUtils.readFully(is, buf, 0, 128);
            this.manufacturer = buf[nindex++];
            this.version = buf[nindex++];
            this.encoding = buf[nindex++];
            this.bits_per_pixel = buf[nindex++];
            this.xmin = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            this.ymin = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            this.xmax = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            this.ymax = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            this.hres = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            this.vres = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            for (i = 0; i < 16; ++i) {
                this.colorPalette[i] = 0xFF000000 | (buf[nindex++] & 0xFF) << 16 | (buf[nindex++] & 0xFF) << 8 | buf[nindex++] & 0xFF;
            }
            this.reserved = buf[nindex++];
            this.color_plane = buf[nindex++];
            this.bytes_per_line = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            this.palette_type = (short)(buf[nindex++] & 0xFF | (buf[nindex++] & 0xFF) << 8);
            for (i = 0; i < 58; ++i) {
                this.filler[i] = buf[nindex++];
            }
        }
    }
}

