/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.meta.icc.ICCProfile;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.image.png.ColorType;
import guilibshadow.cafe4j.image.png.Filter;
import guilibshadow.cafe4j.image.png.PNGDescriptor;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class PNGReader
extends ImageReader {
    public static final long SIGNATURE = -8552249625308161526L;
    private static final byte NON_INTERLACED = 0;
    private static final byte ADAM7 = 1;
    private static final int[] BLACK_WHITE_PALETTE = new int[]{-16777216, -1};
    private static final int[] FOUR_COLOR_PALETTE = new int[]{-16777216, -12566464, -8355712, -1};
    private static final int[] SIXTEEN_COLOR_PALETTE = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
    private static final int[] EIGHT_BIT_COLOR_PALETTE = new int[256];
    private static final Logger LOGGER;
    private byte color_format;
    private byte compression;
    private byte filter_method;
    private byte interlace_method;
    private float gamma = 0.45455f;
    private boolean hasGamma;
    private float displayExponent = 2.2f;
    private byte[] alpha;
    private byte[] gammaTable;
    private short[] gammaUShortTable;
    private int block_width;
    private int block_height;
    private int x_start;
    private int y_start;
    private int x_inc;
    private int y_inc;
    private byte renderingIntent = (byte)-1;
    private boolean hasICCP = false;
    private byte[] icc_profile;

    private static void apply_defilter(InputStream bis, byte[] pixBytes, int height, int bytesPerPixel, int bytesPerScanLine) throws Exception {
        int filter_type = 0;
        int j = 0;
        int offset = 0;
        while (j < height) {
            filter_type = bis.read();
            IOUtils.readFully(bis, pixBytes, offset, bytesPerScanLine);
            switch (filter_type) {
                case 0: {
                    break;
                }
                case 1: {
                    Filter.defilter_sub(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
                    break;
                }
                case 2: {
                    Filter.defilter_up(bytesPerScanLine, pixBytes, offset);
                    break;
                }
                case 3: {
                    Filter.defilter_average(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
                    break;
                }
                case 4: {
                    Filter.defilter_paeth(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
                    break;
                }
            }
            ++j;
            offset += bytesPerScanLine;
        }
    }

    private void adjust_grayscale_PLTE(int[] palette) {
        LOGGER.info("Transparent grayscale image!");
        palette[this.alpha[1] & 0xFF] = palette[this.alpha[1] & 0xFF] & 0xFFFFFF;
    }

    private void adjust_PLTE() {
        LOGGER.info("Transparent indexed color image!");
        int len = Math.min(this.alpha.length, this.rgbColorPalette.length);
        for (int i = 0; i < len; ++i) {
            this.rgbColorPalette[i] = (this.alpha[i] & 0xFF) << 24 | this.rgbColorPalette[i] & 0xFFFFFF;
        }
    }

    private boolean calculatePassVariables(int pass) {
        switch (pass) {
            case 1: {
                this.block_width = this.width / 8 + (this.width % 8 == 0 ? 0 : 1);
                this.block_height = this.height / 8 + (this.height % 8 == 0 ? 0 : 1);
                this.y_start = 0;
                this.x_start = 0;
                this.y_inc = 8;
                this.x_inc = 8;
                break;
            }
            case 2: {
                if (this.width < 5) {
                    return false;
                }
                this.block_width = this.width / 8 + (this.width % 8 < 5 ? 0 : 1);
                this.block_height = this.height / 8 + (this.height % 8 == 0 ? 0 : 1);
                this.x_start = 4;
                this.y_start = 0;
                this.y_inc = 8;
                this.x_inc = 8;
                break;
            }
            case 3: {
                if (this.height < 5) {
                    return false;
                }
                this.block_width = this.width / 4 + (this.width % 4 == 0 ? 0 : 1);
                this.block_height = this.height / 8 + (this.height % 8 < 5 ? 0 : 1);
                this.x_start = 0;
                this.y_start = 4;
                this.x_inc = 4;
                this.y_inc = 8;
                break;
            }
            case 4: {
                if (this.width < 3) {
                    return false;
                }
                this.block_width = this.width / 4 + (this.width % 4 < 3 ? 0 : 1);
                this.block_height = this.height / 4 + (this.height % 4 == 0 ? 0 : 1);
                this.x_start = 2;
                this.y_start = 0;
                this.x_inc = 4;
                this.y_inc = 4;
                break;
            }
            case 5: {
                if (this.height < 3) {
                    return false;
                }
                this.block_width = this.width / 2 + (this.width % 2 == 0 ? 0 : 1);
                this.block_height = this.height / 4 + (this.height % 4 < 3 ? 0 : 1);
                this.x_start = 0;
                this.y_start = 2;
                this.x_inc = 2;
                this.y_inc = 4;
                break;
            }
            case 6: {
                if (this.width < 2) {
                    return false;
                }
                this.block_width = this.width / 2;
                this.block_height = this.height / 2 + (this.height % 2 == 0 ? 0 : 1);
                this.x_start = 1;
                this.y_start = 0;
                this.y_inc = 2;
                this.x_inc = 2;
                break;
            }
            case 7: {
                if (this.height < 2) {
                    return false;
                }
                this.block_width = this.width;
                this.block_height = this.height / 2;
                this.x_start = 0;
                this.y_start = 1;
                this.x_inc = 1;
                this.y_inc = 2;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void correctGamma(byte[] image, int width, int height) {
        int p_index = 0;
        for (int i = 0; i < height; ++i) {
            int j = 0;
            while (j < width) {
                image[p_index] = this.gammaTable[image[p_index] & 0xFF];
                ++j;
                p_index += 2;
            }
        }
    }

    private void correctGamma(int[] rgbColorPalette) {
        for (int i = 0; i < rgbColorPalette.length; ++i) {
            byte red = this.gammaTable[(rgbColorPalette[i] & 0xFF0000) >> 16];
            byte green = this.gammaTable[(rgbColorPalette[i] & 0xFF00) >> 8];
            byte blue = this.gammaTable[rgbColorPalette[i] & 0xFF];
            rgbColorPalette[i] = rgbColorPalette[i] & 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        }
    }

    private void correctGamma(int[] image, int width, int height) {
        int p_index = 0;
        for (int i = 0; i < height; ++i) {
            int j = 0;
            while (j < width) {
                byte red = this.gammaTable[(image[p_index] & 0xFF0000) >> 16];
                byte green = this.gammaTable[(image[p_index] & 0xFF00) >> 8];
                byte blue = this.gammaTable[image[p_index] & 0xFF];
                image[p_index] = image[p_index] & 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                ++j;
                ++p_index;
            }
        }
    }

    private void correctGamma(byte[] image, int width, int height, boolean hasAlpha) {
        int index = 0;
        for (int i = 0; i < height; ++i) {
            int j = 0;
            while (j < width) {
                image[index] = this.gammaTable[image[index] & 0xFF];
                image[index + 1] = this.gammaTable[image[index + 1] & 0xFF];
                image[index + 2] = this.gammaTable[image[index + 2] & 0xFF];
                if (hasAlpha) {
                    ++index;
                }
                ++j;
                index += 3;
            }
        }
    }

    private void correctGamma(short[] image, int width, int height, int rgbStride, int alphaStride) {
        int p_index = 0;
        for (int i = 0; i < height; ++i) {
            int j = 0;
            while (j < width) {
                int k = 0;
                while (k < rgbStride) {
                    image[p_index] = this.gammaUShortTable[image[p_index] & 0xFFFF];
                    ++k;
                    ++p_index;
                }
                ++j;
                p_index += alphaStride;
            }
        }
    }

    private void createGammaTable(float gamma, float displayExponent) {
        int size = 256;
        this.gammaTable = new byte[size];
        double decodingExponent = 1.0 / ((double)gamma * (double)displayExponent);
        for (int i = 0; i < size; ++i) {
            this.gammaTable[i] = (byte)(Math.pow((double)i / (double)(size - 1), decodingExponent) * (double)(size - 1));
        }
    }

    private void createUShortGammaTable(float gamma, float displayExponent) {
        int size = 65536;
        this.gammaUShortTable = new short[size];
        double decodingExponent = 1.0 / ((double)gamma * (double)displayExponent);
        for (int i = 0; i < size; ++i) {
            this.gammaUShortTable[i] = (short)(Math.pow((double)i / (double)(size - 1), decodingExponent) * (double)(size - 1));
        }
    }

    private byte[] deflateRGBPixels(byte[] compr_data, boolean fullAlpha) throws Exception {
        int bytesPerPixel = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                if (fullAlpha) {
                    bytesPerPixel = 4;
                    break;
                }
                bytesPerPixel = 3;
                break;
            }
            case 16: {
                if (fullAlpha) {
                    bytesPerPixel = 8;
                    break;
                }
                bytesPerPixel = 6;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for RGB image...");
            }
        }
        this.bytesPerScanLine = this.width * bytesPerPixel;
        byte[] pixBytes = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        PNGReader.apply_defilter(bis, pixBytes, this.height, bytesPerPixel, this.bytesPerScanLine);
        return pixBytes;
    }

    private short[] generate16BitGrayscaleInterlacedPixels(byte[] compr_data) throws Exception {
        int bytesPerPixel = 0;
        int p_index = 0;
        bytesPerPixel = 2;
        short grayMask = 0;
        short[] spixels = null;
        if (this.alpha != null) {
            grayMask = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            spixels = new short[this.width * this.height * 2];
        } else {
            spixels = new short[this.width * this.height];
        }
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        for (int pass = 1; pass < 8; ++pass) {
            int j;
            if (!this.calculatePassVariables(pass)) continue;
            this.bytesPerScanLine = bytesPerPixel * this.block_width;
            byte[] pix_interlaced = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bis, pix_interlaced, this.block_height, bytesPerPixel, this.bytesPerScanLine);
            p_index = this.x_start + this.width * this.y_start;
            if (this.alpha != null) {
                int s_index = 0;
                int k = 0;
                for (j = 0; j < this.block_height; ++j) {
                    int i = 0;
                    while (i < this.block_width) {
                        s_index = p_index << 1;
                        spixels[s_index] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[++s_index] = spixels[s_index] == grayMask ? 0 : -1;
                        ++i;
                        p_index += this.x_inc;
                    }
                    p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            int k = 0;
            for (j = 0; j < this.block_height; ++j) {
                int i = 0;
                while (i < this.block_width) {
                    spixels[p_index] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                    ++i;
                    p_index += this.x_inc;
                }
                p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        bis.close();
        return spixels;
    }

    private short[] generate16BitGrayscalePixels(byte[] compr_data) throws Exception {
        int bytesPerPixel = 1;
        bytesPerPixel = 2;
        this.bytesPerScanLine = bytesPerPixel * this.width;
        byte[] pixBytes = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        PNGReader.apply_defilter(bis, pixBytes, this.height, bytesPerPixel, this.bytesPerScanLine);
        bis.close();
        if (this.alpha != null) {
            short[] spixels = new short[this.width * this.height * 2];
            short grayMask = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            int i = 0;
            int index = 0;
            while (i < pixBytes.length) {
                spixels[index] = (short)((pixBytes[i++] & 0xFF) << 8 | pixBytes[i++] & 0xFF);
                spixels[++index] = spixels[index] == grayMask ? 0 : -1;
                ++index;
            }
            return spixels;
        }
        return ArrayUtils.toShortArray(pixBytes, true);
    }

    private short[] generate16BitRGBInterlacedPixels(byte[] compr_data, boolean fullAlpha) throws Exception {
        int bytesPerPixel = 0;
        int p_index = 0;
        short redMask = 0;
        short greenMask = 0;
        short blueMask = 0;
        if (this.alpha != null) {
            redMask = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            greenMask = (short)(this.alpha[3] & 0xFF | (this.alpha[2] & 0xFF) << 8);
            blueMask = (short)(this.alpha[5] & 0xFF | (this.alpha[4] & 0xFF) << 8);
        }
        bytesPerPixel = fullAlpha ? 8 : 6;
        short[] spixels = null;
        spixels = fullAlpha || this.alpha != null ? new short[this.width * this.height * 4] : new short[this.width * this.height * 3];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        for (int pass = 1; pass < 8; ++pass) {
            int i;
            int j;
            int k;
            int s_index;
            if (!this.calculatePassVariables(pass)) continue;
            this.bytesPerScanLine = bytesPerPixel * this.block_width;
            byte[] pix_interlaced = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bis, pix_interlaced, this.block_height, bytesPerPixel, this.bytesPerScanLine);
            p_index = this.x_start + this.width * this.y_start;
            if (fullAlpha) {
                s_index = 0;
                k = 0;
                for (j = 0; j < this.block_height; ++j) {
                    i = 0;
                    while (i < this.block_width) {
                        s_index = p_index << 2;
                        spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        ++i;
                        p_index += this.x_inc;
                    }
                    p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            if (this.alpha != null) {
                s_index = 0;
                k = 0;
                for (j = 0; j < this.block_height; ++j) {
                    i = 0;
                    while (i < this.block_width) {
                        s_index = p_index << 2;
                        spixels[s_index] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[s_index + 1] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[s_index + 2] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                        spixels[s_index + 3] = spixels[s_index] == redMask && spixels[s_index + 1] == greenMask && spixels[s_index + 2] == blueMask ? 0 : -1;
                        ++i;
                        p_index += this.x_inc;
                    }
                    p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            s_index = 0;
            k = 0;
            for (j = 0; j < this.block_height; ++j) {
                i = 0;
                while (i < this.block_width) {
                    s_index = p_index * 3;
                    spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                    spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                    spixels[s_index++] = (short)((pix_interlaced[k++] & 0xFF) << 8 | pix_interlaced[k++] & 0xFF);
                    ++i;
                    p_index += this.x_inc;
                }
                p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        bis.close();
        return spixels;
    }

    private short[] generate16BitRGBPixels(byte[] compr_data, boolean fullAlpha) throws Exception {
        int bytesPerPixel = 0;
        bytesPerPixel = fullAlpha ? 8 : 6;
        this.bytesPerScanLine = this.width * bytesPerPixel;
        byte[] pixBytes = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        PNGReader.apply_defilter(bis, pixBytes, this.height, bytesPerPixel, this.bytesPerScanLine);
        short[] spixels = null;
        if (this.alpha != null) {
            spixels = new short[this.width * this.height * 4];
            short redMask = (short)(this.alpha[1] & 0xFF | (this.alpha[0] & 0xFF) << 8);
            short greenMask = (short)(this.alpha[3] & 0xFF | (this.alpha[2] & 0xFF) << 8);
            short blueMask = (short)(this.alpha[5] & 0xFF | (this.alpha[4] & 0xFF) << 8);
            int i = 0;
            int index = 0;
            while (i < pixBytes.length) {
                short red = (short)((pixBytes[i++] & 0xFF) << 8 | pixBytes[i++] & 0xFF);
                short green = (short)((pixBytes[i++] & 0xFF) << 8 | pixBytes[i++] & 0xFF);
                short blue = (short)((pixBytes[i++] & 0xFF) << 8 | pixBytes[i++] & 0xFF);
                spixels[index] = red;
                spixels[index + 1] = green;
                spixels[index + 2] = blue;
                spixels[index + 3] = spixels[index] == redMask && spixels[index + 1] == greenMask && spixels[index + 2] == blueMask ? 0 : -1;
                index += 4;
            }
        } else {
            spixels = ArrayUtils.toShortArray(pixBytes, true);
        }
        return spixels;
    }

    private byte[] generate8BitRGBInterlacedPixels(byte[] compr_data, boolean fullAlpha) throws Exception {
        int bytesPerPixel = 0;
        int p_index = 0;
        byte[] bpixels = new byte[this.width * this.height * 3];
        bytesPerPixel = fullAlpha ? 4 : 3;
        if (fullAlpha || this.alpha != null) {
            bpixels = new byte[this.width * this.height * 4];
        }
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        for (int pass = 1; pass < 8; ++pass) {
            int i;
            int j;
            int k;
            if (!this.calculatePassVariables(pass)) continue;
            this.bytesPerScanLine = bytesPerPixel * this.block_width;
            byte[] pix_interlaced = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bis, pix_interlaced, this.block_height, bytesPerPixel, this.bytesPerScanLine);
            p_index = this.x_start + this.width * this.y_start;
            if (fullAlpha) {
                k = 0;
                for (j = 0; j < this.block_height; ++j) {
                    i = 0;
                    while (i < this.block_width) {
                        System.arraycopy(pix_interlaced, k, bpixels, p_index << 2, 4);
                        ++i;
                        p_index += this.x_inc;
                        k += 4;
                    }
                    p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            if (this.alpha != null) {
                k = 0;
                for (j = 0; j < this.block_height; ++j) {
                    i = 0;
                    while (i < this.block_width) {
                        int offset = p_index << 2;
                        System.arraycopy(pix_interlaced, k, bpixels, offset, 3);
                        bpixels[offset + 3] = pix_interlaced[k] == this.alpha[1] && pix_interlaced[k + 1] == this.alpha[3] && pix_interlaced[k + 2] == this.alpha[5] ? 0 : -1;
                        ++i;
                        p_index += this.x_inc;
                        k += 3;
                    }
                    p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            k = 0;
            for (j = 0; j < this.block_height; ++j) {
                i = 0;
                while (i < this.block_width) {
                    System.arraycopy(pix_interlaced, k, bpixels, 3 * p_index, 3);
                    ++i;
                    p_index += this.x_inc;
                    k += 3;
                }
                p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        return bpixels;
    }

    private byte[] generate8BitRGBPixels(byte[] compr_data, boolean fullAlpha) throws Exception {
        byte[] pixBytes = this.deflateRGBPixels(compr_data, fullAlpha);
        if (this.alpha == null) {
            return pixBytes;
        }
        int image_size = this.width * this.height;
        byte[] bpixels = new byte[image_size * this.height * 4];
        int i = 0;
        int index = 0;
        while (i < pixBytes.length) {
            byte red = pixBytes[i++];
            byte green = pixBytes[i++];
            byte blue = pixBytes[i++];
            bpixels[index++] = red;
            bpixels[index++] = green;
            bpixels[index++] = blue;
            if (red == this.alpha[1] && green == this.alpha[3] && blue == this.alpha[5]) {
                bpixels[index++] = 0;
                continue;
            }
            bpixels[index++] = -1;
        }
        return bpixels;
    }

    private void generateGrayscaleInterlacedPixels(byte[] pixels, byte[] pix_interlaced, int block_width, int block_height, int padding, int p_index, int x_start, int y_start, int x_inc, int y_inc) {
        int i = 0;
        int safeEnd = block_width - padding;
        switch (this.bitsPerPixel) {
            case 8: {
                int k = 0;
                for (int j = 0; j < block_height; ++j) {
                    int l = 0;
                    while (l < block_width) {
                        pixels[p_index] = pix_interlaced[k++];
                        ++l;
                        p_index += x_inc;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
            case 4: {
                for (int j = 0; j < block_height; ++j) {
                    for (int k = 0; k < safeEnd; k += 2) {
                        pixels[p_index] = (byte)(pix_interlaced[i] >>> 4 & 0xF);
                        pixels[p_index += x_inc] = (byte)(pix_interlaced[i++] >>> 0 & 0xF);
                        p_index += x_inc;
                    }
                    if (padding != 0) {
                        pixels[p_index] = (byte)(pix_interlaced[i++] >>> 4 & 0xF);
                        p_index += x_inc;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
            case 2: {
                for (int j = 0; j < block_height; ++j) {
                    int k = 0;
                    while (k < safeEnd) {
                        for (int l = 6; l >= 0; l -= 2) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> l & 3);
                            p_index += x_inc;
                        }
                        k += 4;
                        ++i;
                    }
                    if (padding != 0) {
                        int m = 0;
                        int n = 6;
                        while (m < padding) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> n & 3);
                            p_index += x_inc;
                            ++m;
                            n -= 2;
                        }
                        ++i;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
            case 1: {
                for (int j = 0; j < block_height; ++j) {
                    int k = 0;
                    while (k < safeEnd) {
                        for (int l = 7; l >= 0; --l) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> l & 1);
                            p_index += x_inc;
                        }
                        k += 8;
                        ++i;
                    }
                    if (padding != 0) {
                        for (int m = 7; m >= 8 - padding; --m) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> m & 1);
                            p_index += x_inc;
                        }
                        ++i;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
        }
    }

    private void generateIndexedInterlacedPixels(byte[] pixels, byte[] pix_interlaced, int block_width, int block_height, int padding, int p_index, int x_start, int y_start, int x_inc, int y_inc) {
        int i = 0;
        int safeEnd = block_width - padding;
        switch (this.bitsPerPixel) {
            case 8: {
                int k = 0;
                for (int j = 0; j < block_height; ++j) {
                    int l = 0;
                    while (l < block_width) {
                        pixels[p_index] = pix_interlaced[k];
                        ++l;
                        ++k;
                        p_index += x_inc;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
            case 4: {
                for (int j = 0; j < block_height; ++j) {
                    for (int k = 0; k < safeEnd; k += 2) {
                        pixels[p_index] = (byte)(pix_interlaced[i] >>> 4);
                        pixels[p_index += x_inc] = pix_interlaced[i++];
                        p_index += x_inc;
                    }
                    if (padding != 0) {
                        pixels[p_index] = (byte)(pix_interlaced[i++] >>> 4);
                        p_index += x_inc;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
            case 2: {
                for (int j = 0; j < block_height; ++j) {
                    int k = 0;
                    while (k < safeEnd) {
                        for (int l = 6; l >= 0; l -= 2) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> l & 3);
                            p_index += x_inc;
                        }
                        k += 4;
                        ++i;
                    }
                    if (padding != 0) {
                        int m = 0;
                        int n = 6;
                        while (m < padding) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> n & 3);
                            p_index += x_inc;
                            ++m;
                            n -= 2;
                        }
                        ++i;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
            case 1: {
                for (int j = 0; j < block_height; ++j) {
                    int k = 0;
                    while (k < safeEnd) {
                        for (int l = 7; l >= 0; --l) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> l & 1);
                            p_index += x_inc;
                        }
                        k += 8;
                        ++i;
                    }
                    if (padding != 0) {
                        for (int m = 7; m >= 8 - padding; --m) {
                            pixels[p_index] = (byte)(pix_interlaced[i] >>> m & 1);
                            p_index += x_inc;
                        }
                        ++i;
                    }
                    p_index = ((j + 1) * y_inc + y_start) * this.width + x_start;
                }
                break;
            }
        }
    }

    private int getBytesPerScanLine(int block_width) {
        int padding = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                this.bytesPerScanLine = block_width;
                break;
            }
            case 4: {
                padding = block_width % 2;
                this.bytesPerScanLine = block_width >>> 1;
                break;
            }
            case 2: {
                padding = block_width % 4;
                this.bytesPerScanLine = block_width >>> 2;
                break;
            }
            case 1: {
                padding = block_width % 8;
                this.bytesPerScanLine = block_width >>> 3;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for PNG image...");
            }
        }
        if (padding != 0) {
            ++this.bytesPerScanLine;
        }
        return this.bytesPerScanLine;
    }

    public byte[] getICCProfile() {
        return this.icc_profile;
    }

    private int getPadding(int block_width) {
        int padding = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                break;
            }
            case 4: {
                padding = block_width % 2;
                break;
            }
            case 2: {
                padding = block_width % 4;
                break;
            }
            case 1: {
                padding = block_width % 8;
            }
        }
        return padding;
    }

    public boolean hasICCProfile() {
        return this.hasICCP;
    }

    private byte[] process_grayscaleAlphaImage(byte[] compr_data) throws Exception {
        int bytesPerPixel = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                bytesPerPixel = 2;
                break;
            }
            case 16: {
                bytesPerPixel = 4;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is invalid for full alpha grayscale image...");
            }
        }
        this.bytesPerScanLine = this.width * bytesPerPixel;
        byte[] pixBytes = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        PNGReader.apply_defilter(bis, pixBytes, this.height, bytesPerPixel, this.bytesPerScanLine);
        return pixBytes;
    }

    private byte[] process_grayscaleAlphaInterlacedImage(byte[] compr_data) throws Exception {
        int bytesPerPixel = 0;
        int p_index = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                bytesPerPixel = 2;
                break;
            }
            case 16: {
                bytesPerPixel = 4;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for grayscale full alpha image...");
            }
        }
        byte[] pixels = new byte[this.width * this.height * bytesPerPixel];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        for (int pass = 1; pass < 8; ++pass) {
            int j;
            if (!this.calculatePassVariables(pass)) continue;
            this.bytesPerScanLine = bytesPerPixel * this.block_width;
            byte[] pix_interlaced = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bis, pix_interlaced, this.block_height, bytesPerPixel, this.bytesPerScanLine);
            p_index = this.x_start + this.width * this.y_start;
            if (this.bitsPerPixel == 8) {
                int k = 0;
                for (j = 0; j < this.block_height; ++j) {
                    int i = 0;
                    int b_index = 0;
                    while (i < this.block_width) {
                        b_index = p_index << 1;
                        pixels[b_index++] = pix_interlaced[k++];
                        pixels[b_index++] = pix_interlaced[k++];
                        ++i;
                        p_index += this.x_inc;
                    }
                    p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
                }
                continue;
            }
            if (this.bitsPerPixel != 16) continue;
            int b_index = 0;
            int k = 0;
            for (j = 0; j < this.block_height; ++j) {
                int l = 0;
                while (l < this.block_width) {
                    b_index = p_index << 2;
                    pixels[b_index++] = pix_interlaced[k++];
                    pixels[b_index++] = pix_interlaced[k++];
                    pixels[b_index++] = pix_interlaced[k++];
                    pixels[b_index++] = pix_interlaced[k++];
                    ++l;
                    p_index += this.x_inc;
                }
                p_index = ((j + 1) * this.y_inc + this.y_start) * this.width + this.x_start;
            }
        }
        return pixels;
    }

    private byte[] process_grayscaleImage(byte[] compr_data) throws Exception {
        int bytesPerPixel = 1;
        int padding = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                this.rgbColorPalette = EIGHT_BIT_COLOR_PALETTE;
                this.bytesPerScanLine = this.width;
                break;
            }
            case 4: {
                padding = this.width % 2;
                this.rgbColorPalette = SIXTEEN_COLOR_PALETTE;
                this.bytesPerScanLine = (this.width >>> 1) + (padding == 0 ? 0 : 1);
                break;
            }
            case 2: {
                padding = this.width % 4;
                this.rgbColorPalette = FOUR_COLOR_PALETTE;
                this.bytesPerScanLine = (this.width >>> 2) + (padding == 0 ? 0 : 1);
                break;
            }
            case 1: {
                padding = this.width % 8;
                this.rgbColorPalette = BLACK_WHITE_PALETTE;
                this.bytesPerScanLine = (this.width >>> 3) + (padding == 0 ? 0 : 1);
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for grayscale image...");
            }
        }
        byte[] pixBytes = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        PNGReader.apply_defilter(bis, pixBytes, this.height, bytesPerPixel, this.bytesPerScanLine);
        bis.close();
        return pixBytes;
    }

    private byte[] process_grayscaleInterlacedImage(byte[] compr_data) throws Exception {
        int bytesPerPixel = 0;
        int padding = 0;
        switch (this.bitsPerPixel) {
            case 8: {
                bytesPerPixel = 1;
                this.rgbColorPalette = EIGHT_BIT_COLOR_PALETTE;
                break;
            }
            case 1: {
                bytesPerPixel = 1;
                this.rgbColorPalette = BLACK_WHITE_PALETTE;
                break;
            }
            case 2: {
                bytesPerPixel = 1;
                this.rgbColorPalette = FOUR_COLOR_PALETTE;
                break;
            }
            case 4: {
                bytesPerPixel = 1;
                this.rgbColorPalette = SIXTEEN_COLOR_PALETTE;
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for grayscale image...");
            }
        }
        byte[] pixels = new byte[this.width * this.height * bytesPerPixel];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        for (int pass = 1; pass < 8; ++pass) {
            if (!this.calculatePassVariables(pass)) continue;
            this.bytesPerScanLine = this.getBytesPerScanLine(this.block_width);
            padding = this.getPadding(this.block_width);
            byte[] pix_interlaced = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bis, pix_interlaced, this.block_height, bytesPerPixel, this.bytesPerScanLine);
            this.generateGrayscaleInterlacedPixels(pixels, pix_interlaced, this.block_width, this.block_height, padding, this.x_start + this.width * this.y_start, this.x_start, this.y_start, this.x_inc, this.y_inc);
        }
        bis.close();
        return ArrayUtils.packByteArray(pixels, this.width, 0, this.bitsPerPixel, pixels.length);
    }

    private BufferedImage process_IDAT(byte[] compr_data) throws Exception {
        byte[] bpixels = null;
        short[] spixels = null;
        WritableRaster raster = null;
        DataBuffer db = null;
        ColorModel cm = null;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        if (this.hasICCP) {
            colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(this.icc_profile));
        }
        switch (ColorType.fromInt(this.color_format)) {
            case GRAY_SCALE: {
                if (this.bitsPerPixel == 16) {
                    if (this.interlace_method == 0) {
                        spixels = this.generate16BitGrayscalePixels(compr_data);
                    } else if (this.interlace_method == 1) {
                        spixels = this.generate16BitGrayscaleInterlacedPixels(compr_data);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        if (this.alpha != null) {
                            this.correctGamma(spixels, this.width, this.height, 1, 1);
                        } else {
                            this.correctGamma(spixels, this.width, this.height, 1, 0);
                        }
                    }
                    if (this.alpha != null) {
                        db = new DataBufferUShort(spixels, spixels.length);
                        int[] off = new int[]{0, 1};
                        raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width * 2, 2, off, null);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 1);
                    } else {
                        db = new DataBufferUShort(spixels, spixels.length);
                        int[] off = new int[]{0};
                        raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, off, null);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 1);
                    }
                } else {
                    if (this.interlace_method == 0) {
                        bpixels = this.process_grayscaleImage(compr_data);
                    } else if (this.interlace_method == 1) {
                        bpixels = this.process_grayscaleInterlacedImage(compr_data);
                    }
                    db = new DataBufferByte(bpixels, bpixels.length);
                    if (this.bitsPerPixel == 8) {
                        int[] off = new int[]{0};
                        raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, off, null);
                    } else {
                        raster = Raster.createPackedRaster(db, this.width, this.height, this.bitsPerPixel, null);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(this.rgbColorPalette);
                    }
                    cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, true, -1, 0);
                }
                return new BufferedImage(cm, raster, false, null);
            }
            case GRAY_SCALE_WITH_ALPHA: {
                if (this.interlace_method == 0) {
                    bpixels = this.process_grayscaleAlphaImage(compr_data);
                } else if (this.interlace_method == 1) {
                    bpixels = this.process_grayscaleAlphaInterlacedImage(compr_data);
                }
                if (this.bitsPerPixel == 16) {
                    spixels = ArrayUtils.toShortArray(bpixels, true);
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(spixels, this.width, this.height, 1, 1);
                    }
                    db = new DataBufferUShort(spixels, spixels.length);
                    int[] off = new int[]{0, 1};
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width * 2, 2, off, null);
                    cm = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 1);
                } else {
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(bpixels, this.width, this.height);
                    }
                    db = new DataBufferByte(bpixels, bpixels.length);
                    int[] off = new int[]{0, 0, 0, 1};
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.bytesPerScanLine, 2, off, null);
                    cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
                }
                return new BufferedImage(cm, raster, false, null);
            }
            case TRUE_COLOR: {
                if (this.bitsPerPixel == 16) {
                    spixels = this.interlace_method == 0 ? this.generate16BitRGBPixels(compr_data, false) : this.generate16BitRGBInterlacedPixels(compr_data, false);
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        if (this.alpha != null) {
                            this.correctGamma(spixels, this.width, this.height, 3, 1);
                        } else {
                            this.correctGamma(spixels, this.width, this.height, 3, 0);
                        }
                    }
                    int[] off = new int[]{0, 1, 2};
                    int numOfBands = 3;
                    boolean hasAlpha = false;
                    int trans = 1;
                    int[] nBits = new int[]{16, 16, 16};
                    if (this.alpha != null) {
                        off = new int[]{0, 1, 2, 3};
                        numOfBands = 4;
                        hasAlpha = true;
                        trans = 3;
                        nBits = new int[]{16, 16, 16, 16};
                    }
                    db = new DataBufferUShort(spixels, spixels.length);
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width * numOfBands, numOfBands, off, null);
                    cm = new ComponentColorModel(colorSpace, nBits, hasAlpha, false, trans, 1);
                    if (this.hasICCP) {
                        raster = IMGUtils.iccp2rgbRaster(raster, cm);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, hasAlpha, false, trans, 1);
                    }
                } else {
                    if (this.interlace_method == 0) {
                        bpixels = this.generate8BitRGBPixels(compr_data, false);
                    } else if (this.interlace_method == 1) {
                        bpixels = this.generate8BitRGBInterlacedPixels(compr_data, false);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(bpixels, this.width, this.height, this.alpha != null);
                    }
                    int[] off = new int[]{0, 1, 2};
                    int numOfBands = 3;
                    boolean hasAlpha = false;
                    int trans = 1;
                    int[] nBits = new int[]{8, 8, 8};
                    db = new DataBufferByte(bpixels, bpixels.length);
                    if (this.alpha != null) {
                        off = new int[]{0, 1, 2, 3};
                        numOfBands = 4;
                        hasAlpha = true;
                        trans = 3;
                        nBits = new int[]{8, 8, 8, 8};
                    }
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width * numOfBands, numOfBands, off, null);
                    cm = new ComponentColorModel(colorSpace, nBits, hasAlpha, false, trans, 0);
                    if (this.hasICCP) {
                        raster = IMGUtils.iccp2rgbRaster(raster, cm);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, hasAlpha, false, trans, 0);
                    }
                }
                return new BufferedImage(cm, raster, false, null);
            }
            case TRUE_COLOR_WITH_ALPHA: {
                if (this.bitsPerPixel == 16) {
                    spixels = this.interlace_method == 0 ? this.generate16BitRGBPixels(compr_data, true) : this.generate16BitRGBInterlacedPixels(compr_data, true);
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(spixels, this.width, this.height, 3, 1);
                    }
                    db = new DataBufferUShort(spixels, spixels.length);
                    int[] off = new int[]{0, 1, 2, 3};
                    int numOfBands = 4;
                    int trans = 3;
                    int[] nBits = new int[]{16, 16, 16, 16};
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width * numOfBands, numOfBands, off, null);
                    cm = new ComponentColorModel(colorSpace, nBits, true, false, trans, 1);
                    if (this.hasICCP) {
                        raster = IMGUtils.iccp2rgbRaster(raster, cm);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, true, false, trans, 1);
                    }
                } else {
                    if (this.interlace_method == 0) {
                        bpixels = this.generate8BitRGBPixels(compr_data, true);
                    } else if (this.interlace_method == 1) {
                        bpixels = this.generate8BitRGBInterlacedPixels(compr_data, true);
                    }
                    if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                        this.correctGamma(bpixels, this.width, this.height, true);
                    }
                    int[] off = new int[]{0, 1, 2, 3};
                    int numOfBands = 4;
                    boolean hasAlpha = true;
                    int trans = 3;
                    int[] nBits = new int[]{8, 8, 8, 8};
                    db = new DataBufferByte(bpixels, bpixels.length);
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width * numOfBands, numOfBands, off, null);
                    cm = new ComponentColorModel(colorSpace, nBits, hasAlpha, false, trans, 0);
                    if (this.hasICCP) {
                        raster = IMGUtils.iccp2rgbRaster(raster, cm);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, hasAlpha, false, trans, 0);
                    }
                }
                return new BufferedImage(cm, raster, false, null);
            }
            case INDEX_COLOR: {
                bpixels = null;
                if (this.interlace_method == 0) {
                    bpixels = this.process_IndexedImage(compr_data);
                } else if (this.interlace_method == 1) {
                    bpixels = this.process_IndexedInterlacedImage(compr_data);
                }
                db = new DataBufferByte(bpixels, bpixels.length);
                if (this.bitsPerPixel != 8) {
                    raster = Raster.createPackedRaster(db, this.width, this.height, this.bitsPerPixel, null);
                } else {
                    int[] off = new int[]{0};
                    raster = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, off, null);
                }
                if (this.hasGamma && this.renderingIntent == -1 && !this.hasICCP) {
                    this.correctGamma(this.rgbColorPalette);
                }
                cm = new IndexColorModel(this.bitsPerPixel, this.rgbColorPalette.length, this.rgbColorPalette, 0, true, -1, 0);
                return new BufferedImage(cm, raster, false, null);
            }
        }
        LOGGER.error("..Invalid color type...");
        return null;
    }

    private byte[] process_IndexedImage(byte[] compr_data) throws Exception {
        this.bytesPerScanLine = this.getBytesPerScanLine(this.width);
        byte[] pixBytes = new byte[this.height * this.bytesPerScanLine];
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        PNGReader.apply_defilter(bis, pixBytes, this.height, 1, this.bytesPerScanLine);
        return pixBytes;
    }

    private byte[] process_IndexedInterlacedImage(byte[] compr_data) throws Exception {
        int padding = 0;
        byte[] pixels = new byte[this.width * this.height];
        switch (this.bitsPerPixel) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                LOGGER.error("... " + this.bitsPerPixel + " bit color depth is not valid for indexed image...");
            }
        }
        BufferedInputStream bis = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(compr_data)));
        for (int pass = 1; pass < 8; ++pass) {
            if (!this.calculatePassVariables(pass)) continue;
            this.bytesPerScanLine = this.getBytesPerScanLine(this.block_width);
            padding = this.getPadding(this.block_width);
            byte[] pix_interlaced = new byte[this.block_height * this.bytesPerScanLine];
            PNGReader.apply_defilter(bis, pix_interlaced, this.block_height, 1, this.bytesPerScanLine);
            this.generateIndexedInterlacedPixels(pixels, pix_interlaced, this.block_width, this.block_height, padding, this.x_start + this.width * this.y_start, this.x_start, this.y_start, this.x_inc, this.y_inc);
        }
        bis.close();
        return ArrayUtils.packByteArray(pixels, this.width, 0, this.bitsPerPixel, pixels.length);
    }

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        int data_len = 0;
        int chunk_type = 0;
        ByteArrayOutputStream compr_data = new ByteArrayOutputStream(65536);
        long signature = IOUtils.readLongMM(is);
        if (signature != -8552249625308161526L) {
            LOGGER.error("--- NOT A PNG IMAGE ---");
            return null;
        }
        if (!this.read_IHDR(is)) {
            throw new IOException("NOT A VALID PNG IMAGE");
        }
        LOGGER.info("--- PNG IMAGE INFO ---");
        LOGGER.info("image width: {}", (Object)this.width);
        LOGGER.info("image height: {}", (Object)this.height);
        LOGGER.info("image bit depth: {}", (Object)this.bitsPerPixel);
        LOGGER.info("Image color type: {}", (Object)ColorType.fromInt(this.color_format));
        LOGGER.info("image compression: {} - {}", (Object)this.compression, (Object)PNGDescriptor.getCompressionTypeDescrition(this.compression));
        LOGGER.info("image filter method: {} - {}", (Object)this.filter_method, (Object)PNGDescriptor.getFilterTypeDescription(this.filter_method));
        LOGGER.info("image interlace method: {} - {}", (Object)this.interlace_method, (Object)PNGDescriptor.getInterlaceTypeDescription(this.interlace_method));
        LOGGER.info("--- END PNG IMAGE INFO ---");
        block8: while (true) {
            data_len = IOUtils.readIntMM(is);
            chunk_type = IOUtils.readIntMM(is);
            if (chunk_type == ChunkType.IEND.getValue()) break;
            ChunkType chunk = ChunkType.fromInt(chunk_type);
            switch (chunk) {
                case IDAT: {
                    this.read_IDAT(is, data_len, compr_data);
                    continue block8;
                }
                case TRNS: {
                    this.alpha = new byte[data_len];
                    is.read(this.alpha, 0, data_len);
                    IOUtils.readUnsignedIntMM(is);
                    if (this.color_format == 3) {
                        this.adjust_PLTE();
                        continue block8;
                    }
                    if (this.color_format == 0) {
                        if (this.bitsPerPixel == 1) {
                            this.adjust_grayscale_PLTE(BLACK_WHITE_PALETTE);
                            continue block8;
                        }
                        if (this.bitsPerPixel == 2) {
                            this.adjust_grayscale_PLTE(FOUR_COLOR_PALETTE);
                            continue block8;
                        }
                        if (this.bitsPerPixel == 4) {
                            this.adjust_grayscale_PLTE(SIXTEEN_COLOR_PALETTE);
                            continue block8;
                        }
                        if (this.bitsPerPixel != 8) continue block8;
                        this.adjust_grayscale_PLTE(EIGHT_BIT_COLOR_PALETTE);
                        continue block8;
                    }
                    if (this.color_format != 2) continue block8;
                    LOGGER.info("full color transparent image!");
                    continue block8;
                }
                case GAMA: {
                    this.read_GAMMA(is, data_len);
                    continue block8;
                }
                case SRGB: {
                    this.read_SRGB(is, data_len);
                    continue block8;
                }
                case PLTE: {
                    this.rgbColorPalette = new int[data_len / 3];
                    this.read_PLTE(is, data_len);
                    continue block8;
                }
                case ICCP: {
                    this.hasICCP = true;
                    this.icc_profile = this.readICCProfile(is, data_len);
                    IOUtils.readUnsignedIntMM(is);
                    continue block8;
                }
            }
            IOUtils.skipFully(is, data_len);
            IOUtils.readUnsignedIntMM(is);
        }
        is.close();
        return this.process_IDAT(compr_data.toByteArray());
    }

    private void read_GAMMA(InputStream is, int data_len) throws Exception {
        if (data_len != 4) {
            LOGGER.error("Invalid Gamma data length: {}", (Object)data_len);
            return;
        }
        this.hasGamma = true;
        this.gamma = (float)IOUtils.readUnsignedIntMM(is) / 100000.0f;
        if (this.bitsPerPixel == 16) {
            this.createUShortGammaTable(this.gamma, this.displayExponent);
        } else {
            this.createGammaTable(this.gamma, this.displayExponent);
        }
        IOUtils.readUnsignedIntMM(is);
    }

    private void read_IDAT(InputStream is, int data_len, ByteArrayOutputStream compr_data) throws Exception {
        byte[] buf = new byte[data_len];
        IOUtils.readFully(is, buf, 0, data_len);
        compr_data.write(buf, 0, data_len);
        IOUtils.readUnsignedIntMM(is);
    }

    private boolean read_IHDR(InputStream is) throws Exception {
        if (IOUtils.readIntMM(is) != 13 || IOUtils.readIntMM(is) != ChunkType.IHDR.getValue()) {
            return false;
        }
        byte[] hdr = new byte[13];
        IOUtils.readFully(is, hdr, 0, 13);
        this.width = IOUtils.readIntMM(hdr, 0);
        this.height = IOUtils.readIntMM(hdr, 4);
        this.bitsPerPixel = hdr[8];
        this.color_format = hdr[9];
        this.compression = hdr[10];
        this.filter_method = hdr[11];
        this.interlace_method = hdr[12];
        IOUtils.readUnsignedIntMM(is);
        return true;
    }

    private void read_PLTE(InputStream is, int data_len) throws Exception {
        int table_indx = 0;
        byte[] rgb_table = new byte[data_len];
        int len = data_len / 3;
        IOUtils.readFully(is, rgb_table, 0, data_len);
        for (int i = 0; i < len; ++i) {
            this.rgbColorPalette[i] = 0xFF000000 | (rgb_table[table_indx++] & 0xFF) << 16 | (rgb_table[table_indx++] & 0xFF) << 8 | rgb_table[table_indx++] & 0xFF;
        }
        IOUtils.readUnsignedIntMM(is);
    }

    private void read_SRGB(InputStream is, int data_len) throws Exception {
        if (data_len != 1) {
            LOGGER.error("Invalid SRGB data length:{}", (Object)data_len);
            return;
        }
        this.renderingIntent = (byte)IOUtils.read(is);
        IOUtils.readUnsignedIntMM(is);
    }

    private byte[] readICCProfile(InputStream is, int data_len) throws Exception {
        byte[] buf = new byte[data_len];
        IOUtils.readFully(is, buf);
        int profileName_len = 0;
        while (buf[profileName_len] != 0) {
            ++profileName_len;
        }
        String profileName = new String(buf, 0, profileName_len, "UTF-8");
        InflaterInputStream ii = new InflaterInputStream(new ByteArrayInputStream(buf, profileName_len + 2, data_len - profileName_len - 2));
        LOGGER.info("ICCProfile name: {}", (Object)profileName);
        byte[] icc_profile = IOUtils.readFully((InputStream)ii, 4096);
        ICCProfile.showProfile(icc_profile);
        return icc_profile;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PNGReader.EIGHT_BIT_COLOR_PALETTE[i] = 0xFF000000 | i << 16 | i << 8 | i & 0xFF;
        }
        LOGGER = LoggerFactory.getLogger(PNGReader.class);
    }
}

