/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.InputStream;

public class TGAReader
extends ImageReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TGAReader.class);
    public static final int SCAN_MODE_BOTTOM_LEFT = 0;
    public static final int SCAN_MODE_BOTTOM_RIGHT = 1;
    public static final int SCAN_MODE_TOP_LEFT = 2;
    public static final int SCAN_MODE_TOP_RIGHT = 3;
    private TgaHeader tgaHeader;
    private int scanMode = 0;
    private int l = 0;
    private int m = 0;
    private int n = 0;
    private int o = 0;
    private int[] pix;

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        this.tgaHeader = new TgaHeader();
        this.tgaHeader.readHeader(is);
        this.bitsPerPixel = this.tgaHeader.bits_per_pixel;
        this.width = this.tgaHeader.width;
        this.height = this.tgaHeader.height;
        this.pix = new int[this.width * this.height];
        if (this.tgaHeader.colourmap_type != 0 && this.tgaHeader.colourmap_type != 1) {
            LOGGER.error("Can only handle colour map types of 0 and 1");
            return null;
        }
        this.scanMode = (this.tgaHeader.image_descriptor & 0x30) >> 4;
        switch (this.scanMode) {
            case 0: {
                this.l = this.height - 1;
                this.m = -1;
                this.n = 0;
                this.o = 1;
                break;
            }
            case 1: {
                this.l = this.height - 1;
                this.m = -1;
                this.n = this.width - 1;
                this.o = -1;
                break;
            }
            case 2: {
                this.l = 0;
                this.m = 1;
                this.n = 0;
                this.o = 1;
                break;
            }
            case 3: {
                this.l = 0;
                this.m = 1;
                this.n = this.width - 1;
                this.o = -1;
                break;
            }
        }
        LOGGER.info("Image x_origin: {}", (Object)this.tgaHeader.x_origin);
        LOGGER.info("Image y_origin: {}", (Object)this.tgaHeader.y_origin);
        switch (this.tgaHeader.image_type) {
            case 0: {
                LOGGER.info("There are no data in the image file");
                System.exit(1);
            }
            case 1: {
                this.readCMPTga(is);
                break;
            }
            case 2: {
                this.readTrueColorTga(is);
                break;
            }
            case 3: {
                this.read_BW_Tga(is);
                break;
            }
            case 9: {
                this.read_RLE_CMP_Tga(is);
                break;
            }
            case 10: {
                this.read_RLE_TrueColor_Tga(is);
                break;
            }
            case 11: {
                this.read_RLE_BW_Tga(is);
                break;
            }
            case 32: 
            case 33: {
                LOGGER.error("Not implemented for compressed color mapped images");
                return null;
            }
            default: {
                LOGGER.error("I can't find a type matches this");
                return null;
            }
        }
        DataBufferInt db = new DataBufferInt(this.pix, this.pix.length);
        WritableRaster raster = Raster.createPackedRaster(db, this.width, this.height, this.width, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        DirectColorModel cm = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        return new BufferedImage(cm, raster, false, null);
    }

    private void read_BW_Tga(InputStream is) throws Exception {
        this.bitsPerPixel = 1;
        LOGGER.info("Uncompressed Black and White Tga image!");
        int index = 0;
        IOUtils.skipFully(is, this.tgaHeader.id_length);
        IOUtils.skipFully(is, this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] brgb = new byte[this.width * this.height];
        IOUtils.readFully(is, brgb, 0, this.width * this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[index] & 0xFF | (brgb[index] & 0xFF) << 8 | (brgb[index++] & 0xFF) << 16;
            }
        }
        is.close();
    }

    private void read_RLE_BW_Tga(InputStream is) throws Exception {
        this.bitsPerPixel = 1;
        LOGGER.info("Black and White Tga RLE image!");
        int nindex = 0;
        int p = 0;
        int k = 0;
        int i = 0;
        int j = 0;
        IOUtils.skipFully(is, this.tgaHeader.id_length);
        IOUtils.skipFully(is, this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] brgb = IOUtils.readFully(is, 4096);
        block0: while (p < this.width * this.height) {
            int q;
            k = (brgb[nindex++] & 0x7F) + 1;
            if ((brgb[nindex - 1] & 0x80) != 0) {
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex] & 0xFF) << 8 | (brgb[nindex] & 0xFF) << 16;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) break;
                }
                ++nindex;
                continue;
            }
            for (q = 0; q < k; ++q) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16;
                if (++j % this.width == 0) {
                    ++i;
                    j = 0;
                }
                if (++p >= this.width * this.height) continue block0;
            }
        }
        is.close();
    }

    private void read_RLE_CMP_Tga(InputStream is) throws Exception {
        LOGGER.info("color mapped Tga RLE image!");
        int nindex = 0;
        int p = 0;
        int k = 0;
        int i = 0;
        int j = 0;
        if (this.tgaHeader.bits_per_pixel != 8) {
            LOGGER.error("Can only handle 8 bit color mapped tga file");
            return;
        }
        this.readPalette(is);
        byte[] brgb = IOUtils.readFully(is, 4096);
        block0: while (p < this.width * this.height) {
            int q;
            k = (brgb[nindex++] & 0x7F) + 1;
            if ((brgb[nindex - 1] & 0x80) != 0) {
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.rgbColorPalette[brgb[nindex] & 0xFF];
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) break;
                }
                ++nindex;
                continue;
            }
            for (q = 0; q < k; ++q) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.rgbColorPalette[brgb[nindex++] & 0xFF];
                if (++j % this.width == 0) {
                    ++i;
                    j = 0;
                }
                if (++p >= this.width * this.height) continue block0;
            }
        }
        is.close();
    }

    private void read_RLE_TrueColor_Tga(InputStream is) throws Exception {
        int skipover = 0;
        int nindex = 0;
        int p = 0;
        int k = 0;
        int i = 0;
        int j = 0;
        skipover += this.tgaHeader.id_length;
        IOUtils.skipFully(is, skipover += this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] brgb = IOUtils.readFully(is, 4096);
        if (this.tgaHeader.bits_per_pixel == 24) {
            LOGGER.info("24 bits Tga RLE image!");
            block0: while (p < this.width * this.height) {
                int q;
                k = (brgb[nindex++] & 0x7F) + 1;
                if ((brgb[nindex - 1] & 0x80) != 0) {
                    for (q = 0; q < k; ++q) {
                        this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex + 1] & 0xFF) << 8 | (brgb[nindex + 2] & 0xFF) << 16;
                        if (++j % this.width == 0) {
                            ++i;
                            j = 0;
                        }
                        if (++p >= this.width * this.height) break;
                    }
                    nindex += 3;
                    continue;
                }
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) continue block0;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 32) {
            LOGGER.info("32 bits Tga RLE image!");
            block3: while (p < this.width * this.height) {
                int q;
                k = (brgb[nindex++] & 0x7F) + 1;
                if ((brgb[nindex - 1] & 0x80) != 0) {
                    for (q = 0; q < k; ++q) {
                        this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = brgb[nindex] & 0xFF | (brgb[nindex + 1] & 0xFF) << 8 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 3] & 0xFF) << 24;
                        if (++j % this.width == 0) {
                            ++i;
                            j = 0;
                        }
                        if (++p >= this.width * this.height) break;
                    }
                    nindex += 4;
                    continue;
                }
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16 | (brgb[nindex++] & 0xFF) << 24;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) continue block3;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 15 || this.tgaHeader.bits_per_pixel == 16) {
            LOGGER.info("16 bits Tga RLE image!");
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 0;
            block6: while (p < this.width * this.height) {
                int q;
                k = (brgb[nindex++] & 0x7F) + 1;
                if ((brgb[nindex - 1] & 0x80) != 0) {
                    r = (brgb[++nindex] & 0x7C) << 1;
                    g = (brgb[nindex] & 3) << 6 | (brgb[nindex - 1] & 0xE0) >> 2;
                    b = (brgb[nindex - 1] & 0x1F) << 3;
                    a = 255;
                    ++nindex;
                    for (q = 0; q < k; ++q) {
                        this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = a << 24 | r << 16 | g << 8 | b;
                        if (++j % this.width == 0) {
                            ++i;
                            j = 0;
                        }
                        if (++p >= this.width * this.height) continue block6;
                    }
                    continue;
                }
                for (q = 0; q < k; ++q) {
                    r = (brgb[++nindex] & 0x7C) << 1;
                    g = (brgb[nindex] & 3) << 6 | (brgb[nindex - 1] & 0xE0) >> 2;
                    b = (brgb[nindex - 1] & 0x1F) << 3;
                    a = 255;
                    ++nindex;
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = a << 24 | r << 16 | g << 8 | b;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) continue block6;
                }
            }
        }
        is.close();
    }

    private void readCMPTga(InputStream is) throws Exception {
        LOGGER.info("color mapped Tga uncompressed image!");
        int index = 0;
        this.readPalette(is);
        if (this.tgaHeader.bits_per_pixel != 8) {
            LOGGER.error("Can only handle 8 bit color mapped tga file");
            return;
        }
        byte[] brgb = new byte[this.width * this.height];
        IOUtils.readFully(is, brgb, 0, this.width * this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.rgbColorPalette[brgb[index++] & 0xFF];
            }
        }
        is.close();
    }

    private void readPalette(InputStream is) throws Exception {
        int index = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int byte_per_pixel = (this.tgaHeader.colourmap_entry_size + 1) / 8;
        int readbytes = byte_per_pixel * (this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index);
        byte[] brgb = new byte[readbytes];
        int colorsUsed = this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index;
        this.rgbColorPalette = new int[colorsUsed];
        IOUtils.skipFully(is, this.tgaHeader.id_length);
        IOUtils.skipFully(is, this.tgaHeader.first_entry_index);
        IOUtils.readFully(is, brgb, 0, readbytes);
        switch (this.tgaHeader.colourmap_entry_size) {
            case 15: 
            case 16: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    r = (brgb[++index] & 0x7C) << 1;
                    g = (brgb[index] & 3) << 6 | (brgb[index - 1] & 0xE0) >> 2;
                    b = (brgb[index - 1] & 0x1F) << 3;
                    a = 255;
                    this.rgbColorPalette[i] = a << 24 | r << 16 | g << 8 | b;
                    ++index;
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    this.rgbColorPalette[i] = 0xFF000000 | brgb[index++] & 0xFF | (brgb[index++] & 0xFF) << 8 | (brgb[index++] & 0xFF) << 16;
                }
                break;
            }
            case 32: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    this.rgbColorPalette[i] = brgb[index++] & 0xFF | (brgb[index++] & 0xFF) << 8 | (brgb[index++] & 0xFF) << 16 | (brgb[index++] & 0xFF) << 24;
                }
                break;
            }
        }
    }

    private void readTrueColorTga(InputStream is) throws Exception {
        int skipover = 0;
        int nindex = 0;
        skipover += this.tgaHeader.id_length;
        IOUtils.skipFully(is, skipover += this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        int bytes2read = (this.tgaHeader.bits_per_pixel + 7) / 8;
        byte[] brgb = new byte[bytes2read * this.width * this.height];
        IOUtils.readFully(is, brgb, 0, bytes2read * this.width * this.height);
        if (this.tgaHeader.bits_per_pixel == 24) {
            LOGGER.info("24 bits Tga uncompressed image!");
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 32) {
            LOGGER.info("32 bits Tga uncompressed image!");
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16 | (brgb[nindex++] & 0xFF) << 24;
                }
            }
        } else if (this.tgaHeader.bits_per_pixel == 15 || this.tgaHeader.bits_per_pixel == 16) {
            LOGGER.info("16 bits Tga uncompressed image!");
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    r = (brgb[++nindex] & 0x7C) << 1;
                    g = (brgb[nindex] & 3) << 6 | (brgb[nindex - 1] & 0xE0) >> 2;
                    b = (brgb[nindex - 1] & 0x1F) << 3;
                    a = 255;
                    ++nindex;
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = a << 24 | r << 16 | g << 8 | b;
                }
            }
        }
        is.close();
    }

    private static class TgaHeader {
        byte id_length;
        byte colourmap_type;
        byte image_type;
        short first_entry_index;
        short colourmap_length;
        byte colourmap_entry_size;
        short x_origin;
        short y_origin;
        short width;
        short height;
        byte bits_per_pixel;
        byte image_descriptor;

        private TgaHeader() {
        }

        void readHeader(InputStream is) throws Exception {
            int nindex = 0;
            byte[] header = new byte[18];
            IOUtils.readFully(is, header, 0, 18);
            this.id_length = header[nindex++];
            this.colourmap_type = header[nindex++];
            this.image_type = header[nindex++];
            this.first_entry_index = (short)(header[nindex++] & 0xFF | (header[nindex++] & 0xFF) << 8);
            this.colourmap_length = (short)(header[nindex++] & 0xFF | (header[nindex++] & 0xFF) << 8);
            this.colourmap_entry_size = header[nindex++];
            this.x_origin = (short)(header[nindex++] & 0xFF | (header[nindex++] & 0xFF) << 8);
            this.y_origin = (short)(header[nindex++] & 0xFF | (header[nindex++] & 0xFF) << 8);
            this.width = (short)(header[nindex++] & 0xFF | (header[nindex++] & 0xFF) << 8);
            this.height = (short)(header[nindex++] & 0xFF | (header[nindex++] & 0xFF) << 8);
            this.bits_per_pixel = header[nindex++];
            this.image_descriptor = header[nindex++];
        }
    }
}

