/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.reader;

import guilibshadow.cafe4j.image.color.CMYKColorSpace;
import guilibshadow.cafe4j.image.color.Int32ComponentColorModel;
import guilibshadow.cafe4j.image.compression.ImageDecoder;
import guilibshadow.cafe4j.image.compression.UnsupportedCompressionException;
import guilibshadow.cafe4j.image.compression.ccitt.G31DDecoder;
import guilibshadow.cafe4j.image.compression.ccitt.G32DDecoder;
import guilibshadow.cafe4j.image.compression.deflate.DeflateDecoder;
import guilibshadow.cafe4j.image.compression.lzw.LZWTreeDecoder;
import guilibshadow.cafe4j.image.compression.packbits.Packbits;
import guilibshadow.cafe4j.image.reader.ImageReader;
import guilibshadow.cafe4j.image.tiff.ASCIIField;
import guilibshadow.cafe4j.image.tiff.ByteField;
import guilibshadow.cafe4j.image.tiff.DoubleField;
import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.FloatField;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.LongField;
import guilibshadow.cafe4j.image.tiff.RationalField;
import guilibshadow.cafe4j.image.tiff.ShortField;
import guilibshadow.cafe4j.image.tiff.TIFFTweaker;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.TiffFieldEnum;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.image.tiff.UndefinedField;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.io.FileCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.io.ReadStrategyII;
import guilibshadow.cafe4j.io.ReadStrategyMM;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TIFFReader
extends ImageReader {
    private RandomAccessInputStream randIS = null;
    protected List<IFD> ifds;
    private List<BufferedImage> frames;
    private int endian = 19789;
    private static final int[] redMask;
    private static final int[] greenMask;
    private static final int[] blueMask;
    private static final int[] BLACK_WHITE_PALETTE;
    private static final int[] BLACK_WHITE_PALETTE_WHITE_IS_ZERO;
    private static final int[] FOUR_COLOR_PALETTE;
    private static final int[] FOUR_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int[] SIXTEEN_COLOR_PALETTE;
    private static final int[] SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO;
    private static final int[] EIGHT_BIT_COLOR_PALETTE;
    private static final int[] EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO;
    private static int GROUP3OPT_2DENCODING;
    private static int GROUP3OPT_UNCOMPRESSED;
    private static final int bufLen = 40960;
    private static final Logger LOGGER;

    protected BufferedImage decode(IFD ifd) throws Exception {
        TiffField<?> f_tileWidth = ifd.getField(TiffTag.TILE_WIDTH);
        TiffField<?> f_tileLength = ifd.getField(TiffTag.TILE_LENGTH);
        if (f_tileWidth != null && f_tileLength != null) {
            return this.decodeTiledTiff(ifd);
        }
        return this.decodeStrippedTiff(ifd);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private BufferedImage decodeStrippedTiff(IFD ifd) throws Exception {
        f_compression = ifd.getField(TiffTag.COMPRESSION);
        data = new short[]{1};
        if (f_compression != null) {
            data = (short[])f_compression.getData();
        }
        compression = TiffFieldEnum.Compression.fromValue(data[0] & 65535);
        TIFFReader.LOGGER.info("Compression type: {}", (Object)compression.getDescription());
        f_stripOffsets = ifd.getField(TiffTag.STRIP_OFFSETS);
        f_stripByteCounts = ifd.getField(TiffTag.STRIP_BYTE_COUNTS);
        if (f_stripOffsets == null) {
            throw new RuntimeException("Missing required field stripOffsets");
        }
        stripOffsets = f_stripOffsets.getDataAsLong();
        stripByteCounts = null;
        if (f_stripByteCounts != null) ** GOTO lbl18
        if (stripOffsets.length == 1) {
            stripByteCounts = new int[]{0};
        } else {
            throw new RuntimeException("Missing required field stripByteCounts");
lbl18:
            // 1 sources

            stripByteCounts = f_stripByteCounts.getDataAsLong();
        }
        imageWidth = ifd.getField(TiffTag.IMAGE_WIDTH).getDataAsLong()[0];
        imageHeight = ifd.getField(TiffTag.IMAGE_LENGTH).getDataAsLong()[0];
        TIFFReader.LOGGER.info("Image width: {}", (Object)imageWidth);
        TIFFReader.LOGGER.info("Image height: {}", (Object)imageHeight);
        f_rowsPerStrip = ifd.getField(TiffTag.ROWS_PER_STRIP);
        rowsPerStrip = imageHeight;
        if (f_rowsPerStrip != null) {
            rowsPerStrip = f_rowsPerStrip.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Rows per strip: {}", (Object)rowsPerStrip);
        f_photoMetric = ifd.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
        photoMetric = TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue();
        if (f_photoMetric != null) {
            photoMetric = f_photoMetric.getDataAsLong()[0];
        }
        e_photoMetric = TiffFieldEnum.PhotoMetric.fromValue(photoMetric);
        TIFFReader.LOGGER.info("PhotoMetric: {}", (Object)e_photoMetric);
        f_bitsPerSample = ifd.getField(TiffTag.BITS_PER_SAMPLE);
        bitsPerSample = 1;
        if (f_bitsPerSample != null) {
            bitsPerSample = f_bitsPerSample.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Bits per sample: {}", (Object)bitsPerSample);
        f_samplesPerPixel = ifd.getField(TiffTag.SAMPLES_PER_PIXEL);
        samplesPerPixel = 1;
        if (f_samplesPerPixel != null) {
            samplesPerPixel = f_samplesPerPixel.getDataAsLong()[0];
        }
        TIFFReader.LOGGER.info("Samples per pixel: {}", (Object)samplesPerPixel);
        f_predictor = ifd.getField(TiffTag.PREDICTOR);
        predictor = 0;
        if (f_predictor != null) {
            predictor = f_predictor.getDataAsLong()[0];
            TIFFReader.LOGGER.info("Predictor: {}", (Object)predictor);
        }
        f_planaryConfiguration = ifd.getField(TiffTag.PLANAR_CONFIGURATTION);
        planaryConfiguration = 1;
        if (f_planaryConfiguration != null) {
            planaryConfiguration = f_planaryConfiguration.getDataAsLong()[0];
        }
        e_planaryConfiguration = TiffFieldEnum.PlanarConfiguration.fromValue(planaryConfiguration);
        TIFFReader.LOGGER.info("Planary configuration: {}", (Object)e_planaryConfiguration);
        f_sampleFormat = ifd.getField(TiffTag.SAMPLE_FORMAT);
        f_sampleMaxValue = ifd.getField(TiffTag.S_MAX_SAMPLE_VALUE);
        f_sampleMinValue = ifd.getField(TiffTag.S_MIN_SAMPLE_VALUE);
        fillOrder = 1;
        f_fillOrder = ifd.getField(TiffTag.FILL_ORDER);
        if (f_fillOrder != null) {
            fillOrder = f_fillOrder.getDataAsLong()[0];
        }
        floatSample = false;
        if (f_sampleFormat != null && f_sampleFormat.getDataAsLong()[0] == 3) {
            floatSample = true;
            maxValue = bitsPerSample <= 32 ? 3.4028234663852886E38 : 1.7976931348623157E308;
            v0 = minValue = bitsPerSample <= 32 ? 1.401298464324817E-45 : 4.9E-324;
            if (bitsPerSample <= 32 && f_sampleMaxValue != null) {
                maxValue = ((float[])f_sampleMaxValue.getData())[0];
            } else if (bitsPerSample > 32 && f_sampleMaxValue != null) {
                maxValue = ((double[])f_sampleMaxValue.getData())[0];
            }
            if (bitsPerSample <= 32 && f_sampleMinValue != null) {
                minValue = ((float[])f_sampleMinValue.getData())[0];
            } else if (bitsPerSample > 32 && f_sampleMinValue != null) {
                minValue = ((double[])f_sampleMinValue.getData())[0];
            }
            TIFFReader.LOGGER.info("Sample MAX value: {}", (Object)maxValue);
            TIFFReader.LOGGER.info("Sample MIN vlaue: {}", (Object)minValue);
        }
        transparent = false;
        isAssociatedAlpha = false;
        numOfBands = samplesPerPixel;
        trans = 1;
        f_extraSamples = ifd.getField(TiffTag.EXTRA_SAMPLES);
        if (f_extraSamples != null) {
            isAssociatedAlpha = f_extraSamples.getDataAsLong()[0] == 1;
        }
        offset = 0;
        decoder = null;
        pixels = null;
        stripBytes = TIFFTweaker.getUncompressedStripByteCounts(ifd, stripOffsets.length);
        count = new int[samplesPerPixel];
        if (planaryConfiguration == 2) {
            inc = stripBytes.length / samplesPerPixel;
            startOff = 0;
            endOff = inc;
            for (k = 0; k < samplesPerPixel; ++k) {
                for (j = startOff; j < endOff; ++j) {
                    v1 = k;
                    count[v1] = count[v1] + stripBytes[j];
                }
                startOff += inc;
                endOff += inc;
            }
        }
        switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$PhotoMetric[e_photoMetric.ordinal()]) {
            case 1: {
                colorMap = (short[])ifd.getField(TiffTag.COLORMAP).getData();
                this.rgbColorPalette = new int[colorMap.length / 3];
                numOfColors = 1 << bitsPerSample;
                numOfColors2 = numOfColors << 1;
                index = 0;
                for (i = 0; i < colorMap.length / 3; ++i) {
                    this.rgbColorPalette[index++] = -16777216 | (colorMap[i] & 65280) << 8 | colorMap[i + numOfColors] & 65280 | (colorMap[i + numOfColors2] & 65280) >> 8;
                }
                bytesPerScanLine = (imageWidth * bitsPerSample + 7) / 8;
                pixels = new byte[bytesPerScanLine * imageHeight];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[compression.ordinal()]) {
                    case 1: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.randIS.seek(stripOffsets[i]);
                            this.randIS.readFully(pixels, offset, bytes2Read);
                            offset += bytes2Read;
                        }
                        break;
                    }
                    case 2: {
                        decoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        decoder = new DeflateDecoder();
                        break;
                    }
                    case 5: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.unpackStrip(pixels, offset, stripBytes[i], stripOffsets[i], stripByteCounts[i]);
                            offset += bytes2Read;
                        }
                        break;
                    }
                }
                if (decoder != null) {
                    for (i = 0; i < stripByteCounts.length; ++i) {
                        temp = null;
                        this.randIS.seek(stripOffsets[i]);
                        if (stripByteCounts[i] == 0) {
                            temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            temp = new byte[stripByteCounts[i]];
                            this.randIS.readFully(temp);
                        }
                        decoder.setInput(temp);
                        numOfBytes = decoder.decode(pixels, offset, stripBytes[i]);
                        offset += numOfBytes;
                    }
                }
                db = new DataBufferByte(pixels, pixels.length);
                raster = null;
                if (bitsPerSample != 8) {
                    raster = Raster.createPackedRaster(db, imageWidth, imageHeight, bitsPerSample, null);
                } else {
                    off = new int[]{0};
                    raster = Raster.createInterleavedRaster(db, imageWidth, imageHeight, imageWidth, 1, off, null);
                }
                cm = new IndexColorModel(bitsPerSample, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                return new BufferedImage(cm, raster, false, null);
            }
            case 2: {
                bytesPerScanLine = samplesPerPixel * ((imageWidth * bitsPerSample + 7) / 8);
                totalBytes = bytesPerScanLine * imageHeight;
                if (planaryConfiguration == 2) {
                    bytesPerScanLine = (imageWidth * bitsPerSample + 7) / 8;
                }
                pixels = new byte[totalBytes];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[compression.ordinal()]) {
                    case 1: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.randIS.seek(stripOffsets[i]);
                            this.randIS.readFully(pixels, offset, bytes2Read);
                            offset += bytes2Read;
                        }
                        break;
                    }
                    case 5: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.unpackStrip(pixels, offset, stripBytes[i], stripOffsets[i], stripByteCounts[i]);
                            offset += bytes2Read;
                        }
                        break;
                    }
                    case 2: {
                        decoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        decoder = new DeflateDecoder();
                        break;
                    }
                }
                if (decoder != null) {
                    for (i = 0; i < stripByteCounts.length; ++i) {
                        this.randIS.seek(stripOffsets[i]);
                        temp = null;
                        if (stripByteCounts[i] == 0) {
                            temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            temp = new byte[stripByteCounts[i]];
                            this.randIS.readFully(temp);
                        }
                        decoder.setInput(temp);
                        numOfBytes = decoder.decode(pixels, offset, stripBytes[i]);
                        offset += numOfBytes;
                    }
                }
                if (predictor == 2 && planaryConfiguration == 1) {
                    pixels = TIFFReader.applyDePredictor(samplesPerPixel, pixels, imageWidth, imageHeight);
                }
                db /* !! */  = new DataBufferByte(pixels, pixels.length);
                f_colorProfile = ifd.getField(TiffTag.ICC_PROFILE);
                profile = null;
                if (f_colorProfile != null) {
                    profile = ICC_Profile.getInstance((byte[])f_colorProfile.getData());
                }
                colorSpace /* !! */  = CMYKColorSpace.getInstance();
                if (profile != null) {
                    colorSpace /* !! */  = new ICC_ColorSpace(profile);
                }
                bandoff = new int[]{0, 1, 2, 3};
                nBits = new int[]{bitsPerSample, bitsPerSample, bitsPerSample, bitsPerSample};
                if (samplesPerPixel >= 5) {
                    bandoff = new int[]{0, 1, 2, 3, 4};
                    nBits = new int[]{bitsPerSample, bitsPerSample, bitsPerSample, bitsPerSample, bitsPerSample};
                    trans = 3;
                    transparent = true;
                }
                if (bitsPerSample == 16) {
                    spixels = ArrayUtils.toShortArray(pixels, this.endian == 19789);
                    db /* !! */  = new DataBufferUShort(spixels, spixels.length);
                    cm = new ComponentColorModel(colorSpace /* !! */ , nBits, transparent, isAssociatedAlpha, trans, 1);
                    if (planaryConfiguration == 2) {
                        bandoff = new int[]{0, count[0] * 8 / bitsPerSample, (count[0] + count[1]) * 8 / bitsPerSample, (count[0] + count[1] + count[2]) * 8 / bitsPerSample};
                        bankIndices = new int[]{0, 0, 0, 0};
                        if (samplesPerPixel >= 5) {
                            bandoff = new int[]{0, count[0], count[0] + count[1], count[0] + count[1] + count[2], count[0] + count[1] + count[2] + count[3]};
                            bankIndices = new int[]{0, 0, 0, 0, 0};
                        }
                        raster = Raster.createBandedRaster(db /* !! */ , imageWidth, imageHeight, bytesPerScanLine * 8 / bitsPerSample, bankIndices, bandoff, null);
                    } else {
                        raster = Raster.createInterleavedRaster(db /* !! */ , imageWidth, imageHeight, imageWidth * numOfBands, numOfBands, bandoff, null);
                    }
                    if (profile != null) {
                        raster = IMGUtils.iccp2rgbRaster(raster, cm);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, raster.getTransferType());
                    }
                } else {
                    cm = new ComponentColorModel(colorSpace /* !! */ , nBits, transparent, isAssociatedAlpha, trans, 0);
                    if (planaryConfiguration == 2) {
                        bandoff = new int[]{0, count[0], count[0] + count[1], count[0] + count[1] + count[2]};
                        bankIndices = new int[]{0, 0, 0, 0};
                        if (samplesPerPixel >= 5) {
                            bandoff = new int[]{0, count[0], count[0] + count[1], count[0] + count[1] + count[2], count[0] + count[1] + count[2] + count[3]};
                            bankIndices = new int[]{0, 0, 0, 0, 0};
                        }
                        raster = Raster.createBandedRaster(db /* !! */ , imageWidth, imageHeight, bytesPerScanLine, bankIndices, bandoff, null);
                    } else {
                        raster = Raster.createInterleavedRaster(db /* !! */ , imageWidth, imageHeight, imageWidth * numOfBands, numOfBands, bandoff, null);
                    }
                    if (profile != null) {
                        raster = IMGUtils.iccp2rgbRaster(raster, cm);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 0);
                    }
                }
                return new BufferedImage(cm, raster, false, null);
            }
            case 3: {
                samplingFactor = new int[]{2, 2};
                f_YCbCrSubSampling = ifd.getField(TiffTag.YCbCr_SUB_SAMPLING);
                if (f_YCbCrSubSampling != null) {
                    samplingFactor = f_YCbCrSubSampling.getDataAsLong();
                }
                expandedImageWidth = (imageWidth + samplingFactor[0] - 1) / samplingFactor[0] * samplingFactor[0];
                expandedImageHeight = (imageHeight + samplingFactor[1] - 1) / samplingFactor[1] * samplingFactor[1];
                referenceBlackY = 0.0f;
                referenceWhiteY = 255.0f;
                referenceBlackCb = 128.0f;
                referenceWhiteCb = 255.0f;
                referenceBlackCr = 128.0f;
                referenceWhiteCr = 255.0f;
                codingRangeY = 255.0f;
                codingRangeCbCr = 127.0f;
                f_referenceBlackWhite = ifd.getField(TiffTag.REFERENCE_BLACK_WHITE);
                if (f_referenceBlackWhite != null) {
                    referenceBlackWhite = f_referenceBlackWhite.getDataAsLong();
                    referenceBlackY = 1.0f * (float)referenceBlackWhite[0] / (float)referenceBlackWhite[1];
                    referenceWhiteY = 1.0f * (float)referenceBlackWhite[2] / (float)referenceBlackWhite[3];
                    referenceBlackCb = 1.0f * (float)referenceBlackWhite[4] / (float)referenceBlackWhite[5];
                    referenceWhiteCb = 1.0f * (float)referenceBlackWhite[6] / (float)referenceBlackWhite[7];
                    referenceBlackCr = 1.0f * (float)referenceBlackWhite[8] / (float)referenceBlackWhite[9];
                    referenceWhiteCr = 1.0f * (float)referenceBlackWhite[10] / (float)referenceBlackWhite[11];
                }
                lumaRed = 0.299f;
                lumaGreen = 0.587f;
                lumaBlue = 0.114f;
                f_YCbCrCoefficients = ifd.getField(TiffTag.YCbCr_COEFFICIENTS);
                if (f_YCbCrCoefficients != null) {
                    lumas = f_YCbCrCoefficients.getDataAsLong();
                    lumaRed = 1.0f * (float)lumas[0] / (float)lumas[1];
                    lumaGreen = 1.0f * (float)lumas[2] / (float)lumas[3];
                    lumaBlue = 1.0f * (float)lumas[4] / (float)lumas[5];
                }
                offsetY = 0;
                bytesY = expandedImageWidth * expandedImageHeight;
                pixels = new byte[bytesY * 3];
                temp = null;
                temp2 = null;
                if (planaryConfiguration != 1) ** GOTO lbl337
                bytesPerUnitY = samplingFactor[0] * samplingFactor[1];
                bytesPerUnitCb = 1;
                bytesPerUnitCr = 1;
                bytesPerDataUnit = bytesPerUnitY + bytesPerUnitCb + bytesPerUnitCr;
                dataUnitsPerWidth = expandedImageWidth / samplingFactor[0];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[compression.ordinal()]) {
                    case 1: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            this.randIS.seek(stripOffsets[i]);
                            if (stripByteCounts[i] == 0) {
                                temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                            } else {
                                temp = new byte[stripByteCounts[i]];
                                this.randIS.readFully(temp);
                            }
                            numOfDataUnit = temp.length / bytesPerDataUnit;
                            offsetY = this.upsampling(offsetY, numOfDataUnit, bytesPerUnitY, samplingFactor, referenceBlackY, referenceWhiteY, referenceBlackCb, referenceWhiteCb, referenceBlackCr, referenceWhiteCr, codingRangeY, codingRangeCbCr, lumaRed, lumaGreen, lumaBlue, temp, pixels, expandedImageWidth, dataUnitsPerWidth);
                        }
                        ** GOTO lbl407
                    }
                    case 2: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            this.randIS.seek(stripOffsets[i]);
                            if (stripByteCounts[i] == 0) {
                                temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                            } else {
                                temp = new byte[stripByteCounts[i]];
                                this.randIS.readFully(temp);
                            }
                            temp2 = new byte[stripBytes[i]];
                            decoder = new LZWTreeDecoder(8, true);
                            decoder.setInput(temp);
                            numOfBytes = decoder.decode(temp2, 0, temp2.length);
                            numOfDataUnit = numOfBytes / bytesPerDataUnit;
                            offsetY = this.upsampling(offsetY, numOfDataUnit, bytesPerUnitY, samplingFactor, referenceBlackY, referenceWhiteY, referenceBlackCb, referenceWhiteCb, referenceBlackCr, referenceWhiteCr, codingRangeY, codingRangeCbCr, lumaRed, lumaGreen, lumaBlue, temp2, pixels, expandedImageWidth, dataUnitsPerWidth);
                        }
                        ** GOTO lbl407
                    }
                    case 5: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            this.randIS.seek(stripOffsets[i]);
                            if (stripByteCounts[i] == 0) {
                                temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                            } else {
                                temp = new byte[stripByteCounts[i]];
                                this.randIS.readFully(temp);
                            }
                            temp2 = new byte[stripBytes[i]];
                            Packbits.unpackbits(temp, temp2);
                            numOfBytes = stripBytes[i];
                            numOfDataUnit = numOfBytes / bytesPerDataUnit;
                            offsetY = this.upsampling(offsetY, numOfDataUnit, bytesPerUnitY, samplingFactor, referenceBlackY, referenceWhiteY, referenceBlackCb, referenceWhiteCb, referenceBlackCr, referenceWhiteCr, codingRangeY, codingRangeCbCr, lumaRed, lumaGreen, lumaBlue, temp2, pixels, expandedImageWidth, dataUnitsPerWidth);
                        }
                        ** GOTO lbl407
                    }
                }
                ** GOTO lbl407
lbl337:
                // 1 sources

                if (stripByteCounts.length == 1 && samplesPerPixel != 1) {
                    throw new RuntimeException("stripByteCounts length 1 is not consistent with samplesPerPixel " + samplesPerPixel);
                }
                bytesPerScanLine = (expandedImageWidth * bitsPerSample + 7) / 8;
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[compression.ordinal()]) {
                    case 1: {
                        stripsPerSample = stripByteCounts.length / samplesPerPixel;
                        buf = new byte[samplesPerPixel][];
                        bout = new ByteArrayOutputStream();
                        index = 0;
                        for (i = 0; i < samplesPerPixel; ++i) {
                            j = 0;
                            while (j < stripsPerSample) {
                                this.randIS.seek(stripOffsets[index]);
                                len = stripByteCounts[index];
                                if (len == 0) {
                                    temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                                } else {
                                    temp = new byte[len];
                                    this.randIS.readFully(temp);
                                }
                                bout.write(temp);
                                ++j;
                                ++index;
                            }
                            buf[i] = bout.toByteArray();
                            bout.reset();
                        }
                        yPos = 0;
                        CbPos = 0;
                        CrPos = 0;
                        yOffset = 0;
                        stride = samplingFactor[0] * samplingFactor[1];
                        counter = 1;
                        for (i = 0; i < expandedImageHeight; ++i) {
                            j = 0;
                            while (j < expandedImageWidth) {
                                Y = buf[0][yPos] & 255;
                                Cb = buf[1][CbPos] & 255;
                                Cr = buf[2][CrPos] & 255;
                                if (counter % stride == 0) {
                                    ++CbPos;
                                    ++CrPos;
                                }
                                fY = ((float)Y - referenceBlackY) * codingRangeY / (referenceWhiteY - referenceBlackY);
                                fCb = ((float)Cb - referenceBlackCb) * codingRangeCbCr / (referenceWhiteCb - referenceBlackCb);
                                fCr = ((float)Cr - referenceBlackCr) * codingRangeCbCr / (referenceWhiteCr - referenceBlackCr);
                                R = fCr * (2.0f - 2.0f * lumaRed) + fY;
                                B = fCb * (2.0f - 2.0f * lumaBlue) + fY;
                                G = (fY - lumaBlue * B - lumaRed * R) / lumaGreen;
                                if (R < 0.0f) {
                                    R = 0.0f;
                                }
                                if (R > 255.0f) {
                                    R = 255.0f;
                                }
                                if (G < 0.0f) {
                                    G = 0.0f;
                                }
                                if (G > 255.0f) {
                                    G = 255.0f;
                                }
                                if (B < 0.0f) {
                                    B = 0.0f;
                                }
                                if (B > 255.0f) {
                                    B = 255.0f;
                                }
                                redPos = 3 * yOffset;
                                pixels[redPos] = (byte)R;
                                pixels[redPos + 1] = (byte)G;
                                pixels[redPos + 2] = (byte)B;
                                ++j;
                                ++yPos;
                                ++yOffset;
                                ++counter;
                            }
                        }
                        break;
                    }
                }
lbl407:
                // 6 sources

                db = new DataBufferByte(pixels, pixels.length);
                bandoff = new int[]{0, 1, 2};
                transparent = false;
                numOfBands = samplesPerPixel;
                trans = 1;
                nBits = new int[]{8, 8, 8};
                raster = Raster.createInterleavedRaster(db, expandedImageWidth, expandedImageHeight, expandedImageWidth * numOfBands, numOfBands, bandoff, null);
                cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 0);
                return new BufferedImage(cm, raster, false, null).getSubimage(0, 0, imageWidth, imageHeight);
            }
            case 4: {
                bytesPerScanLine = samplesPerPixel * ((imageWidth * bitsPerSample + 7) / 8);
                totalBytes2Read = imageHeight * bytesPerScanLine;
                if (planaryConfiguration == 2) {
                    bytesPerScanLine = (imageWidth * bitsPerSample + 7) / 8;
                }
                pixels = new byte[totalBytes2Read];
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[compression.ordinal()]) {
                    case 1: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.randIS.seek(stripOffsets[i]);
                            this.randIS.readFully(pixels, offset, bytes2Read);
                            offset += bytes2Read;
                        }
                        if (fillOrder != 2) break;
                        ArrayUtils.reverseBits(pixels);
                        break;
                    }
                    case 5: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.unpackStrip(pixels, offset, stripBytes[i], stripOffsets[i], stripByteCounts[i]);
                            offset += bytes2Read;
                        }
                        break;
                    }
                    case 2: {
                        decoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        decoder = new DeflateDecoder();
                        break;
                    }
                }
                if (decoder != null) {
                    pixels = new byte[stripOffsets.length * stripBytes[0]];
                    for (i = 0; i < stripByteCounts.length; ++i) {
                        this.randIS.seek(stripOffsets[i]);
                        if (stripByteCounts[i] == 0) {
                            temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            temp = new byte[stripByteCounts[i]];
                            this.randIS.readFully(temp);
                        }
                        if (fillOrder == 2) {
                            ArrayUtils.reverseBits(temp);
                        }
                        decoder.setInput(temp);
                        numOfBytes = decoder.decode(pixels, offset, stripBytes[i]);
                        offset += numOfBytes;
                    }
                }
                if (predictor == 2) {
                    if (planaryConfiguration == 1) {
                        pixels = TIFFReader.applyDePredictor(samplesPerPixel, pixels, imageWidth, imageHeight);
                    } else {
                        dataOffset = 0;
                        for (k = 0; k < samplesPerPixel; ++k) {
                            TIFFReader.applyDePredictor2(pixels, dataOffset, imageWidth, imageHeight);
                            dataOffset += count[k];
                        }
                    }
                }
                cm = null;
                raster = null;
                bandoff = new int[samplesPerPixel];
                nBits = new int[samplesPerPixel];
                numOfBands = samplesPerPixel;
                bankIndices = new int[samplesPerPixel];
                Arrays.fill(nBits, bitsPerSample <= 32 ? bitsPerSample : 32);
                if (planaryConfiguration == 2) {
                    for (i = 0; i < samplesPerPixel; ++i) {
                        bandoff[i] = 0;
                        bankIndices[i] = i;
                    }
                } else {
                    for (i = 0; i < samplesPerPixel; ++i) {
                        bandoff[i] = i;
                        bankIndices[i] = 0;
                    }
                }
                transparent = false;
                trans = 1;
                if (samplesPerPixel == 4) {
                    trans = 3;
                    transparent = true;
                }
                if (planaryConfiguration != 2) ** GOTO lbl568
                rgb = new byte[samplesPerPixel][];
                off = 0;
                dataBufferType = 0;
                for (i = 0; i < samplesPerPixel; ++i) {
                    rgb[i] = ArrayUtils.subArray(pixels, off, count[i]);
                    off += count[i];
                }
                if (floatSample) {
                    if (bitsPerSample == 16 || bitsPerSample == 32) {
                        floats = new float[samplesPerPixel][];
                        if (bitsPerSample == 16) {
                            for (i = 0; i < samplesPerPixel; ++i) {
                                floats[i] = ArrayUtils.to16BitFloatArray(rgb[i], this.endian == 19789);
                            }
                        } else {
                            for (i = 0; i < samplesPerPixel; ++i) {
                                floats[i] = ArrayUtils.toFloatArray(rgb[i], this.endian == 19789);
                            }
                        }
                        dataBufferType = 4;
                        db /* !! */  = new DataBufferFloat(floats, floats[0].length);
                    } else if (bitsPerSample == 64) {
                        doubles = new double[samplesPerPixel][];
                        for (i = 0; i < samplesPerPixel; ++i) {
                            doubles[i] = ArrayUtils.toDoubleArray(rgb[i], this.endian == 19789);
                        }
                        dataBufferType = 5;
                        db /* !! */  = new DataBufferDouble(doubles, doubles[0].length);
                    } else {
                        throw new UnsupportedOperationException("Unsupported floating point sample bit depth: " + bitsPerSample);
                    }
                    cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, dataBufferType);
                    sampleModel = new BandedSampleModel(dataBufferType, imageWidth, imageHeight, imageWidth, bankIndices, bandoff);
                    raster = Raster.createWritableRaster(sampleModel, db /* !! */ , null);
                } else {
                    if (bitsPerSample == 16) {
                        shorts = new short[samplesPerPixel][];
                        for (i = 0; i < samplesPerPixel; ++i) {
                            shorts[i] = ArrayUtils.toShortArray(rgb[i], this.endian == 19789);
                        }
                        db /* !! */  = new DataBufferUShort(shorts, shorts[0].length);
                        dataBufferType = 1;
                    } else if (bitsPerSample > 8 && bitsPerSample < 16) {
                        shorts = new short[samplesPerPixel][];
                        for (i = 0; i < samplesPerPixel; ++i) {
                            shorts[i] = (short[])ArrayUtils.toNBits(bitsPerSample, rgb[i], imageWidth, true);
                        }
                        db /* !! */  = new DataBufferUShort(shorts, shorts[0].length);
                        dataBufferType = 1;
                    } else if (bitsPerSample > 16) {
                        ints = new int[samplesPerPixel][];
                        bigEndian = false;
                        if (bitsPerSample % 8 == 0) {
                            bigEndian = true;
                        }
                        for (i = 0; i < samplesPerPixel; ++i) {
                            ints[i] = (int[])ArrayUtils.toNBits(bitsPerSample, rgb[i], samplesPerPixel * imageWidth, bigEndian);
                        }
                        db /* !! */  = new DataBufferInt(ints, ints[0].length);
                        dataBufferType = 3;
                    } else if (bitsPerSample < 8) {
                        bytes = new byte[samplesPerPixel][];
                        for (i = 0; i < samplesPerPixel; ++i) {
                            bytes[i] = (byte[])ArrayUtils.toNBits(bitsPerSample, rgb[i], imageWidth, true);
                        }
                        db /* !! */  = new DataBufferByte(bytes, bytes[0].length);
                        dataBufferType = 0;
                    } else {
                        db /* !! */  = new DataBufferByte(rgb, rgb[0].length);
                        dataBufferType = 0;
                    }
                    cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, dataBufferType);
                    raster = Raster.createBandedRaster(db /* !! */ , imageWidth, imageHeight, imageWidth, bankIndices, bandoff, null);
                }
                ** GOTO lbl602
lbl568:
                // 1 sources

                if (!floatSample) ** GOTO lbl587
                if (bitsPerSample < 16 || bitsPerSample > 32) ** GOTO lbl579
                if (bitsPerSample % 8 == 0) {
                    tempArray = null;
                    tempArray = bitsPerSample == 16 ? ArrayUtils.to16BitFloatArray(pixels, this.endian == 19789) : (bitsPerSample == 24 ? ArrayUtils.to24BitFloatArray(pixels, this.endian == 19789) : ArrayUtils.toFloatArray(pixels, this.endian == 19789));
                    cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 4);
                    db = new DataBufferFloat(tempArray, tempArray.length);
                    sampleModel = new PixelInterleavedSampleModel(4, imageWidth, imageHeight, samplesPerPixel, imageWidth * samplesPerPixel, bandoff);
                    raster = Raster.createWritableRaster(sampleModel, db, null);
                } else {
                    throw new UnsupportedOperationException("Unsupported bit depth: " + bitsPerSample);
lbl579:
                    // 1 sources

                    if (bitsPerSample == 64) {
                        tempArray = ArrayUtils.toDoubleArray(pixels, this.endian == 19789);
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 5);
                        db = new DataBufferDouble(tempArray, tempArray.length);
                        sampleModel = new PixelInterleavedSampleModel(5, imageWidth, imageHeight, samplesPerPixel, imageWidth * samplesPerPixel, bandoff);
                        raster = Raster.createWritableRaster(sampleModel, db, null);
                    } else {
                        throw new UnsupportedOperationException("Unsupported bit depth: " + bitsPerSample);
lbl587:
                        // 1 sources

                        if (bitsPerSample < 8) {
                            tempArray = ArrayUtils.toNBits(bitsPerSample * samplesPerPixel, pixels, imageWidth, true);
                            cm = new DirectColorModel(bitsPerSample * samplesPerPixel, TIFFReader.redMask[bitsPerSample], TIFFReader.greenMask[bitsPerSample], TIFFReader.blueMask[bitsPerSample]);
                            raster = cm.createCompatibleWritableRaster(imageWidth, imageHeight);
                            raster.setDataElements(0, 0, imageWidth, imageHeight, tempArray);
                        } else if (bitsPerSample == 8) {
                            cm = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 0);
                            db = new DataBufferByte(pixels, pixels.length);
                            raster = Raster.createInterleavedRaster(db, imageWidth, imageHeight, imageWidth * numOfBands, numOfBands, bandoff, null);
                        } else {
                            tempArray = ArrayUtils.toNBits(bitsPerSample, pixels, samplesPerPixel * imageWidth, bitsPerSample % 8 == 0 ? this.endian == 19789 : true);
                            cm = bitsPerSample <= 16 ? new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 1) : (bitsPerSample == 32 ? new Int32ComponentColorModel(ColorSpace.getInstance(1000), transparent) : new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 3));
                            raster = cm.createCompatibleWritableRaster(imageWidth, imageHeight);
                            raster.setDataElements(0, 0, imageWidth, imageHeight, tempArray);
                        }
                    }
                }
lbl602:
                // 7 sources

                return new BufferedImage(cm, raster, false, null);
            }
            case 5: 
            case 6: {
                bytesPerScanLine = samplesPerPixel * ((imageWidth * bitsPerSample + 7) / 8);
                totalBytes2Read = imageHeight * bytesPerScanLine;
                if (planaryConfiguration == 2) {
                    bytesPerScanLine = (imageWidth * bitsPerSample + 7) / 8;
                }
                pixels = new byte[totalBytes2Read];
                switch (bitsPerSample) {
                    case 1: {
                        this.rgbColorPalette = e_photoMetric == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.BLACK_WHITE_PALETTE : TIFFReader.BLACK_WHITE_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 2: {
                        this.rgbColorPalette = e_photoMetric == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.FOUR_COLOR_PALETTE : TIFFReader.FOUR_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 4: {
                        this.rgbColorPalette = e_photoMetric == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.SIXTEEN_COLOR_PALETTE : TIFFReader.SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                    case 8: {
                        this.rgbColorPalette = e_photoMetric == TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO ? TIFFReader.EIGHT_BIT_COLOR_PALETTE : TIFFReader.EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO;
                        break;
                    }
                }
                switch (1.$SwitchMap$com$icafe4j$image$tiff$TiffFieldEnum$Compression[compression.ordinal()]) {
                    case 1: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.randIS.seek(stripOffsets[i]);
                            this.randIS.readFully(pixels, offset, bytes2Read);
                            offset += bytes2Read;
                        }
                        if (fillOrder != 2) break;
                        ArrayUtils.reverseBits(pixels);
                        break;
                    }
                    case 6: {
                        decoder = new G31DDecoder(imageWidth, rowsPerStrip);
                        break;
                    }
                    case 7: {
                        f_t4Options = ifd.getField(TiffTag.T4_OPTIONS);
                        t4Options = 0;
                        if (f_t4Options != null) {
                            t4Options = f_t4Options.getDataAsLong()[0];
                        }
                        if ((t4Options & TIFFReader.GROUP3OPT_UNCOMPRESSED) == TIFFReader.GROUP3OPT_UNCOMPRESSED) {
                            throw new UnsupportedCompressionException("Group 3 Uncompressed mode is not supported");
                        }
                        if ((t4Options & TIFFReader.GROUP3OPT_2DENCODING) == TIFFReader.GROUP3OPT_2DENCODING) {
                            decoder = new G32DDecoder(imageWidth, rowsPerStrip);
                            break;
                        }
                        decoder = new G32DDecoder(imageWidth, rowsPerStrip, true);
                        break;
                    }
                    case 2: {
                        decoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case 3: 
                    case 4: {
                        decoder = new DeflateDecoder();
                        break;
                    }
                    case 5: {
                        for (i = 0; i < stripByteCounts.length; ++i) {
                            bytes2Read = stripBytes[i];
                            this.unpackStrip(pixels, offset, stripBytes[i], stripOffsets[i], stripByteCounts[i]);
                            offset += bytes2Read;
                        }
                        break;
                    }
                }
                if (decoder != null) {
                    for (i = 0; i < stripByteCounts.length; ++i) {
                        this.randIS.seek(stripOffsets[i]);
                        if (stripByteCounts[i] == 0) {
                            temp = IOUtils.readFully((InputStream)this.randIS, 4096);
                        } else {
                            temp = new byte[stripByteCounts[i]];
                            this.randIS.readFully(temp);
                        }
                        if (fillOrder == 2) {
                            ArrayUtils.reverseBits(temp);
                        }
                        decoder.setInput(temp);
                        numOfBytes = decoder.decode(pixels, offset, stripBytes[i]);
                        offset += numOfBytes;
                    }
                }
                if (bitsPerSample <= 8) {
                    if (predictor == 2 && planaryConfiguration == 1) {
                        pixels = TIFFReader.applyDePredictor(samplesPerPixel, pixels, imageWidth, imageHeight);
                    }
                    db = new DataBufferByte(pixels, pixels.length);
                    cm = new IndexColorModel(bitsPerSample, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                    raster = Raster.createPackedRaster(db, imageWidth, imageHeight, bitsPerSample, null);
                    if (samplesPerPixel == 2) {
                        if (e_photoMetric == TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO) {
                            IMGUtils.invertBits(pixels, 2);
                        }
                        numOfBands = samplesPerPixel;
                        bandOffsets = new int[]{0, 0, 0, 1};
                        transparent = true;
                        trans = 3;
                        cm = new ComponentColorModel(ColorSpace.getInstance(1000), transparent, isAssociatedAlpha, trans, 0);
                        raster = Raster.createInterleavedRaster(db, imageWidth, imageHeight, imageWidth * numOfBands, numOfBands, bandOffsets, null);
                    }
                } else if (bitsPerSample <= 16) {
                    tempArray = (short[])ArrayUtils.toNBits(bitsPerSample, pixels, samplesPerPixel * imageWidth, bitsPerSample % 8 == 0 ? this.endian == 19789 : true);
                    if (predictor == 2 && planaryConfiguration == 1) {
                        tempArray = TIFFReader.applyDePredictor(samplesPerPixel, tempArray, imageWidth, imageHeight);
                    }
                    if (e_photoMetric == TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO) {
                        IMGUtils.invertBits(tempArray, samplesPerPixel);
                    }
                    if (samplesPerPixel == 2) {
                        transparent = true;
                        trans = 3;
                    }
                    cm = new ComponentColorModel(ColorSpace.getInstance(1003), transparent, isAssociatedAlpha, trans, 1);
                    raster = cm.createCompatibleWritableRaster(imageWidth, imageHeight);
                    raster.setDataElements(0, 0, imageWidth, imageHeight, tempArray);
                } else if (bitsPerSample == 64) {
                    tempArray = ArrayUtils.toDoubleArray(pixels, this.endian == 19789);
                    cm = new ComponentColorModel(ColorSpace.getInstance(1000), null, transparent, isAssociatedAlpha, trans, 5);
                    db = new DataBufferDouble(tempArray, tempArray.length);
                    sampleModel = new PixelInterleavedSampleModel(5, imageWidth, imageHeight, samplesPerPixel, imageWidth * samplesPerPixel, new int[]{0, 0, 0});
                    raster = Raster.createWritableRaster(sampleModel, db, null);
                } else {
                    throw new UnsupportedOperationException("Unsupported bit depth: " + bitsPerSample);
                }
                return new BufferedImage(cm, raster, false, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedImage decodeTiledTiff(IFD ifd) throws Exception {
        TiffField<?> field = ifd.getField(TiffTag.COMPRESSION);
        short[] data = (short[])field.getData();
        TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.fromValue(data[0] & 0xFFFF);
        LOGGER.info("Compression type: {}", (Object)compression.getDescription());
        TiffField<?> f_tileOffsets = ifd.getField(TiffTag.TILE_OFFSETS);
        if (f_tileOffsets == null) {
            f_tileOffsets = ifd.getField(TiffTag.STRIP_OFFSETS);
        }
        if (f_tileOffsets == null) {
            throw new RuntimeException("Missing required field tileOffsets");
        }
        int[] tileOffsets = f_tileOffsets.getDataAsLong();
        TiffField<?> f_tileByteCounts = ifd.getField(TiffTag.TILE_BYTE_COUNTS);
        if (f_tileByteCounts == null) {
            f_tileByteCounts = ifd.getField(TiffTag.STRIP_BYTE_COUNTS);
        }
        int[] tileByteCounts = null;
        if (f_tileByteCounts == null) {
            if (tileOffsets.length != 1) throw new RuntimeException("Missing required field tileByteCounts");
            tileByteCounts = new int[]{0};
        } else {
            tileByteCounts = f_tileByteCounts.getDataAsLong();
        }
        int imageWidth = ifd.getField(TiffTag.IMAGE_WIDTH).getDataAsLong()[0];
        int imageHeight = ifd.getField(TiffTag.IMAGE_LENGTH).getDataAsLong()[0];
        LOGGER.info("Image width: {}", (Object)imageWidth);
        LOGGER.info("Image height: {}", (Object)imageHeight);
        TiffField<?> f_tileWidth = ifd.getField(TiffTag.TILE_WIDTH);
        TiffField<?> f_tileLength = ifd.getField(TiffTag.TILE_LENGTH);
        int tileWidth = imageWidth;
        if (f_tileWidth != null) {
            tileWidth = f_tileWidth.getDataAsLong()[0];
        }
        int tileLength = imageHeight;
        if (f_tileLength != null) {
            tileLength = f_tileLength.getDataAsLong()[0];
        }
        TiffField<?> f_photoMetric = ifd.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
        int photoMetric = TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue();
        if (f_photoMetric != null) {
            photoMetric = f_photoMetric.getDataAsLong()[0];
        }
        TiffFieldEnum.PhotoMetric e_photoMetric = TiffFieldEnum.PhotoMetric.fromValue(photoMetric);
        LOGGER.info("PhotoMetric: {}", (Object)e_photoMetric);
        TiffField<?> f_bitsPerSample = ifd.getField(TiffTag.BITS_PER_SAMPLE);
        int bitsPerSample = 1;
        if (f_bitsPerSample != null) {
            bitsPerSample = f_bitsPerSample.getDataAsLong()[0];
        }
        LOGGER.info("Bits per sample: {}", (Object)bitsPerSample);
        TiffField<?> f_samplesPerPixel = ifd.getField(TiffTag.SAMPLES_PER_PIXEL);
        int samplesPerPixel = 1;
        if (f_samplesPerPixel != null) {
            samplesPerPixel = f_samplesPerPixel.getDataAsLong()[0];
        }
        LOGGER.info("Samples per pixel: {}", (Object)samplesPerPixel);
        TiffField<?> f_predictor = ifd.getField(TiffTag.PREDICTOR);
        int predictor = 0;
        if (f_predictor != null) {
            predictor = f_predictor.getDataAsLong()[0];
            LOGGER.info("Predictor: {}", (Object)predictor);
        }
        TiffField<?> f_planaryConfiguration = ifd.getField(TiffTag.PLANAR_CONFIGURATTION);
        int planaryConfiguration = 1;
        if (f_planaryConfiguration != null) {
            planaryConfiguration = f_planaryConfiguration.getDataAsLong()[0];
        }
        TiffFieldEnum.PlanarConfiguration e_planaryConfiguration = TiffFieldEnum.PlanarConfiguration.fromValue(planaryConfiguration);
        LOGGER.info("Planary configuration: {}", (Object)e_planaryConfiguration);
        TiffField<?> f_sampleFormat = ifd.getField(TiffTag.SAMPLE_FORMAT);
        TiffField<?> f_sampleMaxValue = ifd.getField(TiffTag.S_MAX_SAMPLE_VALUE);
        TiffField<?> f_sampleMinValue = ifd.getField(TiffTag.S_MIN_SAMPLE_VALUE);
        boolean floatSample = false;
        boolean isAssociatedAlpha = false;
        if (f_sampleFormat != null && f_sampleFormat.getDataAsLong()[0] == 3) {
            double minValue;
            floatSample = true;
            double maxValue = bitsPerSample <= 32 ? 3.4028234663852886E38 : Double.MAX_VALUE;
            double d = minValue = bitsPerSample <= 32 ? (double)1.4E-45f : Double.MIN_VALUE;
            if (bitsPerSample <= 32 && f_sampleMaxValue != null) {
                maxValue = ((float[])f_sampleMaxValue.getData())[0];
            } else if (bitsPerSample > 32 && f_sampleMaxValue != null) {
                maxValue = ((double[])f_sampleMaxValue.getData())[0];
            }
            if (bitsPerSample <= 32 && f_sampleMinValue != null) {
                minValue = ((float[])f_sampleMinValue.getData())[0];
            } else if (bitsPerSample > 32 && f_sampleMinValue != null) {
                minValue = ((double[])f_sampleMinValue.getData())[0];
            }
            LOGGER.info("Sample MAX value: {}", (Object)maxValue);
            LOGGER.info("Sample MIN vlaue: {}", (Object)minValue);
        }
        int tilesAcross = (imageWidth + tileWidth - 1) / tileWidth;
        int tilesDown = (imageHeight + tileLength - 1) / tileLength;
        int tilesPerImage = tilesAcross * tilesDown;
        ImageDecoder decoder = null;
        byte[] pixels = null;
        int bytes2Read = (tileWidth * bitsPerSample + 7) / 8 * samplesPerPixel * tileLength;
        int xoff = 0;
        int yoff = 0;
        int tileCounter = 0;
        WritableRaster raster = null;
        Object var42_44 = null;
        Object var43_48 = null;
        switch (e_photoMetric) {
            case PALETTE_COLOR: {
                void var43_51;
                byte[] temp;
                short[] colorMap = (short[])ifd.getField(TiffTag.COLORMAP).getData();
                this.rgbColorPalette = new int[colorMap.length / 3];
                int numOfColors = 1 << bitsPerSample;
                int numOfColors2 = numOfColors << 1;
                int index = 0;
                for (int i = 0; i < colorMap.length / 3; ++i) {
                    this.rgbColorPalette[index++] = 0xFF000000 | (colorMap[i] & 0xFF00) << 8 | colorMap[i + numOfColors] & 0xFF00 | (colorMap[i + numOfColors2] & 0xFF00) >> 8;
                }
                int bytesPerScanLine = tilesAcross * (tileWidth * bitsPerSample + 7) / 8;
                pixels = new byte[bytesPerScanLine * tilesDown * tileLength];
                short[] spixels = null;
                DataBufferByte dataBufferByte = new DataBufferByte(pixels, pixels.length);
                IndexColorModel indexColorModel = new IndexColorModel(bitsPerSample, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 0);
                if (bitsPerSample < 8) {
                    raster = Raster.createPackedRaster(dataBufferByte, tileWidth * tilesAcross, tileLength * tilesDown, bitsPerSample, null);
                } else {
                    void var42_47;
                    int[] off = new int[]{0};
                    if (bitsPerSample > 8) {
                        spixels = new short[pixels.length / 2];
                        DataBufferUShort dataBufferUShort = new DataBufferUShort(spixels, spixels.length);
                        IndexColorModel indexColorModel2 = new IndexColorModel(bitsPerSample, this.rgbColorPalette.length, this.rgbColorPalette, 0, false, -1, 1);
                    }
                    raster = Raster.createInterleavedRaster((DataBuffer)var42_47, tileWidth * tilesAcross, tileLength * tilesDown, tileWidth * tilesAcross, 1, off, null);
                }
                switch (compression) {
                    case NONE: {
                        for (int i = 0; i < tileByteCounts.length; ++i) {
                            temp = new byte[tileByteCounts[i]];
                            this.randIS.seek(tileOffsets[i]);
                            this.randIS.readFully(temp);
                            if (bitsPerSample == 16) {
                                raster.setDataElements(xoff, yoff, tileWidth, tileLength, ArrayUtils.toShortArray(temp, this.endian == 19789));
                            } else {
                                DataBufferByte tileDataBuffer = new DataBufferByte(temp, temp.length);
                                WritableRaster tileRaster = Raster.createPackedRaster(tileDataBuffer, tileWidth, tileLength, bitsPerSample, null);
                                raster.setDataElements(xoff, yoff, tileRaster);
                            }
                            xoff += tileWidth;
                            if (++tileCounter < tilesAcross) continue;
                            xoff = 0;
                            yoff += tileLength;
                            tileCounter = 0;
                        }
                        break;
                    }
                    case LZW: {
                        decoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case DEFLATE: 
                    case DEFLATE_ADOBE: {
                        decoder = new DeflateDecoder();
                        break;
                    }
                }
                if (decoder == null) return new BufferedImage((ColorModel)var43_51, raster, false, null).getSubimage(0, 0, imageWidth, imageHeight);
                for (int i = 0; i < tileByteCounts.length; ++i) {
                    temp = new byte[tileByteCounts[i]];
                    byte[] temp2 = new byte[bytes2Read];
                    this.randIS.seek(tileOffsets[i]);
                    this.randIS.readFully(temp);
                    decoder.setInput(temp);
                    decoder.decode(temp2, 0, bytes2Read);
                    if (bitsPerSample == 16) {
                        raster.setDataElements(xoff, yoff, tileWidth, tileLength, ArrayUtils.toShortArray(temp2, this.endian == 19789));
                    } else {
                        raster.setDataElements(xoff, yoff, tileWidth, tileLength, temp2);
                    }
                    xoff += tileWidth;
                    if (++tileCounter < tilesAcross) continue;
                    xoff = 0;
                    yoff += tileLength;
                    tileCounter = 0;
                }
                return new BufferedImage((ColorModel)var43_51, raster, false, null).getSubimage(0, 0, imageWidth, imageHeight);
            }
            case RGB: {
                byte[] temp;
                int i;
                void var43_60;
                int[] bandoff = new int[samplesPerPixel];
                int[] nBits = new int[samplesPerPixel];
                Arrays.fill(nBits, bitsPerSample);
                for (int i2 = 0; i2 < samplesPerPixel; ++i2) {
                    bandoff[i2] = i2;
                }
                boolean transparent = false;
                int trans = 1;
                if (samplesPerPixel >= 4) {
                    trans = 3;
                    transparent = true;
                }
                if (floatSample) {
                    if (bitsPerSample == 64) {
                        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, false, trans, 5);
                    } else if (bitsPerSample >= 16 && bitsPerSample <= 32) {
                        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, false, trans, 4);
                    }
                } else if (bitsPerSample < 8) {
                    DirectColorModel directColorModel = new DirectColorModel(bitsPerSample * samplesPerPixel, redMask[bitsPerSample], greenMask[bitsPerSample], blueMask[bitsPerSample]);
                } else if (bitsPerSample == 16) {
                    ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 1);
                } else if (bitsPerSample == 24) {
                    ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 3);
                } else if (bitsPerSample == 32) {
                    Int32ComponentColorModel int32ComponentColorModel = new Int32ComponentColorModel(ColorSpace.getInstance(1000), transparent);
                } else if (bitsPerSample == 64) {
                    Int32ComponentColorModel int32ComponentColorModel = new Int32ComponentColorModel(ColorSpace.getInstance(1000), transparent);
                } else {
                    ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nBits, transparent, isAssociatedAlpha, trans, 0);
                }
                raster = var43_60.createCompatibleWritableRaster(tileWidth * tilesAcross, tileLength * tilesDown);
                switch (compression) {
                    case NONE: {
                        if (planaryConfiguration == 1) {
                            for (i = 0; i < tileByteCounts.length; ++i) {
                                temp = new byte[tileByteCounts[i]];
                                this.randIS.seek(tileOffsets[i]);
                                this.randIS.readFully(temp);
                                if (floatSample) {
                                    void var55_87;
                                    Object var55_82 = null;
                                    if (bitsPerSample == 64) {
                                        double[] dArray = ArrayUtils.toDoubleArray(temp, this.endian == 19789);
                                    } else if (bitsPerSample == 32) {
                                        float[] fArray = ArrayUtils.toFloatArray(temp, this.endian == 19789);
                                    } else if (bitsPerSample == 24) {
                                        float[] fArray = ArrayUtils.to24BitFloatArray(temp, this.endian == 19789);
                                    } else {
                                        if (bitsPerSample != 16) throw new UnsupportedOperationException("Unsupported bit depth: " + bitsPerSample);
                                        float[] fArray = ArrayUtils.to16BitFloatArray(temp, this.endian == 19789);
                                    }
                                    raster.setDataElements(xoff, yoff, tileWidth, tileLength, var55_87);
                                } else if (bitsPerSample < 8) {
                                    raster.setDataElements(xoff, yoff, tileWidth, tileLength, ArrayUtils.toNBits(bitsPerSample * samplesPerPixel, temp, tileWidth, true));
                                } else if (bitsPerSample == 8) {
                                    raster.setDataElements(xoff, yoff, tileWidth, tileLength, temp);
                                } else if (bitsPerSample % 8 == 0) {
                                    Object object = ArrayUtils.toNBits(bitsPerSample, temp, samplesPerPixel * tileWidth, this.endian == 19789);
                                    raster.setDataElements(xoff, yoff, tileWidth, tileLength, object);
                                } else {
                                    Object object = ArrayUtils.toNBits(bitsPerSample, temp, samplesPerPixel * tileWidth, true);
                                    raster.setDataElements(xoff, yoff, tileWidth, tileLength, object);
                                }
                                xoff += tileWidth;
                                if (++tileCounter < tilesAcross) continue;
                                xoff = 0;
                                yoff += tileLength;
                                tileCounter = 0;
                            }
                            break;
                        }
                        byte[][] rgb = new byte[samplesPerPixel][];
                        WritableRaster tileRaster = null;
                        Object var55_90 = null;
                        int[] bankIndices = new int[]{0, 1, 2};
                        bandoff = new int[]{0, 0, 0};
                        int dataBufferType = 0;
                        for (int i3 = 0; i3 < tilesPerImage; ++i3) {
                            rgb[0] = new byte[tileByteCounts[i3]];
                            this.randIS.seek(tileOffsets[i3]);
                            this.randIS.readFully(rgb[0]);
                            int greenOff = i3 + tilesPerImage;
                            rgb[1] = new byte[tileByteCounts[greenOff]];
                            this.randIS.seek(tileOffsets[greenOff]);
                            this.randIS.readFully(rgb[1]);
                            int blueOff = greenOff + tilesPerImage;
                            rgb[2] = new byte[tileByteCounts[blueOff]];
                            this.randIS.seek(tileOffsets[blueOff]);
                            this.randIS.readFully(rgb[2]);
                            if (floatSample) {
                                void var55_94;
                                int j;
                                if (bitsPerSample >= 16 && bitsPerSample <= 32) {
                                    float[][] floats = new float[samplesPerPixel][];
                                    if (bitsPerSample == 16) {
                                        for (j = 0; j < samplesPerPixel; ++j) {
                                            floats[j] = ArrayUtils.to16BitFloatArray(rgb[j], this.endian == 19789);
                                        }
                                    } else if (bitsPerSample == 24) {
                                        for (j = 0; j < samplesPerPixel; ++j) {
                                            floats[j] = ArrayUtils.to24BitFloatArray(rgb[j], this.endian == 19789);
                                        }
                                    } else if (bitsPerSample == 32) {
                                        for (j = 0; j < samplesPerPixel; ++j) {
                                            floats[j] = ArrayUtils.toFloatArray(rgb[j], this.endian == 19789);
                                        }
                                    }
                                    DataBufferFloat dataBufferFloat = new DataBufferFloat(floats, floats[0].length);
                                    dataBufferType = 4;
                                } else {
                                    if (bitsPerSample != 64) throw new UnsupportedOperationException("Unsupported floating point sample bit depth: " + bitsPerSample);
                                    double[][] doubles = new double[samplesPerPixel][];
                                    for (j = 0; j < samplesPerPixel; ++j) {
                                        doubles[j] = ArrayUtils.toDoubleArray(rgb[j], this.endian == 19789);
                                    }
                                    DataBufferDouble dataBufferDouble = new DataBufferDouble(doubles, doubles[0].length);
                                    dataBufferType = 5;
                                }
                                BandedSampleModel sampleModel = new BandedSampleModel(dataBufferType, tileWidth, tileLength, tileWidth, bankIndices, bandoff);
                                tileRaster = Raster.createWritableRaster(sampleModel, (DataBuffer)var55_94, null);
                            } else {
                                void var55_99;
                                if (bitsPerSample == 16) {
                                    DataBufferUShort dataBufferUShort = new DataBufferUShort(new short[][]{ArrayUtils.toShortArray(rgb[0], this.endian == 19789), ArrayUtils.toShortArray(rgb[1], this.endian == 19789), ArrayUtils.toShortArray(rgb[2], this.endian == 19789)}, tileWidth * tileLength);
                                } else if (bitsPerSample > 16 && bitsPerSample <= 32) {
                                    boolean bigEndian = bitsPerSample % 8 == 0 ? this.endian == 19789 : true;
                                    DataBufferInt dataBufferInt = new DataBufferInt(new int[][]{(int[])ArrayUtils.toNBits(bitsPerSample, rgb[0], tileWidth, bigEndian), (int[])ArrayUtils.toNBits(bitsPerSample, rgb[1], tileWidth, bigEndian), (int[])ArrayUtils.toNBits(bitsPerSample, rgb[2], tileWidth, bigEndian)}, tileWidth * tileLength);
                                } else if (bitsPerSample == 64) {
                                    DataBufferInt dataBufferInt = new DataBufferInt(new int[][]{ArrayUtils.to32BitsLongArray(rgb[0], this.endian == 19789), ArrayUtils.to32BitsLongArray(rgb[1], this.endian == 19789), ArrayUtils.to32BitsLongArray(rgb[2], this.endian == 19789)}, tileWidth * tileLength);
                                } else {
                                    DataBufferByte dataBufferByte = new DataBufferByte(rgb, rgb[0].length);
                                }
                                tileRaster = Raster.createBandedRaster((DataBuffer)var55_99, tileWidth, tileLength, tileWidth, bankIndices, bandoff, null);
                            }
                            raster.setRect(xoff, yoff, tileRaster);
                            xoff += tileWidth;
                            if (++tileCounter < tilesAcross) continue;
                            xoff = 0;
                            yoff += tileLength;
                            tileCounter = 0;
                        }
                        break;
                    }
                    case PACKBITS: {
                        for (int i4 = 0; i4 < tileByteCounts.length; ++i4) {
                            temp = new byte[tileByteCounts[i4]];
                            this.randIS.seek(tileOffsets[i4]);
                            this.randIS.readFully(temp);
                            byte[] byArray = new byte[bytes2Read];
                            Packbits.unpackbits(temp, byArray);
                            if (bitsPerSample == 16) {
                                raster.setDataElements(xoff, yoff, tileWidth, tileLength, ArrayUtils.toShortArray(byArray, this.endian == 19789));
                            } else {
                                raster.setDataElements(xoff, yoff, tileWidth, tileLength, byArray);
                            }
                            xoff += tileWidth;
                            if (++tileCounter < tilesAcross) continue;
                            xoff = 0;
                            yoff += tileLength;
                            tileCounter = 0;
                        }
                        break;
                    }
                    case LZW: {
                        decoder = new LZWTreeDecoder(8, true);
                        break;
                    }
                    case DEFLATE: 
                    case DEFLATE_ADOBE: {
                        decoder = new DeflateDecoder();
                        break;
                    }
                }
                if (decoder != null) {
                    for (i = 0; i < tileByteCounts.length; ++i) {
                        temp = new byte[tileByteCounts[i]];
                        byte[] byArray = new byte[bytes2Read];
                        this.randIS.seek(tileOffsets[i]);
                        this.randIS.readFully(temp);
                        decoder.setInput(temp);
                        decoder.decode(byArray, 0, bytes2Read);
                        if (bitsPerSample == 16) {
                            raster.setDataElements(xoff, yoff, tileWidth, tileLength, ArrayUtils.toShortArray(byArray, this.endian == 19789));
                        } else {
                            raster.setDataElements(xoff, yoff, tileWidth, tileLength, byArray);
                        }
                        xoff += tileWidth;
                        if (++tileCounter < tilesAcross) continue;
                        xoff = 0;
                        yoff += tileLength;
                        tileCounter = 0;
                    }
                }
                if (predictor != 2 || planaryConfiguration != 1 || this.bitsPerPixel != 8) return new BufferedImage((ColorModel)var43_60, raster, false, null).getSubimage(0, 0, imageWidth, imageHeight);
                pixels = TIFFReader.applyDePredictor(samplesPerPixel, pixels, imageWidth, imageHeight);
                return new BufferedImage((ColorModel)var43_60, raster, false, null).getSubimage(0, 0, imageWidth, imageHeight);
            }
        }
        return null;
    }

    @Override
    public int getFrameCount() {
        if (this.frames != null) {
            return this.frames.size();
        }
        return super.getFrameCount();
    }

    @Override
    public BufferedImage getFrame(int i) {
        if (this.frames == null) {
            return null;
        }
        if (i >= 0 && i < this.frames.size()) {
            return this.frames.get(i);
        }
        throw new IllegalArgumentException("Frame index " + i + " out of bounds");
    }

    @Override
    public List<BufferedImage> getFrames() {
        if (this.frames != null) {
            return Collections.unmodifiableList(this.frames);
        }
        return Collections.emptyList();
    }

    @Override
    public BufferedImage read(InputStream is) throws Exception {
        if (!this.readIFDs(is)) {
            return null;
        }
        this.frames = new ArrayList<BufferedImage>();
        BufferedImage frame = null;
        for (IFD page : this.ifds) {
            try {
                frame = this.decode(page);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            if (frame == null) continue;
            this.frames.add(frame);
        }
        this.randIS.shallowClose();
        if (this.frames.size() > 0) {
            return this.frames.get(0);
        }
        return null;
    }

    private boolean readHeader(RandomAccessInputStream randIS) throws IOException {
        this.endian = randIS.readShort();
        if (this.endian == 19789) {
            LOGGER.info("Byte order: Motorola BIG_ENDIAN");
            this.randIS.setReadStrategy(ReadStrategyMM.getInstance());
        } else if (this.endian == 18761) {
            LOGGER.info("Byte order: Intel LITTLE_ENDIAN");
            this.randIS.setReadStrategy(ReadStrategyII.getInstance());
        } else {
            LOGGER.info("Warning: invalid TIFF byte order!");
            return false;
        }
        short tiff_id = randIS.readShort();
        if (tiff_id != 42) {
            LOGGER.error("Error: invalid tiff identifier");
            return false;
        }
        return true;
    }

    private int readIFD(int id, int offset) throws IOException {
        IFD tiffIFD = new IFD();
        LOGGER.info("IFD {} offset: byte {}", (Object)id, (Object)offset);
        this.randIS.seek(offset);
        int no_of_fields = this.randIS.readShort();
        LOGGER.info("Total number of fields for IFD {}: {}", (Object)id, (Object)no_of_fields);
        offset += 2;
        block9: for (int i = 0; i < no_of_fields; ++i) {
            LOGGER.info("TiffField {} =>", (Object)i);
            this.randIS.seek(offset);
            short tag = this.randIS.readShort();
            Tag ftag = TiffTag.fromShort(tag);
            if (ftag == TiffTag.UNKNOWN) {
                LOGGER.info("TiffTag: {} [Value: 0x{}] (Unknown)", (Object)ftag, (Object)Integer.toHexString(tag & 0xFFFF));
            } else {
                LOGGER.info("TiffTag: {}", (Object)ftag);
            }
            this.randIS.seek(offset += 2);
            short type = this.randIS.readShort();
            FieldType ftype = FieldType.fromShort(type);
            LOGGER.info("Data type: {}", (Object)ftype);
            this.randIS.seek(offset += 2);
            int field_length = this.randIS.readInt();
            LOGGER.info("TiffField length: {}", (Object)field_length);
            offset += 4;
            switch (ftype) {
                case BYTE: 
                case UNDEFINED: {
                    byte[] data = new byte[field_length];
                    if (field_length <= 4) {
                        this.randIS.seek(offset);
                        this.randIS.readFully(data, 0, field_length);
                    } else {
                        this.randIS.seek(offset);
                        this.randIS.seek(this.randIS.readInt());
                        this.randIS.readFully(data, 0, field_length);
                    }
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.byteArrayToHexString(data, 0, 10));
                    offset += 4;
                    tiffIFD.addField(ftype == FieldType.BYTE ? new ByteField(tag, data) : new UndefinedField(tag, data));
                    continue block9;
                }
                case ASCII: {
                    byte[] data = new byte[field_length];
                    if (field_length <= 4) {
                        this.randIS.seek(offset);
                        this.randIS.readFully(data, 0, field_length);
                    } else {
                        this.randIS.seek(offset);
                        this.randIS.seek(this.randIS.readInt());
                        this.randIS.readFully(data, 0, field_length);
                    }
                    if (data.length > 0) {
                        LOGGER.info("TiffField value: {}", (Object)new String(data, 0, data.length - 1).trim());
                    }
                    offset += 4;
                    tiffIFD.addField(new ASCIIField(tag, new String(data, 0, data.length)));
                    continue block9;
                }
                case SHORT: {
                    short[] sdata = new short[field_length];
                    if (field_length == 1) {
                        this.randIS.seek(offset);
                        sdata[0] = this.randIS.readShort();
                        offset += 4;
                    } else if (field_length == 2) {
                        this.randIS.seek(offset);
                        sdata[0] = this.randIS.readShort();
                        this.randIS.seek(offset += 2);
                        sdata[1] = this.randIS.readShort();
                        offset += 2;
                    } else {
                        this.randIS.seek(offset);
                        int toOffset = this.randIS.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            this.randIS.seek(toOffset);
                            sdata[j] = this.randIS.readShort();
                            toOffset += 2;
                        }
                    }
                    tiffIFD.addField(new ShortField(tag, sdata));
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.shortArrayToString(sdata, 0, 10, true));
                    continue block9;
                }
                case LONG: {
                    int[] ldata = new int[field_length];
                    if (field_length == 1) {
                        this.randIS.seek(offset);
                        ldata[0] = this.randIS.readInt();
                        offset += 4;
                    } else {
                        this.randIS.seek(offset);
                        int toOffset = this.randIS.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            this.randIS.seek(toOffset);
                            ldata[j] = this.randIS.readInt();
                            toOffset += 4;
                        }
                    }
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.longArrayToString(ldata, 0, 10, true));
                    tiffIFD.addField(new LongField(tag, ldata));
                    continue block9;
                }
                case RATIONAL: {
                    int len = 2 * field_length;
                    int[] ldata = new int[len];
                    this.randIS.seek(offset);
                    int toOffset = this.randIS.readInt();
                    offset += 4;
                    for (int j = 0; j < len; j += 2) {
                        this.randIS.seek(toOffset);
                        ldata[j] = this.randIS.readInt();
                        this.randIS.seek(toOffset += 4);
                        ldata[j + 1] = this.randIS.readInt();
                        toOffset += 4;
                    }
                    tiffIFD.addField(new RationalField(tag, ldata));
                    LOGGER.info("TiffField value: {}", (Object)StringUtils.rationalArrayToString(ldata, true));
                    continue block9;
                }
                case FLOAT: {
                    int toOffset;
                    float[] fdata = new float[field_length];
                    if (field_length == 1) {
                        this.randIS.seek(offset);
                        fdata[0] = this.randIS.readFloat();
                        offset += 4;
                    } else {
                        this.randIS.seek(offset);
                        toOffset = this.randIS.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            this.randIS.seek(toOffset);
                            fdata[j] = this.randIS.readFloat();
                            toOffset += 4;
                        }
                    }
                    tiffIFD.addField(new FloatField(tag, fdata));
                    LOGGER.info("TiffField value: {}", (Object)Arrays.toString(fdata));
                    continue block9;
                }
                case DOUBLE: {
                    double[] ddata = new double[field_length];
                    this.randIS.seek(offset);
                    int toOffset = this.randIS.readInt();
                    offset += 4;
                    for (int j = 0; j < field_length; ++j) {
                        this.randIS.seek(toOffset);
                        ddata[j] = this.randIS.readDouble();
                        toOffset += 8;
                    }
                    tiffIFD.addField(new DoubleField(tag, ddata));
                    LOGGER.info("Field value: {}", (Object)Arrays.toString(ddata));
                    continue block9;
                }
                default: {
                    offset += 4;
                }
            }
        }
        this.ifds.add(tiffIFD);
        LOGGER.info("********************************");
        this.randIS.seek(offset);
        return this.randIS.readInt();
    }

    protected boolean readIFDs(InputStream is) throws Exception {
        this.randIS = new FileCacheRandomAccessInputStream(is, 40960);
        if (!this.readHeader(this.randIS)) {
            return false;
        }
        this.ifds = new ArrayList<IFD>();
        int offset = this.randIS.readInt();
        int ifd = 0;
        while (offset != 0) {
            try {
                offset = this.readIFD(ifd++, offset);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break;
            }
        }
        return true;
    }

    private static byte[] applyDePredictor(int numOfSamples, byte[] input, int imageWidth, int imageHeight) {
        int inc = numOfSamples * imageWidth;
        int maxVal = inc - numOfSamples;
        int minVal = numOfSamples;
        for (int i = 0; i <= imageHeight - 1; ++i) {
            for (int j = minVal; j <= maxVal; j += numOfSamples) {
                for (int k = 0; k < numOfSamples; ++k) {
                    int n = j + k;
                    input[n] = (byte)(input[n] + input[j - numOfSamples + k]);
                }
            }
            maxVal += inc;
            minVal += inc;
        }
        return input;
    }

    private static short[] applyDePredictor(int numOfSamples, short[] input, int imageWidth, int imageHeight) {
        int inc = numOfSamples * imageWidth;
        int maxVal = inc - numOfSamples;
        int minVal = numOfSamples;
        for (int i = 0; i <= imageHeight - 1; ++i) {
            for (int j = minVal; j <= maxVal; j += numOfSamples) {
                for (int k = 0; k < numOfSamples; ++k) {
                    int n = j + k;
                    input[n] = (short)(input[n] + input[j - numOfSamples + k]);
                }
            }
            maxVal += inc;
            minVal += inc;
        }
        return input;
    }

    private static byte[] applyDePredictor2(byte[] input, int offset, int imageWidth, int imageHeight) {
        int inc = imageWidth;
        int maxVal = offset + inc - 1;
        int minVal = offset + 1;
        for (int i = imageHeight - 1; i >= 0; --i) {
            for (int j = minVal; j < maxVal; ++j) {
                int n = j;
                input[n] = (byte)(input[n] + input[j - 1]);
            }
            maxVal += inc;
            minVal += inc;
        }
        return input;
    }

    private void unpackStrip(byte[] pixels, int offset, int bytes2Read, int stripOffset, int stripByteCount) throws IOException {
        this.randIS.seek(stripOffset);
        byte[] temp = null;
        if (stripByteCount == 0) {
            temp = IOUtils.readFully((InputStream)this.randIS, 4096);
        } else {
            temp = new byte[stripByteCount];
            this.randIS.readFully(temp);
        }
        byte[] temp2 = new byte[bytes2Read];
        Packbits.unpackbits(temp, temp2);
        System.arraycopy(temp2, 0, pixels, offset, bytes2Read);
    }

    private int upsampling(int offsetY, int numOfDataUnit, int bytesPerUnitY, int[] samplingFactor, float referenceBlackY, float referenceWhiteY, float referenceBlackCb, float referenceWhiteCb, float referenceBlackCr, float referenceWhiteCr, float codingRangeY, float codingRangeCbCr, float lumaRed, float lumaGreen, float lumaBlue, byte[] temp, byte[] pixels, int expandedImageWidth, int dataUnitsPerWidth) {
        int offset = 0;
        int offsetX = 0;
        for (int j = 1; j <= numOfDataUnit; ++j) {
            int offsetCb = offset + bytesPerUnitY;
            int Cb = temp[offsetCb] & 0xFF;
            int Cr = temp[offsetCb + 1] & 0xFF;
            for (int k = 0; k < samplingFactor[1]; ++k) {
                int l = 0;
                while (l < samplingFactor[0]) {
                    int Y = temp[offset++] & 0xFF;
                    float fY = ((float)Y - referenceBlackY) * codingRangeY / (referenceWhiteY - referenceBlackY);
                    float fCb = ((float)Cb - referenceBlackCb) * codingRangeCbCr / (referenceWhiteCb - referenceBlackCb);
                    float fCr = ((float)Cr - referenceBlackCr) * codingRangeCbCr / (referenceWhiteCr - referenceBlackCr);
                    float R = fCr * (2.0f - 2.0f * lumaRed) + fY;
                    float B = fCb * (2.0f - 2.0f * lumaBlue) + fY;
                    float G = (fY - lumaBlue * B - lumaRed * R) / lumaGreen;
                    if (R < 0.0f) {
                        R = 0.0f;
                    }
                    if (R > 255.0f) {
                        R = 255.0f;
                    }
                    if (G < 0.0f) {
                        G = 0.0f;
                    }
                    if (G > 255.0f) {
                        G = 255.0f;
                    }
                    if (B < 0.0f) {
                        B = 0.0f;
                    }
                    if (B > 255.0f) {
                        B = 255.0f;
                    }
                    int yPos = offsetX + offsetY * expandedImageWidth;
                    int redPos = 3 * yPos;
                    pixels[redPos] = (byte)R;
                    pixels[redPos + 1] = (byte)G;
                    pixels[redPos + 2] = (byte)B;
                    ++l;
                    ++offsetX;
                }
                offsetX -= samplingFactor[0];
                ++offsetY;
            }
            offsetY -= samplingFactor[1];
            offset += 2;
            offsetX += samplingFactor[0];
            if (j % dataUnitsPerWidth != 0) continue;
            offsetY += samplingFactor[1];
            offsetX = 0;
        }
        return offsetY;
    }

    static {
        int i;
        redMask = new int[]{0, 4, 48, 448, 3840};
        greenMask = new int[]{0, 2, 12, 56, 240};
        blueMask = new int[]{0, 1, 3, 7, 15};
        BLACK_WHITE_PALETTE = new int[]{-16777216, -1};
        BLACK_WHITE_PALETTE_WHITE_IS_ZERO = new int[]{-1, -16777216};
        FOUR_COLOR_PALETTE = new int[]{-16777216, -12566464, -8355712, -1};
        FOUR_COLOR_PALETTE_WHITE_IS_ZERO = new int[]{-1, -8355712, -12566464, -16777216};
        SIXTEEN_COLOR_PALETTE = new int[]{-16777216, -15658735, -14540254, -13421773, -12303292, -11184811, -10066330, -8947849, -7829368, -6710887, -5592406, -4473925, -3355444, -2236963, -1118482, -1};
        SIXTEEN_COLOR_PALETTE_WHITE_IS_ZERO = new int[]{-1, -1118482, -2236963, -3355444, -4473925, -5592406, -6710887, -7829368, -8947849, -10066330, -11184811, -12303292, -13421773, -14540254, -15658735, -16777216};
        EIGHT_BIT_COLOR_PALETTE = new int[256];
        EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO = new int[256];
        GROUP3OPT_2DENCODING = 1;
        GROUP3OPT_UNCOMPRESSED = 2;
        for (i = 0; i < 256; ++i) {
            TIFFReader.EIGHT_BIT_COLOR_PALETTE[i] = 0xFF000000 | i << 16 | i << 8 | i & 0xFF;
        }
        for (i = 0; i < 256; ++i) {
            TIFFReader.EIGHT_BIT_COLOR_PALETTE_WHITE_IS_ZERO[255 - i] = 0xFF000000 | i << 16 | i << 8 | i & 0xFF;
        }
        LOGGER = LoggerFactory.getLogger(TIFFReader.class);
    }
}

