/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class ASCIIField
extends TiffField<String> {
    public ASCIIField(short tag, String data) {
        super(tag, FieldType.ASCII, ASCIIField.getLength(data));
        this.data = data.trim() + '\u0000';
    }

    private static int getLength(String data) {
        try {
            return data.trim().getBytes("UTF-8").length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to create ASCIIField.");
        }
    }

    @Override
    public String getDataAsString() {
        return ((String)this.data).trim().replace("\u0000", "; ");
    }

    @Override
    protected int writeData(RandomAccessOutputStream os, int toOffset) throws IOException {
        byte[] buf = ((String)this.data).getBytes("UTF-8");
        if (buf.length <= 4) {
            this.dataOffset = (int)os.getStreamPointer();
            byte[] tmp = new byte[4];
            System.arraycopy(buf, 0, tmp, 0, buf.length);
            os.write(tmp);
        } else {
            this.dataOffset = toOffset;
            os.writeInt(toOffset);
            os.seek(toOffset);
            os.write(buf);
            toOffset += buf.length;
        }
        return toOffset;
    }
}

