/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.io.IOException;

public abstract class AbstractShortField
extends TiffField<short[]> {
    public AbstractShortField(short tag, FieldType fieldType, short[] data) {
        super(tag, fieldType, data.length);
        this.data = data;
    }

    @Override
    public short[] getData() {
        return (short[])((short[])this.data).clone();
    }

    @Override
    protected int writeData(RandomAccessOutputStream os, int toOffset) throws IOException {
        if (((short[])this.data).length <= 2) {
            this.dataOffset = (int)os.getStreamPointer();
            short[] tmp = new short[2];
            System.arraycopy(this.data, 0, tmp, 0, ((short[])this.data).length);
            for (short value : tmp) {
                os.writeShort(value);
            }
        } else {
            this.dataOffset = toOffset;
            os.writeInt(toOffset);
            os.seek(toOffset);
            for (short value : (short[])this.data) {
                os.writeShort(value);
            }
            toOffset += ((short[])this.data).length << 1;
        }
        return toOffset;
    }
}

