/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.ASCIIField;
import guilibshadow.cafe4j.image.tiff.ByteField;
import guilibshadow.cafe4j.image.tiff.LongField;
import guilibshadow.cafe4j.image.tiff.RationalField;
import guilibshadow.cafe4j.image.tiff.SByteField;
import guilibshadow.cafe4j.image.tiff.SLongField;
import guilibshadow.cafe4j.image.tiff.SRationalField;
import guilibshadow.cafe4j.image.tiff.SShortField;
import guilibshadow.cafe4j.image.tiff.ShortField;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.UndefinedField;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public enum FieldType {
    BYTE("Byte", 1),
    ASCII("ASCII", 2),
    SHORT("Short", 3),
    LONG("Long", 4),
    RATIONAL("Rational", 5),
    SBYTE("SByte", 6),
    UNDEFINED("Undefined", 7),
    SSHORT("SShort", 8),
    SLONG("SLong", 9),
    SRATIONAL("SRational", 10),
    FLOAT("Float", 11),
    DOUBLE("Double", 12),
    IFD("IFD", 13),
    WINDOWSXP("WindowsXP", 14),
    UNKNOWN("Unknown", 0);

    private static final Map<Short, FieldType> typeMap;
    private final String name;
    private final short value;

    private FieldType(String name, short value) {
        this.name = name;
        this.value = value;
    }

    public static TiffField<?> createField(Tag tag, FieldType type, Object data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        TiffField retValue = null;
        Class<?> typeClass = data.getClass();
        switch (type) {
            case ASCII: {
                if (typeClass != String.class) break;
                retValue = new ASCIIField(tag.getValue(), (String)data);
                break;
            }
            case BYTE: 
            case SBYTE: 
            case UNDEFINED: {
                byte[] byteData;
                if (typeClass != byte[].class || (byteData = (byte[])data).length <= 0) break;
                if (type == BYTE) {
                    retValue = new ByteField(tag.getValue(), byteData);
                    break;
                }
                if (type == SBYTE) {
                    retValue = new SByteField(tag.getValue(), byteData);
                    break;
                }
                retValue = new UndefinedField(tag.getValue(), byteData);
                break;
            }
            case SHORT: 
            case SSHORT: {
                short[] shortData;
                if (typeClass != short[].class || (shortData = (short[])data).length <= 0) break;
                if (type == SHORT) {
                    retValue = new ShortField(tag.getValue(), shortData);
                    break;
                }
                retValue = new SShortField(tag.getValue(), shortData);
                break;
            }
            case LONG: 
            case SLONG: {
                int[] intData;
                if (typeClass != int[].class || (intData = (int[])data).length <= 0) break;
                if (type == LONG) {
                    retValue = new LongField(tag.getValue(), intData);
                    break;
                }
                retValue = new SLongField(tag.getValue(), intData);
                break;
            }
            case RATIONAL: 
            case SRATIONAL: {
                int[] intData;
                if (typeClass != int[].class || (intData = (int[])data).length <= 0 || intData.length % 2 != 0) break;
                if (type == RATIONAL) {
                    retValue = new RationalField(tag.getValue(), intData);
                    break;
                }
                retValue = new SRationalField(tag.getValue(), intData);
                break;
            }
            case WINDOWSXP: {
                if (typeClass != String.class) break;
                try {
                    byte[] xp = (((String)data).trim() + '\u0000').getBytes("UTF-16LE");
                    retValue = new ByteField(tag.getValue(), xp);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        return retValue;
    }

    public String getName() {
        return this.name;
    }

    public short getValue() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public static FieldType fromShort(short value) {
        FieldType fieldType = typeMap.get(value);
        if (fieldType == null) {
            return UNKNOWN;
        }
        return fieldType;
    }

    public static boolean validateData(FieldType type, Object data) {
        if (data == null) {
            throw new IllegalArgumentException("Input data is null");
        }
        boolean retValue = false;
        Class<?> typeClass = data.getClass();
        switch (type) {
            case ASCII: 
            case WINDOWSXP: {
                if (typeClass != String.class) break;
                retValue = true;
                break;
            }
            case BYTE: 
            case SBYTE: 
            case UNDEFINED: {
                byte[] byteData;
                if (typeClass != byte[].class || (byteData = (byte[])data).length <= 0) break;
                retValue = true;
                break;
            }
            case SHORT: 
            case SSHORT: {
                short[] shortData;
                if (typeClass != short[].class || (shortData = (short[])data).length <= 0) break;
                retValue = true;
                break;
            }
            case LONG: 
            case SLONG: {
                int[] intData;
                if (typeClass != int[].class || (intData = (int[])data).length <= 0) break;
                retValue = true;
                break;
            }
            case RATIONAL: 
            case SRATIONAL: {
                int[] intData;
                if (typeClass != int[].class || (intData = (int[])data).length <= 0 || intData.length % 2 != 0) break;
                retValue = true;
                break;
            }
        }
        return retValue;
    }

    static {
        typeMap = new HashMap<Short, FieldType>();
        for (FieldType fieldType : FieldType.values()) {
            typeMap.put(fieldType.getValue(), fieldType);
        }
    }
}

