/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class FloatField
extends TiffField<float[]> {
    public FloatField(short tag, float[] data) {
        super(tag, FieldType.FLOAT, data.length);
        this.data = data;
    }

    @Override
    public float[] getData() {
        return (float[])((float[])this.data).clone();
    }

    @Override
    public String getDataAsString() {
        return Arrays.toString((float[])this.data);
    }

    @Override
    protected int writeData(RandomAccessOutputStream os, int toOffset) throws IOException {
        if (((float[])this.data).length == 1) {
            this.dataOffset = (int)os.getStreamPointer();
            os.writeFloat(((float[])this.data)[0]);
        } else {
            this.dataOffset = toOffset;
            os.writeInt(toOffset);
            os.seek(toOffset);
            for (float value : (float[])this.data) {
                os.writeFloat(value);
            }
            toOffset += ((float[])this.data).length << 2;
        }
        return toOffset;
    }
}

