/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class IFD {
    private Map<Tag, IFD> children = new HashMap<Tag, IFD>();
    private Map<Short, TiffField<?>> tiffFields = new HashMap();
    private int endOffset;
    private int startOffset;

    public IFD() {
    }

    public IFD(IFD other) {
        this.children = Collections.unmodifiableMap(other.children);
        this.tiffFields = Collections.unmodifiableMap(other.tiffFields);
        this.startOffset = other.startOffset;
        this.endOffset = other.endOffset;
    }

    public void addChild(Tag tag, IFD child) {
        this.children.put(tag, child);
    }

    public void addField(TiffField<?> tiffField) {
        this.tiffFields.put(tiffField.getTag(), tiffField);
    }

    public void addFields(Collection<TiffField<?>> tiffFields) {
        for (TiffField<?> field : tiffFields) {
            this.addField(field);
        }
    }

    public IFD getChild(Tag tag) {
        return this.children.get(tag);
    }

    public Map<Tag, IFD> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public TiffField<?> getField(Tag tag) {
        return this.tiffFields.get(tag.getValue());
    }

    public String getFieldAsString(Tag tag) {
        TiffField<?> field = this.tiffFields.get(tag.getValue());
        if (field != null) {
            FieldType ftype = field.getType();
            String tagAsString = null;
            tagAsString = ftype == FieldType.SHORT || ftype == FieldType.SSHORT ? tag.getFieldAsString(field.getDataAsLong()) : tag.getFieldAsString(field.getData());
            if (StringUtils.isNullOrEmpty(tagAsString)) {
                return field.getDataAsString();
            }
            return tagAsString;
        }
        return "";
    }

    public Collection<TiffField<?>> getFields() {
        return Collections.unmodifiableCollection(this.tiffFields.values());
    }

    public int getSize() {
        return this.tiffFields.size();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void removeAllFields() {
        this.tiffFields.clear();
    }

    public IFD removeChild(Tag tag) {
        return this.children.remove(tag);
    }

    public TiffField<?> removeField(Tag tag) {
        return this.tiffFields.remove(tag.getValue());
    }

    public void setNextIFDOffset(RandomAccessOutputStream os, int nextOffset) throws IOException {
        os.seek(this.endOffset - 4);
        os.writeInt(nextOffset);
    }

    public int write(RandomAccessOutputStream os, int offset) throws IOException {
        this.startOffset = offset;
        ArrayList list = new ArrayList(this.tiffFields.values());
        Collections.sort(list);
        os.seek(offset);
        os.writeShort(list.size());
        int toOffset = this.endOffset = (offset += 2) + list.size() * 12 + 4;
        os.seek(offset);
        for (TiffField tiffField : list) {
            toOffset = tiffField.write(os, toOffset);
            os.seek(offset += 12);
        }
        os.seek(offset);
        os.writeInt(0);
        if (this.children.size() > 0) {
            for (Map.Entry entry : this.children.entrySet()) {
                Tag key = (Tag)entry.getKey();
                IFD value = (IFD)entry.getValue();
                TiffField<?> tiffField = this.getField(key);
                if (tiffField == null) continue;
                int dataPos = tiffField.getDataOffset();
                os.seek(dataPos);
                os.writeInt(toOffset);
                os.seek(toOffset);
                toOffset = value.write(os, toOffset);
            }
        }
        return toOffset;
    }
}

