/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.ShortField;
import guilibshadow.cafe4j.image.tiff.TIFFTweaker;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TIFFImage
implements Iterable<IFD>,
Closeable {
    private int numOfPages;
    private int workingPage;
    private List<IFD> ifds = new ArrayList<IFD>();
    private RandomAccessInputStream rin;

    public TIFFImage(RandomAccessInputStream rin) throws IOException {
        this.rin = rin;
        TIFFTweaker.readIFDs(this.ifds, rin);
        this.numOfPages = this.ifds.size();
        this.workingPage = 0;
    }

    public void addField(TiffField<?> field) {
        this.ifds.get(this.workingPage).addField(field);
    }

    public TiffField<?> getField(Tag tag) {
        return this.ifds.get(this.workingPage).getField(tag);
    }

    public List<IFD> getIFDs() {
        return Collections.unmodifiableList(this.ifds);
    }

    public RandomAccessInputStream getInputStream() {
        return this.rin;
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public TiffField<?> removeField(Tag tag) {
        return this.ifds.get(this.workingPage).removeField(tag);
    }

    public IFD removePage(int index) {
        IFD removed = this.ifds.remove(index);
        --this.numOfPages;
        return removed;
    }

    public void setWorkingPage(int workingPage) {
        if (workingPage < 0 || workingPage >= this.numOfPages) {
            throw new IllegalArgumentException("Invalid page number: " + workingPage);
        }
        this.workingPage = workingPage;
    }

    public void write(RandomAccessOutputStream out) throws IOException {
        if (this.numOfPages > 1) {
            for (int i = 0; i < this.ifds.size(); ++i) {
                this.ifds.get(i).removeField(TiffTag.PAGE_NUMBER);
                this.ifds.get(i).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(this.numOfPages - 1)}));
            }
        }
        TIFFTweaker.write(this, out);
    }

    @Override
    public Iterator<IFD> iterator() {
        return this.ifds.iterator();
    }

    @Override
    public void close() throws IOException {
        this.rin.close();
    }
}

