/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.ImageFrame;
import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.compression.CodecException;
import guilibshadow.cafe4j.image.compression.ImageDecoder;
import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.image.compression.deflate.DeflateDecoder;
import guilibshadow.cafe4j.image.compression.deflate.DeflateEncoder;
import guilibshadow.cafe4j.image.compression.lzw.LZWTreeDecoder;
import guilibshadow.cafe4j.image.compression.lzw.LZWTreeEncoder;
import guilibshadow.cafe4j.image.compression.packbits.Packbits;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.meta.Metadata;
import guilibshadow.cafe4j.image.meta.MetadataType;
import guilibshadow.cafe4j.image.meta.Thumbnail;
import guilibshadow.cafe4j.image.meta.adobe.DDB;
import guilibshadow.cafe4j.image.meta.adobe.IRB;
import guilibshadow.cafe4j.image.meta.adobe.IRBThumbnail;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe.ThumbnailResource;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.meta.exif.Exif;
import guilibshadow.cafe4j.image.meta.exif.ExifTag;
import guilibshadow.cafe4j.image.meta.exif.GPSTag;
import guilibshadow.cafe4j.image.meta.exif.InteropTag;
import guilibshadow.cafe4j.image.meta.icc.ICCProfile;
import guilibshadow.cafe4j.image.meta.image.Comments;
import guilibshadow.cafe4j.image.meta.image.ImageMetadata;
import guilibshadow.cafe4j.image.meta.iptc.IPTC;
import guilibshadow.cafe4j.image.meta.iptc.IPTCDataSet;
import guilibshadow.cafe4j.image.meta.iptc.IPTCTag;
import guilibshadow.cafe4j.image.meta.tiff.TiffExif;
import guilibshadow.cafe4j.image.meta.tiff.TiffXMP;
import guilibshadow.cafe4j.image.meta.xmp.XMP;
import guilibshadow.cafe4j.image.options.TIFFOptions;
import guilibshadow.cafe4j.image.tiff.ASCIIField;
import guilibshadow.cafe4j.image.tiff.AbstractRationalField;
import guilibshadow.cafe4j.image.tiff.ByteField;
import guilibshadow.cafe4j.image.tiff.DoubleField;
import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.FloatField;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.IFDField;
import guilibshadow.cafe4j.image.tiff.LongField;
import guilibshadow.cafe4j.image.tiff.PageWritingException;
import guilibshadow.cafe4j.image.tiff.RationalField;
import guilibshadow.cafe4j.image.tiff.SRationalField;
import guilibshadow.cafe4j.image.tiff.ShortField;
import guilibshadow.cafe4j.image.tiff.TIFFImage;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.TiffFieldEnum;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.image.tiff.UndefinedField;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.image.writer.TIFFWriter;
import guilibshadow.cafe4j.io.ByteOrder;
import guilibshadow.cafe4j.io.File2RandomInputStreamAdaptor;
import guilibshadow.cafe4j.io.FileCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.FileCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.MemoryCacheRandomAccessInputStream;
import guilibshadow.cafe4j.io.MemoryCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.cafe4j.io.RandomInputStreamAdaptor;
import guilibshadow.cafe4j.io.ReadStrategy;
import guilibshadow.cafe4j.io.ReadStrategyII;
import guilibshadow.cafe4j.io.ReadStrategyMM;
import guilibshadow.cafe4j.io.Stream2RandomInputStreamAdaptor;
import guilibshadow.cafe4j.io.WriteStrategy;
import guilibshadow.cafe4j.io.WriteStrategyII;
import guilibshadow.cafe4j.io.WriteStrategyMM;
import guilibshadow.cafe4j.string.StringUtils;
import guilibshadow.cafe4j.string.XMLUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class TIFFTweaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TIFFTweaker.class);

    public static void append(RandomAccessInputStream rin, RandomAccessOutputStream rout, BufferedImage ... images) throws IOException {
        TIFFTweaker.append(rin, rout, null, images);
    }

    public static void append(RandomAccessInputStream rin, RandomAccessOutputStream rout, ImageFrame ... frames) throws IOException {
        TIFFTweaker.insertPages(rin, rout, TIFFTweaker.getPageCount(rin), frames);
    }

    public static void append(RandomAccessInputStream rin, RandomAccessOutputStream rout, ImageParam[] imageParam, BufferedImage ... images) throws IOException {
        TIFFTweaker.insertPages(rin, rout, TIFFTweaker.getPageCount(rin), imageParam, images);
    }

    public static void copyCat(RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        ArrayList<IFD> list = new ArrayList<IFD>();
        int offset = TIFFTweaker.copyHeader(rin, rout);
        int writeOffset = 8;
        TIFFTweaker.readIFDs(list, offset, rin);
        offset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    private static int copyHeader(RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        rin.seek(0L);
        short endian = rin.readShort();
        if (endian == 19789) {
            rin.setReadStrategy(ReadStrategyMM.getInstance());
            rout.setWriteStrategy(WriteStrategyMM.getInstance());
        } else if (endian == 18761) {
            rin.setReadStrategy(ReadStrategyII.getInstance());
            rout.setWriteStrategy(WriteStrategyII.getInstance());
        } else {
            rin.close();
            rout.close();
            throw new RuntimeException("Invalid TIFF byte order");
        }
        rout.writeShort(endian);
        rin.seek(2L);
        short tiff_id = rin.readShort();
        if (tiff_id != 42) {
            rin.close();
            rout.close();
            throw new RuntimeException("Invalid TIFF identifier");
        }
        rout.writeShort(tiff_id);
        rin.seek(4L);
        return rin.readInt();
    }

    private static Collection<IPTCDataSet> copyIPTCDataSet(Collection<IPTCDataSet> iptcs, byte[] data) throws IOException {
        IPTC iptc = new IPTC(data);
        HashMap<IPTCTag, List<IPTCDataSet>> dataSetMap = new HashMap<IPTCTag, List<IPTCDataSet>>(iptc.getDataSets());
        for (IPTCDataSet set : iptcs) {
            if (set.allowMultiple()) continue;
            dataSetMap.remove(set.getTagEnum());
        }
        for (List iptcList : dataSetMap.values()) {
            iptcs.addAll(iptcList);
        }
        return iptcs;
    }

    private static TiffField<?> copyJpegHufTable(RandomAccessInputStream rin, RandomAccessOutputStream rout, TiffField<?> field, int curPos) throws IOException {
        int[] data = field.getDataAsLong();
        int[] tmp = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            rin.seek(data[i]);
            tmp[i] = curPos;
            byte[] htable = new byte[16];
            IOUtils.readFully((InputStream)rin, htable);
            IOUtils.write((OutputStream)rout, htable);
            curPos += 16;
            int numCodes = 0;
            for (int j = 0; j < 16; ++j) {
                numCodes += htable[j] & 0xFF;
            }
            curPos += numCodes;
            htable = new byte[numCodes];
            IOUtils.readFully((InputStream)rin, htable);
            IOUtils.write((OutputStream)rout, htable);
        }
        if (TiffTag.fromShort(field.getTag()) == TiffTag.JPEG_AC_TABLES) {
            return new LongField(TiffTag.JPEG_AC_TABLES.getValue(), tmp);
        }
        return new LongField(TiffTag.JPEG_DC_TABLES.getValue(), tmp);
    }

    private static void copyJpegIFByteCount(RandomAccessInputStream rin, RandomAccessOutputStream rout, int offset, int outOffset) throws IOException {
        boolean finished = false;
        int length = 0;
        rin.seek(offset);
        rout.seek(outOffset);
        if (Marker.fromShort(IOUtils.readShortMM(rin)) != Marker.SOI) {
            return;
        }
        IOUtils.writeShortMM(rout, Marker.SOI.getValue());
        short marker = IOUtils.readShortMM(rin);
        block5: while (!finished) {
            if (Marker.fromShort(marker) == Marker.EOI) {
                IOUtils.writeShortMM(rout, marker);
                finished = true;
                continue;
            }
            Marker emarker = Marker.fromShort(marker);
            switch (emarker) {
                case JPG: 
                case JPG0: 
                case JPG13: 
                case TEM: {
                    marker = IOUtils.readShortMM(rin);
                    continue block5;
                }
                case SOS: {
                    marker = TIFFTweaker.copyJpegSOS(rin, rout);
                    continue block5;
                }
                case PADDING: {
                    int nextByte = 0;
                    while ((nextByte = rin.read()) == 255) {
                    }
                    marker = (short)(0xFF00 | nextByte);
                    continue block5;
                }
            }
            length = IOUtils.readUnsignedShortMM(rin);
            byte[] buf = new byte[length - 2];
            rin.read(buf);
            IOUtils.writeShortMM(rout, marker);
            IOUtils.writeShortMM(rout, length);
            rout.write(buf);
            marker = IOUtils.readShortMM(rin);
        }
    }

    private static TiffField<?> copyJpegQTable(RandomAccessInputStream rin, RandomAccessOutputStream rout, TiffField<?> field, int curPos) throws IOException {
        byte[] qtable = new byte[64];
        int[] data = field.getDataAsLong();
        int[] tmp = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            rin.seek(data[i]);
            tmp[i] = curPos;
            IOUtils.readFully((InputStream)rin, qtable);
            IOUtils.write((OutputStream)rout, qtable);
            curPos += 64;
        }
        return new LongField(TiffTag.JPEG_Q_TABLES.getValue(), tmp);
    }

    private static short copyJpegSOS(RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int len = IOUtils.readUnsignedShortMM(rin);
        byte[] buf = new byte[len - 2];
        IOUtils.readFully((InputStream)rin, buf);
        IOUtils.writeShortMM(rout, Marker.SOS.getValue());
        IOUtils.writeShortMM(rout, len);
        rout.write(buf);
        int nextByte = 0;
        short marker = 0;
        block3: while ((nextByte = IOUtils.read(rin)) != -1) {
            rout.write(nextByte);
            if (nextByte != 255) continue;
            nextByte = IOUtils.read(rin);
            rout.write(nextByte);
            if (nextByte == -1) {
                throw new IOException("Premature end of SOS segment!");
            }
            if (nextByte == 0) continue;
            marker = (short)(0xFF00 | nextByte);
            switch (Marker.fromShort(marker)) {
                case RST0: 
                case RST1: 
                case RST2: 
                case RST3: 
                case RST4: 
                case RST5: 
                case RST6: 
                case RST7: {
                    continue block3;
                }
            }
        }
        if (nextByte == -1) {
            throw new IOException("Premature end of SOS segment!");
        }
        return marker;
    }

    private static int copyPageData(IFD ifd, int offset, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TiffField<?> jpegTable;
        TiffField<?> stripByteCounts;
        int writeOffset = offset;
        int writeByteCount = 0;
        rout.seek(writeOffset);
        TiffField<?> stripOffSets = ifd.removeField(TiffTag.STRIP_OFFSETS);
        if (stripOffSets == null) {
            stripOffSets = ifd.removeField(TiffTag.TILE_OFFSETS);
        }
        if ((stripByteCounts = ifd.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
            stripByteCounts = ifd.getField(TiffTag.TILE_BYTE_COUNTS);
        }
        if (stripOffSets != null) {
            int[] counts = stripByteCounts.getDataAsLong();
            int[] off = stripOffSets.getDataAsLong();
            int[] temp = new int[off.length];
            TiffField<?> tiffField = ifd.getField(TiffTag.COMPRESSION);
            if (tiffField == null || tiffField != null && tiffField.getDataAsLong()[0] == 1) {
                int planaryConfiguration = 1;
                tiffField = ifd.getField(TiffTag.PLANAR_CONFIGURATTION);
                if (tiffField != null) {
                    planaryConfiguration = tiffField.getDataAsLong()[0];
                }
                tiffField = ifd.getField(TiffTag.SAMPLES_PER_PIXEL);
                int samplesPerPixel = 1;
                if (tiffField != null) {
                    samplesPerPixel = tiffField.getDataAsLong()[0];
                }
                if (planaryConfiguration == 1 && off.length == 1 || planaryConfiguration == 2 && off.length == samplesPerPixel) {
                    int[] totalBytes2Read = TIFFTweaker.getBytes2Read(ifd);
                    for (int i = 0; i < off.length; ++i) {
                        counts[i] = totalBytes2Read[i];
                    }
                }
            }
            writeByteCount = counts[0];
            rout.seek(writeOffset);
            for (int i = 0; i < off.length; ++i) {
                rin.seek(off[i]);
                byte[] buf = new byte[counts[i]];
                rin.readFully(buf);
                rout.write(buf);
                temp[i] = writeOffset;
                writeOffset += buf.length;
            }
            if (ifd.getField(TiffTag.STRIP_BYTE_COUNTS) != null) {
                ifd.addField(new LongField(TiffTag.STRIP_OFFSETS.getValue(), temp));
            } else {
                ifd.addField(new LongField(TiffTag.TILE_OFFSETS.getValue(), temp));
            }
        }
        String softWare = "ICAFE - https://github.com/dragon66/icafe\u0000";
        ifd.addField(new ASCIIField(TiffTag.SOFTWARE.getValue(), softWare));
        LongField jpegIFOffset = ifd.removeField(TiffTag.JPEG_INTERCHANGE_FORMAT);
        if (jpegIFOffset != null) {
            TiffField<?> jpegIFByteCount = ifd.removeField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH);
            if (((TiffField)jpegIFOffset).getDataAsLong()[0] != stripOffSets.getDataAsLong()[0]) {
                try {
                    if (jpegIFByteCount != null) {
                        rin.seek(((TiffField)jpegIFOffset).getDataAsLong()[0]);
                        byte[] bytes2Read = new byte[jpegIFByteCount.getDataAsLong()[0]];
                        rin.readFully(bytes2Read);
                        rout.seek(writeOffset);
                        rout.write(bytes2Read);
                        ifd.addField(jpegIFByteCount);
                    } else {
                        long startOffset = rout.getStreamPointer();
                        TIFFTweaker.copyJpegIFByteCount(rin, rout, ((TiffField)jpegIFOffset).getDataAsLong()[0], writeOffset);
                        long endOffset = rout.getStreamPointer();
                        ifd.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{(int)(endOffset - startOffset)}));
                    }
                    jpegIFOffset = new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{writeOffset});
                    ifd.addField(jpegIFOffset);
                }
                catch (EOFException eOFException) {}
            } else {
                ifd.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT.getValue(), new int[]{offset}));
                ifd.addField(new LongField(TiffTag.JPEG_INTERCHANGE_FORMAT_LENGTH.getValue(), new int[]{writeByteCount}));
            }
        }
        if ((jpegTable = ifd.removeField(TiffTag.JPEG_DC_TABLES)) != null) {
            try {
                ifd.addField(TIFFTweaker.copyJpegHufTable(rin, rout, jpegTable, (int)rout.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((jpegTable = ifd.removeField(TiffTag.JPEG_AC_TABLES)) != null) {
            try {
                ifd.addField(TIFFTweaker.copyJpegHufTable(rin, rout, jpegTable, (int)rout.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        if ((jpegTable = ifd.removeField(TiffTag.JPEG_Q_TABLES)) != null) {
            try {
                ifd.addField(TIFFTweaker.copyJpegQTable(rin, rout, jpegTable, (int)rout.getStreamPointer()));
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return (int)rout.getStreamPointer();
    }

    private static int copyPages(List<IFD> list, int writeOffset, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        writeOffset = TIFFTweaker.copyPageData(list.get(0), writeOffset, rin, rout);
        writeOffset = list.get(0).write(rout, writeOffset);
        for (int i = 1; i < list.size(); ++i) {
            writeOffset = TIFFTweaker.copyPageData(list.get(i), writeOffset, rin, rout);
            list.get(i - 1).setNextIFDOffset(rout, writeOffset);
            writeOffset = list.get(i).write(rout, writeOffset);
        }
        return writeOffset;
    }

    public static byte[] extractICCProfile(int pageNumber, RandomAccessInputStream rin) throws Exception {
        int offset = TIFFTweaker.readHeader(rin);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        TiffField<?> f_iccProfile = workingPage.getField(TiffTag.ICC_PROFILE);
        if (f_iccProfile != null) {
            return (byte[])f_iccProfile.getData();
        }
        return null;
    }

    public static byte[] extractICCProfile(RandomAccessInputStream rin) throws Exception {
        return TIFFTweaker.extractICCProfile(0, rin);
    }

    public static IRBThumbnail extractThumbnail(int pageNumber, RandomAccessInputStream rin) throws IOException {
        byte[] data;
        IRB irb;
        int offset = TIFFTweaker.readHeader(rin);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        TiffField<?> f_photoshop = workingPage.getField(TiffTag.PHOTOSHOP);
        if (f_photoshop != null && (irb = new IRB(data = (byte[])f_photoshop.getData())).containsThumbnail()) {
            IRBThumbnail thumbnail = irb.getThumbnail();
            return thumbnail;
        }
        return null;
    }

    public static IRBThumbnail extractThumbnail(RandomAccessInputStream rin) throws IOException {
        return TIFFTweaker.extractThumbnail(0, rin);
    }

    public static void extractThumbnail(RandomAccessInputStream rin, String pathToThumbnail) throws IOException {
        IRBThumbnail thumbnail = TIFFTweaker.extractThumbnail(rin);
        if (thumbnail != null) {
            String outpath = "";
            outpath = pathToThumbnail.endsWith("\\") || pathToThumbnail.endsWith("/") ? pathToThumbnail + "photoshop_thumbnail.jpg" : pathToThumbnail.replaceFirst("[.][^.]+$", "") + "_photoshop_t.jpg";
            FileOutputStream fout = new FileOutputStream(outpath);
            if (thumbnail.getDataType() == 1) {
                fout.write(thumbnail.getCompressedImage());
            } else {
                ImageWriter writer = ImageIO.getWriter(ImageType.JPG);
                try {
                    writer.write(thumbnail.getRawImage(), fout);
                }
                catch (Exception e) {
                    throw new IOException("Writing thumbnail failed!");
                }
            }
            fout.close();
        }
    }

    public static Collection<BufferedImage> extractThumbnails(RandomAccessInputStream rin) throws IOException {
        List<BufferedImage> thumbnails = Collections.emptyList();
        IRBThumbnail thumbnail = TIFFTweaker.extractThumbnail(rin);
        if (thumbnail != null) {
            thumbnails.add(thumbnail.getAsBufferedImage());
        }
        return thumbnails;
    }

    public static void finishInsert(RandomAccessOutputStream rout, List<IFD> list) throws IOException {
        int i;
        for (i = 0; i < list.size(); ++i) {
            int offset = list.get(i).getField(TiffTag.PAGE_NUMBER).getDataOffset();
            rout.seek(offset);
            rout.writeShort((short)i);
            rout.writeShort((short)list.size());
        }
        for (i = 0; i < list.size() - 1; ++i) {
            list.get(i).setNextIFDOffset(rout, list.get(i + 1).getStartOffset());
        }
        int firstIFDOffset = list.get(0).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void finishWrite(RandomAccessOutputStream rout, List<IFD> list) throws IOException {
        TIFFTweaker.finishInsert(rout, list);
    }

    private static int[] getBytes2Read(IFD ifd) {
        TiffField<?> tiffField = ifd.getField(TiffTag.IMAGE_WIDTH);
        int imageWidth = tiffField.getDataAsLong()[0];
        tiffField = ifd.getField(TiffTag.IMAGE_LENGTH);
        int imageHeight = tiffField.getDataAsLong()[0];
        int horizontalSampleFactor = 2;
        int verticalSampleFactor = 2;
        int photoMetric = ifd.getField(TiffTag.PHOTOMETRIC_INTERPRETATION).getDataAsLong()[0];
        if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            TiffField<?> f_YCbCrSubSampling = ifd.getField(TiffTag.YCbCr_SUB_SAMPLING);
            if (f_YCbCrSubSampling != null) {
                int[] sampleFactors = f_YCbCrSubSampling.getDataAsLong();
                horizontalSampleFactor = sampleFactors[0];
                verticalSampleFactor = sampleFactors[1];
            }
            imageWidth = (imageWidth + horizontalSampleFactor - 1) / horizontalSampleFactor * horizontalSampleFactor;
            imageHeight = (imageHeight + verticalSampleFactor - 1) / verticalSampleFactor * verticalSampleFactor;
        }
        int samplesPerPixel = 1;
        tiffField = ifd.getField(TiffTag.SAMPLES_PER_PIXEL);
        if (tiffField != null) {
            samplesPerPixel = tiffField.getDataAsLong()[0];
        }
        int bitsPerSample = 1;
        tiffField = ifd.getField(TiffTag.BITS_PER_SAMPLE);
        if (tiffField != null) {
            bitsPerSample = tiffField.getDataAsLong()[0];
        }
        int tileWidth = -1;
        int tileLength = -1;
        TiffField<?> f_tileLength = ifd.getField(TiffTag.TILE_LENGTH);
        TiffField<?> f_tileWidth = ifd.getField(TiffTag.TILE_WIDTH);
        if (f_tileWidth != null) {
            tileWidth = f_tileWidth.getDataAsLong()[0];
            tileLength = f_tileLength.getDataAsLong()[0];
        }
        int rowsPerStrip = imageHeight;
        int rowWidth = imageWidth;
        TiffField<?> f_rowsPerStrip = ifd.getField(TiffTag.ROWS_PER_STRIP);
        if (f_rowsPerStrip != null) {
            rowsPerStrip = f_rowsPerStrip.getDataAsLong()[0];
        }
        if (rowsPerStrip > imageHeight) {
            rowsPerStrip = imageHeight;
        }
        if (tileWidth > 0) {
            rowsPerStrip = tileLength;
            rowWidth = tileWidth;
        }
        int planaryConfiguration = 1;
        tiffField = ifd.getField(TiffTag.PLANAR_CONFIGURATTION);
        if (tiffField != null) {
            planaryConfiguration = tiffField.getDataAsLong()[0];
        }
        int[] totalBytes2Read = new int[samplesPerPixel];
        if (planaryConfiguration == 1) {
            totalBytes2Read[0] = (rowWidth * bitsPerSample * samplesPerPixel + 7) / 8 * rowsPerStrip;
        } else {
            totalBytes2Read[1] = totalBytes2Read[2] = (rowWidth * bitsPerSample + 7) / 8 * rowsPerStrip;
            totalBytes2Read[0] = totalBytes2Read[2];
        }
        if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            if (samplesPerPixel != 3) {
                samplesPerPixel = 3;
            }
            int[] sampleBytesPerRow = new int[samplesPerPixel];
            sampleBytesPerRow[0] = (bitsPerSample * rowWidth + 7) / 8;
            sampleBytesPerRow[1] = (bitsPerSample * rowWidth / horizontalSampleFactor + 7) / 8;
            sampleBytesPerRow[2] = sampleBytesPerRow[1];
            int[] sampleRowsPerStrip = new int[samplesPerPixel];
            sampleRowsPerStrip[0] = rowsPerStrip;
            sampleRowsPerStrip[1] = rowsPerStrip / verticalSampleFactor;
            sampleRowsPerStrip[2] = sampleRowsPerStrip[1];
            totalBytes2Read[0] = sampleBytesPerRow[0] * sampleRowsPerStrip[0];
            totalBytes2Read[1] = sampleBytesPerRow[1] * sampleRowsPerStrip[1];
            totalBytes2Read[2] = totalBytes2Read[1];
            if (tiffField != null) {
                planaryConfiguration = tiffField.getDataAsLong()[0];
            }
            if (planaryConfiguration == 1) {
                totalBytes2Read[0] = totalBytes2Read[0] + totalBytes2Read[1] + totalBytes2Read[2];
            }
        }
        return totalBytes2Read;
    }

    public static int getPageCount(RandomAccessInputStream rin) throws IOException {
        long streamPointer = rin.getStreamPointer();
        rin.seek(0L);
        ArrayList<IFD> list = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(list, rin);
        rin.seek(streamPointer);
        return list.size();
    }

    private static int getRowWidth(IFD ifd) {
        TiffField<?> tiffField = ifd.getField(TiffTag.IMAGE_WIDTH);
        int imageWidth = tiffField.getDataAsLong()[0];
        int horizontalSampleFactor = 2;
        int photoMetric = ifd.getField(TiffTag.PHOTOMETRIC_INTERPRETATION).getDataAsLong()[0];
        if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
            TiffField<?> f_YCbCrSubSampling = ifd.getField(TiffTag.YCbCr_SUB_SAMPLING);
            if (f_YCbCrSubSampling != null) {
                int[] sampleFactors = f_YCbCrSubSampling.getDataAsLong();
                horizontalSampleFactor = sampleFactors[0];
            }
            imageWidth = (imageWidth + horizontalSampleFactor - 1) / horizontalSampleFactor * horizontalSampleFactor;
        }
        int rowWidth = imageWidth;
        int tileWidth = -1;
        TiffField<?> f_tileWidth = ifd.getField(TiffTag.TILE_WIDTH);
        if (f_tileWidth != null && (tileWidth = f_tileWidth.getDataAsLong()[0]) > 0) {
            rowWidth = tileWidth;
        }
        return rowWidth;
    }

    public static int[] getUncompressedStripByteCounts(IFD ifd, int strips) {
        int[] counts;
        block18: {
            int[] columnHeight;
            int[] sampleRowsPerStrip;
            int[] sampleBytesPerRow;
            int tileWidth;
            int samplesPerPixel;
            block19: {
                int lastStripBytes;
                int bytesPerStrip;
                int planaryConfiguration;
                int rowWidth;
                int rowsPerStrip;
                int bitsPerSample;
                int verticalSampleFactor;
                int horizontalSampleFactor;
                int imageHeight;
                block17: {
                    int stripsPerSample;
                    int lastStripBytes2;
                    TiffField<?> tiffField = ifd.getField(TiffTag.IMAGE_WIDTH);
                    int imageWidth = tiffField.getDataAsLong()[0];
                    tiffField = ifd.getField(TiffTag.IMAGE_LENGTH);
                    imageHeight = tiffField.getDataAsLong()[0];
                    horizontalSampleFactor = 2;
                    verticalSampleFactor = 2;
                    tiffField = ifd.getField(TiffTag.PHOTOMETRIC_INTERPRETATION);
                    int photoMetric = TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue();
                    if (tiffField != null) {
                        photoMetric = tiffField.getDataAsLong()[0];
                    }
                    if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) {
                        TiffField<?> f_YCbCrSubSampling = ifd.getField(TiffTag.YCbCr_SUB_SAMPLING);
                        if (f_YCbCrSubSampling != null) {
                            int[] sampleFactors = f_YCbCrSubSampling.getDataAsLong();
                            horizontalSampleFactor = sampleFactors[0];
                            verticalSampleFactor = sampleFactors[1];
                        }
                        imageWidth = (imageWidth + horizontalSampleFactor - 1) / horizontalSampleFactor * horizontalSampleFactor;
                        imageHeight = (imageHeight + verticalSampleFactor - 1) / verticalSampleFactor * verticalSampleFactor;
                    }
                    samplesPerPixel = 1;
                    tiffField = ifd.getField(TiffTag.SAMPLES_PER_PIXEL);
                    if (tiffField != null) {
                        samplesPerPixel = tiffField.getDataAsLong()[0];
                    }
                    bitsPerSample = 1;
                    tiffField = ifd.getField(TiffTag.BITS_PER_SAMPLE);
                    if (tiffField != null) {
                        bitsPerSample = tiffField.getDataAsLong()[0];
                    }
                    tileWidth = -1;
                    int tileLength = -1;
                    TiffField<?> f_tileLength = ifd.getField(TiffTag.TILE_LENGTH);
                    TiffField<?> f_tileWidth = ifd.getField(TiffTag.TILE_WIDTH);
                    if (f_tileWidth != null) {
                        tileWidth = f_tileWidth.getDataAsLong()[0];
                        tileLength = f_tileLength.getDataAsLong()[0];
                    }
                    rowsPerStrip = imageHeight;
                    rowWidth = imageWidth;
                    TiffField<?> f_rowsPerStrip = ifd.getField(TiffTag.ROWS_PER_STRIP);
                    if (f_rowsPerStrip != null) {
                        rowsPerStrip = f_rowsPerStrip.getDataAsLong()[0];
                    }
                    if (rowsPerStrip > imageHeight) {
                        rowsPerStrip = imageHeight;
                    }
                    if (tileWidth > 0) {
                        rowsPerStrip = tileLength;
                        rowWidth = tileWidth;
                    }
                    int bytesPerRow = (bitsPerSample * rowWidth * samplesPerPixel + 7) / 8;
                    planaryConfiguration = 1;
                    tiffField = ifd.getField(TiffTag.PLANAR_CONFIGURATTION);
                    if (tiffField != null) {
                        planaryConfiguration = tiffField.getDataAsLong()[0];
                    }
                    if (planaryConfiguration == 2) {
                        bytesPerRow = (bitsPerSample * rowWidth + 7) / 8;
                    }
                    bytesPerStrip = bytesPerRow * rowsPerStrip;
                    counts = new int[strips];
                    if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr.getValue()) break block17;
                    Arrays.fill(counts, bytesPerStrip);
                    if (tileWidth >= 0) break block18;
                    counts[counts.length - 1] = lastStripBytes2 = bytesPerRow * imageHeight - bytesPerStrip * (strips - 1);
                    if (planaryConfiguration == 2 && (lastStripBytes2 = bytesPerRow * imageHeight - bytesPerStrip * ((stripsPerSample = strips / samplesPerPixel) - 1)) > 0) {
                        int stripOffset = stripsPerSample - 1;
                        for (int i = 0; i < samplesPerPixel; ++i) {
                            counts[stripOffset] = lastStripBytes2;
                            stripOffset += stripsPerSample;
                        }
                    }
                    break block18;
                }
                if (samplesPerPixel != 3) {
                    samplesPerPixel = 3;
                }
                sampleBytesPerRow = new int[samplesPerPixel];
                sampleBytesPerRow[0] = (bitsPerSample * rowWidth + 7) / 8;
                sampleBytesPerRow[1] = (bitsPerSample * rowWidth / horizontalSampleFactor + 7) / 8;
                sampleBytesPerRow[2] = sampleBytesPerRow[1];
                sampleRowsPerStrip = new int[samplesPerPixel];
                sampleRowsPerStrip[0] = rowsPerStrip;
                sampleRowsPerStrip[1] = rowsPerStrip / verticalSampleFactor;
                sampleRowsPerStrip[2] = sampleRowsPerStrip[1];
                columnHeight = new int[samplesPerPixel];
                columnHeight[0] = imageHeight;
                columnHeight[1] = imageHeight / verticalSampleFactor;
                columnHeight[2] = columnHeight[1];
                if (planaryConfiguration != 1) break block19;
                bytesPerStrip = sampleBytesPerRow[0] * sampleRowsPerStrip[0] + sampleBytesPerRow[1] * sampleRowsPerStrip[1] + sampleBytesPerRow[2] * sampleRowsPerStrip[2];
                Arrays.fill(counts, bytesPerStrip);
                if (tileWidth >= 0) break block18;
                counts[counts.length - 1] = lastStripBytes = sampleBytesPerRow[0] * columnHeight[0] + sampleBytesPerRow[1] * columnHeight[1] + sampleBytesPerRow[2] * columnHeight[2] - bytesPerStrip * (strips - 1);
                break block18;
            }
            int[] sampleBytesPerStrip = new int[samplesPerPixel];
            sampleBytesPerStrip[0] = sampleRowsPerStrip[0] * sampleBytesPerRow[0];
            sampleBytesPerStrip[1] = sampleRowsPerStrip[1] * sampleBytesPerRow[1];
            sampleBytesPerStrip[2] = sampleBytesPerStrip[1];
            int stripsPerSample = strips / samplesPerPixel;
            int startOffset = 0;
            int endOffset = stripsPerSample;
            for (int i = 0; i < samplesPerPixel; ++i) {
                Arrays.fill(counts, startOffset, endOffset, sampleBytesPerStrip[i]);
                startOffset = endOffset;
                endOffset += stripsPerSample;
            }
            if (tileWidth < 0) {
                int[] lastStripBytes = new int[samplesPerPixel];
                lastStripBytes[0] = sampleBytesPerRow[0] * columnHeight[0] - sampleBytesPerStrip[0] * (stripsPerSample - 1);
                lastStripBytes[1] = sampleBytesPerRow[1] * columnHeight[1] - sampleBytesPerStrip[1] * (stripsPerSample - 1);
                lastStripBytes[2] = lastStripBytes[1];
                startOffset = stripsPerSample - 1;
                for (int i = 0; i < samplesPerPixel; ++i) {
                    counts[startOffset] = lastStripBytes[i];
                    startOffset += stripsPerSample;
                }
            }
        }
        return counts;
    }

    public static void insertComments(List<String> comments, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TIFFTweaker.insertComments(comments, 0, rin, rout);
    }

    public static void insertComments(List<String> comments, int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        StringBuilder commentsBuilder = new StringBuilder();
        for (String comment : comments) {
            commentsBuilder.append(comment);
            commentsBuilder.append('\u0000');
        }
        workingPage.addField(new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), commentsBuilder.toString()));
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertExif(RandomAccessInputStream rin, RandomAccessOutputStream rout, Exif exif, boolean update) throws IOException {
        TIFFTweaker.insertExif(rin, rout, exif, 0, update);
    }

    public static void insertExif(RandomAccessInputStream rin, RandomAccessOutputStream rout, Exif exif, int pageNumber, boolean update) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD imageIFD = (IFD)ifds.get(pageNumber);
        IFD exifSubIFD = imageIFD.getChild(TiffTag.EXIF_SUB_IFD);
        IFD gpsSubIFD = imageIFD.getChild(TiffTag.GPS_SUB_IFD);
        IFD newImageIFD = exif.getImageIFD();
        IFD newExifSubIFD = exif.getExifIFD();
        IFD newGpsSubIFD = exif.getGPSIFD();
        if (newImageIFD != null) {
            Collection<TiffField<?>> fields = newImageIFD.getFields();
            for (TiffField<?> field : fields) {
                Tag tag = TiffTag.fromShort(field.getTag());
                if (imageIFD.getField(tag) != null && tag.isCritical()) {
                    throw new RuntimeException("Duplicate Tag: " + tag);
                }
                imageIFD.addField(field);
            }
        }
        if (update && exifSubIFD != null && newExifSubIFD != null) {
            exifSubIFD.addFields(newExifSubIFD.getFields());
            newExifSubIFD = exifSubIFD;
        }
        if (newExifSubIFD != null) {
            imageIFD.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
            imageIFD.addChild(TiffTag.EXIF_SUB_IFD, newExifSubIFD);
        }
        if (update && gpsSubIFD != null && newGpsSubIFD != null) {
            gpsSubIFD.addFields(newGpsSubIFD.getFields());
            newGpsSubIFD = gpsSubIFD;
        }
        if (newGpsSubIFD != null) {
            imageIFD.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
            imageIFD.addChild(TiffTag.GPS_SUB_IFD, newGpsSubIFD);
        }
        int writeOffset = 8;
        writeOffset = TIFFTweaker.copyPages(ifds, writeOffset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertICCProfile(byte[] icc_profile, int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        workingPage.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), icc_profile));
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertICCProfile(ICC_Profile icc_profile, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TIFFTweaker.insertICCProfile(icc_profile.getData(), 0, rin, rout);
    }

    public static void insertICCProfile(ICC_Profile icc_profile, int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TIFFTweaker.insertICCProfile(icc_profile.getData(), pageNumber, rin, rout);
    }

    public static void insertIPTC(RandomAccessInputStream rin, RandomAccessOutputStream rout, Collection<IPTCDataSet> iptcs, boolean update) throws IOException {
        TIFFTweaker.insertIPTC(rin, rout, 0, iptcs, update);
    }

    public static void insertIPTC(RandomAccessInputStream rin, RandomAccessOutputStream rout, int pageNumber, Collection<IPTCDataSet> iptcs, boolean update) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        TiffField<?> f_iptc = workingPage.removeField(TiffTag.IPTC);
        TiffField<?> f_photoshop = workingPage.getField(TiffTag.PHOTOSHOP);
        if (f_photoshop != null) {
            IRB irb = new IRB((byte[])f_photoshop.getData());
            HashMap<Short, _8BIM> bims = new HashMap<Short, _8BIM>(irb.get8BIM());
            _8BIM photoshop_iptc = (_8BIM)bims.remove(ImageResourceID.IPTC_NAA.getValue());
            if (photoshop_iptc != null && update) {
                if (f_iptc != null) {
                    byte[] data = null;
                    data = f_iptc.getType() == FieldType.LONG ? ArrayUtils.toByteArray(f_iptc.getDataAsLong(), rin.getEndian() == 19789) : (byte[])f_iptc.getData();
                    TIFFTweaker.copyIPTCDataSet(iptcs, data);
                }
                TIFFTweaker.copyIPTCDataSet(iptcs, photoshop_iptc.getData());
                iptcs = new ArrayList<IPTCDataSet>(new HashSet<IPTCDataSet>(iptcs));
            }
            for (_8BIM bim : bims.values()) {
                bim.write(bout);
            }
            workingPage.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), bout.toByteArray()));
        } else if (f_iptc != null && update) {
            byte[] data = null;
            data = f_iptc.getType() == FieldType.LONG ? ArrayUtils.toByteArray(f_iptc.getDataAsLong(), rin.getEndian() == 19789) : (byte[])f_iptc.getData();
            TIFFTweaker.copyIPTCDataSet(iptcs, data);
        }
        ArrayList<IPTCDataSet> iptcList = new ArrayList<IPTCDataSet>(iptcs);
        Collections.sort(iptcList);
        bout.reset();
        for (IPTCDataSet dataset : iptcList) {
            dataset.write(bout);
        }
        workingPage.addField(new UndefinedField(TiffTag.IPTC.getValue(), bout.toByteArray()));
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertIRB(RandomAccessInputStream rin, RandomAccessOutputStream rout, Collection<_8BIM> bims, boolean update) throws IOException {
        TIFFTweaker.insertIRB(rin, rout, 0, bims, update);
    }

    public static void insertIRB(RandomAccessInputStream rin, RandomAccessOutputStream rout, int pageNumber, Collection<_8BIM> bims, boolean update) throws IOException {
        Object f_irb;
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (update && (f_irb = workingPage.getField(TiffTag.PHOTOSHOP)) != null) {
            IRB irb = new IRB((byte[])((TiffField)f_irb).getData());
            HashMap<Short, _8BIM> bimMap = new HashMap<Short, _8BIM>(irb.get8BIM());
            for (_8BIM bim : bims) {
                bimMap.put(bim.getID(), bim);
            }
            if (bimMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue()) && bimMap.containsKey(ImageResourceID.THUMBNAIL_RESOURCE_PS5.getValue())) {
                bimMap.remove(ImageResourceID.THUMBNAIL_RESOURCE_PS4.getValue());
            }
            bims = bimMap.values();
        }
        for (_8BIM bim : bims) {
            bim.write(bout);
        }
        workingPage.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), bout.toByteArray()));
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertMetadata(RandomAccessInputStream rin, RandomAccessOutputStream rout, Collection<Metadata> metadata) throws IOException {
        TIFFTweaker.insertMetadata(rin, rout, 0, metadata);
    }

    public static void insertMetadata(RandomAccessInputStream rin, RandomAccessOutputStream rout, int pageNumber, Collection<Metadata> metadata) throws IOException {
        Comments comments;
        IRB irb;
        IPTC iptc;
        ICCProfile iccProfile;
        XMP xmp;
        IRB irb2;
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        for (Metadata meta : metadata) {
            metadataMap.put(meta.getType(), meta);
        }
        if (metadataMap.get((Object)MetadataType.IPTC) != null && (irb2 = (IRB)metadataMap.get((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            HashMap<Short, _8BIM> bimMap = new HashMap<Short, _8BIM>(irb2.get8BIM());
            bimMap.remove(ImageResourceID.IPTC_NAA.getValue());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (_8BIM bim : bimMap.values()) {
                bim.write(bout);
            }
            metadataMap.put(MetadataType.PHOTOSHOP_IRB, new IRB(bout.toByteArray()));
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Exif exif = (Exif)metadataMap.remove((Object)MetadataType.EXIF);
        if (exif != null) {
            IFD newImageIFD = exif.getImageIFD();
            IFD newExifSubIFD = exif.getExifIFD();
            IFD newGpsSubIFD = exif.getGPSIFD();
            if (newImageIFD != null) {
                Collection<TiffField<?>> fields = newImageIFD.getFields();
                for (TiffField<?> field : fields) {
                    Tag tag = TiffTag.fromShort(field.getTag());
                    if (workingPage.getField(tag) != null && tag.isCritical()) {
                        throw new RuntimeException("Duplicate Tag: " + tag);
                    }
                    workingPage.addField(field);
                }
            }
            if (newExifSubIFD != null) {
                workingPage.addField(new LongField(TiffTag.EXIF_SUB_IFD.getValue(), new int[]{0}));
                workingPage.addChild(TiffTag.EXIF_SUB_IFD, newExifSubIFD);
            }
            if (newGpsSubIFD != null) {
                workingPage.addField(new LongField(TiffTag.GPS_SUB_IFD.getValue(), new int[]{0}));
                workingPage.addChild(TiffTag.GPS_SUB_IFD, newGpsSubIFD);
            }
            offset = 8;
        }
        if ((xmp = (XMP)metadataMap.remove((Object)MetadataType.XMP)) != null) {
            workingPage.addField(new UndefinedField(TiffTag.XMP.getValue(), xmp.getData()));
        }
        if ((iccProfile = (ICCProfile)metadataMap.remove((Object)MetadataType.ICC_PROFILE)) != null) {
            workingPage.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), iccProfile.getData()));
        }
        if ((iptc = (IPTC)metadataMap.remove((Object)MetadataType.IPTC)) != null) {
            workingPage.removeField(TiffTag.IPTC);
            TiffField<?> f_photoshop = workingPage.getField(TiffTag.PHOTOSHOP);
            if (f_photoshop != null) {
                IRB irb3 = new IRB((byte[])f_photoshop.getData());
                HashMap<Short, _8BIM> bims = new HashMap<Short, _8BIM>(irb3.get8BIM());
                bims.remove(ImageResourceID.IPTC_NAA.getValue());
                iptc.write(bout);
                _8BIM iptc_bim = new _8BIM(ImageResourceID.IPTC_NAA, "iptc", bout.toByteArray());
                bout.reset();
                iptc_bim.write(bout);
                for (_8BIM bim : bims.values()) {
                    bim.write(bout);
                }
                workingPage.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), bout.toByteArray()));
            } else {
                bout.reset();
                iptc.write(bout);
                workingPage.addField(new UndefinedField(TiffTag.IPTC.getValue(), bout.toByteArray()));
            }
        }
        if ((irb = (IRB)metadataMap.remove((Object)MetadataType.PHOTOSHOP_IRB)) != null) {
            bout.reset();
            for (_8BIM bim : irb.get8BIM().values()) {
                bim.write(bout);
            }
            workingPage.addField(new UndefinedField(TiffTag.PHOTOSHOP.getValue(), bout.toByteArray()));
        }
        if ((comments = (Comments)metadataMap.remove((Object)MetadataType.COMMENT)) != null) {
            StringBuilder commentsBuilder = new StringBuilder();
            for (String comment : comments.getComments()) {
                commentsBuilder.append(comment);
                commentsBuilder.append('\u0000');
            }
            workingPage.addField(new ASCIIField(TiffTag.IMAGE_DESCRIPTION.getValue(), commentsBuilder.toString()));
        }
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static int insertPage(BufferedImage image, int pageNumber, RandomAccessOutputStream rout, List<IFD> ifds, int writeOffset, TIFFWriter writer) throws IOException {
        if (pageNumber < 0) {
            pageNumber = 0;
        } else if (pageNumber > ifds.size()) {
            pageNumber = ifds.size();
        }
        try {
            writeOffset = writer.writePage(image, pageNumber, ifds.size(), rout, writeOffset);
            ifds.add(pageNumber, writer.getIFD());
        }
        catch (Exception e) {
            LOGGER.error("Failed inserting page " + pageNumber, e);
            throw new PageWritingException("Failed inserting page " + pageNumber, e);
        }
        return writeOffset;
    }

    public static int insertPage(ImageFrame page, int pageNumber, RandomAccessOutputStream rout, List<IFD> ifds, int writeOffset, TIFFWriter writer) throws IOException {
        BufferedImage image = page.getFrame();
        writer.setImageParam(page.getFrameParam());
        return TIFFTweaker.insertPage(image, pageNumber, rout, ifds, writeOffset, writer);
    }

    public static void insertPages(RandomAccessInputStream rin, RandomAccessOutputStream rout, int pageNumber, BufferedImage ... images) throws IOException {
        TIFFTweaker.insertPages(rin, rout, pageNumber, null, images);
    }

    public static void insertPages(RandomAccessInputStream rin, RandomAccessOutputStream rout, int pageNumber, ImageFrame ... frames) throws IOException {
        int i;
        rin.seek(0L);
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> list = new ArrayList<IFD>();
        ArrayList<IFD> insertedList = new ArrayList<IFD>(frames.length);
        TIFFTweaker.readIFDs(list, offset, rin);
        if (pageNumber < 0) {
            pageNumber = 0;
        } else if (pageNumber > list.size()) {
            pageNumber = list.size();
        }
        int minPageNumber = pageNumber;
        int maxPageNumber = list.size() + frames.length;
        int writeOffset = 8;
        TIFFWriter writer = new TIFFWriter();
        for (i = 0; i < frames.length; ++i) {
            BufferedImage frame = frames[i].getFrame();
            ImageParam param = frames[i].getFrameParam();
            try {
                writer.setImageParam(param);
                writeOffset = writer.writePage(frame, pageNumber++, maxPageNumber, rout, writeOffset);
                insertedList.add(writer.getIFD());
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed inserting page " + pageNumber, e);
                throw new PageWritingException("Failed inserting page " + pageNumber, e);
            }
        }
        for (i = 0; i < minPageNumber; ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)maxPageNumber}));
        }
        for (i = minPageNumber; i < list.size(); ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)(i + frames.length), (short)maxPageNumber}));
        }
        if (list.size() == 1) {
            if (((IFD)list.get(0)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)list.get(0)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)list.get(0)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{3}));
        }
        writeOffset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        for (i = 0; i < frames.length - 1; ++i) {
            ((IFD)insertedList.get(i)).setNextIFDOffset(rout, ((IFD)insertedList.get(i + 1)).getStartOffset());
        }
        if (minPageNumber != 0) {
            ((IFD)list.get(minPageNumber - 1)).setNextIFDOffset(rout, ((IFD)insertedList.get(0)).getStartOffset());
        }
        if (minPageNumber != list.size()) {
            ((IFD)insertedList.get(insertedList.size() - 1)).setNextIFDOffset(rout, ((IFD)list.get(minPageNumber)).getStartOffset());
        }
        int firstIFDOffset = 0;
        firstIFDOffset = minPageNumber == 0 ? ((IFD)insertedList.get(0)).getStartOffset() : ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertPages(RandomAccessInputStream rin, RandomAccessOutputStream rout, int pageNumber, ImageParam[] imageParam, BufferedImage ... images) throws IOException {
        int i;
        rin.seek(0L);
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> list = new ArrayList<IFD>();
        ArrayList<IFD> insertedList = new ArrayList<IFD>(images.length);
        TIFFTweaker.readIFDs(list, offset, rin);
        if (pageNumber < 0) {
            pageNumber = 0;
        } else if (pageNumber > list.size()) {
            pageNumber = list.size();
        }
        int minPageNumber = pageNumber;
        int maxPageNumber = list.size() + images.length;
        int writeOffset = 8;
        Object[] param = null;
        if (imageParam == null) {
            param = new ImageParam[images.length];
            Arrays.fill(param, ImageParam.DEFAULT_IMAGE_PARAM);
        } else if (images.length > imageParam.length && imageParam.length > 0) {
            param = new ImageParam[images.length];
            System.arraycopy(imageParam, 0, param, 0, imageParam.length);
            Arrays.fill(param, imageParam.length, images.length, imageParam[imageParam.length - 1]);
        } else {
            param = imageParam;
        }
        TIFFWriter writer = new TIFFWriter();
        for (i = 0; i < images.length; ++i) {
            try {
                writer.setImageParam((ImageParam)param[i]);
                writeOffset = writer.writePage(images[i], pageNumber++, maxPageNumber, rout, writeOffset);
                insertedList.add(writer.getIFD());
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed inserting page " + pageNumber, e);
                throw new PageWritingException("Failed inserting page " + pageNumber, e);
            }
        }
        for (i = 0; i < minPageNumber; ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)maxPageNumber}));
        }
        for (i = minPageNumber; i < list.size(); ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)(i + images.length), (short)maxPageNumber}));
        }
        if (list.size() == 1) {
            if (((IFD)list.get(0)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)list.get(0)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)list.get(0)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{3}));
        }
        writeOffset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        for (i = 0; i < images.length - 1; ++i) {
            ((IFD)insertedList.get(i)).setNextIFDOffset(rout, ((IFD)insertedList.get(i + 1)).getStartOffset());
        }
        if (minPageNumber != 0) {
            ((IFD)list.get(minPageNumber - 1)).setNextIFDOffset(rout, ((IFD)insertedList.get(0)).getStartOffset());
        }
        if (minPageNumber != list.size()) {
            ((IFD)insertedList.get(insertedList.size() - 1)).setNextIFDOffset(rout, ((IFD)list.get(minPageNumber)).getStartOffset());
        }
        int firstIFDOffset = 0;
        firstIFDOffset = minPageNumber == 0 ? ((IFD)insertedList.get(0)).getStartOffset() : ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertThumbnail(RandomAccessInputStream rin, RandomAccessOutputStream rout, BufferedImage thumbnail) throws IOException {
        if (thumbnail == null) {
            throw new IllegalArgumentException("Input thumbnail is null");
        }
        ThumbnailResource bim = new ThumbnailResource(thumbnail);
        TIFFTweaker.insertIRB(rin, rout, Arrays.asList(bim), true);
    }

    public static void insertTiffImage(File original, File toBeInserted, int pageNumber, File output) throws IOException {
        FileInputStream fin1 = new FileInputStream(original);
        FileInputStream fin2 = new FileInputStream(toBeInserted);
        FileOutputStream fout = new FileOutputStream(output);
        FileCacheRandomAccessInputStream rin1 = new FileCacheRandomAccessInputStream(fin1);
        FileCacheRandomAccessInputStream rin2 = new FileCacheRandomAccessInputStream(fin2);
        FileCacheRandomAccessOutputStream rout = new FileCacheRandomAccessOutputStream(fout);
        TIFFTweaker.insertTiffImage(rin1, rin2, pageNumber, rout);
        ((InputStream)rin1).close();
        ((InputStream)rin2).close();
        ((RandomAccessOutputStream)rout).close();
    }

    public static void insertTiffImage(RandomAccessInputStream original, RandomAccessInputStream toBeInserted, int pageNumber, RandomAccessOutputStream output) throws IOException {
        ArrayList<IFD> ifds1 = new ArrayList<IFD>();
        int offset1 = TIFFTweaker.copyHeader(original, output);
        TIFFTweaker.readIFDs(ifds1, offset1, original);
        if (pageNumber < 0) {
            pageNumber = 0;
        } else if (pageNumber > ifds1.size()) {
            pageNumber = ifds1.size();
        }
        for (int i = 0; i < ifds1.size(); ++i) {
            ((IFD)ifds1.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)ifds1.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
        }
        int offset = TIFFTweaker.copyPages(ifds1, 8, original, output);
        short writeEndian = output.getEndian();
        ArrayList<IFD> ifds2 = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds2, toBeInserted);
        for (int j = 0; j < ifds2.size(); ++j) {
            ((IFD)ifds2.get(j)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)ifds2.get(j)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
        }
        ArrayList<IFD> newList = new ArrayList<IFD>(ifds1.size() + ifds2.size());
        short readEndian = toBeInserted.getEndian();
        if (readEndian == writeEndian) {
            offset = TIFFTweaker.copyPages(ifds2, offset, toBeInserted, output);
        } else {
            IFD prevIFD = null;
            for (int j = 0; j < ifds2.size(); ++j) {
                TiffField<?> stripByteCounts;
                IFD currIFD = (IFD)ifds2.get(j);
                int bitsPerSample = 1;
                TiffField<?> f_bitsPerSample = currIFD.getField(TiffTag.BITS_PER_SAMPLE);
                if (f_bitsPerSample != null) {
                    bitsPerSample = f_bitsPerSample.getDataAsLong()[0];
                }
                if (bitsPerSample <= 8) {
                    offset = TIFFTweaker.copyPageData(currIFD, offset, toBeInserted, output);
                    continue;
                }
                if (bitsPerSample % 8 != 0) continue;
                ImageDecoder decoder = null;
                ImageEncoder encoder = null;
                LongField stripOffSets = currIFD.removeField(TiffTag.STRIP_OFFSETS);
                if (stripOffSets == null) {
                    stripOffSets = currIFD.removeField(TiffTag.TILE_OFFSETS);
                }
                if ((stripByteCounts = currIFD.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
                    stripByteCounts = currIFD.getField(TiffTag.TILE_BYTE_COUNTS);
                }
                if (stripOffSets != null) {
                    int k;
                    int[] counts = stripByteCounts.getDataAsLong();
                    int[] off = ((TiffField)stripOffSets).getDataAsLong();
                    int[] temp = new int[off.length];
                    int[] uncompressedStripByteCounts = TIFFTweaker.getUncompressedStripByteCounts(currIFD, off.length);
                    output.seek(offset);
                    TiffField<?> tiffField = currIFD.getField(TiffTag.COMPRESSION);
                    int tiffCompression = 1;
                    if (tiffField != null) {
                        tiffCompression = tiffField.getDataAsLong()[0];
                    }
                    TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.fromValue(tiffCompression);
                    int samplesPerPixel = 1;
                    tiffField = currIFD.getField(TiffTag.SAMPLES_PER_PIXEL);
                    if (tiffField != null) {
                        samplesPerPixel = tiffField.getDataAsLong()[0];
                    }
                    int planaryConfiguration = 1;
                    tiffField = currIFD.getField(TiffTag.PLANAR_CONFIGURATTION);
                    if (tiffField != null) {
                        planaryConfiguration = tiffField.getDataAsLong()[0];
                    }
                    int scanLineStride = TIFFTweaker.getRowWidth(currIFD);
                    if (planaryConfiguration == 1) {
                        scanLineStride *= samplesPerPixel;
                    }
                    switch (compression) {
                        case LZW: {
                            decoder = new LZWTreeDecoder(8, true);
                            encoder = new LZWTreeEncoder(output, 8, 4096, null);
                            break;
                        }
                        case DEFLATE: 
                        case DEFLATE_ADOBE: {
                            decoder = new DeflateDecoder();
                            encoder = new DeflateEncoder(output, 4096, 4, null);
                            break;
                        }
                        case PACKBITS: {
                            for (k = 0; k < off.length; ++k) {
                                toBeInserted.seek(off[k]);
                                byte[] buf = new byte[counts[k]];
                                toBeInserted.readFully(buf);
                                byte[] buf2 = new byte[uncompressedStripByteCounts[k]];
                                Packbits.unpackbits(buf, buf2);
                                ArrayUtils.flipEndian(buf2, 0, buf2.length, bitsPerSample, scanLineStride, readEndian == 19789);
                                buf2 = new byte[buf.length + (buf.length + 127) / 128];
                                int bytesCompressed = Packbits.packbits(buf, buf2);
                                output.write(buf2, 0, bytesCompressed);
                                temp[k] = offset;
                                offset += bytesCompressed;
                            }
                            break;
                        }
                        case NONE: {
                            if (planaryConfiguration == 1 && off.length == 1 || planaryConfiguration == 2 && off.length == samplesPerPixel) {
                                int[] totalBytes2Read = TIFFTweaker.getBytes2Read(currIFD);
                                for (int k2 = 0; k2 < off.length; ++k2) {
                                    counts[k2] = totalBytes2Read[k2];
                                }
                            }
                            for (k = 0; k < off.length; ++k) {
                                toBeInserted.seek(off[k]);
                                byte[] buf = new byte[counts[k]];
                                toBeInserted.readFully(buf);
                                buf = ArrayUtils.flipEndian(buf, 0, buf.length, bitsPerSample, scanLineStride, readEndian == 19789);
                                output.write(buf);
                                temp[k] = offset;
                                offset += buf.length;
                            }
                            break;
                        }
                        default: {
                            for (int l = 0; l < off.length; ++l) {
                                toBeInserted.seek(off[l]);
                                byte[] buf = new byte[counts[l]];
                                toBeInserted.readFully(buf);
                                output.write(buf);
                                temp[l] = offset;
                                offset += buf.length;
                            }
                        }
                    }
                    if (decoder != null) {
                        for (k = 0; k < off.length; ++k) {
                            toBeInserted.seek(off[k]);
                            byte[] buf = new byte[counts[k]];
                            toBeInserted.readFully(buf);
                            decoder.setInput(buf);
                            int bytesDecompressed = 0;
                            byte[] decompressed = new byte[uncompressedStripByteCounts[k]];
                            try {
                                bytesDecompressed = decoder.decode(decompressed, 0, uncompressedStripByteCounts[k]);
                            }
                            catch (Exception e) {
                                LOGGER.error("Failed decoding image", e);
                                throw new CodecException("Failed decoding image", e);
                            }
                            buf = ArrayUtils.flipEndian(decompressed, 0, bytesDecompressed, bitsPerSample, scanLineStride, readEndian == 19789);
                            try {
                                encoder.initialize();
                                encoder.encode(buf, 0, buf.length);
                                encoder.finish();
                            }
                            catch (Exception e) {
                                LOGGER.error("Failed encoding image", e);
                                throw new CodecException("Failed encoding image", e);
                            }
                            temp[k] = offset;
                            offset += encoder.getCompressedDataLen();
                        }
                    }
                    stripOffSets = currIFD.getField(TiffTag.STRIP_BYTE_COUNTS) != null ? new LongField(TiffTag.STRIP_OFFSETS.getValue(), temp) : new LongField(TiffTag.TILE_OFFSETS.getValue(), temp);
                    currIFD.addField(stripOffSets);
                } else {
                    offset = TIFFTweaker.copyPageData(currIFD, offset, toBeInserted, output);
                }
                if (prevIFD != null) {
                    prevIFD.setNextIFDOffset(output, offset);
                }
                offset = currIFD.write(output, offset);
                prevIFD = currIFD;
            }
        }
        if (pageNumber == 0) {
            ((IFD)ifds2.get(ifds2.size() - 1)).setNextIFDOffset(output, ((IFD)ifds1.get(0)).getStartOffset());
            newList.addAll(ifds2);
            newList.addAll(ifds1);
        } else if (pageNumber == ifds1.size()) {
            ((IFD)ifds1.get(ifds1.size() - 1)).setNextIFDOffset(output, ((IFD)ifds2.get(0)).getStartOffset());
            newList.addAll(ifds1);
            newList.addAll(ifds2);
        } else {
            ((IFD)ifds1.get(pageNumber - 1)).setNextIFDOffset(output, ((IFD)ifds2.get(0)).getStartOffset());
            ((IFD)ifds2.get(ifds2.size() - 1)).setNextIFDOffset(output, ((IFD)ifds1.get(pageNumber)).getStartOffset());
            newList.addAll(ifds1.subList(0, pageNumber));
            newList.addAll(ifds2);
            newList.addAll(ifds1.subList(pageNumber, ifds1.size()));
        }
        int maxPageNumber = newList.size();
        for (int i = 0; i < maxPageNumber; ++i) {
            offset = ((IFD)newList.get(i)).getField(TiffTag.PAGE_NUMBER).getDataOffset();
            output.seek(offset);
            output.writeShort((short)i);
            output.writeShort((short)maxPageNumber);
        }
        int firstIFDOffset = ((IFD)newList.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(output, firstIFDOffset);
    }

    public static void insertXMP(XMP xmp, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TIFFTweaker.insertXMP(xmp.getData(), rin, rout);
    }

    public static void insertXMP(XMP xmp, int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TIFFTweaker.insertXMP(xmp.getData(), pageNumber, rin, rout);
    }

    public static void insertXMP(byte[] xmp, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        TIFFTweaker.insertXMP(xmp, 0, rin, rout);
    }

    public static void insertXMP(byte[] xmp, int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        workingPage.addField(new UndefinedField(TiffTag.XMP.getValue(), xmp));
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    public static void insertXMP(String xmp, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        Document doc = XMLUtils.createXML(xmp);
        XMLUtils.insertLeadingPI(doc, "xpacket", "begin='' id='W5M0MpCehiHzreSzNTczkc9d'");
        XMLUtils.insertTrailingPI(doc, "xpacket", "end='r'");
        byte[] xmpBytes = XMLUtils.serializeToByteArray(doc);
        TIFFTweaker.insertXMP(xmpBytes, rin, rout);
    }

    private static <E> void merge(RandomAccessOutputStream merged, RandomInputStreamAdaptor<E> adaptor) throws IOException {
        if (adaptor.hasNext()) {
            RandomAccessInputStream image1 = (RandomAccessInputStream)adaptor.next();
            ArrayList<IFD> ifds1 = new ArrayList<IFD>();
            int offset1 = TIFFTweaker.copyHeader(image1, merged);
            TIFFTweaker.readIFDs(ifds1, offset1, image1);
            for (int i = 0; i < ifds1.size(); ++i) {
                ((IFD)ifds1.get(i)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)ifds1.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
            }
            int offset = TIFFTweaker.copyPages(ifds1, 8, image1, merged);
            image1.close();
            short writeEndian = merged.getEndian();
            while (adaptor.hasNext()) {
                ArrayList<IFD> ifds2 = new ArrayList<IFD>();
                RandomAccessInputStream image2 = (RandomAccessInputStream)adaptor.next();
                TIFFTweaker.readIFDs(ifds2, image2);
                for (int j = 0; j < ifds2.size(); ++j) {
                    ((IFD)ifds2.get(j)).removeField(TiffTag.PAGE_NUMBER);
                    ((IFD)ifds2.get(j)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
                }
                short readEndian = image2.getEndian();
                if (readEndian == writeEndian) {
                    offset = TIFFTweaker.copyPages(ifds2, offset, image2, merged);
                } else {
                    IFD prevIFD = null;
                    for (int j = 0; j < ifds2.size(); ++j) {
                        IFD currIFD = (IFD)ifds2.get(j);
                        int bitsPerSample = 1;
                        TiffField<?> f_bitsPerSample = currIFD.getField(TiffTag.BITS_PER_SAMPLE);
                        if (f_bitsPerSample != null) {
                            bitsPerSample = f_bitsPerSample.getDataAsLong()[0];
                        }
                        if (bitsPerSample <= 8) {
                            offset = TIFFTweaker.copyPageData(currIFD, offset, image2, merged);
                        } else if (bitsPerSample % 8 == 0) {
                            TiffField<?> stripByteCounts;
                            ImageDecoder decoder = null;
                            ImageEncoder encoder = null;
                            LongField stripOffSets = currIFD.removeField(TiffTag.STRIP_OFFSETS);
                            if (stripOffSets == null) {
                                stripOffSets = currIFD.removeField(TiffTag.TILE_OFFSETS);
                            }
                            if ((stripByteCounts = currIFD.getField(TiffTag.STRIP_BYTE_COUNTS)) == null) {
                                stripByteCounts = currIFD.getField(TiffTag.TILE_BYTE_COUNTS);
                            }
                            if (stripOffSets != null) {
                                int k;
                                int[] counts = stripByteCounts.getDataAsLong();
                                int[] off = ((TiffField)stripOffSets).getDataAsLong();
                                int[] temp = new int[off.length];
                                int[] uncompressedStripByteCounts = TIFFTweaker.getUncompressedStripByteCounts(currIFD, off.length);
                                merged.seek(offset);
                                TiffField<?> tiffField = currIFD.getField(TiffTag.COMPRESSION);
                                int tiffCompression = 1;
                                if (tiffField != null) {
                                    tiffCompression = tiffField.getDataAsLong()[0];
                                }
                                TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.fromValue(tiffCompression);
                                int samplesPerPixel = 1;
                                tiffField = currIFD.getField(TiffTag.SAMPLES_PER_PIXEL);
                                if (tiffField != null) {
                                    samplesPerPixel = tiffField.getDataAsLong()[0];
                                }
                                int planaryConfiguration = 1;
                                tiffField = currIFD.getField(TiffTag.PLANAR_CONFIGURATTION);
                                if (tiffField != null) {
                                    planaryConfiguration = tiffField.getDataAsLong()[0];
                                }
                                int scanLineStride = TIFFTweaker.getRowWidth(currIFD);
                                if (planaryConfiguration == 1) {
                                    scanLineStride *= samplesPerPixel;
                                }
                                switch (compression) {
                                    case LZW: {
                                        decoder = new LZWTreeDecoder(8, true);
                                        encoder = new LZWTreeEncoder(merged, 8, 4096, null);
                                        break;
                                    }
                                    case DEFLATE: 
                                    case DEFLATE_ADOBE: {
                                        decoder = new DeflateDecoder();
                                        encoder = new DeflateEncoder(merged, 4096, 4, null);
                                        break;
                                    }
                                    case PACKBITS: {
                                        for (k = 0; k < off.length; ++k) {
                                            image2.seek(off[k]);
                                            byte[] buf = new byte[counts[k]];
                                            image2.readFully(buf);
                                            byte[] buf2 = new byte[uncompressedStripByteCounts[k]];
                                            Packbits.unpackbits(buf, buf2);
                                            ArrayUtils.flipEndian(buf2, 0, buf2.length, bitsPerSample, scanLineStride, readEndian == 19789);
                                            buf2 = new byte[buf.length + (buf.length + 127) / 128];
                                            int bytesCompressed = Packbits.packbits(buf, buf2);
                                            merged.write(buf2, 0, bytesCompressed);
                                            temp[k] = offset;
                                            offset += bytesCompressed;
                                        }
                                        break;
                                    }
                                    case NONE: {
                                        if (planaryConfiguration == 1 && off.length == 1 || planaryConfiguration == 2 && off.length == samplesPerPixel) {
                                            int[] totalBytes2Read = TIFFTweaker.getBytes2Read(currIFD);
                                            for (int k2 = 0; k2 < off.length; ++k2) {
                                                counts[k2] = totalBytes2Read[k2];
                                            }
                                        }
                                        for (k = 0; k < off.length; ++k) {
                                            image2.seek(off[k]);
                                            byte[] buf = new byte[counts[k]];
                                            image2.readFully(buf);
                                            buf = ArrayUtils.flipEndian(buf, 0, buf.length, bitsPerSample, scanLineStride, readEndian == 19789);
                                            merged.write(buf);
                                            temp[k] = offset;
                                            offset += buf.length;
                                        }
                                        break;
                                    }
                                    default: {
                                        for (int l = 0; l < off.length; ++l) {
                                            image2.seek(off[l]);
                                            byte[] buf = new byte[counts[l]];
                                            image2.readFully(buf);
                                            merged.write(buf);
                                            temp[l] = offset;
                                            offset += buf.length;
                                        }
                                    }
                                }
                                if (decoder != null) {
                                    for (k = 0; k < off.length; ++k) {
                                        image2.seek(off[k]);
                                        byte[] buf = new byte[counts[k]];
                                        image2.readFully(buf);
                                        decoder.setInput(buf);
                                        int bytesDecompressed = 0;
                                        byte[] decompressed = new byte[uncompressedStripByteCounts[k]];
                                        try {
                                            bytesDecompressed = decoder.decode(decompressed, 0, uncompressedStripByteCounts[k]);
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Failed decoding image", e);
                                            throw new CodecException("Failed decoding image", e);
                                        }
                                        buf = ArrayUtils.flipEndian(decompressed, 0, bytesDecompressed, bitsPerSample, scanLineStride, readEndian == 19789);
                                        try {
                                            encoder.initialize();
                                            encoder.encode(buf, 0, buf.length);
                                            encoder.finish();
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Failed encoding image", e);
                                            throw new CodecException("Failed encoding image", e);
                                        }
                                        temp[k] = offset;
                                        offset += encoder.getCompressedDataLen();
                                    }
                                }
                                stripOffSets = currIFD.getField(TiffTag.STRIP_BYTE_COUNTS) != null ? new LongField(TiffTag.STRIP_OFFSETS.getValue(), temp) : new LongField(TiffTag.TILE_OFFSETS.getValue(), temp);
                                currIFD.addField(stripOffSets);
                            }
                        } else {
                            offset = TIFFTweaker.copyPageData(currIFD, offset, image2, merged);
                        }
                        if (prevIFD != null) {
                            prevIFD.setNextIFDOffset(merged, offset);
                        }
                        offset = currIFD.write(merged, offset);
                        prevIFD = currIFD;
                    }
                }
                ((IFD)ifds1.get(ifds1.size() - 1)).setNextIFDOffset(merged, ((IFD)ifds2.get(0)).getStartOffset());
                ifds1.addAll(ifds2);
                image2.close();
            }
            int maxPageNumber = ifds1.size();
            if (maxPageNumber > 0) {
                for (int i = 0; i < ifds1.size(); ++i) {
                    offset = ((IFD)ifds1.get(i)).getField(TiffTag.PAGE_NUMBER).getDataOffset();
                    merged.seek(offset);
                    merged.writeShort((short)i);
                    merged.writeShort((short)maxPageNumber);
                }
                int firstIFDOffset = ((IFD)ifds1.get(0)).getStartOffset();
                TIFFTweaker.writeToStream(merged, firstIFDOffset);
            }
        }
    }

    public static void mergeTiffImages(RandomAccessInputStream image1, RandomAccessInputStream image2, RandomAccessOutputStream merged) throws IOException {
        int i;
        int offset1 = TIFFTweaker.copyHeader(image1, merged);
        int offset2 = TIFFTweaker.readHeader(image2);
        ArrayList<IFD> ifds1 = new ArrayList<IFD>();
        ArrayList<IFD> ifds2 = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds1, offset1, image1);
        TIFFTweaker.readIFDs(ifds2, offset2, image2);
        int maxPageNumber = ifds1.size() + ifds2.size();
        for (i = 0; i < ifds1.size(); ++i) {
            ((IFD)ifds1.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)ifds1.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)maxPageNumber}));
        }
        for (i = 0; i < ifds2.size(); ++i) {
            ((IFD)ifds2.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)ifds2.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)(i + ifds1.size()), (short)maxPageNumber}));
        }
        int offset = TIFFTweaker.copyPages(ifds1, 8, image1, merged);
        offset = TIFFTweaker.copyPages(ifds2, offset, image2, merged);
        ((IFD)ifds1.get(ifds1.size() - 1)).setNextIFDOffset(merged, ((IFD)ifds2.get(0)).getStartOffset());
        int firstIFDOffset = ((IFD)ifds1.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(merged, firstIFDOffset);
    }

    public static void mergeTiffImages(RandomAccessOutputStream merged, File ... images) throws IOException {
        if (images != null && images.length > 1) {
            FileInputStream fis1 = new FileInputStream(images[0]);
            FileCacheRandomAccessInputStream image1 = new FileCacheRandomAccessInputStream(fis1);
            ArrayList<IFD> ifds1 = new ArrayList<IFD>();
            int offset1 = TIFFTweaker.copyHeader(image1, merged);
            TIFFTweaker.readIFDs(ifds1, offset1, image1);
            for (int i = 0; i < ifds1.size(); ++i) {
                ((IFD)ifds1.get(i)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)ifds1.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
            }
            int offset = TIFFTweaker.copyPages(ifds1, 8, image1, merged);
            ((InputStream)image1).close();
            for (int i = 1; i < images.length; ++i) {
                ArrayList<IFD> ifds2 = new ArrayList<IFD>();
                FileInputStream fis2 = new FileInputStream(images[i]);
                FileCacheRandomAccessInputStream image2 = new FileCacheRandomAccessInputStream(fis2);
                TIFFTweaker.readIFDs(ifds2, image2);
                for (int j = 0; j < ifds2.size(); ++j) {
                    ((IFD)ifds2.get(j)).removeField(TiffTag.PAGE_NUMBER);
                    ((IFD)ifds2.get(j)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
                }
                offset = TIFFTweaker.copyPages(ifds2, offset, image2, merged);
                ((IFD)ifds1.get(ifds1.size() - 1)).setNextIFDOffset(merged, ((IFD)ifds2.get(0)).getStartOffset());
                ifds1.addAll(ifds2);
                ((InputStream)image2).close();
            }
            int maxPageNumber = ifds1.size();
            for (int i = 0; i < ifds1.size(); ++i) {
                offset = ((IFD)ifds1.get(i)).getField(TiffTag.PAGE_NUMBER).getDataOffset();
                merged.seek(offset);
                merged.writeShort((short)i);
                merged.writeShort((short)maxPageNumber);
            }
            int firstIFDOffset = ((IFD)ifds1.get(0)).getStartOffset();
            TIFFTweaker.writeToStream(merged, firstIFDOffset);
        }
    }

    public static void mergeTiffImagesEx(RandomAccessOutputStream merged, File ... images) throws IOException {
        if (images != null && images.length > 1) {
            TIFFTweaker.merge(merged, new File2RandomInputStreamAdaptor(images));
        }
    }

    public static void mergeTiffImagesEx(RandomAccessOutputStream merged, InputStream ... images) throws IOException {
        if (images != null && images.length > 1) {
            TIFFTweaker.merge(merged, new Stream2RandomInputStreamAdaptor(images));
        }
    }

    public static int prepareForInsert(RandomAccessInputStream rin, RandomAccessOutputStream rout, List<IFD> ifds) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (ifds.size() == 1) {
            if (ifds.get(0).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ifds.get(0).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ifds.get(0).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{3}));
        }
        for (int i = 0; i < ifds.size(); ++i) {
            ifds.get(i).removeField(TiffTag.PAGE_NUMBER);
            ifds.get(i).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{0, 0}));
        }
        int writeOffset = 8;
        writeOffset = TIFFTweaker.copyPages(ifds, writeOffset, rin, rout);
        return writeOffset;
    }

    public static int prepareForWrite(RandomAccessOutputStream rout) throws IOException {
        return TIFFTweaker.prepareForWrite(rout, ByteOrder.BIG_ENDIAN);
    }

    public static int prepareForWrite(RandomAccessOutputStream rout, ByteOrder byteOrder) throws IOException {
        if (byteOrder == null) {
            throw new IllegalArgumentException("Input ByteOrder is null");
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            rout.setWriteStrategy(WriteStrategyMM.getInstance());
        } else {
            rout.setWriteStrategy(WriteStrategyII.getInstance());
        }
        return TIFFTweaker.writeHeader(rout);
    }

    public static void printIFDs(Collection<IFD> list, String indent) {
        int id = 0;
        LOGGER.info("Printing IFDs ... ");
        for (IFD currIFD : list) {
            LOGGER.info("IFD #{}", (Object)id);
            TIFFTweaker.printIFD(currIFD, TiffTag.class, indent);
            ++id;
        }
    }

    public static void printIFD(IFD currIFD, Class<? extends Tag> tagClass, String indent) {
        StringBuilder ifd = new StringBuilder();
        TIFFTweaker.print(currIFD, tagClass, indent, ifd);
        LOGGER.info("\n{}", (Object)ifd);
    }

    private static void print(IFD currIFD, Class<? extends Tag> tagClass, String indent, StringBuilder ifds) {
        Method method = null;
        try {
            method = tagClass.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method 'fromShort' is not defined for class " + tagClass);
        }
        catch (SecurityException e) {
            throw new RuntimeException("The operation is not allowed by the current security setup");
        }
        Collection<TiffField<?>> fields = currIFD.getFields();
        int i = 0;
        for (TiffField<?> field : fields) {
            ifds.append(indent);
            ifds.append("Field #" + i + "\n");
            ifds.append(indent);
            short tag = field.getTag();
            Tag ftag = TiffTag.UNKNOWN;
            if (tag == ExifTag.PADDING.getValue()) {
                ftag = ExifTag.PADDING;
            } else {
                try {
                    ftag = (Tag)method.invoke(null, tag);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Illegal access for method: " + method);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Illegal argument for method:  " + method);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Incorrect invocation target");
                }
            }
            if (ftag == TiffTag.UNKNOWN) {
                LOGGER.warn("Tag: {} [Value: 0x{}] (Unknown)", (Object)ftag, (Object)Integer.toHexString(tag & 0xFFFF));
            } else {
                ifds.append("Tag: " + ftag + "\n");
            }
            FieldType ftype = field.getType();
            ifds.append(indent);
            ifds.append("Field type: " + (Object)((Object)ftype) + "\n");
            int field_length = field.getLength();
            ifds.append(indent);
            ifds.append("Field length: " + field_length + "\n");
            ifds.append(indent);
            String tagString = null;
            tagString = ftype == FieldType.SHORT || ftype == FieldType.SSHORT ? ftag.getFieldAsString(field.getDataAsLong()) : ftag.getFieldAsString(field.getData());
            if (StringUtils.isNullOrEmpty(tagString)) {
                ifds.append("Field value: " + field.getDataAsString() + "\n");
            } else {
                ifds.append("Field value: " + tagString + "\n");
            }
            ++i;
        }
        Map<Tag, IFD> children = currIFD.getChildren();
        if (children.get(TiffTag.EXIF_SUB_IFD) != null) {
            ifds.append(indent + "--------- ");
            ifds.append("<<Exif SubIFD starts>>\n");
            TIFFTweaker.print(children.get(TiffTag.EXIF_SUB_IFD), ExifTag.class, indent + "--------- ", ifds);
            ifds.append(indent + "--------- ");
            ifds.append("<<Exif SubIFD ends>>\n");
        }
        if (children.get(TiffTag.GPS_SUB_IFD) != null) {
            ifds.append(indent + "--------- ");
            ifds.append("<<GPS SubIFD starts>>\n");
            TIFFTweaker.print(children.get(TiffTag.GPS_SUB_IFD), GPSTag.class, indent + "--------- ", ifds);
            ifds.append(indent + "--------- ");
            ifds.append("<<GPS SubIFD ends>>\n");
        }
    }

    private static int readHeader(RandomAccessInputStream rin) throws IOException {
        int offset = 0;
        rin.seek(0L);
        short endian = rin.readShort();
        offset += 2;
        if (endian == 19789) {
            rin.setReadStrategy(ReadStrategyMM.getInstance());
        } else if (endian == 18761) {
            rin.setReadStrategy(ReadStrategyII.getInstance());
        } else {
            rin.close();
            throw new RuntimeException("Invalid TIFF byte order");
        }
        rin.seek(offset);
        short tiff_id = rin.readShort();
        offset += 2;
        if (tiff_id != 42) {
            rin.close();
            throw new RuntimeException("Invalid TIFF identifier");
        }
        rin.seek(offset);
        offset = rin.readInt();
        return offset;
    }

    private static int readIFD(RandomAccessInputStream rin, List<IFD> list, int offset, Class<? extends Tag> tagClass, IFD parent, Tag parentTag) throws IOException {
        Method method = null;
        try {
            method = tagClass.getDeclaredMethod("fromShort", Short.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Method 'fromShort' is not defined for class " + tagClass);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Current security doesn't allow this operation");
        }
        IFD tiffIFD = new IFD();
        rin.seek(offset);
        int no_of_fields = rin.readShort();
        offset += 2;
        block25: for (int i = 0; i < no_of_fields; ++i) {
            rin.seek(offset);
            short tag = rin.readShort();
            Tag ftag = TiffTag.UNKNOWN;
            try {
                ftag = (Tag)method.invoke(null, tag);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Illegal access for method: " + method);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Illegal argument for method:  " + method);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Incorrect invocation target");
            }
            rin.seek(offset += 2);
            short type = rin.readShort();
            FieldType ftype = FieldType.fromShort(type);
            rin.seek(offset += 2);
            int field_length = rin.readInt();
            offset += 4;
            switch (ftype) {
                case BYTE: 
                case UNDEFINED: {
                    byte[] data = new byte[field_length];
                    rin.seek(offset);
                    if (field_length <= 4) {
                        rin.readFully(data, 0, field_length);
                    } else {
                        rin.seek(rin.readInt());
                        rin.readFully(data, 0, field_length);
                    }
                    TiffField byteField = null;
                    byteField = ftype == FieldType.BYTE ? new ByteField(tag, data) : new UndefinedField(tag, data);
                    tiffIFD.addField(byteField);
                    offset += 4;
                    continue block25;
                }
                case ASCII: {
                    byte[] data = new byte[field_length];
                    if (field_length <= 4) {
                        rin.seek(offset);
                        rin.readFully(data, 0, field_length);
                    } else {
                        rin.seek(offset);
                        rin.seek(rin.readInt());
                        rin.readFully(data, 0, field_length);
                    }
                    ASCIIField ascIIField = new ASCIIField(tag, new String(data, "UTF-8"));
                    tiffIFD.addField(ascIIField);
                    offset += 4;
                    continue block25;
                }
                case SHORT: {
                    short[] sdata = new short[field_length];
                    if (field_length == 1) {
                        rin.seek(offset);
                        sdata[0] = rin.readShort();
                        offset += 4;
                    } else if (field_length == 2) {
                        rin.seek(offset);
                        sdata[0] = rin.readShort();
                        rin.seek(offset += 2);
                        sdata[1] = rin.readShort();
                        offset += 2;
                    } else {
                        rin.seek(offset);
                        int toOffset = rin.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            rin.seek(toOffset);
                            sdata[j] = rin.readShort();
                            toOffset += 2;
                        }
                    }
                    ShortField shortField = new ShortField(tag, sdata);
                    tiffIFD.addField(shortField);
                    continue block25;
                }
                case LONG: {
                    int[] ldata = new int[field_length];
                    if (field_length == 1) {
                        rin.seek(offset);
                        ldata[0] = rin.readInt();
                        offset += 4;
                    } else {
                        rin.seek(offset);
                        int toOffset = rin.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            rin.seek(toOffset);
                            ldata[j] = rin.readInt();
                            toOffset += 4;
                        }
                    }
                    LongField longField = new LongField(tag, ldata);
                    tiffIFD.addField(longField);
                    if (ftag == TiffTag.EXIF_SUB_IFD && ldata[0] != 0) {
                        try {
                            TIFFTweaker.readIFD(rin, null, ldata[0], ExifTag.class, tiffIFD, TiffTag.EXIF_SUB_IFD);
                        }
                        catch (Exception e) {
                            tiffIFD.removeField(TiffTag.EXIF_SUB_IFD);
                            LOGGER.error("Unable to read TiffTag.EXIF_SUB_IFD", e);
                        }
                        continue block25;
                    }
                    if (ftag == TiffTag.GPS_SUB_IFD && ldata[0] != 0) {
                        try {
                            TIFFTweaker.readIFD(rin, null, ldata[0], GPSTag.class, tiffIFD, TiffTag.GPS_SUB_IFD);
                        }
                        catch (Exception e) {
                            tiffIFD.removeField(TiffTag.GPS_SUB_IFD);
                            LOGGER.error("Unable to read TiffTag.GPS_SUB_IFD", e);
                        }
                        continue block25;
                    }
                    if (ftag == ExifTag.EXIF_INTEROPERABILITY_OFFSET && ldata[0] != 0) {
                        try {
                            TIFFTweaker.readIFD(rin, null, ldata[0], InteropTag.class, tiffIFD, ExifTag.EXIF_INTEROPERABILITY_OFFSET);
                        }
                        catch (Exception e) {
                            tiffIFD.removeField(ExifTag.EXIF_INTEROPERABILITY_OFFSET);
                            LOGGER.error("Unable to read ExifTag.EXIF_INTEROPERABILITY_OFFSET", e);
                        }
                        continue block25;
                    }
                    if (ftag != TiffTag.SUB_IFDS) continue block25;
                    for (int ifd = 0; ifd < ldata.length; ++ifd) {
                        try {
                            TIFFTweaker.readIFD(rin, null, ldata[0], TiffTag.class, tiffIFD, TiffTag.SUB_IFDS);
                            continue;
                        }
                        catch (Exception e) {
                            tiffIFD.removeField(TiffTag.SUB_IFDS);
                            LOGGER.error("Unable to read TiffTag.SUB_IFDS", e);
                        }
                    }
                    continue block25;
                }
                case FLOAT: {
                    float[] fdata = new float[field_length];
                    if (field_length == 1) {
                        rin.seek(offset);
                        fdata[0] = rin.readFloat();
                        offset += 4;
                    } else {
                        rin.seek(offset);
                        int toOffset = rin.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            rin.seek(toOffset);
                            fdata[j] = rin.readFloat();
                            toOffset += 4;
                        }
                    }
                    FloatField floatField = new FloatField(tag, fdata);
                    tiffIFD.addField(floatField);
                    continue block25;
                }
                case DOUBLE: {
                    double[] ddata = new double[field_length];
                    rin.seek(offset);
                    int toOffset = rin.readInt();
                    offset += 4;
                    for (int j = 0; j < field_length; ++j) {
                        rin.seek(toOffset);
                        ddata[j] = rin.readDouble();
                        toOffset += 8;
                    }
                    DoubleField doubleField = new DoubleField(tag, ddata);
                    tiffIFD.addField(doubleField);
                    continue block25;
                }
                case RATIONAL: 
                case SRATIONAL: {
                    int len = 2 * field_length;
                    int[] ldata = new int[len];
                    rin.seek(offset);
                    int toOffset = rin.readInt();
                    offset += 4;
                    for (int j = 0; j < len; j += 2) {
                        rin.seek(toOffset);
                        ldata[j] = rin.readInt();
                        rin.seek(toOffset += 4);
                        ldata[j + 1] = rin.readInt();
                        toOffset += 4;
                    }
                    AbstractRationalField rationalField = null;
                    rationalField = ftype == FieldType.SRATIONAL ? new SRationalField(tag, ldata) : new RationalField(tag, ldata);
                    tiffIFD.addField(rationalField);
                    continue block25;
                }
                case IFD: {
                    int toOffset;
                    int[] ldata = new int[field_length];
                    if (field_length == 1) {
                        rin.seek(offset);
                        ldata[0] = rin.readInt();
                        offset += 4;
                    } else {
                        rin.seek(offset);
                        toOffset = rin.readInt();
                        offset += 4;
                        for (int j = 0; j < field_length; ++j) {
                            rin.seek(toOffset);
                            ldata[j] = rin.readInt();
                            toOffset += 4;
                        }
                    }
                    IFDField ifdField = new IFDField(tag, ldata);
                    tiffIFD.addField(ifdField);
                    for (int ifd = 0; ifd < ldata.length; ++ifd) {
                        TIFFTweaker.readIFD(rin, null, ldata[0], TiffTag.class, tiffIFD, TiffTag.SUB_IFDS);
                    }
                    continue block25;
                }
                default: {
                    offset += 4;
                }
            }
        }
        if (parent != null) {
            parent.addChild(parentTag, tiffIFD);
        } else {
            list.add(tiffIFD);
        }
        rin.seek(offset);
        return rin.readInt();
    }

    private static void readIFDs(List<IFD> list, int offset, RandomAccessInputStream rin) throws IOException {
        while (offset != 0) {
            offset = TIFFTweaker.readIFD(rin, list, offset, TiffTag.class, null, null);
        }
    }

    public static void readIFDs(List<IFD> list, RandomAccessInputStream rin) throws IOException {
        int offset = TIFFTweaker.readHeader(rin);
        TIFFTweaker.readIFDs(list, offset, rin);
    }

    public static Map<MetadataType, Metadata> readMetadata(RandomAccessInputStream rin) throws IOException {
        return TIFFTweaker.readMetadata(rin, 0);
    }

    public static Map<MetadataType, Metadata> readMetadata(RandomAccessInputStream rin, int pageNumber) throws IOException {
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        int offset = TIFFTweaker.readHeader(rin);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD currIFD = (IFD)ifds.get(pageNumber);
        TiffField<?> field = currIFD.getField(TiffTag.ICC_PROFILE);
        if (field != null) {
            metadataMap.put(MetadataType.ICC_PROFILE, new ICCProfile((byte[])field.getData()));
        }
        if ((field = currIFD.getField(TiffTag.XMP)) != null) {
            metadataMap.put(MetadataType.XMP, new TiffXMP((byte[])field.getData()));
        }
        if ((field = currIFD.getField(TiffTag.PHOTOSHOP)) != null) {
            IRB irb = new IRB((byte[])field.getData());
            metadataMap.put(MetadataType.PHOTOSHOP_IRB, irb);
            _8BIM photoshop_8bim = irb.get8BIM(ImageResourceID.IPTC_NAA.getValue());
            if (photoshop_8bim != null) {
                IPTC iptc = new IPTC(photoshop_8bim.getData());
                metadataMap.put(MetadataType.IPTC, iptc);
            }
            if (irb.containsThumbnail()) {
                IRBThumbnail thumbnail = irb.getThumbnail();
                HashMap<String, Thumbnail> thumbnails = new HashMap<String, Thumbnail>(1);
                thumbnails.put("PHOTOSHOP_IRB", thumbnail);
                metadataMap.put(MetadataType.IMAGE, new ImageMetadata(thumbnails));
            }
        }
        if ((field = currIFD.getField(TiffTag.IPTC)) != null) {
            IPTC iptc = (IPTC)metadataMap.get((Object)MetadataType.IPTC);
            byte[] iptcData = null;
            FieldType type = field.getType();
            iptcData = type == FieldType.LONG ? ArrayUtils.toByteArray(field.getDataAsLong(), rin.getEndian() == 19789) : (byte[])field.getData();
            if (iptc != null) {
                iptcData = ArrayUtils.concat(iptcData, new byte[][]{iptc.getData()});
            }
            metadataMap.put(MetadataType.IPTC, new IPTC(iptcData));
        }
        if ((field = currIFD.getField(TiffTag.EXIF_SUB_IFD)) != null) {
            metadataMap.put(MetadataType.EXIF, new TiffExif(currIFD));
        }
        if ((field = currIFD.getField(TiffTag.IMAGE_SOURCE_DATA)) != null) {
            boolean bigEndian = rin.getEndian() == 19789;
            ReadStrategy readStrategy = bigEndian ? ReadStrategyMM.getInstance() : ReadStrategyII.getInstance();
            metadataMap.put(MetadataType.PHOTOSHOP_DDB, new DDB((byte[])field.getData(), readStrategy));
        }
        if ((field = currIFD.getField(TiffTag.IMAGE_DESCRIPTION)) != null) {
            Comments comments = new Comments();
            comments.addComment(field.getDataAsString());
            metadataMap.put(MetadataType.COMMENT, comments);
        }
        return metadataMap;
    }

    public static Map<MetadataType, Metadata> removeMetadata(int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout, MetadataType ... metadataTypes) throws IOException {
        return TIFFTweaker.removeMetadata(new HashSet<MetadataType>(Arrays.asList(metadataTypes)), pageNumber, rin, rout);
    }

    public static Map<MetadataType, Metadata> removeMetadata(RandomAccessInputStream rin, RandomAccessOutputStream rout, MetadataType ... metadataTypes) throws IOException {
        return TIFFTweaker.removeMetadata(0, rin, rout, metadataTypes);
    }

    public static Map<MetadataType, Metadata> removeMetadata(Set<MetadataType> metadataTypes, int pageNumber, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int offset = TIFFTweaker.copyHeader(rin, rout);
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        TIFFTweaker.readIFDs(ifds, offset, rin);
        HashMap<MetadataType, Metadata> metadataMap = new HashMap<MetadataType, Metadata>();
        if (pageNumber < 0 || pageNumber >= ifds.size()) {
            throw new IllegalArgumentException("pageNumber " + pageNumber + " out of bounds: 0 - " + (ifds.size() - 1));
        }
        IFD workingPage = (IFD)ifds.get(pageNumber);
        TiffField<?> metadata = null;
        block8: for (MetadataType metaType : metadataTypes) {
            switch (metaType) {
                case XMP: {
                    TiffField<?> xmpField = workingPage.removeField(TiffTag.XMP);
                    if (xmpField != null) {
                        metadataMap.put(MetadataType.XMP, new TiffXMP((byte[])xmpField.getData()));
                    }
                    if ((metadata = workingPage.removeField(TiffTag.PHOTOSHOP)) == null) break;
                    byte[] data = (byte[])metadata.getData();
                    List<_8BIM> bims = TIFFTweaker.removeMetadataFromIRB(workingPage, data, ImageResourceID.XMP_METADATA);
                    if (bims.size() <= 0 || xmpField != null) continue block8;
                    metadataMap.put(MetadataType.XMP, new TiffXMP(bims.get(0).getData()));
                    break;
                }
                case IPTC: {
                    TiffField<?> iptcField = workingPage.removeField(TiffTag.IPTC);
                    if (iptcField != null) {
                        metadataMap.put(MetadataType.IPTC, new IPTC((byte[])iptcField.getData()));
                    }
                    if ((metadata = workingPage.removeField(TiffTag.PHOTOSHOP)) == null) break;
                    byte[] data = (byte[])metadata.getData();
                    List<_8BIM> bims = TIFFTweaker.removeMetadataFromIRB(workingPage, data, ImageResourceID.IPTC_NAA);
                    if (bims.size() <= 0) continue block8;
                    IPTC iptc = (IPTC)metadataMap.remove((Object)MetadataType.IPTC);
                    if (iptc != null) {
                        byte[] iptcData = ArrayUtils.concat(iptc.getData(), new byte[][]{bims.get(0).getData()});
                        metadataMap.put(MetadataType.IPTC, new IPTC(iptcData));
                        break;
                    }
                    metadataMap.put(MetadataType.IPTC, new IPTC(bims.get(0).getData()));
                    break;
                }
                case ICC_PROFILE: {
                    TiffField<?> iccField = workingPage.removeField(TiffTag.ICC_PROFILE);
                    if (iccField != null) {
                        metadataMap.put(MetadataType.ICC_PROFILE, new ICCProfile((byte[])iccField.getData()));
                    }
                    if ((metadata = workingPage.removeField(TiffTag.PHOTOSHOP)) == null) break;
                    byte[] data = (byte[])metadata.getData();
                    List<_8BIM> bims = TIFFTweaker.removeMetadataFromIRB(workingPage, data, ImageResourceID.ICC_PROFILE);
                    if (bims.size() <= 0 || iccField != null) continue block8;
                    metadataMap.put(MetadataType.ICC_PROFILE, new ICCProfile(bims.get(0).getData()));
                    break;
                }
                case PHOTOSHOP_IRB: {
                    TiffField<?> irbField = workingPage.removeField(TiffTag.PHOTOSHOP);
                    if (irbField == null) break;
                    metadataMap.put(MetadataType.PHOTOSHOP_IRB, new IRB((byte[])irbField.getData()));
                    break;
                }
                case EXIF: {
                    TiffField<?> exifField = workingPage.removeField(TiffTag.EXIF_SUB_IFD);
                    if (exifField != null) {
                        metadataMap.put(MetadataType.EXIF, new TiffExif(workingPage));
                    }
                    workingPage.removeField(TiffTag.GPS_SUB_IFD);
                    metadata = workingPage.removeField(TiffTag.PHOTOSHOP);
                    if (metadata == null) break;
                    byte[] data = (byte[])metadata.getData();
                    List<_8BIM> bims = TIFFTweaker.removeMetadataFromIRB(workingPage, data, ImageResourceID.EXIF_DATA1, ImageResourceID.EXIF_DATA3);
                    if (exifField != null || bims.size() <= 0) continue block8;
                    MemoryCacheRandomAccessInputStream exif = new MemoryCacheRandomAccessInputStream(new ByteArrayInputStream(bims.get(0).getData()));
                    ArrayList<IFD> exifIFDs = new ArrayList<IFD>();
                    TIFFTweaker.readIFDs(exifIFDs, exif);
                    ((InputStream)exif).close();
                    if (exifIFDs.size() <= 0) continue block8;
                    metadataMap.put(MetadataType.EXIF, new TiffExif((IFD)exifIFDs.get(0)));
                    break;
                }
                case COMMENT: {
                    TiffField<?> commentField = workingPage.removeField(TiffTag.IMAGE_DESCRIPTION);
                    if (commentField == null) break;
                    Comments comments = new Comments();
                    comments.addComment(commentField.getDataAsString());
                    metadataMap.put(MetadataType.COMMENT, comments);
                    break;
                }
            }
        }
        offset = TIFFTweaker.copyPages(ifds, offset, rin, rout);
        int firstIFDOffset = ((IFD)ifds.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
        return metadataMap;
    }

    public static Map<MetadataType, Metadata> removeMetadata(Set<MetadataType> metadataTypes, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        return TIFFTweaker.removeMetadata(metadataTypes, 0, rin, rout);
    }

    private static List<_8BIM> removeMetadataFromIRB(IFD workingPage, byte[] data, ImageResourceID ... ids) throws IOException {
        IRB irb = new IRB(data);
        HashMap<Short, _8BIM> bimMap = new HashMap<Short, _8BIM>(irb.get8BIM());
        ArrayList<_8BIM> bimList = new ArrayList<_8BIM>();
        for (ImageResourceID id : ids) {
            _8BIM bim = (_8BIM)bimMap.remove(id.getValue());
            if (bim == null) continue;
            bimList.add(bim);
        }
        if (bimMap.size() > 0) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            for (_8BIM bim : bimMap.values()) {
                bim.write(bout);
            }
            workingPage.addField(new ByteField(TiffTag.PHOTOSHOP.getValue(), bout.toByteArray()));
        }
        return bimList;
    }

    public static int removePages(int startPage, int endPage, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int i;
        if (startPage < 0 || endPage < 0) {
            throw new IllegalArgumentException("Negative start or end page");
        }
        if (startPage > endPage) {
            throw new IllegalArgumentException("Start page is larger than end page");
        }
        ArrayList<IFD> list = new ArrayList<IFD>();
        int offset = TIFFTweaker.copyHeader(rin, rout);
        TIFFTweaker.readIFDs(list, offset, rin);
        int pagesRemoved = 0;
        if (startPage <= list.size() - 1) {
            if (endPage > list.size() - 1) {
                endPage = list.size() - 1;
            }
            for (i = endPage; i >= startPage; --i) {
                if (list.size() <= 1) continue;
                ++pagesRemoved;
                list.remove(i);
            }
        }
        for (i = 0; i < list.size(); ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(list.size() - 1)}));
        }
        int writeOffset = 8;
        offset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
        return pagesRemoved;
    }

    public static int removePages(RandomAccessInputStream rin, RandomAccessOutputStream rout, int ... pages) throws IOException {
        int i;
        ArrayList<IFD> list = new ArrayList<IFD>();
        int offset = TIFFTweaker.copyHeader(rin, rout);
        TIFFTweaker.readIFDs(list, offset, rin);
        int pagesRemoved = 0;
        pages = ArrayUtils.removeDuplicates(pages);
        for (i = pages.length - 1; i >= 0 && pages[i] >= 0; --i) {
            if (list.size() <= 1 || list.size() <= pages[i]) continue;
            ++pagesRemoved;
            list.remove(pages[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(list.size() - 1)}));
        }
        int writeOffset = 8;
        offset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
        return pagesRemoved;
    }

    public static int retainPages(int startPage, int endPage, RandomAccessInputStream rin, RandomAccessOutputStream rout) throws IOException {
        int i;
        if (startPage < 0 || endPage < 0) {
            throw new IllegalArgumentException("Negative start or end page");
        }
        if (startPage > endPage) {
            throw new IllegalArgumentException("Start page is larger than end page");
        }
        ArrayList<IFD> list = new ArrayList<IFD>();
        int offset = TIFFTweaker.copyHeader(rin, rout);
        TIFFTweaker.readIFDs(list, offset, rin);
        int pagesRetained = list.size();
        ArrayList newList = new ArrayList();
        if (startPage <= list.size() - 1) {
            if (endPage > list.size() - 1) {
                endPage = list.size() - 1;
            }
            for (i = endPage; i >= startPage; --i) {
                newList.add(list.get(i));
            }
        }
        if (newList.size() > 0) {
            pagesRetained = newList.size();
            list.retainAll(newList);
        }
        for (i = 0; i < list.size(); ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(list.size() - 1)}));
        }
        int writeOffset = 8;
        offset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
        return pagesRetained;
    }

    public static int retainPages(RandomAccessInputStream rin, RandomAccessOutputStream rout, int ... pages) throws IOException {
        int i;
        ArrayList<IFD> list = new ArrayList<IFD>();
        int offset = TIFFTweaker.copyHeader(rin, rout);
        TIFFTweaker.readIFDs(list, offset, rin);
        int pagesRetained = list.size();
        ArrayList newList = new ArrayList();
        Arrays.sort(pages);
        for (i = pages.length - 1; i >= 0; --i) {
            if (pages[i] < 0 || pages[i] >= list.size()) continue;
            newList.add(list.get(pages[i]));
        }
        if (newList.size() > 0) {
            pagesRetained = newList.size();
            list.retainAll(newList);
        }
        for (i = 0; i < list.size(); ++i) {
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)i, (short)(list.size() - 1)}));
        }
        int writeOffset = 8;
        offset = TIFFTweaker.copyPages(list, writeOffset, rin, rout);
        int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
        return pagesRetained;
    }

    public static void splitPages(RandomAccessInputStream rin, List<byte[]> outputFilesByte) throws IOException {
        ArrayList<IFD> list = new ArrayList<IFD>();
        short endian = rin.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (endian == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        rin.seek(0L);
        int offset = TIFFTweaker.readHeader(rin);
        TIFFTweaker.readIFDs(list, offset, rin);
        for (int i = 0; i < list.size(); ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MemoryCacheRandomAccessOutputStream rout = new MemoryCacheRandomAccessOutputStream(baos);
            rout.setWriteStrategy(writeStrategy);
            int writeOffset = TIFFTweaker.writeHeader(rout);
            int firstIFDOffset = writeOffset = TIFFTweaker.copyPageData((IFD)list.get(i), writeOffset, rin, rout);
            if (((IFD)list.get(i)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)list.get(i)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{1}));
            writeOffset = ((IFD)list.get(i)).write(rout, writeOffset);
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
            ((RandomAccessOutputStream)rout).close();
            byte[] byteData = baos.toByteArray();
            LOGGER.debug("File " + i + " has byte size: " + byteData.length / 1024 + " kb");
            outputFilesByte.add(byteData);
        }
    }

    public static void splitPages(RandomAccessInputStream rin, String outputFilePrefix) throws IOException {
        ArrayList<IFD> list = new ArrayList<IFD>();
        short endian = rin.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (endian == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        rin.seek(0L);
        int offset = TIFFTweaker.readHeader(rin);
        TIFFTweaker.readIFDs(list, offset, rin);
        String fileNamePrefix = "page_#";
        if (!StringUtils.isNullOrEmpty(outputFilePrefix)) {
            fileNamePrefix = outputFilePrefix + "_" + fileNamePrefix;
        }
        for (int i = 0; i < list.size(); ++i) {
            FileCacheRandomAccessOutputStream rout = new FileCacheRandomAccessOutputStream(new FileOutputStream(fileNamePrefix + i + ".tif"));
            rout.setWriteStrategy(writeStrategy);
            int writeOffset = TIFFTweaker.writeHeader(rout);
            int firstIFDOffset = writeOffset = TIFFTweaker.copyPageData((IFD)list.get(i), writeOffset, rin, rout);
            if (((IFD)list.get(i)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                ((IFD)list.get(i)).removeField(TiffTag.NEW_SUBFILE_TYPE);
            }
            ((IFD)list.get(i)).removeField(TiffTag.PAGE_NUMBER);
            ((IFD)list.get(i)).addField(new ShortField(TiffTag.SUBFILE_TYPE.getValue(), new short[]{1}));
            writeOffset = ((IFD)list.get(i)).write(rout, writeOffset);
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
            ((RandomAccessOutputStream)rout).close();
        }
    }

    public static void splitPages(RandomAccessInputStream rin, String outputFilePrefix, int size) throws IOException {
        if (size <= 0) {
            throw new IllegalArgumentException("Negative size specified");
        }
        if (size == 1) {
            TIFFTweaker.splitPages(rin, outputFilePrefix);
        }
        ArrayList<IFD> list = new ArrayList<IFD>();
        short endian = rin.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (endian == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        rin.seek(0L);
        int offset = TIFFTweaker.readHeader(rin);
        TIFFTweaker.readIFDs(list, offset, rin);
        String fileNamePrefix = "image_#";
        if (!StringUtils.isNullOrEmpty(outputFilePrefix)) {
            fileNamePrefix = outputFilePrefix + "_" + fileNamePrefix;
        }
        if (list.size() <= size) {
            return;
        }
        int partition = list.size() / size;
        int leftOver = list.size() % size;
        int fromIndex = 0;
        for (int i = 0; i < partition; ++i) {
            FileCacheRandomAccessOutputStream rout = new FileCacheRandomAccessOutputStream(new FileOutputStream(fileNamePrefix + i + ".tif"));
            rout.setWriteStrategy(writeStrategy);
            int writeOffset = TIFFTweaker.writeHeader(rout);
            for (int j = 0; j < size; ++j) {
                writeOffset = TIFFTweaker.copyPageData((IFD)list.get(fromIndex + j), writeOffset, rin, rout);
            }
            int firstIFDOffset = writeOffset;
            for (int k = 0; k < size; ++k) {
                if (((IFD)list.get(fromIndex + k)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)list.get(fromIndex + k)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)list.get(fromIndex + k)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)k, (short)size}));
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                writeOffset = ((IFD)list.get(fromIndex + k)).write(rout, writeOffset);
            }
            for (int l = 0; l < size - 1; ++l) {
                ((IFD)list.get(fromIndex + l)).setNextIFDOffset(rout, ((IFD)list.get(fromIndex + l + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
            ((RandomAccessOutputStream)rout).close();
            fromIndex += size;
        }
        if (leftOver > 0) {
            FileCacheRandomAccessOutputStream rout = new FileCacheRandomAccessOutputStream(new FileOutputStream(fileNamePrefix + partition + ".tif"));
            rout.setWriteStrategy(writeStrategy);
            int writeOffset = TIFFTweaker.writeHeader(rout);
            for (int j = 0; j < leftOver; ++j) {
                writeOffset = TIFFTweaker.copyPageData((IFD)list.get(fromIndex + j), writeOffset, rin, rout);
            }
            int firstIFDOffset = writeOffset;
            for (int k = 0; k < leftOver; ++k) {
                if (((IFD)list.get(fromIndex + k)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)list.get(fromIndex + k)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)list.get(fromIndex + k)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)k, (short)size}));
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                writeOffset = ((IFD)list.get(fromIndex + k)).write(rout, writeOffset);
            }
            for (int l = 0; l < leftOver - 1; ++l) {
                ((IFD)list.get(fromIndex + l)).setNextIFDOffset(rout, ((IFD)list.get(fromIndex + l + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
            ((RandomAccessOutputStream)rout).close();
        }
    }

    public static void splitPages(RandomAccessInputStream rin, List<byte[]> outputFilesByte, int size) throws IOException {
        if (size <= 0) {
            throw new IllegalArgumentException("Negative size specified");
        }
        if (size == 1) {
            TIFFTweaker.splitPages(rin, outputFilesByte);
        }
        ArrayList<IFD> list = new ArrayList<IFD>();
        short endian = rin.readShort();
        WriteStrategy writeStrategy = WriteStrategyMM.getInstance();
        if (endian == 18761) {
            writeStrategy = WriteStrategyII.getInstance();
        }
        rin.seek(0L);
        int offset = TIFFTweaker.readHeader(rin);
        TIFFTweaker.readIFDs(list, offset, rin);
        if (list.size() <= size) {
            return;
        }
        int partition = list.size() / size;
        int leftOver = list.size() % size;
        int fromIndex = 0;
        for (int i = 0; i < partition; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileCacheRandomAccessOutputStream rout = new FileCacheRandomAccessOutputStream(baos);
            rout.setWriteStrategy(writeStrategy);
            int writeOffset = TIFFTweaker.writeHeader(rout);
            for (int j = 0; j < size; ++j) {
                writeOffset = TIFFTweaker.copyPageData((IFD)list.get(fromIndex + j), writeOffset, rin, rout);
            }
            int firstIFDOffset = writeOffset;
            for (int k = 0; k < size; ++k) {
                if (((IFD)list.get(fromIndex + k)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)list.get(fromIndex + k)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)list.get(fromIndex + k)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)k, (short)size}));
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                writeOffset = ((IFD)list.get(fromIndex + k)).write(rout, writeOffset);
            }
            for (int l = 0; l < size - 1; ++l) {
                ((IFD)list.get(fromIndex + l)).setNextIFDOffset(rout, ((IFD)list.get(fromIndex + l + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
            ((RandomAccessOutputStream)rout).close();
            byte[] byteData = baos.toByteArray();
            LOGGER.debug("File " + i + " has byte size: " + byteData.length / 1024 + " kb");
            outputFilesByte.add(byteData);
            fromIndex += size;
        }
        if (leftOver > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileCacheRandomAccessOutputStream rout = new FileCacheRandomAccessOutputStream(baos);
            rout.setWriteStrategy(writeStrategy);
            int writeOffset = TIFFTweaker.writeHeader(rout);
            for (int j = 0; j < leftOver; ++j) {
                writeOffset = TIFFTweaker.copyPageData((IFD)list.get(fromIndex + j), writeOffset, rin, rout);
            }
            int firstIFDOffset = writeOffset;
            for (int k = 0; k < leftOver; ++k) {
                if (((IFD)list.get(fromIndex + k)).removeField(TiffTag.SUBFILE_TYPE) == null) {
                    ((IFD)list.get(fromIndex + k)).removeField(TiffTag.NEW_SUBFILE_TYPE);
                }
                ((IFD)list.get(fromIndex + k)).removeField(TiffTag.PAGE_NUMBER);
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)k, (short)size}));
                ((IFD)list.get(fromIndex + k)).addField(new ShortField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new short[]{2}));
                writeOffset = ((IFD)list.get(fromIndex + k)).write(rout, writeOffset);
            }
            for (int l = 0; l < leftOver - 1; ++l) {
                ((IFD)list.get(fromIndex + l)).setNextIFDOffset(rout, ((IFD)list.get(fromIndex + l + 1)).getStartOffset());
            }
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
            ((RandomAccessOutputStream)rout).close();
            byte[] byteData = baos.toByteArray();
            LOGGER.debug("File " + partition + " has byte size: " + byteData.length / 1024 + " kb");
            outputFilesByte.add(byteData);
        }
    }

    public static void write(TIFFImage tiffImage, RandomAccessOutputStream rout) throws IOException {
        RandomAccessInputStream rin = tiffImage.getInputStream();
        int offset = TIFFTweaker.writeHeader(rout);
        offset = TIFFTweaker.copyPages(tiffImage.getIFDs(), offset, rin, rout);
        int firstIFDOffset = tiffImage.getIFDs().get(0).getStartOffset();
        TIFFTweaker.writeToStream(rout, firstIFDOffset);
    }

    private static int writeHeader(RandomAccessOutputStream rout) throws IOException {
        short endian = rout.getEndian();
        rout.writeShort(endian);
        rout.writeShort(42);
        return 8;
    }

    public static void writeMultipageTIFF(RandomAccessOutputStream rout, BufferedImage ... images) throws IOException {
        TIFFTweaker.writeMultipageTIFF(rout, images, (ImageParam[])null);
    }

    public static void writeMultipageTIFF(RandomAccessOutputStream rout, ImageFrame ... frames) throws IOException {
        int i;
        TIFFOptions options;
        if (frames == null || frames.length == 0) {
            throw new IllegalArgumentException("Input ImageFrame array is null or empty");
        }
        ImageParam param = frames[0].getFrameParam();
        if (param != null && (options = (TIFFOptions)param.getImageOptions()) != null) {
            ByteOrder byteOrder = options.getByteOrder();
            if (byteOrder == ByteOrder.BIG_ENDIAN) {
                rout.setWriteStrategy(WriteStrategyMM.getInstance());
            } else {
                rout.setWriteStrategy(WriteStrategyII.getInstance());
            }
        }
        int writeOffset = TIFFTweaker.writeHeader(rout);
        int pageNumber = 0;
        int maxPageNumber = frames.length;
        ArrayList<IFD> list = new ArrayList<IFD>(frames.length);
        TIFFWriter writer = new TIFFWriter();
        for (i = 0; i < frames.length; ++i) {
            BufferedImage frame = frames[i].getFrame();
            param = frames[i].getFrameParam();
            try {
                writer.setImageParam(param);
                writeOffset = writer.writePage(frame, pageNumber++, maxPageNumber, rout, writeOffset);
                list.add(writer.getIFD());
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed writing page " + pageNumber, e);
                throw new PageWritingException("Failed writing page " + pageNumber, e);
            }
        }
        for (i = 0; i < list.size() - 1; ++i) {
            ((IFD)list.get(i)).setNextIFDOffset(rout, ((IFD)list.get(i + 1)).getStartOffset());
        }
        if (list.size() > 0) {
            int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
        }
    }

    public static void writeMultipageTIFF(RandomAccessOutputStream rout, BufferedImage[] images, ImageParam ... imageParams) throws IOException {
        int i;
        Object[] params = null;
        if (imageParams == null || imageParams.length == 0) {
            params = new ImageParam[images.length];
            Arrays.fill(params, ImageParam.DEFAULT_IMAGE_PARAM);
        } else if (images.length > imageParams.length && imageParams.length > 0) {
            params = new ImageParam[images.length];
            System.arraycopy(imageParams, 0, params, 0, imageParams.length);
            Arrays.fill(params, imageParams.length, images.length, imageParams[imageParams.length - 1]);
        } else {
            params = imageParams;
        }
        TIFFOptions options = (TIFFOptions)((ImageParam)params[0]).getImageOptions();
        if (options != null) {
            ByteOrder byteOrder = options.getByteOrder();
            if (byteOrder == ByteOrder.BIG_ENDIAN) {
                rout.setWriteStrategy(WriteStrategyMM.getInstance());
            } else {
                rout.setWriteStrategy(WriteStrategyII.getInstance());
            }
        }
        int writeOffset = TIFFTweaker.writeHeader(rout);
        int pageNumber = 0;
        int maxPageNumber = images.length;
        ArrayList<IFD> list = new ArrayList<IFD>(images.length);
        TIFFWriter writer = new TIFFWriter();
        for (i = 0; i < images.length; ++i) {
            try {
                writer.setImageParam((ImageParam)params[i]);
                writeOffset = writer.writePage(images[i], pageNumber++, maxPageNumber, rout, writeOffset);
                list.add(writer.getIFD());
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Failed writing page " + pageNumber, e);
                throw new PageWritingException("Failed writing page " + pageNumber, e);
            }
        }
        for (i = 0; i < list.size() - 1; ++i) {
            ((IFD)list.get(i)).setNextIFDOffset(rout, ((IFD)list.get(i + 1)).getStartOffset());
        }
        if (list.size() > 0) {
            int firstIFDOffset = ((IFD)list.get(0)).getStartOffset();
            TIFFTweaker.writeToStream(rout, firstIFDOffset);
        }
    }

    public static int writePage(BufferedImage image, RandomAccessOutputStream rout, List<IFD> ifds, int writeOffset, TIFFWriter writer) throws IOException {
        try {
            writeOffset = writer.writePage(image, 0, 0, rout, writeOffset);
            ifds.add(writer.getIFD());
        }
        catch (Exception e) {
            LOGGER.error("Failed writing page", e);
            throw new PageWritingException("Failed writing page", e);
        }
        return writeOffset;
    }

    public static int writePage(ImageFrame page, RandomAccessOutputStream rout, List<IFD> ifds, int writeOffset, TIFFWriter writer) throws IOException {
        BufferedImage image = page.getFrame();
        writer.setImageParam(page.getFrameParam());
        return TIFFTweaker.writePage(image, rout, ifds, writeOffset, writer);
    }

    private static void writeToStream(RandomAccessOutputStream rout, int firstIFDOffset) throws IOException {
        rout.seek(4L);
        rout.writeInt(firstIFDOffset);
        rout.seek(0L);
        rout.writeToStream(rout.getLength());
    }
}

