/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.tiff;

import guilibshadow.cafe4j.image.tiff.FieldType;
import guilibshadow.cafe4j.image.tiff.Tag;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.cafe4j.string.StringUtils;
import java.io.IOException;

public abstract class TiffField<T>
implements Comparable<TiffField<?>> {
    private final short tag;
    private final FieldType fieldType;
    private final int length;
    protected T data;
    protected static final int MAX_STRING_REPR_LEN = 10;
    protected int dataOffset;

    public TiffField(short tag, FieldType fieldType, int length) {
        this.tag = tag;
        this.fieldType = fieldType;
        this.length = length;
    }

    @Override
    public int compareTo(TiffField<?> that) {
        return (this.tag & 0xFFFF) - (that.tag & 0xFFFF);
    }

    public T getData() {
        return this.data;
    }

    public int[] getDataAsLong() {
        throw new UnsupportedOperationException("getDataAsLong() method is only supported by short, long, and rational data types");
    }

    public abstract String getDataAsString();

    public int getLength() {
        return this.length;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public short getTag() {
        return this.tag;
    }

    public FieldType getType() {
        return this.fieldType;
    }

    public String toString() {
        short tag = this.getTag();
        Tag tagEnum = TiffTag.fromShort(tag);
        if (tagEnum != TiffTag.UNKNOWN) {
            return tagEnum.toString();
        }
        return tagEnum.toString() + " [TiffTag value: " + StringUtils.shortToHexStringMM(tag) + "]";
    }

    public final int write(RandomAccessOutputStream os, int toOffset) throws IOException {
        os.writeShort(this.tag);
        os.writeShort(this.getType().getValue());
        os.writeInt(this.getLength());
        return this.writeData(os, toOffset);
    }

    protected abstract int writeData(RandomAccessOutputStream var1, int var2) throws IOException;
}

