/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.util;

public class BytePacker {
    private static final short[] mask = new short[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private int bits;
    private int stride;
    int index;
    private byte[] packedBytes;
    int empty_bits;
    int strideCounter = 0;

    public BytePacker(int bits, int stride, int len) {
        this.reset(bits, stride, len);
    }

    public byte[] getPackedBytes() {
        return this.packedBytes;
    }

    public void packByte(int abyte) {
        if (this.empty_bits >= this.bits) {
            int n = this.index;
            this.packedBytes[n] = (byte)(this.packedBytes[n] | (abyte & mask[this.bits]) << this.empty_bits - this.bits);
            this.empty_bits -= this.bits;
        } else {
            int n = this.index++;
            this.packedBytes[n] = (byte)(this.packedBytes[n] | abyte >> this.bits - this.empty_bits & mask[this.empty_bits]);
            int n2 = this.index;
            this.packedBytes[n2] = (byte)(this.packedBytes[n2] | (abyte & mask[this.bits - this.empty_bits]) << 8 - this.bits + this.empty_bits);
            this.empty_bits += 8 - this.bits;
        }
        if (++this.strideCounter % this.stride == 0 || this.empty_bits == 0) {
            ++this.index;
            this.empty_bits = 8;
        }
    }

    public void reset(int bits, int stride, int len) {
        if (bits >= 8 || bits <= 0) {
            throw new IllegalArgumentException("Invalid value of bits: " + bits);
        }
        this.bits = bits;
        this.stride = stride;
        int bitsPerStride = bits * stride;
        int numOfStrides = len / stride;
        this.packedBytes = new byte[(bitsPerStride + 7 >> 3) * numOfStrides];
        this.index = 0;
        this.empty_bits = 8;
        this.strideCounter = 0;
    }
}

