/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.util;

public class DCT {
    private static final float BETA1 = 1.4142135f;
    private static final float BETA2 = 2.6131258f;
    private static final float BETA3 = 1.4142135f;
    private static final float BETA4 = 1.0823922f;
    private static final float BETA5 = 0.76536685f;
    private static final float[] AANscaleFactor = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
    private static final float[][] MULTIPLIER = new float[8][8];

    private DCT() {
    }

    public static float[][] forwardDCT(float[][] input) {
        float z13;
        float z11;
        float z3;
        float z4;
        float z2;
        float z5;
        float z1;
        float tmp12;
        float tmp11;
        float tmp13;
        float tmp10;
        float tmp4;
        float tmp3;
        float tmp5;
        float tmp2;
        float tmp6;
        float tmp1;
        float tmp7;
        float tmp0;
        int i;
        for (i = 0; i < 8; ++i) {
            tmp0 = input[i][0] + input[i][7];
            tmp7 = input[i][0] - input[i][7];
            tmp1 = input[i][1] + input[i][6];
            tmp6 = input[i][1] - input[i][6];
            tmp2 = input[i][2] + input[i][5];
            tmp5 = input[i][2] - input[i][5];
            tmp3 = input[i][3] + input[i][4];
            tmp4 = input[i][3] - input[i][4];
            tmp10 = tmp0 + tmp3;
            tmp13 = tmp0 - tmp3;
            tmp11 = tmp1 + tmp2;
            tmp12 = tmp1 - tmp2;
            input[i][0] = tmp10 + tmp11;
            input[i][4] = tmp10 - tmp11;
            z1 = (tmp12 + tmp13) * 0.70710677f;
            input[i][2] = tmp13 + z1;
            input[i][6] = tmp13 - z1;
            tmp10 = tmp4 + tmp5;
            tmp11 = tmp5 + tmp6;
            tmp12 = tmp6 + tmp7;
            z5 = (tmp10 - tmp12) * 0.38268343f;
            z2 = 0.5411961f * tmp10 + z5;
            z4 = 1.306563f * tmp12 + z5;
            z3 = tmp11 * 0.70710677f;
            z11 = tmp7 + z3;
            z13 = tmp7 - z3;
            input[i][5] = z13 + z2;
            input[i][3] = z13 - z2;
            input[i][1] = z11 + z4;
            input[i][7] = z11 - z4;
        }
        for (i = 0; i < 8; ++i) {
            tmp0 = input[0][i] + input[7][i];
            tmp7 = input[0][i] - input[7][i];
            tmp1 = input[1][i] + input[6][i];
            tmp6 = input[1][i] - input[6][i];
            tmp2 = input[2][i] + input[5][i];
            tmp5 = input[2][i] - input[5][i];
            tmp3 = input[3][i] + input[4][i];
            tmp4 = input[3][i] - input[4][i];
            tmp10 = tmp0 + tmp3;
            tmp13 = tmp0 - tmp3;
            tmp11 = tmp1 + tmp2;
            tmp12 = tmp1 - tmp2;
            input[0][i] = (tmp10 + tmp11) * MULTIPLIER[0][i];
            input[4][i] = (tmp10 - tmp11) * MULTIPLIER[4][i];
            z1 = (tmp12 + tmp13) * 0.70710677f;
            input[2][i] = (tmp13 + z1) * MULTIPLIER[2][i];
            input[6][i] = (tmp13 - z1) * MULTIPLIER[6][i];
            tmp10 = tmp4 + tmp5;
            tmp11 = tmp5 + tmp6;
            tmp12 = tmp6 + tmp7;
            z5 = (tmp10 - tmp12) * 0.38268343f;
            z2 = 0.5411961f * tmp10 + z5;
            z4 = 1.306563f * tmp12 + z5;
            z3 = tmp11 * 0.70710677f;
            z11 = tmp7 + z3;
            z13 = tmp7 - z3;
            input[5][i] = (z13 + z2) * MULTIPLIER[5][i];
            input[3][i] = (z13 - z2) * MULTIPLIER[3][i];
            input[1][i] = (z11 + z4) * MULTIPLIER[1][i];
            input[7][i] = (z11 - z4) * MULTIPLIER[7][i];
        }
        return input;
    }

    public static float[][] inverseDCT(float[][] input) {
        int i;
        for (i = 0; i < 8; ++i) {
            DCT.inverseDCT_col(input, i * 8);
        }
        for (i = 0; i < 8; ++i) {
            DCT.inverseDCT_row(input, i++);
        }
        return input;
    }

    private static void inverseDCT_col(float[][] input, int offset) {
        float tmp0 = input[0][offset] + input[4][offset];
        float tmp1 = input[0][offset] - input[4][offset];
        float tmp3 = input[2][offset] + input[6][offset];
        float tmp2 = (input[2][offset] - input[6][offset]) * 1.4142135f - tmp3;
        float tmp4 = input[5][offset] - input[3][offset];
        float tmp5 = input[1][offset] + input[7][offset];
        float tmp6 = input[1][offset] - input[7][offset];
        float tmp7 = input[5][offset] + input[3][offset];
        float temp5 = tmp5 - tmp7;
        tmp7 = tmp5 + tmp7;
        float temp = (tmp4 - tmp6) * 0.76536685f;
        tmp4 = -tmp4 * 2.6131258f + temp;
        tmp6 = tmp6 * 1.0823922f - temp;
        tmp5 = temp5 * 1.4142135f;
        float temp0 = tmp0 + tmp3;
        float temp3 = tmp0 - tmp3;
        float temp1 = tmp1 + tmp2;
        float temp2 = tmp1 - tmp2;
        tmp4 = -(tmp4 + (tmp5 -= (tmp6 -= tmp7)));
        input[0][offset] = temp0 + tmp7;
        input[7][offset] = temp0 - tmp7;
        input[1][offset] = temp1 + tmp6;
        input[6][offset] = temp1 - tmp6;
        input[2][offset] = temp2 + tmp5;
        input[5][offset] = temp2 - tmp5;
        input[3][offset] = temp3 + tmp4;
        input[4][offset] = temp3 - tmp4;
    }

    private static void inverseDCT_row(float[][] input, int offset) {
        float tmp0 = input[offset][0] + input[offset][4];
        float tmp1 = input[offset][0] - input[offset][4];
        float tmp3 = input[offset][2] + input[offset][6];
        float tmp2 = (input[offset][2] - input[offset][6]) * 1.4142135f - tmp3;
        float tmp4 = input[offset][5] - input[offset][3];
        float tmp5 = input[offset][1] + input[offset][7];
        float tmp6 = input[offset][1] - input[offset][7];
        float tmp7 = input[offset][5] + input[offset][3];
        float temp5 = tmp5 - tmp7;
        tmp7 = tmp5 + tmp7;
        float temp = (tmp4 - tmp6) * 0.76536685f;
        tmp4 = -tmp4 * 2.6131258f + temp;
        tmp6 = tmp6 * 1.0823922f - temp;
        tmp5 = temp5 * 1.4142135f;
        float temp0 = tmp0 + tmp3;
        float temp3 = tmp0 - tmp3;
        float temp1 = tmp1 + tmp2;
        float temp2 = tmp1 - tmp2;
        tmp4 = -(tmp4 + (tmp5 -= (tmp6 -= tmp7)));
        input[offset][0] = (temp0 + tmp7) * MULTIPLIER[offset][0];
        input[offset][7] = (temp0 - tmp7) * MULTIPLIER[offset][7];
        input[offset][1] = (temp1 + tmp6) * MULTIPLIER[offset][1];
        input[offset][6] = (temp1 - tmp6) * MULTIPLIER[offset][6];
        input[offset][2] = (temp2 + tmp5) * MULTIPLIER[offset][2];
        input[offset][5] = (temp2 - tmp5) * MULTIPLIER[offset][5];
        input[offset][3] = (temp3 + tmp4) * MULTIPLIER[offset][3];
        input[offset][4] = (temp3 - tmp4) * MULTIPLIER[offset][4];
    }

    static {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                DCT.MULTIPLIER[i][j] = 1.0f / (AANscaleFactor[i] * AANscaleFactor[j] * 8.0f);
            }
        }
    }
}

