/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.util;

import guilibshadow.cafe4j.image.ImageIO;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.meta.adobe.ImageResourceID;
import guilibshadow.cafe4j.image.meta.adobe._8BIM;
import guilibshadow.cafe4j.image.quant.NeuQuant;
import guilibshadow.cafe4j.image.quant.QuantMethod;
import guilibshadow.cafe4j.image.quant.WuQuant;
import guilibshadow.cafe4j.image.util.InverseColorMap;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.io.PeekHeadInputStream;
import guilibshadow.cafe4j.io.RandomAccessInputStream;
import guilibshadow.cafe4j.util.IntHashtable;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class IMGUtils {
    private static byte[] BM = new byte[]{66, 77};
    private static byte[] GIF = new byte[]{71, 73, 70, 56};
    private static byte[] PNG = new byte[]{-119, 80, 78, 71};
    private static byte[] TIFF_II = new byte[]{73, 73, 42, 0};
    private static byte[] TIFF_MM = new byte[]{77, 77, 0, 42};
    private static byte[] JPG = new byte[]{-1, -40, -1};
    private static byte[] PCX = new byte[]{10};
    private static byte[] JPG2000 = new byte[]{0, 0, 0, 12};
    private static float GAMMA = 0.45455f;
    private static float DISPLAY_EXPONENT = 1.8f;
    private static final Logger LOGGER = LoggerFactory.getLogger(IMGUtils.class);

    public static int[] checkColorDepth(int[] rgbTriplets, byte[] newPixels, int[] colorPalette) {
        int index = 0;
        int temp = 0;
        int bitsPerPixel = 1;
        int transparent_index = -1;
        int transparent_color = -1;
        int[] colorInfo = new int[2];
        IntHashtable<Integer> rgbHash = new IntHashtable<Integer>(1023);
        for (int i = 0; i < rgbTriplets.length; ++i) {
            Integer entry;
            temp = rgbTriplets[i] & 0xFFFFFF;
            if (rgbTriplets[i] >>> 24 == 0) {
                if (transparent_index < 0) {
                    transparent_index = index;
                    transparent_color = temp;
                }
                temp = Integer.MAX_VALUE;
            }
            if ((entry = (Integer)rgbHash.get(temp)) != null) {
                newPixels[i] = entry.byteValue();
                continue;
            }
            if (index > 255) {
                colorInfo[0] = 24;
                return colorInfo;
            }
            rgbHash.put(temp, index);
            newPixels[i] = (byte)index;
            colorPalette[index++] = 0xFF000000 | temp;
        }
        if (transparent_index >= 0) {
            colorPalette[transparent_index] = transparent_color;
        }
        while (1 << bitsPerPixel < index) {
            ++bitsPerPixel;
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = transparent_index;
        return colorInfo;
    }

    public static byte[] createGammaTable(float gamma, float displayExponent) {
        int size = 256;
        byte[] gammaTable = new byte[size];
        double decodingExponent = 1.0 / ((double)gamma * (double)displayExponent);
        for (int i = 0; i < size; ++i) {
            gammaTable[i] = (byte)(Math.pow((double)i / (double)(size - 1), decodingExponent) * (double)(size - 1));
        }
        return gammaTable;
    }

    public static void correctGamma(int[] rgbColorPalette, byte[] gammaTable) {
        for (int i = 0; i < rgbColorPalette.length; ++i) {
            byte red = gammaTable[(rgbColorPalette[i] & 0xFF0000) >> 16];
            byte green = gammaTable[(rgbColorPalette[i] & 0xFF00) >> 8];
            byte blue = gammaTable[rgbColorPalette[i] & 0xFF];
            rgbColorPalette[i] = rgbColorPalette[i] & 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        }
    }

    public static BufferedImage createThumbnail(InputStream is) throws IOException {
        BufferedImage original = null;
        if (is instanceof RandomAccessInputStream) {
            RandomAccessInputStream rin = (RandomAccessInputStream)is;
            long streamPointer = rin.getStreamPointer();
            rin.seek(streamPointer);
            original = javax.imageio.ImageIO.read(rin);
            if (original == null) {
                rin.seek(streamPointer);
                try {
                    original = ImageIO.read(rin);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            rin.seek(streamPointer);
        } else {
            original = javax.imageio.ImageIO.read(is);
        }
        int imageWidth = original.getWidth();
        int imageHeight = original.getHeight();
        int thumbnailWidth = 160;
        int thumbnailHeight = 120;
        if (imageWidth < imageHeight) {
            int temp = thumbnailWidth;
            thumbnailWidth = thumbnailHeight;
            thumbnailHeight = temp;
        }
        if (imageWidth < thumbnailWidth) {
            thumbnailWidth = imageWidth;
        }
        if (imageHeight < thumbnailHeight) {
            thumbnailHeight = imageHeight;
        }
        return IMGUtils.getScaledInstance(original, thumbnailWidth, thumbnailHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
    }

    public static _8BIM createThumbnail8BIM(BufferedImage thumbnail) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ImageWriter writer = ImageIO.getWriter(ImageType.JPG);
        try {
            writer.write(thumbnail, bout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] data = bout.toByteArray();
        bout.reset();
        IOUtils.writeIntMM(bout, 1);
        int width = thumbnail.getWidth();
        int height = thumbnail.getHeight();
        IOUtils.writeIntMM(bout, width);
        IOUtils.writeIntMM(bout, height);
        int bitsPerPixel = 24;
        int planes = 1;
        int widthBytes = (width * bitsPerPixel + 31) / 32 * 4;
        IOUtils.writeIntMM(bout, widthBytes);
        IOUtils.writeIntMM(bout, widthBytes * height * planes);
        IOUtils.writeIntMM(bout, data.length);
        IOUtils.writeShortMM(bout, bitsPerPixel);
        IOUtils.writeShortMM(bout, planes);
        bout.write(data);
        _8BIM bim = new _8BIM(ImageResourceID.THUMBNAIL_RESOURCE_PS5, "thumbnail", bout.toByteArray());
        return bim;
    }

    public static void dither_Bayer(byte[] gray, byte[] mask, int width, int height, int[][] threshold) {
        int level = threshold.length;
        int scaler = level * level + 1;
        for (int i = 0; i < level; ++i) {
            for (int j = 0; j < level; ++j) {
                threshold[i][j] = (threshold[i][j] << 8) / scaler;
            }
        }
        int index = 0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int intensity;
                gray[index] = mask[index] == 0 ? (byte)0 : ((intensity = gray[index] & 0xFF) <= threshold[row % level][col % level] ? (byte)1 : 0);
                ++index;
            }
        }
    }

    public static void dither_FloydSteinberg(byte[] gray, byte[] mask, int width, int height, int threshold) {
        int[] thisErr = new int[width + 2];
        int[] nextErr = new int[width + 2];
        int index = 0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (mask[index] == 0) {
                    gray[index] = 0;
                } else {
                    int intensity = (gray[index] & 0xFF) + thisErr[col + 1];
                    if (intensity > 255) {
                        intensity = 255;
                    } else if (intensity < 0) {
                        intensity = 0;
                    }
                    int newIntensity = 0;
                    if (intensity <= threshold) {
                        gray[index] = 1;
                        newIntensity = 0;
                    } else {
                        gray[index] = 0;
                        newIntensity = 255;
                    }
                    int err = intensity - newIntensity;
                    int n = col + 2;
                    thisErr[n] = thisErr[n] + err * 7 / 16;
                    int n2 = col;
                    nextErr[n2] = nextErr[n2] + err * 3 / 16;
                    int n3 = col + 1;
                    nextErr[n3] = nextErr[n3] + err * 5 / 16;
                    int n4 = col + 2;
                    nextErr[n4] = nextErr[n4] + err / 16;
                }
                ++index;
            }
            int[] tempErr = thisErr;
            thisErr = nextErr;
            nextErr = tempErr;
            Arrays.fill(nextErr, 0);
        }
    }

    public static void dither_Bayer(int[] rgbTriplet, int width, int height, byte[] newPixels, int no_of_color, int[] colorPalette, int transparent_index, int[][] threshold) {
        int index = 0;
        InverseColorMap invMap = new InverseColorMap();
        invMap.createInverseMap(no_of_color, colorPalette);
        int level = threshold.length;
        int scaler = threshold.length * threshold.length + 1;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (rgbTriplet[index] >>> 24 < 128) {
                    newPixels[index] = (byte)transparent_index;
                } else {
                    int red = (rgbTriplet[index] & 0xFF0000) >>> 16;
                    if ((red += red * threshold[row % level][col % level] / scaler) > 255) {
                        red = 255;
                    } else if (red < 0) {
                        red = 0;
                    }
                    int green = (rgbTriplet[index] & 0xFF00) >>> 8;
                    green += green * threshold[row % level][col % level] / scaler;
                    if (green > 255) {
                        green = 255;
                    } else if (green < 0) {
                        green = 0;
                    }
                    int blue = rgbTriplet[index] & 0xFF;
                    blue += blue * threshold[row % level][col % level] / scaler;
                    if (blue > 255) {
                        blue = 255;
                    } else if (blue < 0) {
                        blue = 0;
                    }
                    newPixels[index] = (byte)invMap.getNearestColorIndex(red, green, blue);
                }
                ++index;
            }
        }
        IMGUtils.correctGamma(colorPalette, IMGUtils.createGammaTable(GAMMA, DISPLAY_EXPONENT));
    }

    public static void dither_FloydSteinberg(int[] rgbTriplet, int width, int height, byte[] newPixels, int no_of_color, int[] colorPalette, int transparent_index) {
        int index = 0;
        int index1 = 0;
        int[] thisErrR = new int[width + 2];
        int[] thisErrG = new int[width + 2];
        int[] thisErrB = new int[width + 2];
        int[] nextErrR = new int[width + 2];
        int[] nextErrG = new int[width + 2];
        int[] nextErrB = new int[width + 2];
        InverseColorMap invMap = new InverseColorMap();
        invMap.createInverseMap(no_of_color, colorPalette);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (rgbTriplet[index1] >>> 24 < 128) {
                    newPixels[index1] = (byte)transparent_index;
                } else {
                    int red = ((rgbTriplet[index1] & 0xFF0000) >>> 16) + thisErrR[col + 1];
                    if (red > 255) {
                        red = 255;
                    } else if (red < 0) {
                        red = 0;
                    }
                    int green = ((rgbTriplet[index1] & 0xFF00) >>> 8) + thisErrG[col + 1];
                    if (green > 255) {
                        green = 255;
                    } else if (green < 0) {
                        green = 0;
                    }
                    int blue = (rgbTriplet[index1] & 0xFF) + thisErrB[col + 1];
                    if (blue > 255) {
                        blue = 255;
                    } else if (blue < 0) {
                        blue = 0;
                    }
                    index = invMap.getNearestColorIndex(red, green, blue);
                    newPixels[index1] = (byte)index;
                    int err1 = red - (colorPalette[index] >> 16 & 0xFF);
                    int err2 = green - (colorPalette[index] >> 8 & 0xFF);
                    int err3 = blue - (colorPalette[index] & 0xFF);
                    int n = col + 2;
                    thisErrR[n] = thisErrR[n] + err1 * 7 / 16;
                    int n2 = col;
                    nextErrR[n2] = nextErrR[n2] + err1 * 3 / 16;
                    int n3 = col + 1;
                    nextErrR[n3] = nextErrR[n3] + err1 * 5 / 16;
                    int n4 = col + 2;
                    nextErrR[n4] = nextErrR[n4] + err1 / 16;
                    int n5 = col + 2;
                    thisErrG[n5] = thisErrG[n5] + err2 * 7 / 16;
                    int n6 = col;
                    nextErrG[n6] = nextErrG[n6] + err2 * 3 / 16;
                    int n7 = col + 1;
                    nextErrG[n7] = nextErrG[n7] + err2 * 5 / 16;
                    int n8 = col + 2;
                    nextErrG[n8] = nextErrG[n8] + err2 / 16;
                    int n9 = col + 2;
                    thisErrB[n9] = thisErrB[n9] + err3 * 7 / 16;
                    int n10 = col;
                    nextErrB[n10] = nextErrB[n10] + err3 * 3 / 16;
                    int n11 = col + 1;
                    nextErrB[n11] = nextErrB[n11] + err3 * 5 / 16;
                    int n12 = col + 2;
                    nextErrB[n12] = nextErrB[n12] + err3 / 16;
                }
                ++index1;
            }
            int[] tempErr = thisErrR;
            thisErrR = nextErrR;
            nextErrR = tempErr;
            tempErr = thisErrG;
            thisErrG = nextErrG;
            nextErrG = tempErr;
            tempErr = thisErrB;
            thisErrB = nextErrB;
            nextErrB = tempErr;
            Arrays.fill(nextErrR, 0);
            Arrays.fill(nextErrG, 0);
            Arrays.fill(nextErrB, 0);
        }
    }

    public static byte[] easyRGB2CMYK(int[] rgb, boolean hasAlpha) {
        byte[] cmyk = hasAlpha ? new byte[rgb.length * 5] : new byte[rgb.length * 4];
        int index = 0;
        for (int i = 0; i < rgb.length; ++i) {
            int red = rgb[i] >> 16 & 0xFF;
            int green = rgb[i] >> 8 & 0xFF;
            int blue = rgb[i] & 0xFF;
            float c = 1.0f - (float)red / 255.0f;
            float m = 1.0f - (float)green / 255.0f;
            float y = 1.0f - (float)blue / 255.0f;
            float tempK = 1.0f;
            if (c < tempK) {
                tempK = c;
            }
            if (m < tempK) {
                tempK = m;
            }
            if (y < tempK) {
                tempK = y;
            }
            if (tempK == 1.0f) {
                int n = index++;
                int n2 = index++;
                cmyk[index++] = 0;
                cmyk[n2] = 0;
                cmyk[n] = 0;
            } else {
                cmyk[index++] = (byte)((c - tempK) / (1.0f - tempK) * 255.0f);
                cmyk[index++] = (byte)((m - tempK) / (1.0f - tempK) * 255.0f);
                cmyk[index++] = (byte)((y - tempK) / (1.0f - tempK) * 255.0f);
            }
            cmyk[index++] = (byte)(tempK * 255.0f);
            if (!hasAlpha) continue;
            cmyk[index++] = (byte)(rgb[i] >> 24 & 0xFF);
        }
        return cmyk;
    }

    public static BufferedImage filterImage(BufferedImageOp bufferedImageOp, BufferedImage srcImg, BufferedImage dstImg) {
        return bufferedImageOp.filter(srcImg, dstImg);
    }

    public static int getBitDepth(byte[] input, boolean hasAlpha) {
        int i;
        int[] freq = new int[256];
        if (hasAlpha) {
            for (i = (input.length << 1) - 2; i >= 0; i -= 2) {
                int n = input[i] & 0xFF;
                freq[n] = freq[n] + 1;
            }
        } else {
            for (i = input.length - 1; i >= 0; --i) {
                int n = input[i] & 0xFF;
                freq[n] = freq[n] + 1;
            }
        }
        int numOfColor = 0;
        for (int j = 0; j < freq.length; ++j) {
            if (freq[j] == 0) continue;
            ++numOfColor;
        }
        int k = 0;
        while (1 << k < numOfColor) {
            ++k;
        }
        return k;
    }

    public static ICC_ColorSpace getICCColorSpace(String pathToICCProfile) throws IOException {
        return new ICC_ColorSpace(ICC_Profile.getInstance(IMGUtils.class.getResourceAsStream(pathToICCProfile)));
    }

    public static ICC_Profile getICCProfile(String pathToICCProfile) throws IOException {
        ICC_ColorSpace icc_colorspace = IMGUtils.getICCColorSpace(pathToICCProfile);
        if (icc_colorspace != null) {
            return icc_colorspace.getProfile();
        }
        return null;
    }

    public static int[] getRGB(BufferedImage image) {
        int type = image.getType();
        WritableRaster raster = image.getRaster();
        Object object = raster.getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        int transferType = raster.getTransferType();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int imageSize = imageWidth * imageHeight;
        int[] rgbs = new int[imageSize];
        switch (transferType) {
            case 3: {
                rgbs = (int[])object;
                if (type == 3) {
                    for (int i = 0; i < imageSize; ++i) {
                        float alpha = 255.0f / (float)(rgbs[i] >> 24 & 0xFF);
                        byte red = (byte)((float)(rgbs[i] >> 16 & 0xFF) * alpha);
                        byte green = (byte)((float)(rgbs[i] >> 8 & 0xFF) * alpha);
                        byte blue = (byte)((float)(rgbs[i] & 0xFF) * alpha);
                        rgbs[i] = rgbs[i] & 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                    }
                } else if (type == 4) {
                    for (int i = 0; i < rgbs.length; ++i) {
                        int blue = rgbs[i] >> 16 & 0xFF;
                        int green = rgbs[i] >> 8 & 0xFF;
                        int red = rgbs[i] & 0xFF;
                        rgbs[i] = 0xFF000000 | red << 16 | green << 8 | blue;
                    }
                } else if (type == 1) {
                    for (int i = 0; i < rgbs.length; ++i) {
                        rgbs[i] = 0xFF000000 | rgbs[i];
                    }
                } else if (type != 2) {
                    LOGGER.warn("### Warning: IMGUtils.getRGB() found custom type BufferedImage, fall back to BufferedImage.getRGB() ###");
                    return image.getRGB(0, 0, imageWidth, imageHeight, rgbs, 0, imageWidth);
                }
                return rgbs;
            }
            case 0: {
                byte[] bpixels = (byte[])object;
                if (type == 13 || type == 12) {
                    int i;
                    IndexColorModel indexModel = (IndexColorModel)image.getColorModel();
                    int mapSize = indexModel.getMapSize();
                    byte[] reds = new byte[mapSize];
                    byte[] greens = new byte[mapSize];
                    byte[] blues = new byte[mapSize];
                    byte[] alphas = new byte[mapSize];
                    int[] palette = new int[mapSize];
                    indexModel.getReds(reds);
                    indexModel.getGreens(greens);
                    indexModel.getBlues(blues);
                    indexModel.getAlphas(alphas);
                    for (i = 0; i < mapSize; ++i) {
                        palette[i] = (alphas[i] & 0xFF) << 24 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
                    }
                    for (i = 0; i < imageSize; ++i) {
                        rgbs[i] = palette[bpixels[i] & 0xFF];
                    }
                } else if (type == 6) {
                    int index = 0;
                    for (int i = 0; i < imageSize; ++i) {
                        rgbs[i] = (bpixels[index++] & 0xFF) << 16 | (bpixels[index++] & 0xFF) << 8 | bpixels[index++] & 0xFF | (bpixels[index++] & 0xFF) << 24;
                    }
                } else if (type == 5) {
                    int index = 0;
                    for (int i = 0; i < imageSize; ++i) {
                        rgbs[i] = 0xFF000000 | (bpixels[index++] & 0xFF) << 16 | (bpixels[index++] & 0xFF) << 8 | bpixels[index++] & 0xFF;
                    }
                } else if (type == 7) {
                    int i = 0;
                    int index = 0;
                    while (i < imageSize) {
                        float alpha = 255.0f * (float)(bpixels[index + 3] & 0xFF);
                        byte blue = (byte)((float)(bpixels[index + 2] & 0xFF) * alpha);
                        byte green = (byte)((float)(bpixels[index + 1] & 0xFF) * alpha);
                        byte red = (byte)((float)(bpixels[index] & 0xFF) * alpha);
                        rgbs[i] = bpixels[index + 3] & 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                        ++i;
                        index += 4;
                    }
                } else if (type == 10) {
                    for (int i = 0; i < imageSize; ++i) {
                        rgbs[i] = 0xFF000000 | (bpixels[i] & 0xFF) << 16 | (bpixels[i] & 0xFF) << 8 | bpixels[i] & 0xFF;
                    }
                } else {
                    LOGGER.warn("### Warning: IMGUtils.getRGB() found custom type BufferedImage, fall back to BufferedImage.getRGB() ###");
                    return image.getRGB(0, 0, imageWidth, imageHeight, rgbs, 0, imageWidth);
                }
                return rgbs;
            }
            case 1: {
                short[] spixels = (short[])object;
                if (type == 11) {
                    for (int i = 0; i < imageSize; ++i) {
                        int gray = spixels[i] >> 8 & 0xFF;
                        rgbs[i] = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    }
                } else if (type == 8) {
                    for (int i = 0; i < imageSize; ++i) {
                        int red = spixels[i] >> 11 & 0x1F;
                        int green = spixels[i] >> 5 & 0x3F;
                        int blue = spixels[i] & 0x1F;
                        rgbs[i] = 0xFF000000 | red << 19 | green << 10 | blue << 3;
                    }
                } else if (type == 9) {
                    for (int i = 0; i < imageSize; ++i) {
                        int red = spixels[i] >>> 10 & 0x1F;
                        int green = spixels[i] >>> 5 & 0x1F;
                        int blue = spixels[i] & 0x1F;
                        rgbs[i] = 0xFF000000 | red << 19 | green << 11 | blue << 3;
                    }
                } else {
                    LOGGER.warn("### Warning: IMGUtils.getRGB() found custom type BufferedImage, fall back to BufferedImage.getRGB() ###");
                    return image.getRGB(0, 0, imageWidth, imageHeight, rgbs, 0, imageWidth);
                }
                return rgbs;
            }
        }
        return image.getRGB(0, 0, imageWidth, imageHeight, rgbs, 0, imageWidth);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getRGB2(BufferedImage image) {
        int type = image.getType();
        WritableRaster raster = image.getRaster();
        DataBuffer dataBuffer = raster.getDataBuffer();
        int numOfBanks = dataBuffer.getNumBanks();
        int dataType = dataBuffer.getDataType();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int imageSize = imageWidth * imageHeight;
        int[] rgbs = new int[imageSize];
        switch (dataType) {
            case 3: {
                rgbs = ((DataBufferInt)dataBuffer).getData(0);
                if (type == 3) {
                    for (int i = 0; i < imageSize; ++i) {
                        float alpha = 255.0f / (float)(rgbs[i] >> 24 & 0xFF);
                        byte red = (byte)((float)(rgbs[i] >> 16 & 0xFF) * alpha);
                        byte green = (byte)((float)(rgbs[i] >> 8 & 0xFF) * alpha);
                        byte blue = (byte)((float)(rgbs[i] & 0xFF) * alpha);
                        rgbs[i] = rgbs[i] & 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                    }
                    return rgbs;
                } else if (type == 4) {
                    for (int i = 0; i < rgbs.length; ++i) {
                        int blue = rgbs[i] >> 16 & 0xFF;
                        int green = rgbs[i] >> 8 & 0xFF;
                        int red = rgbs[i] & 0xFF;
                        rgbs[i] = 0xFF000000 | red << 16 | green << 8 | blue;
                    }
                    return rgbs;
                } else if (type == 1) {
                    for (int i = 0; i < rgbs.length; ++i) {
                        rgbs[i] = 0xFF000000 | rgbs[i];
                    }
                    return rgbs;
                } else if (type != 2) return rgbs;
                return rgbs;
            }
            case 0: {
                byte[][] bpixels = ((DataBufferByte)dataBuffer).getBankData();
                if (type == 13 || type == 12) {
                    IndexColorModel indexModel = (IndexColorModel)image.getColorModel();
                    int mapSize = indexModel.getMapSize();
                    byte[] reds = new byte[mapSize];
                    byte[] greens = new byte[mapSize];
                    byte[] blues = new byte[mapSize];
                    byte[] alphas = new byte[mapSize];
                    int[] palette = new int[mapSize];
                    indexModel.getReds(reds);
                    indexModel.getGreens(greens);
                    indexModel.getBlues(blues);
                    indexModel.getAlphas(alphas);
                    for (int i = 0; i < mapSize; ++i) {
                        palette[i] = (alphas[i] & 0xFF) << 24 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
                    }
                    int bitsPerPixel = raster.getSampleModel().getSampleSize(0);
                    int index = 0;
                    int padding = 0;
                    int safeEnd = 0;
                    switch (bitsPerPixel) {
                        case 8: {
                            int i;
                            for (i = 0; i < imageSize; ++i) {
                                rgbs[i] = palette[bpixels[0][i] & 0xFF];
                            }
                            return rgbs;
                        }
                        case 4: {
                            int i;
                            padding = imageWidth % 2;
                            safeEnd = imageWidth - padding;
                            for (int j = 0; j < imageHeight; ++j) {
                                int k = 0;
                                while (k < safeEnd) {
                                    rgbs[index++] = palette[bpixels[0][i] >>> 4 & 0xF];
                                    rgbs[index++] = palette[bpixels[0][i] & 0xF];
                                    k += 2;
                                    ++i;
                                }
                                if (padding == 0) continue;
                                rgbs[index++] = palette[bpixels[0][i] >>> 4 & 0xF];
                            }
                            return rgbs;
                        }
                        case 2: {
                            int i;
                            padding = imageWidth % 4;
                            safeEnd = imageWidth - padding;
                            for (int j = 0; j < imageHeight; ++j) {
                                int k = 0;
                                while (k < safeEnd) {
                                    int l = 6;
                                    while (l >= 0) {
                                        rgbs[index] = palette[bpixels[0][i] >>> l & 3];
                                        l -= 2;
                                        ++index;
                                    }
                                    k += 4;
                                    ++i;
                                }
                                if (padding == 0) continue;
                                int m = 0;
                                int n = 6;
                                while (m < padding) {
                                    rgbs[index] = palette[bpixels[0][i] >>> n & 3];
                                    ++m;
                                    n -= 2;
                                    ++index;
                                }
                                ++i;
                            }
                            return rgbs;
                        }
                        case 1: {
                            int i;
                            padding = imageWidth % 8;
                            safeEnd = imageWidth - padding;
                            int maxValue = 8 - padding;
                            for (int j = 0; j < imageHeight; ++j) {
                                int k = 0;
                                while (k < safeEnd) {
                                    int l = 7;
                                    while (l >= 0) {
                                        rgbs[index] = palette[bpixels[0][i] >>> l & 1];
                                        --l;
                                        ++index;
                                    }
                                    k += 8;
                                    ++i;
                                }
                                if (padding == 0) continue;
                                int m = 7;
                                while (m >= maxValue) {
                                    rgbs[index] = palette[bpixels[0][i] >>> m & 1];
                                    --m;
                                    ++index;
                                }
                                ++i;
                            }
                            return rgbs;
                        }
                        default: {
                            LOGGER.error(bitsPerPixel + " bit color depth is not valid for indexed image...");
                        }
                    }
                    return rgbs;
                }
                if (type == 6) {
                    if (numOfBanks == 1) {
                        int index = 0;
                        for (int i = 0; i < imageSize; ++i) {
                            rgbs[i] = (bpixels[0][index++] & 0xFF) << 24 | bpixels[0][index++] & 0xFF | (bpixels[0][index++] & 0xFF) << 8 | (bpixels[0][index++] & 0xFF) << 16;
                        }
                        return rgbs;
                    } else {
                        for (int i = 0; i < imageSize; ++i) {
                            rgbs[i] = (bpixels[0][i] & 0xFF) << 24 | bpixels[1][i] & 0xFF | (bpixels[2][i] & 0xFF) << 8 | (bpixels[3][i] & 0xFF) << 16;
                        }
                    }
                    return rgbs;
                } else if (type == 5) {
                    if (numOfBanks == 1) {
                        int index = 0;
                        for (int i = 0; i < imageSize; ++i) {
                            rgbs[i] = 0xFF000000 | bpixels[0][index++] & 0xFF | (bpixels[0][index++] & 0xFF) << 8 | (bpixels[0][index++] & 0xFF) << 16;
                        }
                        return rgbs;
                    } else {
                        for (int i = 0; i < imageSize; ++i) {
                            rgbs[i] = 0xFF000000 | bpixels[0][i] & 0xFF | (bpixels[1][i] & 0xFF) << 8 | (bpixels[2][i] & 0xFF) << 16;
                        }
                    }
                    return rgbs;
                } else if (type == 7) {
                    if (numOfBanks == 1) {
                        int i = 0;
                        int index = 0;
                        while (i < imageSize) {
                            float alpha = 255.0f * (float)(bpixels[0][index] & 0xFF);
                            byte blue = (byte)((float)(bpixels[0][index + 1] & 0xFF) * alpha);
                            byte green = (byte)((float)(bpixels[0][index + 2] & 0xFF) * alpha);
                            byte red = (byte)((float)(bpixels[0][index + 3] & 0xFF) * alpha);
                            rgbs[i] = (bpixels[0][index] & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                            ++i;
                            index += 4;
                        }
                        return rgbs;
                    } else {
                        for (int i = 0; i < imageSize; ++i) {
                            float alpha = 255.0f * (float)(bpixels[0][i] & 0xFF);
                            byte blue = (byte)((float)(bpixels[1][i] & 0xFF) * alpha);
                            byte green = (byte)((float)(bpixels[2][i] & 0xFF) * alpha);
                            byte red = (byte)((float)(bpixels[3][i] & 0xFF) * alpha);
                            rgbs[i] = (bpixels[0][i] & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                        }
                    }
                    return rgbs;
                } else {
                    if (type != 10) return rgbs;
                    for (int i = 0; i < imageSize; ++i) {
                        rgbs[i] = 0xFF000000 | (bpixels[0][i] & 0xFF) << 16 | (bpixels[0][i] & 0xFF) << 8 | bpixels[0][i] & 0xFF;
                    }
                }
                return rgbs;
            }
            case 1: {
                short[] spixels = ((DataBufferUShort)dataBuffer).getBankData()[0];
                if (type == 11) {
                    for (int i = 0; i < imageSize; ++i) {
                        int gray = spixels[i] >> 8 & 0xFF;
                        rgbs[i] = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    }
                    return rgbs;
                } else if (type == 8) {
                    for (int i = 0; i < imageSize; ++i) {
                        int red = spixels[i] >> 11 & 0x1F;
                        int green = spixels[i] >> 5 & 0x3F;
                        int blue = spixels[i] & 0x1F;
                        rgbs[i] = 0xFF000000 | red << 19 | green << 10 | blue << 3;
                    }
                    return rgbs;
                } else {
                    if (type != 9) return rgbs;
                    for (int i = 0; i < imageSize; ++i) {
                        int red = spixels[i] >>> 10 & 0x1F;
                        int green = spixels[i] >>> 5 & 0x1F;
                        int blue = spixels[i] & 0x1F;
                        rgbs[i] = 0xFF000000 | red << 19 | green << 11 | blue << 3;
                    }
                }
                return rgbs;
            }
        }
        return image.getRGB(0, 0, imageWidth, imageHeight, rgbs, 0, imageWidth);
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        if (w < targetWidth || h < targetHeight || !higherQuality) {
            return IMGUtils.scaleImage(ret, type, hint, targetWidth, targetHeight);
        }
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            ret = IMGUtils.scaleImage(ret, type, hint, w, h);
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static ImageType guessImageType(byte[] magicNumber) {
        ImageType imageType = ImageType.UNKNOWN;
        if (Arrays.equals(magicNumber, TIFF_II) || Arrays.equals(magicNumber, TIFF_MM)) {
            imageType = ImageType.TIFF;
        } else if (Arrays.equals(magicNumber, PNG)) {
            imageType = ImageType.PNG;
        } else if (Arrays.equals(magicNumber, GIF)) {
            imageType = ImageType.GIF;
        } else if (magicNumber[0] == JPG[0] && magicNumber[1] == JPG[1] && magicNumber[2] == JPG[2]) {
            imageType = ImageType.JPG;
        } else if (magicNumber[0] == BM[0] && magicNumber[1] == BM[1]) {
            imageType = ImageType.BMP;
        } else if (magicNumber[0] == PCX[0]) {
            imageType = ImageType.PCX;
        } else if (Arrays.equals(magicNumber, JPG2000)) {
            imageType = ImageType.JPG2000;
        } else if (magicNumber[1] == 0 || magicNumber[1] == 1) {
            switch (magicNumber[2]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 32: 
                case 33: {
                    imageType = ImageType.TGA;
                }
            }
        } else {
            LOGGER.error("Unknown image type format!");
        }
        return imageType;
    }

    public static ImageType guessImageType(PeekHeadInputStream is) throws IOException {
        byte[] magicNumber = is.peek(4);
        ImageType imageType = IMGUtils.guessImageType(magicNumber);
        return imageType;
    }

    public static ImageType guessImageType(RandomAccessInputStream is) throws IOException {
        byte[] magicNumber = new byte[4];
        long streamPointer = is.getStreamPointer();
        is.read(magicNumber);
        ImageType imageType = IMGUtils.guessImageType(magicNumber);
        is.seek(streamPointer);
        return imageType;
    }

    public static WritableRaster iccp2rgbRaster(WritableRaster raster, ColorModel cm) {
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        ColorConvertOp cco = new ColorConvertOp(cm.getColorSpace(), sRGB, null);
        WritableRaster rgbRaster = null;
        BufferedImage iccpImage = new BufferedImage(cm, raster, false, null);
        rgbRaster = cco.filter(iccpImage, null).getRaster();
        return rgbRaster;
    }

    public static void invertBits(byte[] input, int pixelStride) {
        for (int i = input.length - 1; i >= 0; i -= pixelStride) {
            input[i] = ~input[i];
        }
    }

    public static void invertBits(short[] input, int pixelStride) {
        for (int i = input.length - 1; i >= 0; i -= pixelStride) {
            input[i] = ~input[i];
        }
    }

    private static int[] reduceColorsPopularity(int[] rgbTriplets, int colorDepth, byte[] newPixels, int[] colorPalette, boolean fullAlpha) {
        int j;
        int i;
        int index;
        int alpha;
        int blue;
        int green;
        int red;
        int i2;
        if (colorDepth > 8 || colorDepth < 1) {
            throw new IllegalArgumentException("Invalid color depth " + colorDepth);
        }
        int no_of_color = 1 << colorDepth;
        int[] colorFreq = new int[65536];
        int[] indexColor = new int[65536];
        int[] clrPalRed = new int[no_of_color];
        int[] clrPalGreen = new int[no_of_color];
        int[] clrPalBlue = new int[no_of_color];
        int[] clrPalAlpha = new int[no_of_color];
        int[] colorInfo = new int[2];
        int bitsPerPixel = 1;
        int transparent_color = -1;
        int transparent_index = -1;
        for (i2 = 0; i2 < rgbTriplets.length; ++i2) {
            boolean trans;
            boolean bl = fullAlpha ? rgbTriplets[i2] >>> 24 == 0 : (trans = rgbTriplets[i2] >>> 24 < 128);
            if (trans && transparent_color < 0) {
                transparent_color = rgbTriplets[i2];
            }
            red = (rgbTriplets[i2] & 0xF00000) >>> 20;
            green = (rgbTriplets[i2] & 0xF000) >>> 8;
            blue = (rgbTriplets[i2] & 0xF0) << 4;
            alpha = (rgbTriplets[i2] & 0xF0000000) >>> 16;
            int n = index = alpha | red | green | blue;
            colorFreq[n] = colorFreq[n] + 1;
        }
        int colorCount = 0;
        for (i2 = 0; i2 < 65536; ++i2) {
            if (colorFreq[i2] == 0 || (i2 & 0xF000) == 0) continue;
            colorFreq[colorCount] = colorFreq[i2];
            indexColor[colorCount++] = i2;
        }
        int gap = 1;
        while (gap < colorCount) {
            gap = 3 * gap + 1;
        }
        while (gap > 0) {
            for (i = gap; i < colorCount; ++i) {
                int temp = colorFreq[i];
                int temp1 = indexColor[i];
                for (j = i; j >= gap && temp >= colorFreq[j - gap]; j -= gap) {
                    colorFreq[j] = colorFreq[j - gap];
                    indexColor[j] = indexColor[j - gap];
                }
                colorFreq[j] = temp;
                indexColor[j] = temp1;
            }
            gap /= 3;
        }
        int[] colorIndex = new int[no_of_color >= colorCount ? no_of_color : colorCount];
        for (i = 0; i < no_of_color; ++i) {
            clrPalBlue[i] = (indexColor[i] & 0xF00) >>> 4;
            clrPalGreen[i] = indexColor[i] & 0xF0;
            clrPalRed[i] = (indexColor[i] & 0xF) << 4;
            clrPalAlpha[i] = (indexColor[i] & 0xF000) >>> 8;
            colorPalette[i] = clrPalAlpha[i] << 24 | clrPalRed[i] << 16 | clrPalGreen[i] << 8 | clrPalBlue[i];
            colorIndex[i] = i;
        }
        if (transparent_color >= 0) {
            --no_of_color;
        }
        if (colorCount > no_of_color) {
            for (i = no_of_color; i < colorCount; ++i) {
                index = 0;
                blue = (indexColor[i] & 0xF00) >>> 4;
                green = indexColor[i] & 0xF0;
                red = (indexColor[i] & 0xF) << 4;
                alpha = (indexColor[i] & 0xF000) >>> 8;
                int err1 = (red - clrPalRed[0]) * (red - clrPalRed[0]) + (green - clrPalGreen[0]) * (green - clrPalGreen[0]) + (blue - clrPalBlue[0]) * (blue - clrPalBlue[0]) + (alpha - clrPalAlpha[0]) * (alpha - clrPalAlpha[0]);
                for (j = 1; j < no_of_color; ++j) {
                    int err2 = (red - clrPalRed[j]) * (red - clrPalRed[j]) + (green - clrPalGreen[j]) * (green - clrPalGreen[j]) + (blue - clrPalBlue[j]) * (blue - clrPalBlue[j]) + (alpha - clrPalAlpha[j]) * (alpha - clrPalAlpha[j]);
                    if (err2 >= err1) continue;
                    err1 = err2;
                    index = j;
                }
                colorIndex[i] = index;
            }
        }
        for (i = 0; i < colorCount; ++i) {
            colorFreq[indexColor[i]] = i;
        }
        if (transparent_color >= 0) {
            ++colorCount;
        }
        while (1 << bitsPerPixel < colorCount) {
            ++bitsPerPixel;
        }
        if (bitsPerPixel > colorDepth) {
            bitsPerPixel = colorDepth;
        }
        if (transparent_color >= 0) {
            transparent_index = (1 << bitsPerPixel) - 1;
            colorPalette[transparent_index] = transparent_color;
        }
        for (i = 0; i < rgbTriplets.length; ++i) {
            red = (rgbTriplets[i] & 0xF00000) >>> 20;
            green = (rgbTriplets[i] & 0xF000) >>> 8;
            blue = (rgbTriplets[i] & 0xF0) << 4;
            alpha = (rgbTriplets[i] & 0xF0000000) >>> 16;
            index = alpha | red | green | blue;
            boolean trans = fullAlpha ? rgbTriplets[i] >>> 24 == 0 || (index & 0xF000) == 0 : rgbTriplets[i] >>> 24 < 128;
            newPixels[i] = trans ? (byte)transparent_index : (byte)colorIndex[colorFreq[index]];
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = transparent_index;
        return colorInfo;
    }

    public static int[] reduceColors(QuantMethod quantMethod, int[] rgbTriplets, int colorDepth, byte[] newPixels, int[] colorPalette, boolean fullAlpha) {
        int[] colorInfo = new int[2];
        if (quantMethod == QuantMethod.WU_QUANT) {
            new WuQuant(rgbTriplets, 1 << colorDepth).quantize(newPixels, colorPalette, colorInfo);
        } else if (quantMethod == QuantMethod.NEU_QUANT) {
            new NeuQuant(rgbTriplets).quantize(newPixels, colorPalette, colorInfo);
        } else {
            colorInfo = IMGUtils.reduceColorsPopularity(rgbTriplets, colorDepth, newPixels, colorPalette, fullAlpha);
        }
        return colorInfo;
    }

    public static int[] reduceColorsDiffusionDither(int[] rgbTriplets, int width, int height, int colorDepth, byte[] newPixels, int[] colorPalette) {
        if (colorDepth > 8 || colorDepth < 1) {
            throw new IllegalArgumentException("Invalid color depth " + colorDepth);
        }
        int[] colorInfo = new int[2];
        int colors = IMGUtils.reduceColors(rgbTriplets, colorDepth, colorPalette, colorInfo);
        IMGUtils.dither_FloydSteinberg(rgbTriplets, width, height, newPixels, colors, colorPalette, colorInfo[1]);
        return colorInfo;
    }

    public static int[] reduceColorsDiffusionDither(QuantMethod quantMethod, int[] rgbTriplets, int width, int height, int colorDepth, byte[] newPixels, int[] colorPalette) {
        if (colorDepth > 8 || colorDepth < 1) {
            throw new IllegalArgumentException("Invalid color depth " + colorDepth);
        }
        int[] colorInfo = new int[2];
        int colors = 0;
        colors = quantMethod == QuantMethod.WU_QUANT ? new WuQuant(rgbTriplets, 1 << colorDepth).quantize(colorPalette, colorInfo) : (quantMethod == QuantMethod.NEU_QUANT ? new NeuQuant(rgbTriplets).quantize(colorPalette, colorInfo) : IMGUtils.reduceColors(rgbTriplets, colorDepth, colorPalette, colorInfo));
        IMGUtils.dither_FloydSteinberg(rgbTriplets, width, height, newPixels, colors, colorPalette, colorInfo[1]);
        return colorInfo;
    }

    public static int[] reduceColorsOrderedDither(int[] rgbTriplet, int width, int height, int colorDepth, byte[] newPixels, int[] colorPalette, int[][] threshold) {
        if (colorDepth > 8 || colorDepth < 1) {
            throw new IllegalArgumentException("Invalid color depth " + colorDepth);
        }
        int[] colorInfo = new int[2];
        int colors = IMGUtils.reduceColors(rgbTriplet, colorDepth, colorPalette, colorInfo);
        IMGUtils.dither_Bayer(rgbTriplet, width, height, newPixels, colors, colorPalette, colorInfo[1], threshold);
        return colorInfo;
    }

    public static int[] reduceColorsOrderedDither(QuantMethod quantMethod, int[] rgbTriplets, int width, int height, int colorDepth, byte[] newPixels, int[] colorPalette, int[][] threshold) {
        if (colorDepth > 8 || colorDepth < 1) {
            throw new IllegalArgumentException("Invalid color depth " + colorDepth);
        }
        int[] colorInfo = new int[2];
        int colors = 0;
        colors = quantMethod == QuantMethod.WU_QUANT ? new WuQuant(rgbTriplets, 1 << colorDepth).quantize(colorPalette, colorInfo) : (quantMethod == QuantMethod.NEU_QUANT ? new NeuQuant(rgbTriplets).quantize(colorPalette, colorInfo) : IMGUtils.reduceColors(rgbTriplets, colorDepth, colorPalette, colorInfo));
        IMGUtils.dither_Bayer(rgbTriplets, width, height, newPixels, colors, colorPalette, colorInfo[1], threshold);
        return colorInfo;
    }

    private static int reduceColors(int[] rgbTriplet, int colorDepth, int[] colorPalette, int[] colorInfo) {
        int i;
        int blue;
        int green;
        int red;
        int i2;
        if (colorDepth > 8 || colorDepth < 1) {
            throw new IllegalArgumentException("Invalid color depth " + colorDepth);
        }
        int no_of_color = 1 << colorDepth;
        int[] colorFreq = new int[4096];
        int[] indexColor = new int[4096];
        int bitsPerPixel = 1;
        int transparent_color = -1;
        int transparent_index = -1;
        for (i2 = 0; i2 < rgbTriplet.length; ++i2) {
            int index;
            if (rgbTriplet[i2] >>> 24 < 128 && transparent_color < 0) {
                transparent_color = rgbTriplet[i2];
            }
            red = (rgbTriplet[i2] & 0xF00000) >>> 20;
            green = (rgbTriplet[i2] & 0xF000) >>> 8;
            blue = (rgbTriplet[i2] & 0xF0) << 4;
            int n = index = red | green | blue;
            colorFreq[n] = colorFreq[n] + 1;
        }
        int colorCount = 0;
        for (i2 = 0; i2 < 4096; ++i2) {
            if (colorFreq[i2] == 0) continue;
            colorFreq[colorCount] = colorFreq[i2];
            indexColor[colorCount++] = i2;
        }
        int gap = 1;
        while (gap < colorCount) {
            gap = 3 * gap + 1;
        }
        while (gap > 0) {
            for (i = gap; i < colorCount; ++i) {
                int temp = colorFreq[i];
                int temp1 = indexColor[i];
                for (int j = i; j >= gap && temp >= colorFreq[j - gap]; j -= gap) {
                    colorFreq[j] = colorFreq[j - gap];
                    indexColor[j] = indexColor[j - gap];
                }
                colorFreq[j] = temp;
                indexColor[j] = temp1;
            }
            gap /= 3;
        }
        int[] colorIndex = new int[no_of_color];
        for (i = 0; i < no_of_color; ++i) {
            blue = (indexColor[i] & 0xF00) >>> 4;
            green = indexColor[i] & 0xF0;
            red = (indexColor[i] & 0xF) << 4;
            colorPalette[i] = 0xFF000000 | red << 16 | green << 8 | blue;
            colorIndex[i] = i;
        }
        if (transparent_color >= 0) {
            --no_of_color;
            ++colorCount;
        }
        while (1 << bitsPerPixel < colorCount) {
            ++bitsPerPixel;
        }
        if (bitsPerPixel > colorDepth) {
            bitsPerPixel = colorDepth;
        }
        if (transparent_color >= 0) {
            transparent_index = (1 << bitsPerPixel) - 1;
            colorPalette[transparent_index] = transparent_color;
            --colorCount;
        }
        colorInfo[0] = bitsPerPixel;
        colorInfo[1] = transparent_index;
        return colorCount < no_of_color ? colorCount : no_of_color;
    }

    public static byte[] rgb2bilevel(int[] rgb) {
        byte[] pixels = new byte[rgb.length];
        long sum = 0L;
        for (int i = 0; i < rgb.length; ++i) {
            pixels[i] = rgb[i] >>> 24 < 128 ? -1 : (byte)((double)(rgb[i] >> 16 & 0xFF) * 0.2126 + (double)(rgb[i] >> 8 & 0xFF) * 0.7152 + (double)(rgb[i] & 0xFF) * 0.0722);
            sum += (long)(pixels[i] & 0xFF);
        }
        int threshold = (int)(sum / (long)pixels.length);
        for (int l = 0; l < pixels.length; ++l) {
            pixels[l] = (pixels[l] & 0xFF) <= threshold ? (byte)1 : 0;
        }
        return pixels;
    }

    public static byte[] rgb2bilevelOrderedDither(int[] rgb, int imageWidth, int imageHeight, int[][] threshold) {
        byte[] pixels = new byte[rgb.length];
        byte[] mask = new byte[rgb.length];
        Arrays.fill(mask, (byte)1);
        for (int i = 0; i < rgb.length; ++i) {
            if (rgb[i] >>> 24 < 128) {
                pixels[i] = -1;
                mask[i] = 0;
                continue;
            }
            pixels[i] = (byte)((double)(rgb[i] >> 16 & 0xFF) * 0.2126 + (double)(rgb[i] >> 8 & 0xFF) * 0.7152 + (double)(rgb[i] & 0xFF) * 0.0722);
        }
        IMGUtils.dither_Bayer(pixels, mask, imageWidth, imageHeight, threshold);
        return pixels;
    }

    public static byte[] rgb2bilevelDiffusionDither(int[] rgb, int imageWidth, int imageHeight) {
        byte[] pixels = new byte[rgb.length];
        byte[] mask = new byte[rgb.length];
        long sum = 0L;
        Arrays.fill(mask, (byte)1);
        for (int i = 0; i < rgb.length; ++i) {
            if (rgb[i] >>> 24 < 128) {
                pixels[i] = -1;
                mask[i] = 0;
            } else {
                pixels[i] = (byte)((double)(rgb[i] >> 16 & 0xFF) * 0.2126 + (double)(rgb[i] >> 8 & 0xFF) * 0.7152 + (double)(rgb[i] & 0xFF) * 0.0722);
            }
            sum += (long)(pixels[i] & 0xFF);
        }
        int threshold = (int)(sum / (long)pixels.length);
        IMGUtils.dither_FloydSteinberg(pixels, mask, imageWidth, imageHeight, threshold);
        return pixels;
    }

    public static void RGB2CMYK(ICC_ColorSpace cmykColorSpace, int[] rgb, float[][] C, float[][] M, float[][] Y, float[][] K, int imageWidth, int imageHeight) {
        DataBufferInt db = new DataBufferInt(rgb, rgb.length);
        WritableRaster raster = Raster.createPackedRaster(db, imageWidth, imageHeight, imageWidth, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        ColorConvertOp cco = new ColorConvertOp(sRGB, cmykColorSpace, null);
        BufferedImage rgbImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255), raster, false, null);
        BufferedImage cmykImage = cco.filter(rgbImage, null);
        WritableRaster cmykRaster = cmykImage.getRaster();
        byte[] cmyk = (byte[])cmykRaster.getDataElements(0, 0, imageWidth, imageHeight, null);
        int index = 0;
        for (int i = 0; i < imageHeight; ++i) {
            for (int j = 0; j < imageWidth; ++j) {
                C[i][j] = (float)(cmyk[index++] & 0xFF) - 128.0f;
                M[i][j] = (float)(cmyk[index++] & 0xFF) - 128.0f;
                Y[i][j] = (float)(cmyk[index++] & 0xFF) - 128.0f;
                K[i][j] = (float)(cmyk[index++] & 0xFF) - 128.0f;
            }
        }
    }

    public static byte[] RGB2CMYK(ICC_ColorSpace cmykColorSpace, int[] rgb, int imageWidth, int imageHeight, boolean hasAlpha) {
        DataBufferInt db = new DataBufferInt(rgb, rgb.length);
        int[] bandMasks = new int[]{0xFF0000, 65280, 255};
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        ColorConvertOp cco = new ColorConvertOp(sRGB, cmykColorSpace, null);
        ColorModel cm = null;
        WritableRaster cmykRaster = null;
        if (hasAlpha) {
            cm = ColorModel.getRGBdefault();
            bandMasks = new int[]{0xFF0000, 65280, 255, -16777216};
        } else {
            cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        WritableRaster raster = Raster.createPackedRaster(db, imageWidth, imageHeight, imageWidth, bandMasks, null);
        BufferedImage rgbImage = new BufferedImage(cm, raster, false, null);
        BufferedImage cmykImage = cco.filter(rgbImage, null);
        cmykRaster = cmykImage.getRaster();
        return (byte[])cmykRaster.getDataElements(0, 0, imageWidth, imageHeight, null);
    }

    public static void RGB2CMYK_Inverted(ICC_ColorSpace cmykColorSpace, int[] rgb, float[][] C, float[][] M, float[][] Y, float[][] K, int imageWidth, int imageHeight) {
        DataBufferInt db = new DataBufferInt(rgb, rgb.length);
        WritableRaster raster = Raster.createPackedRaster(db, imageWidth, imageHeight, imageWidth, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        ColorConvertOp cco = new ColorConvertOp(sRGB, cmykColorSpace, null);
        BufferedImage rgbImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255), raster, false, null);
        BufferedImage cmykImage = cco.filter(rgbImage, null);
        WritableRaster cmykRaster = cmykImage.getRaster();
        byte[] cmyk = (byte[])cmykRaster.getDataElements(0, 0, imageWidth, imageHeight, null);
        int index = 0;
        for (int i = 0; i < imageHeight; ++i) {
            for (int j = 0; j < imageWidth; ++j) {
                C[i][j] = 128.0f - (float)(cmyk[index++] & 0xFF);
                M[i][j] = 128.0f - (float)(cmyk[index++] & 0xFF);
                Y[i][j] = 128.0f - (float)(cmyk[index++] & 0xFF);
                K[i][j] = 128.0f - (float)(cmyk[index++] & 0xFF);
            }
        }
    }

    public static byte[] rgb2grayscale(int[] rgb) {
        byte[] grayscale = new byte[rgb.length];
        for (int i = 0; i < rgb.length; ++i) {
            grayscale[i] = (byte)((double)(rgb[i] >> 16 & 0xFF) * 0.2126 + (double)(rgb[i] >> 8 & 0xFF) * 0.7152 + (double)(rgb[i] & 0xFF) * 0.0722);
        }
        return grayscale;
    }

    public static float[][] rgb2grayscale(int[] rgb, int imageWidth, int imageHeight) {
        float[][] grayscale = new float[imageHeight][imageWidth];
        int index = 0;
        for (int i = 0; i < imageHeight; ++i) {
            int j = 0;
            while (j < imageWidth) {
                grayscale[i][j] = (float)((double)(rgb[index] >> 16 & 0xFF) * 0.2126 + (double)(rgb[index] >> 8 & 0xFF) * 0.7152 + (double)(rgb[index] & 0xFF) * 0.0722 - 128.0);
                ++j;
                ++index;
            }
        }
        return grayscale;
    }

    public static byte[] rgb2grayscaleA(int[] rgb) {
        byte[] grayscale = new byte[rgb.length << 1];
        int j = 0;
        for (int i = 0; i < rgb.length; ++i) {
            grayscale[j++] = (byte)((double)(rgb[i] >> 16 & 0xFF) * 0.2126 + (double)(rgb[i] >> 8 & 0xFF) * 0.7152 + (double)(rgb[i] & 0xFF) * 0.0722);
            grayscale[j++] = (byte)(rgb[i] >> 24 & 0xFF);
        }
        return grayscale;
    }

    public static byte[] RGB2YCbCr(int[] rgb) {
        int index = 0;
        byte[] ycbcr = new byte[rgb.length * 3];
        for (int i = 0; i < rgb.length; ++i) {
            int red = rgb[i] >> 16 & 0xFF;
            int green = rgb[i] >> 8 & 0xFF;
            int blue = rgb[i] & 0xFF;
            ycbcr[index++] = (byte)(0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue);
            ycbcr[index++] = (byte)(-0.1687f * (float)red - 0.3313f * (float)green + 0.5f * (float)blue + 128.0f);
            ycbcr[index++] = (byte)(0.5f * (float)red - 0.4187f * (float)green - 0.0813f * (float)blue + 128.0f);
        }
        return ycbcr;
    }

    public static void RGB2YCbCr(int[] rgb, float[][] Y, float[][] Cb, float[][] Cr, int imageWidth, int imageHeight) {
        int index = 0;
        for (int i = 0; i < imageHeight; ++i) {
            for (int j = 0; j < imageWidth; ++j) {
                int red = rgb[index] >> 16 & 0xFF;
                int green = rgb[index] >> 8 & 0xFF;
                int blue = rgb[index++] & 0xFF;
                Y[i][j] = 0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue - 128.0f;
                Cb[i][j] = -0.1687f * (float)red - 0.3313f * (float)green + 0.5f * (float)blue;
                Cr[i][j] = 0.5f * (float)red - 0.4187f * (float)green - 0.0813f * (float)blue;
            }
        }
    }

    public static void RGB2YCbCr(int[][] red, int[][] green, int[][] blue, float[][] Y, float[][] Cb, float[][] Cr, int imageWidth, int imageHeight) {
        for (int i = 0; i < imageHeight; ++i) {
            for (int j = 0; j < imageWidth; ++j) {
                Y[i][j] = 0.299f * (float)red[i][j] + 0.587f * (float)green[i][j] + 0.114f * (float)blue[i][j] - 128.0f;
                Cb[i][j] = -0.1687f * (float)red[i][j] - 0.3313f * (float)green[i][j] + 0.5f * (float)blue[i][j];
                Cr[i][j] = 0.5f * (float)red[i][j] - 0.4187f * (float)green[i][j] - 0.0813f * (float)blue[i][j];
            }
        }
    }

    public static byte[] RGB2YCbCrA(int[] rgba) {
        int index = 0;
        byte[] ycbcra = new byte[rgba.length * 4];
        for (int i = 0; i < rgba.length; ++i) {
            int alpha = rgba[i] >> 24 & 0xFF;
            int red = rgba[i] >> 16 & 0xFF;
            int green = rgba[i] >> 8 & 0xFF;
            int blue = rgba[i] & 0xFF;
            ycbcra[index++] = (byte)(0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue);
            ycbcra[index++] = (byte)(-0.1687f * (float)red - 0.3313f * (float)green + 0.5f * (float)blue + 128.0f);
            ycbcra[index++] = (byte)(0.5f * (float)red - 0.4187f * (float)green - 0.0813f * (float)blue + 128.0f);
            ycbcra[index++] = (byte)alpha;
        }
        return ycbcra;
    }

    public static void RGB2YCCK_Inverted(ICC_ColorSpace cmykColorSpace, int[] rgb, float[][] Y, float[][] Cb, float[][] Cr, float[][] K, int imageWidth, int imageHeight) {
        DataBufferInt db = new DataBufferInt(rgb, rgb.length);
        WritableRaster raster = Raster.createPackedRaster(db, imageWidth, imageHeight, imageWidth, new int[]{0xFF0000, 65280, 255}, null);
        ColorSpace sRGB = ColorSpace.getInstance(1000);
        ColorConvertOp cco = new ColorConvertOp(sRGB, cmykColorSpace, null);
        BufferedImage rgbImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255), raster, false, null);
        BufferedImage cmykImage = cco.filter(rgbImage, null);
        WritableRaster cmykRaster = cmykImage.getRaster();
        byte[] cmyk = (byte[])cmykRaster.getDataElements(0, 0, imageWidth, imageHeight, null);
        int index = 0;
        for (int i = 0; i < imageHeight; ++i) {
            for (int j = 0; j < imageWidth; ++j) {
                float c = 255.0f - (float)(cmyk[index++] & 0xFF);
                float m = 255.0f - (float)(cmyk[index++] & 0xFF);
                float y = 255.0f - (float)(cmyk[index++] & 0xFF);
                Y[i][j] = 128.0f - (c * 0.299f + m * 0.587f + y * 0.114f);
                Cb[i][j] = 0.16874f * c + 0.33126f * m - 0.5f * y;
                Cr[i][j] = -0.5f * c + 0.41869f * m + 0.08131f * y;
                K[i][j] = 128.0f - (float)(cmyk[index++] & 0xFF);
            }
        }
    }

    private static BufferedImage scaleImage(BufferedImage orig, int type, Object hint, int w, int h) {
        BufferedImage tmp = new BufferedImage(w, h, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
        g2.drawImage(orig, 0, 0, w, h, null);
        g2.dispose();
        return tmp;
    }

    private IMGUtils() {
    }
}

