/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.util;

public class InverseColorMap {
    private int bitsReserved;
    private int bitsDiscarded;
    private int maxColorVal;
    private int invMapLen;
    private byte[] invColorMap;

    public InverseColorMap() {
        this(5);
    }

    public InverseColorMap(int rbits) {
        this.bitsReserved = rbits;
        this.bitsDiscarded = 8 - this.bitsReserved;
        this.maxColorVal = 1 << this.bitsReserved;
        this.invMapLen = this.maxColorVal * this.maxColorVal * this.maxColorVal;
        this.invColorMap = new byte[this.invMapLen];
    }

    public int getNearestColorIndex(int color) {
        return this.invColorMap[(color & 0xFF0000) >> 16 + this.bitsDiscarded << (this.bitsReserved << 1) | (color & 0xFF00) >> 8 + this.bitsDiscarded << this.bitsReserved | (color & 0xFF) >> this.bitsDiscarded] & 0xFF;
    }

    public int getNearestColorIndex(int red, int green, int blue) {
        return this.invColorMap[red >> this.bitsDiscarded << (this.bitsReserved << 1) | green >> this.bitsDiscarded << this.bitsReserved | blue >> this.bitsDiscarded] & 0xFF;
    }

    public int getNearestColorIndex(byte red, byte green, byte blue) {
        return this.invColorMap[(red & 0xFF) >> this.bitsDiscarded << (this.bitsReserved << 1) | (green & 0xFF) >> this.bitsDiscarded << this.bitsReserved | (blue & 0xFF) >> this.bitsDiscarded] & 0xFF;
    }

    public void createInverseMap(int no_of_colors, int[] colorPalette) {
        int x = 1 << this.bitsDiscarded;
        int xsqr = 1 << this.bitsDiscarded + this.bitsDiscarded;
        int txsqr = xsqr + xsqr;
        int[] dist_buf = new int[this.invMapLen];
        int i = this.invMapLen;
        while (--i >= 0) {
            dist_buf[i] = Integer.MAX_VALUE;
        }
        for (i = 0; i < no_of_colors; ++i) {
            int red = colorPalette[i] >> 16 & 0xFF;
            int green = colorPalette[i] >> 8 & 0xFF;
            int blue = colorPalette[i] & 0xFF;
            int rdist = (x >> 1) - red;
            int gdist = (x >> 1) - green;
            int bdist = (x >> 1) - blue;
            int dist = rdist * rdist + gdist * gdist + bdist * bdist;
            int rinc = txsqr - (red << this.bitsDiscarded + 1);
            int ginc = txsqr - (green << this.bitsDiscarded + 1);
            int binc = txsqr - (blue << this.bitsDiscarded + 1);
            int buf_index = 0;
            rdist = dist;
            for (int r = 0; r < this.maxColorVal; ++r) {
                gdist = rdist;
                for (int g = 0; g < this.maxColorVal; ++g) {
                    bdist = gdist;
                    for (int b = 0; b < this.maxColorVal; ++b) {
                        if (bdist < dist_buf[buf_index]) {
                            dist_buf[buf_index] = bdist;
                            this.invColorMap[buf_index] = (byte)i;
                        }
                        bdist += binc;
                        binc += txsqr;
                        ++buf_index;
                    }
                    gdist += ginc;
                    ginc += txsqr;
                }
                rdist += rinc;
                rinc += txsqr;
            }
        }
    }

    public void createInverseMap(int no_of_colors, byte[] redPalette, byte[] greenPalette, byte[] bluePalette) {
        int x = 1 << this.bitsDiscarded;
        int xsqr = 1 << this.bitsDiscarded + this.bitsDiscarded;
        int txsqr = xsqr + xsqr;
        int[] dist_buf = new int[this.invMapLen];
        int i = this.invMapLen;
        while (--i >= 0) {
            dist_buf[i] = Integer.MAX_VALUE;
        }
        for (i = 0; i < no_of_colors; ++i) {
            int red = redPalette[i] & 0xFF;
            int green = greenPalette[i] & 0xFF;
            int blue = bluePalette[i] & 0xFF;
            int rdist = (x >> 1) - red;
            int gdist = (x >> 1) - green;
            int bdist = (x >> 1) - blue;
            int dist = rdist * rdist + gdist * gdist + bdist * bdist;
            int rinc = txsqr - (red << this.bitsDiscarded + 1);
            int ginc = txsqr - (green << this.bitsDiscarded + 1);
            int binc = txsqr - (blue << this.bitsDiscarded + 1);
            int buf_index = 0;
            rdist = dist;
            for (int r = 0; r < this.maxColorVal; ++r) {
                gdist = rdist;
                for (int g = 0; g < this.maxColorVal; ++g) {
                    bdist = gdist;
                    for (int b = 0; b < this.maxColorVal; ++b) {
                        if (bdist < dist_buf[buf_index]) {
                            dist_buf[buf_index] = bdist;
                            this.invColorMap[buf_index] = (byte)i;
                        }
                        bdist += binc;
                        binc += txsqr;
                        ++buf_index;
                    }
                    gdist += ginc;
                    ginc += txsqr;
                }
                rdist += rinc;
                rinc += txsqr;
            }
        }
    }
}

