/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.writer;

import guilibshadow.cafe4j.image.ImageColorType;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.quant.DitherMethod;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.io.OutputStream;

public class BMPWriter
extends ImageWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BMPWriter.class);
    private BitmapHeader bitmapHeader;

    public BMPWriter() {
    }

    public BMPWriter(ImageParam param) {
        super(param);
    }

    @Override
    public ImageType getImageType() {
        return ImageType.BMP;
    }

    @Override
    protected void write(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        if (this.getImageParam().getColorType() == ImageColorType.INDEXED) {
            this.write256ColorBitmap(pixels, imageWidth, imageHeight, os);
        } else {
            this.writeTrueColorBitmap(pixels, imageWidth, imageHeight, os);
        }
    }

    private void write256ColorBitmap(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        int i;
        ImageParam param = this.getImageParam();
        int nindex = 0;
        int index = 0;
        int npad = 0;
        npad = 4 - imageWidth % 4;
        if (npad == 4) {
            npad = 0;
        }
        int bytePerScanLine = imageWidth + npad;
        byte[] brgb = new byte[1024];
        LOGGER.info("Saving as 256 bits bitmap color image!");
        this.bitmapHeader = new BitmapHeader();
        this.bitmapHeader.imageWidth = imageWidth;
        this.bitmapHeader.imageHeight = imageHeight;
        this.bitmapHeader.bitCount = (short)8;
        this.bitmapHeader.compression = 0;
        this.bitmapHeader.imageSize = bytePerScanLine * imageHeight;
        this.bitmapHeader.fileSize += this.bitmapHeader.imageSize;
        this.bitmapHeader.dataOffSet += 1024;
        this.bitmapHeader.colorsUsed = 256;
        this.bitmapHeader.colorsImportant = 256;
        this.bitmapHeader.writeHeader(os);
        byte[] newPixels = new byte[imageWidth * imageHeight];
        int[] colorPalette = new int[256];
        if (param.isApplyDither()) {
            if (param.getDitherMethod() == DitherMethod.FLOYD_STEINBERG) {
                IMGUtils.reduceColorsDiffusionDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, 8, newPixels, colorPalette);
            } else {
                IMGUtils.reduceColorsOrderedDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, 8, newPixels, colorPalette, param.getDitherMatrix());
            }
        } else {
            IMGUtils.reduceColors(param.getQuantMethod(), pixels, 8, newPixels, colorPalette, false);
        }
        for (i = 0; i < 256; ++i) {
            brgb[nindex++] = (byte)(colorPalette[i] & 0xFF);
            brgb[nindex++] = (byte)(colorPalette[i] >> 8 & 0xFF);
            brgb[nindex++] = (byte)(colorPalette[i] >> 16 & 0xFF);
            brgb[nindex++] = -1;
        }
        os.write(brgb, 0, 1024);
        brgb = new byte[bytePerScanLine];
        for (i = 1; i <= imageHeight; ++i) {
            nindex = 0;
            index = imageWidth * (imageHeight - i);
            for (int j = 0; j < imageWidth; ++j) {
                brgb[nindex++] = newPixels[index++];
            }
            os.write(brgb, 0, bytePerScanLine);
        }
        os.close();
    }

    private void writeTrueColorBitmap(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        int nindex = 0;
        int index = 0;
        int npad = 0;
        npad = 4 - imageWidth * 3 % 4;
        if (npad == 4) {
            npad = 0;
        }
        int bytePerScanLine = imageWidth * 3 + npad;
        byte[] brgb = new byte[bytePerScanLine];
        LOGGER.info("Saving as 24 bits bitmap color image!");
        this.bitmapHeader = new BitmapHeader();
        this.bitmapHeader.imageWidth = imageWidth;
        this.bitmapHeader.imageHeight = imageHeight;
        this.bitmapHeader.bitCount = (short)24;
        this.bitmapHeader.compression = 0;
        this.bitmapHeader.imageSize = bytePerScanLine * imageHeight;
        this.bitmapHeader.fileSize += this.bitmapHeader.imageSize;
        this.bitmapHeader.colorsUsed = 0;
        this.bitmapHeader.colorsImportant = 0;
        this.bitmapHeader.writeHeader(os);
        for (int i = 1; i <= imageHeight; ++i) {
            nindex = 0;
            index = imageWidth * (imageHeight - i);
            for (int j = 0; j < imageWidth; ++j) {
                brgb[nindex++] = (byte)(pixels[index] & 0xFF);
                brgb[nindex++] = (byte)(pixels[index] >> 8 & 0xFF);
                brgb[nindex++] = (byte)(pixels[index++] >> 16 & 0xFF);
            }
            os.write(brgb, 0, bytePerScanLine);
        }
        os.close();
    }

    private static class BitmapHeader {
        final byte[] signature = new byte[]{66, 77};
        int fileSize = 54;
        final short reserved1 = 0;
        final short reserved2 = 0;
        int dataOffSet = 54;
        final int infoHeaderLen = 40;
        int imageWidth;
        int imageHeight;
        final short planes = 1;
        short bitCount;
        int compression;
        int imageSize;
        int xResolution = 0;
        int yResolution = 0;
        int colorsUsed;
        int colorsImportant;

        private BitmapHeader() {
        }

        void writeHeader(OutputStream os) throws Exception {
            byte[] bhdr = new byte[]{this.signature[0], this.signature[1], (byte)(this.fileSize & 0xFF), (byte)(this.fileSize >> 8 & 0xFF), (byte)(this.fileSize >> 16 & 0xFF), (byte)(this.fileSize >> 24 & 0xFF), 0, 0, 0, 0, (byte)(this.dataOffSet & 0xFF), (byte)(this.dataOffSet >> 8 & 0xFF), (byte)(this.dataOffSet >> 16 & 0xFF), (byte)(this.dataOffSet >> 24 & 0xFF), 40, 0, 0, 0, (byte)(this.imageWidth & 0xFF), (byte)(this.imageWidth >> 8 & 0xFF), (byte)(this.imageWidth >> 16 & 0xFF), (byte)(this.imageWidth >> 24 & 0xFF), (byte)(this.imageHeight & 0xFF), (byte)(this.imageHeight >> 8 & 0xFF), (byte)(this.imageHeight >> 16 & 0xFF), (byte)(this.imageHeight >> 24 & 0xFF), 1, 0, (byte)(this.bitCount & 0xFF), (byte)(this.bitCount >> 8 & 0xFF), (byte)(this.compression & 0xFF), (byte)(this.compression >> 8 & 0xFF), (byte)(this.compression >> 16 & 0xFF), (byte)(this.compression >> 24 & 0xFF), (byte)(this.imageSize & 0xFF), (byte)(this.imageSize >> 8 & 0xFF), (byte)(this.imageSize >> 16 & 0xFF), (byte)(this.imageSize >> 24 & 0xFF), (byte)(this.xResolution & 0xFF), (byte)(this.xResolution >> 8 & 0xFF), (byte)(this.xResolution >> 16 & 0xFF), (byte)(this.xResolution >> 24 & 0xFF), (byte)(this.yResolution & 0xFF), (byte)(this.yResolution >> 8 & 0xFF), (byte)(this.yResolution >> 16 & 0xFF), (byte)(this.yResolution >> 24 & 0xFF), (byte)(this.colorsUsed & 0xFF), (byte)(this.colorsUsed >> 8 & 0xFF), (byte)(this.colorsUsed >> 16 & 0xFF), (byte)(this.colorsUsed >> 24 & 0xFF), (byte)(this.colorsImportant & 0xFF), (byte)(this.colorsImportant >> 8 & 0xFF), (byte)(this.colorsImportant >> 16 & 0xFF), (byte)(this.colorsImportant >> 24 & 0xFF)};
            os.write(bhdr, 0, 54);
        }
    }
}

