/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.writer;

import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.gif.GIFFrame;
import guilibshadow.cafe4j.image.quant.DitherMethod;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class GIFWriter
extends ImageWriter {
    private int codeLen;
    private int codeIndex;
    private int clearCode;
    private int endOfImage;
    private int bufIndex;
    private int empty_bits = 8;
    private int bitsPerPixel = 8;
    private byte[] bytes_buf = new byte[256];
    private int[] colorPalette;
    private static final int[] MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    int[] child = new int[4097];
    int[] siblings = new int[4097];
    int[] suffix = new int[4097];
    private int logicalScreenWidth;
    private int logicalScreenHeight;
    private boolean animated;
    private int loopCount;
    private boolean firstFrame = true;

    private static Dimension getLogicalScreenSize(BufferedImage[] images) {
        int logicalScreenWidth = 0;
        int logicalScreenHeight = 0;
        for (BufferedImage image : images) {
            if (image.getWidth() > logicalScreenWidth) {
                logicalScreenWidth = image.getWidth();
            }
            if (image.getHeight() <= logicalScreenHeight) continue;
            logicalScreenHeight = image.getHeight();
        }
        return new Dimension(logicalScreenWidth, logicalScreenHeight);
    }

    private static Dimension getLogicalScreenSize(GIFFrame[] frames) {
        int logicalScreenWidth = 0;
        int logicalScreenHeight = 0;
        for (GIFFrame frame : frames) {
            int frameRightPosition = frame.getFrameWidth() + frame.getLeftPosition();
            int frameBottomPosition = frame.getFrameHeight() + frame.getTopPosition();
            if (frameRightPosition > logicalScreenWidth) {
                logicalScreenWidth = frameRightPosition;
            }
            if (frameBottomPosition <= logicalScreenHeight) continue;
            logicalScreenHeight = frameBottomPosition;
        }
        return new Dimension(logicalScreenWidth, logicalScreenHeight);
    }

    public GIFWriter() {
    }

    public GIFWriter(ImageParam param) {
        super(param);
    }

    private void encode(byte[] pixels, OutputStream os) throws Exception {
        int parent = 0;
        int son = 0;
        int brother = 0;
        int color = 0;
        int index = 0;
        int dimension = pixels.length;
        this.bitsPerPixel = this.bitsPerPixel == 1 ? 2 : this.bitsPerPixel;
        os.write(this.bitsPerPixel);
        this.init_encoder(this.bitsPerPixel);
        this.send_code_to_buffer(this.clearCode, os);
        parent = pixels[index++] & 0xFF;
        block0: while (index < dimension) {
            color = pixels[index++] & 0xFF;
            son = this.child[parent];
            if (son > 0) {
                if (this.suffix[son] == color) {
                    parent = son;
                    continue;
                }
                brother = son;
                while (this.siblings[brother] > 0) {
                    if (this.suffix[brother = this.siblings[brother]] != color) continue;
                    parent = brother;
                    continue block0;
                }
                this.siblings[brother] = this.codeIndex;
                this.suffix[this.codeIndex] = color;
                this.send_code_to_buffer(parent, os);
                parent = color;
                ++this.codeIndex;
                if (this.codeIndex <= 1 << this.codeLen) continue;
                if (this.codeLen == 12) {
                    this.send_code_to_buffer(this.clearCode, os);
                    this.init_encoder(this.bitsPerPixel);
                    continue;
                }
                ++this.codeLen;
                continue;
            }
            this.child[parent] = this.codeIndex;
            this.suffix[this.codeIndex] = color;
            this.send_code_to_buffer(parent, os);
            parent = color;
            ++this.codeIndex;
            if (this.codeIndex <= 1 << this.codeLen) continue;
            if (this.codeLen == 12) {
                this.send_code_to_buffer(this.clearCode, os);
                this.init_encoder(this.bitsPerPixel);
                continue;
            }
            ++this.codeLen;
        }
        this.send_code_to_buffer(parent, os);
        this.send_code_to_buffer(this.endOfImage, os);
        this.flush_buf(os, this.bufIndex + 1);
    }

    public void finishWrite(OutputStream os) throws Exception {
        os.write(59);
        os.close();
    }

    private void flush_buf(OutputStream os, int len) throws Exception {
        os.write(len);
        os.write(this.bytes_buf, 0, len);
        this.bufIndex = 0;
        Arrays.fill(this.bytes_buf, 0, 255, (byte)0);
    }

    @Override
    public ImageType getImageType() {
        return ImageType.GIF;
    }

    private void init_encoder(int bitsPerPixel) {
        this.clearCode = 1 << bitsPerPixel;
        this.endOfImage = this.clearCode + 1;
        this.codeLen = bitsPerPixel + 1;
        this.codeIndex = this.endOfImage + 1;
        Arrays.fill(this.child, 0);
        Arrays.fill(this.siblings, 0);
        Arrays.fill(this.suffix, 0);
    }

    public void prepareForWrite(OutputStream os, int logicalScreenWidth, int logicalScreenHeight) throws Exception {
        this.writeHeader(os, true);
        this.logicalScreenWidth = logicalScreenWidth;
        this.logicalScreenHeight = logicalScreenHeight;
        this.animated = true;
    }

    private void send_code_to_buffer(int code, OutputStream os) throws Exception {
        int temp = this.codeLen;
        int n = this.bufIndex;
        this.bytes_buf[n] = (byte)(this.bytes_buf[n] | (code & MASK[this.empty_bits]) << 8 - this.empty_bits);
        code >>= this.empty_bits;
        temp -= this.empty_bits;
        while (temp > 0) {
            if (++this.bufIndex >= 255) {
                this.flush_buf(os, 255);
            }
            int n2 = this.bufIndex;
            this.bytes_buf[n2] = (byte)(this.bytes_buf[n2] | code & 0xFF);
            code >>= 8;
            temp -= 8;
        }
        this.empty_bits = -temp;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    @Override
    protected void write(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        this.writeHeader(os, true);
        this.logicalScreenWidth = imageWidth;
        this.logicalScreenHeight = imageHeight;
        this.firstFrame = true;
        this.animated = false;
        this.writeFrame(pixels, imageWidth, imageHeight, 0, 0, 0, os);
        os.write(59);
        os.close();
    }

    public void writeAnimatedGIF(BufferedImage[] images, int[] delays, OutputStream os) throws Exception {
        this.writeHeader(os, true);
        Dimension logicalScreenSize = GIFWriter.getLogicalScreenSize(images);
        this.logicalScreenWidth = logicalScreenSize.width;
        this.logicalScreenHeight = logicalScreenSize.height;
        this.animated = true;
        for (int i = 0; i < images.length; ++i) {
            int imageWidth = images[i].getWidth();
            int imageHeight = images[i].getHeight();
            int[] pixels = IMGUtils.getRGB(images[i]);
            this.writeFrame(pixels, imageWidth, imageHeight, 0, 0, delays[i], os);
        }
        os.write(59);
        os.close();
    }

    public void writeAnimatedGIF(GIFFrame[] frames, OutputStream os) throws Exception {
        this.writeHeader(os, true);
        Dimension logicalScreenSize = GIFWriter.getLogicalScreenSize(frames);
        this.logicalScreenWidth = logicalScreenSize.width;
        this.logicalScreenHeight = logicalScreenSize.height;
        this.animated = true;
        for (int i = 0; i < frames.length; ++i) {
            int imageWidth = frames[i].getFrameWidth();
            int imageHeight = frames[i].getFrameHeight();
            int[] pixels = IMGUtils.getRGB(frames[i].getFrame());
            if (frames[i].getTransparencyFlag() == 1 && frames[i].getTransparentColor() != -1) {
                int transColor = frames[i].getTransparentColor() & 0xFFFFFF;
                for (int j = pixels.length - 1; j > 0; --j) {
                    int pixel = pixels[j] & 0xFFFFFF;
                    if (pixel != transColor) continue;
                    pixels[j] = pixel;
                }
            }
            this.writeFrame(pixels, imageWidth, imageHeight, frames[i].getLeftPosition(), frames[i].getTopPosition(), frames[i].getDelay(), frames[i].getDisposalMethod(), frames[i].getUserInputFlag(), os);
        }
        os.write(59);
        os.close();
    }

    public void writeAnimatedGIF(List<GIFFrame> frames, OutputStream os) throws Exception {
        this.writeAnimatedGIF(frames.toArray(new GIFFrame[0]), os);
    }

    public void writeComment(OutputStream os, String comment) throws Exception {
        os.write(33);
        os.write(-2);
        byte[] commentBytes = comment.getBytes();
        int numBlocks = commentBytes.length / 255;
        int leftOver = commentBytes.length % 255;
        int offset = 0;
        if (numBlocks > 0) {
            for (int i = 0; i < numBlocks; ++i) {
                os.write(255);
                os.write(commentBytes, offset, 255);
                offset += 255;
            }
        }
        if (leftOver > 0) {
            os.write(leftOver);
            os.write(commentBytes, offset, leftOver);
        }
        os.write(0);
    }

    public void writeFrame(OutputStream os, GIFFrame frame) throws Exception {
        BufferedImage image = frame.getFrame();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int frameLeft = frame.getLeftPosition();
        int frameTop = frame.getTopPosition();
        if (this.firstFrame) {
            if (this.logicalScreenWidth <= 0) {
                this.logicalScreenWidth = imageWidth;
            }
            if (this.logicalScreenHeight <= 0) {
                this.logicalScreenHeight = imageHeight;
            }
        }
        if (frameLeft >= this.logicalScreenWidth || frameTop >= this.logicalScreenHeight) {
            return;
        }
        if (frameLeft + imageWidth > this.logicalScreenWidth) {
            imageWidth = this.logicalScreenWidth - frameLeft;
        }
        if (frameTop + imageHeight > this.logicalScreenHeight) {
            imageHeight = this.logicalScreenHeight - frameTop;
        }
        int[] pixels = IMGUtils.getRGB(image.getSubimage(0, 0, imageWidth, imageHeight));
        if (frame.getTransparencyFlag() == 1 && frame.getTransparentColor() != -1) {
            int transColor = frame.getTransparentColor() & 0xFFFFFF;
            for (int j = pixels.length - 1; j > 0; --j) {
                int pixel = pixels[j] & 0xFFFFFF;
                if (pixel != transColor) continue;
                pixels[j] = pixel;
            }
        }
        this.writeFrame(pixels, imageWidth, imageHeight, frame.getLeftPosition(), frame.getTopPosition(), frame.getDelay(), frame.getDisposalMethod(), frame.getUserInputFlag(), os);
    }

    public void writeFrame(OutputStream os, BufferedImage frame) throws Exception {
        this.writeFrame(os, frame, 100);
    }

    public void writeFrame(OutputStream os, BufferedImage frame, int delay) throws Exception {
        int imageWidth = frame.getWidth();
        int imageHeight = frame.getHeight();
        if (this.firstFrame) {
            if (this.logicalScreenWidth <= 0) {
                this.logicalScreenWidth = imageWidth;
            }
            if (this.logicalScreenHeight <= 0) {
                this.logicalScreenHeight = imageHeight;
            }
        }
        if (delay <= 0) {
            delay = 100;
        }
        if (imageWidth > this.logicalScreenWidth) {
            imageWidth = this.logicalScreenWidth;
        }
        if (imageHeight > this.logicalScreenHeight) {
            imageHeight = this.logicalScreenHeight;
        }
        int[] pixels = IMGUtils.getRGB(frame.getSubimage(0, 0, imageWidth, imageHeight));
        this.writeFrame(pixels, imageWidth, imageHeight, 0, 0, delay, os);
    }

    private void writeFrame(int[] pixels, int imageWidth, int imageHeight, int imageLeftPosition, int imageTopPosition, int delay, int disposalMethod, int userInputFlag, OutputStream os) throws Exception {
        ImageParam param = this.getImageParam();
        this.empty_bits = 8;
        int transparent_color = -1;
        byte[] newPixels = new byte[imageWidth * imageHeight];
        this.colorPalette = new int[256];
        int[] colorInfo = IMGUtils.checkColorDepth(pixels, newPixels, this.colorPalette);
        if (colorInfo[0] > 8) {
            this.bitsPerPixel = param.getBitsPerPixel();
            if (this.bitsPerPixel <= 0 || this.bitsPerPixel > 8) {
                this.bitsPerPixel = 8;
            }
            colorInfo = param.isApplyDither() ? (param.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.reduceColorsDiffusionDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, this.bitsPerPixel, newPixels, this.colorPalette) : IMGUtils.reduceColorsOrderedDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, this.bitsPerPixel, newPixels, this.colorPalette, param.getDitherMatrix())) : IMGUtils.reduceColors(param.getQuantMethod(), pixels, this.bitsPerPixel, newPixels, this.colorPalette, false);
        }
        this.bitsPerPixel = colorInfo[0];
        transparent_color = colorInfo[1];
        int num_of_color = 1 << this.bitsPerPixel;
        if (this.firstFrame) {
            int flags = -120;
            byte bgcolor = 0;
            byte aspectRatio = 0;
            int colorResolution = 7;
            flags = (byte)(flags | (colorResolution << 4 | this.bitsPerPixel - 1));
            if (transparent_color >= 0) {
                bgcolor = (byte)transparent_color;
            }
            this.writeLSD(os, (short)this.logicalScreenWidth, (short)this.logicalScreenHeight, (short)flags, bgcolor, aspectRatio);
            this.writePalette(os, num_of_color);
            this.writeComment(os, "Created by ICAFE - https://github.com/dragon66/icafe");
            if (this.animated) {
                this.writeNetscapeApplicationBlock(os, this.loopCount);
            }
        }
        this.writeGraphicControlBlock(os, delay, transparent_color, disposalMethod, userInputFlag);
        if (this.firstFrame) {
            this.writeImageDescriptor(os, imageWidth, imageHeight, imageLeftPosition, imageTopPosition, -1);
            this.firstFrame = false;
        } else {
            this.writeImageDescriptor(os, imageWidth, imageHeight, imageLeftPosition, imageTopPosition, this.bitsPerPixel - 1);
            this.writePalette(os, num_of_color);
        }
        this.encode(newPixels, os);
        os.write(0);
    }

    private void writeFrame(int[] pixels, int imageWidth, int imageHeight, int imageLeftPosition, int imageTopPosition, int delay, OutputStream os) throws Exception {
        this.writeFrame(pixels, imageWidth, imageHeight, imageLeftPosition, imageTopPosition, delay, 2, 0, os);
    }

    private void writeGraphicControlBlock(OutputStream os, int delay, int transparent_color, int disposalMethod, int userInputFlag) throws Exception {
        byte[] buf;
        delay = Math.round((float)delay / 10.0f);
        buf = new byte[]{33, -7, 4, (byte)(buf[3] | ((disposalMethod & 7) << 2 | (userInputFlag & 1) << 1)), (byte)(delay & 0xFF), (byte)(delay >> 8 & 0xFF), (byte)transparent_color, 0};
        if (transparent_color >= 0) {
            buf[3] = (byte)(buf[3] | 1);
        }
        os.write(buf, 0, 8);
    }

    private void writeHeader(OutputStream os, boolean newFormat) throws IOException {
        if (newFormat) {
            os.write("GIF89a".getBytes());
        } else {
            os.write("GIF87a".getBytes());
        }
    }

    private void writeImageDescriptor(OutputStream os, int imageWidth, int imageHeight, int imageLeftPosition, int imageTopPosition, int colorTableSize) throws Exception {
        byte[] imageDescriptor = new byte[]{44, (byte)(imageLeftPosition & 0xFF), (byte)(imageLeftPosition >> 8 & 0xFF), (byte)(imageTopPosition & 0xFF), (byte)(imageTopPosition >> 8 & 0xFF), (byte)(imageWidth & 0xFF), (byte)(imageWidth >> 8 & 0xFF), (byte)(imageHeight & 0xFF), (byte)(imageHeight >> 8 & 0xFF), 32};
        if (colorTableSize >= 0) {
            imageDescriptor[9] = (byte)(imageDescriptor[9] | (0x80 | colorTableSize));
        }
        os.write(imageDescriptor, 0, 10);
    }

    private void writeLSD(OutputStream os, short screen_width, short screen_height, short flags, byte bgcolor, byte aspectRatio) throws IOException {
        byte[] descriptor = new byte[]{(byte)(screen_width & 0xFF), (byte)(screen_width >> 8 & 0xFF), (byte)(screen_height & 0xFF), (byte)(screen_height >> 8 & 0xFF), (byte)(flags & 0xFF), bgcolor, aspectRatio};
        os.write(descriptor);
    }

    private void writeNetscapeApplicationBlock(OutputStream os, int loopCounts) throws Exception {
        byte[] buf = new byte[]{33, -1, 11, 78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48, 3, 1, (byte)(loopCounts & 0xFF), (byte)(loopCounts >> 8 & 0xFF), 0};
        os.write(buf);
    }

    private void writePalette(OutputStream os, int num_of_color) throws Exception {
        int index = 0;
        byte[] colors = new byte[num_of_color * 3];
        for (int i = 0; i < num_of_color; ++i) {
            colors[index++] = (byte)(this.colorPalette[i] >> 16 & 0xFF);
            colors[index++] = (byte)(this.colorPalette[i] >> 8 & 0xFF);
            colors[index++] = (byte)(this.colorPalette[i] & 0xFF);
        }
        os.write(colors, 0, num_of_color * 3);
    }
}

