/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.writer;

import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.util.IMGUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.OutputStream;

public abstract class ImageWriter {
    private ImageParam imageParam = ImageParam.DEFAULT_IMAGE_PARAM;

    protected ImageWriter() {
    }

    protected ImageWriter(ImageParam param) {
        this.imageParam = param;
    }

    private int[] getPixels(Image img, int imageWidth, int imageHeight) throws Exception {
        int[] pixels = null;
        if (img instanceof BufferedImage) {
            pixels = IMGUtils.getRGB((BufferedImage)img);
        } else {
            pixels = new int[imageWidth * imageHeight];
            PixelGrabber pg = new PixelGrabber(img, 0, 0, imageWidth, imageHeight, pixels, 0, imageWidth);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                System.err.println("interrupted waiting for pixels!");
            }
            if ((pg.getStatus() & 0x80) != 0) {
                System.err.println("image fetch aborted or errored");
            }
        }
        if (this.imageParam.isTransparent()) {
            int transColor = this.imageParam.getTransparentColor() & 0xFFFFFF;
            for (int i = pixels.length - 1; i > 0; --i) {
                int pixel = pixels[i] & 0xFFFFFF;
                if (pixel != transColor) continue;
                pixels[i] = pixel;
            }
        }
        return pixels;
    }

    public ImageParam getImageParam() {
        return this.imageParam;
    }

    public abstract ImageType getImageType();

    public void setImageParam(ImageParam imageParam) {
        this.imageParam = imageParam;
    }

    public void write(Image img, OutputStream os) throws Exception {
        int imageWidth = img.getWidth(null);
        int imageHeight = img.getHeight(null);
        this.write(this.getPixels(img, imageWidth, imageHeight), imageWidth, imageHeight, os);
    }

    protected abstract void write(int[] var1, int var2, int var3, OutputStream var4) throws Exception;
}

