/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.writer;

import guilibshadow.cafe4j.image.ImageColorType;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.compression.huffman.HuffmanEncoder;
import guilibshadow.cafe4j.image.jpeg.HTable;
import guilibshadow.cafe4j.image.jpeg.JPGConsts;
import guilibshadow.cafe4j.image.jpeg.Marker;
import guilibshadow.cafe4j.image.jpeg.QTable;
import guilibshadow.cafe4j.image.jpeg.Segment;
import guilibshadow.cafe4j.image.options.ImageOptions;
import guilibshadow.cafe4j.image.options.JPGOptions;
import guilibshadow.cafe4j.image.util.DCT;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.IOUtils;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class JPGWriter
extends ImageWriter {
    private int newHeight;
    private int newWidth;
    private ImageParam imageParam;
    private JPGOptions jpegOptions;
    private int numOfComponents = 3;
    private int numOfQTables = 2;
    private int numOfHTables = 2;
    private int[] qTableSelector = new int[]{0, 1, 1, 1};
    private int[][] quant_table = new int[2][];
    private byte[][][] huffman_bits = new byte[2][2][];
    private byte[][][] huffman_values = new byte[2][2][];
    private int quality = 100;
    private boolean includeTables = true;
    private boolean grayScale;
    private int colorSpace = JPGOptions.COLOR_SPACE_YCbCr;
    private static final String pathToCMYKProfile = "/resources/CMYK Profiles/USWebCoatedSWOP.icc";
    private ICC_ColorSpace cmykColorSpace;
    private boolean writeICCProfile;
    private boolean isTiffFlavor;
    private static final String comment = "Created by ICAFE - https://github.com/dragon66/icafe";

    public JPGWriter() {
    }

    public JPGWriter(ImageParam param) {
        super(param);
    }

    private float[][] expandArray(float[][] component, int width, int height) {
        int xpadding = width % 8;
        int ypadding = height % 8;
        this.newWidth = width + (xpadding == 0 ? 0 : 8 - xpadding);
        this.newHeight = height + (ypadding == 0 ? 0 : 8 - ypadding);
        if (this.newWidth > width || this.newHeight > height) {
            float[][] temp = new float[this.newHeight][this.newWidth];
            for (int i = 0; i < height; ++i) {
                System.arraycopy(component[i], 0, temp[i], 0, width);
                Arrays.fill(temp[i], width, this.newWidth, component[i][width - 1]);
            }
            for (int k = height; k < this.newHeight; ++k) {
                System.arraycopy(temp[height - 1], 0, temp[k], 0, this.newWidth);
            }
            return temp;
        }
        return component;
    }

    private float[][] getDCTBlock(float[][] component, int x, int y) {
        float[][] block = new float[8][8];
        int i = x;
        int index = 0;
        while (i < 8 + x) {
            System.arraycopy(component[i], y, block[index], 0, 8);
            ++i;
            ++index;
        }
        return block;
    }

    public byte[] getCMYK_ICC_Profile() {
        if (this.cmykColorSpace != null) {
            return this.cmykColorSpace.getProfile().getData();
        }
        return null;
    }

    @Override
    public ImageType getImageType() {
        return ImageType.JPG;
    }

    private void processImageMeta() throws Exception {
        this.imageParam = this.getImageParam();
        this.grayScale = this.imageParam.getColorType() == ImageColorType.GRAY_SCALE;
        ImageOptions options = this.imageParam.getImageOptions();
        if (options instanceof JPGOptions) {
            this.jpegOptions = (JPGOptions)options;
            this.quality = this.jpegOptions.getQuality();
            this.includeTables = this.jpegOptions.includeTables();
            this.colorSpace = this.jpegOptions.getColorSpace();
            this.isTiffFlavor = this.jpegOptions.isTiffFlavor();
            this.writeICCProfile = this.jpegOptions.writeICCProfile();
        }
        if (this.colorSpace == JPGOptions.COLOR_SPACE_CMYK || this.colorSpace == JPGOptions.COLOR_SPACE_YCCK) {
            this.numOfComponents = 4;
            if (this.cmykColorSpace == null) {
                this.cmykColorSpace = IMGUtils.getICCColorSpace(pathToCMYKProfile);
            }
        }
        if (this.grayScale) {
            this.numOfComponents = 1;
            this.numOfQTables = 1;
            this.numOfHTables = 1;
        }
        this.setDefaultTables(this.quality);
    }

    private void RGB2RGB(int[] rgb, float[][] r, float[][] g, float[][] b, int imageWidth, int imageHeight) throws Exception {
        int index = 0;
        for (int i = 0; i < imageHeight; ++i) {
            for (int j = 0; j < imageWidth; ++j) {
                int red = rgb[index] >> 16 & 0xFF;
                int green = rgb[index] >> 8 & 0xFF;
                int blue = rgb[index++] & 0xFF;
                r[i][j] = (float)red - 128.0f;
                g[i][j] = (float)green - 128.0f;
                b[i][j] = (float)blue - 128.0f;
            }
        }
    }

    private void setDefaultTables(int quality) {
        this.quant_table[0] = JPGConsts.getDefaultLuminanceMatrix(quality);
        this.quant_table[1] = JPGConsts.getDefaultChrominanceMatrix(quality);
        this.huffman_bits[0][0] = JPGConsts.getDCLuminanceBits();
        this.huffman_bits[0][1] = JPGConsts.getDCChrominanceBits();
        this.huffman_bits[1][0] = JPGConsts.getACLuminanceBits();
        this.huffman_bits[1][1] = JPGConsts.getACChrominanceBits();
        this.huffman_values[0][0] = JPGConsts.getDCLuminanceValues();
        this.huffman_values[0][1] = JPGConsts.getDCChrominanceValues();
        this.huffman_values[1][0] = JPGConsts.getACLuminanceValues();
        this.huffman_values[1][1] = JPGConsts.getACChrominanceValues();
    }

    @Override
    protected void write(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        this.processImageMeta();
        this.writeSOI(os);
        if (this.colorSpace == JPGOptions.COLOR_SPACE_YCbCr) {
            this.writeJFIF(os);
        } else {
            this.writeAdobeApp14(os);
        }
        if ((this.colorSpace == JPGOptions.COLOR_SPACE_CMYK || this.colorSpace == JPGOptions.COLOR_SPACE_YCCK) && this.writeICCProfile) {
            this.writeICCProfile(os);
        }
        this.writeComment(comment, os);
        this.writeComment("Created on " + new SimpleDateFormat("yyyy:MM:dd HH:mm:ss z").format(new Date()), os);
        if (this.includeTables) {
            this.writeDQT(os);
            this.writeDHT(os);
        }
        this.writeSOF0(os, imageWidth, imageHeight);
        this.writeSOS(os);
        if (this.grayScale) {
            this.writeGrayScale(IMGUtils.rgb2grayscale(pixels, imageWidth, imageHeight), os, imageWidth, imageHeight);
        } else {
            this.writeFullColor(pixels, os, imageWidth, imageHeight);
        }
        this.writeEOI(os);
    }

    private void writeAdobeApp14(OutputStream os) throws Exception {
        int len = 14;
        byte[] app14 = new byte[len + 2];
        app14[0] = -1;
        app14[1] = -18;
        app14[2] = (byte)(len >> 8 & 0xFF);
        app14[3] = (byte)(len & 0xFF);
        app14[4] = 65;
        app14[5] = 100;
        app14[6] = 111;
        app14[7] = 98;
        app14[8] = 101;
        app14[9] = 0;
        app14[10] = 100;
        app14[11] = 0;
        app14[12] = 0;
        app14[13] = 0;
        app14[14] = 0;
        app14[15] = 0;
        if (this.colorSpace == JPGOptions.COLOR_SPACE_YCbCr) {
            app14[15] = 1;
        } else if (this.colorSpace == JPGOptions.COLOR_SPACE_YCCK) {
            app14[15] = 2;
        }
        os.write(app14);
    }

    private void writeComment(String comment, OutputStream os) throws Exception {
        byte[] data = comment.getBytes();
        int len = data.length + 2;
        byte[] COM2 = new byte[len + 2];
        COM2[0] = -1;
        COM2[1] = -2;
        COM2[2] = (byte)(len >> 8 & 0xFF);
        COM2[3] = (byte)(len & 0xFF);
        System.arraycopy(data, 0, COM2, 4, len - 2);
        os.write(COM2, 0, len + 2);
    }

    private void writeDHT(HTable table, OutputStream os) throws Exception {
        int HT_class = table.getClazz();
        int HT_destination_id = table.getID();
        byte[] bits = table.getBits();
        byte[] values = table.getValues();
        int noOfCodes = 0;
        for (byte i : bits) {
            noOfCodes += i;
        }
        byte[] temp = new byte[1 + bits.length + noOfCodes];
        System.arraycopy(bits, 0, temp, 1, bits.length);
        System.arraycopy(values, 0, temp, bits.length + 1, noOfCodes);
        temp[0] = (byte)(HT_class << 4 & 0xF0 | HT_destination_id & 0xF);
        new Segment(Marker.DHT, temp.length + 2, temp).write(os);
    }

    private void writeDHT(OutputStream os) throws Exception {
        for (int i = 0; i < this.numOfHTables; ++i) {
            this.writeDHT(new HTable(0, i, this.huffman_bits[0][i], this.huffman_values[0][i]), os);
            this.writeDHT(new HTable(1, i, this.huffman_bits[1][i], this.huffman_values[1][i]), os);
        }
    }

    private void writeDQT(OutputStream os) throws Exception {
        for (int i = 0; i < this.numOfQTables; ++i) {
            this.writeDQT(new QTable(0, i, this.quant_table[i]), os);
        }
    }

    private void writeDQT(QTable table, OutputStream os) throws Exception {
        byte[] dqt;
        int precision = table.getPrecision();
        int index = table.getID();
        int[] data = table.getData();
        int[] zigzagOrder = JPGConsts.getZigzagMatrix();
        if (precision == 0) {
            dqt = new byte[1 + data.length];
            for (int i = 1; i < dqt.length; ++i) {
                dqt[i] = (byte)data[zigzagOrder[i - 1]];
            }
        } else {
            dqt = new byte[1 + data.length * 2];
            for (int i = 1; i < data.length; ++i) {
                dqt[i] = (byte)(data[zigzagOrder[i - 1]] >> 8);
                dqt[i + 1] = (byte)data[zigzagOrder[i - 1]];
            }
        }
        dqt[0] = (byte)(index & 0xF | precision << 4 & 0xF0);
        new Segment(Marker.DQT, dqt.length + 2, dqt).write(os);
    }

    private void writeEOI(OutputStream os) throws Exception {
        byte[] EOI = new byte[]{-1, -39};
        os.write(EOI);
    }

    private void writeGrayScale(float[][] pixels, OutputStream os, int imageWidth, int imageHeight) throws Exception {
        pixels = this.expandArray(pixels, imageWidth, imageHeight);
        HuffmanEncoder encoder = new HuffmanEncoder(os, 4096);
        encoder.initialize();
        for (int i = 0; i < this.newHeight; i += 8) {
            for (int j = 0; j < this.newWidth; j += 8) {
                float[][] block = this.getDCTBlock(pixels, i, j);
                block = DCT.forwardDCT(block);
                int[] unzigzagBlock = new int[64];
                int index = 0;
                for (int k = 0; k < 8; ++k) {
                    int l = 0;
                    while (l < 8) {
                        unzigzagBlock[index] = (int)block[k][l] / this.quant_table[0][index];
                        ++l;
                        ++index;
                    }
                }
                encoder.encode(unzigzagBlock, 0);
            }
        }
        encoder.finish();
    }

    private void writeICCProfile(OutputStream os) throws Exception {
        ICC_Profile icc_profile = this.cmykColorSpace.getProfile();
        this.writeICCProfile(os, icc_profile.getData());
    }

    private void writeICCProfile(OutputStream os, byte[] data) throws Exception {
        String ICC_PROFILE_ID = "ICC_PROFILE\u0000";
        int maxSegmentLen = 65535;
        int maxICCDataLen = 65519;
        int numOfSegment = data.length / maxICCDataLen;
        int leftOver = data.length % maxICCDataLen;
        int totalSegment = numOfSegment == 0 ? 1 : (leftOver == 0 ? numOfSegment : numOfSegment + 1);
        for (int i = 0; i < numOfSegment; ++i) {
            IOUtils.writeShortMM(os, Marker.APP2.getValue());
            IOUtils.writeShortMM(os, maxSegmentLen);
            IOUtils.write(os, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(os, totalSegment | i + 1 << 8);
            IOUtils.write(os, data, i * maxICCDataLen, maxICCDataLen);
        }
        if (leftOver != 0) {
            IOUtils.writeShortMM(os, Marker.APP2.getValue());
            IOUtils.writeShortMM(os, leftOver + 16);
            IOUtils.write(os, "ICC_PROFILE\u0000".getBytes());
            IOUtils.writeShortMM(os, totalSegment | totalSegment << 8);
            IOUtils.write(os, data, data.length - leftOver, leftOver);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFullColor(int[] pixels, OutputStream os, int imageWidth, int imageHeight) throws Exception {
        float[][][] c = new float[this.numOfComponents][imageHeight][imageWidth];
        if (this.colorSpace == JPGOptions.COLOR_SPACE_YCbCr) {
            IMGUtils.RGB2YCbCr(pixels, c[0], c[1], c[2], imageWidth, imageHeight);
        } else if (this.colorSpace == JPGOptions.COLOR_SPACE_RGB) {
            this.RGB2RGB(pixels, c[0], c[1], c[2], imageWidth, imageHeight);
        } else if (this.colorSpace == JPGOptions.COLOR_SPACE_CMYK) {
            if (!this.isTiffFlavor) {
                IMGUtils.RGB2CMYK_Inverted(this.cmykColorSpace, pixels, c[0], c[1], c[2], c[3], imageWidth, imageHeight);
            } else {
                IMGUtils.RGB2CMYK(this.cmykColorSpace, pixels, c[0], c[1], c[2], c[3], imageWidth, imageHeight);
            }
        } else {
            if (this.colorSpace != JPGOptions.COLOR_SPACE_YCCK) throw new IllegalArgumentException("Unsupported color space type: " + this.colorSpace);
            if (this.isTiffFlavor) throw new UnsupportedOperationException("YCCK JPEG is not supported in TIFF!");
            IMGUtils.RGB2YCCK_Inverted(this.cmykColorSpace, pixels, c[0], c[1], c[2], c[3], imageWidth, imageHeight);
        }
        for (int i = 0; i < this.numOfComponents; ++i) {
            c[i] = this.expandArray(c[i], imageWidth, imageHeight);
        }
        HuffmanEncoder encoder = new HuffmanEncoder(os, 4096);
        encoder.initialize();
        for (int i = 0; i < this.newHeight; i += 8) {
            for (int j = 0; j < this.newWidth; j += 8) {
                for (int k = 0; k < this.numOfComponents; ++k) {
                    int[] q = this.quant_table[this.qTableSelector[k]];
                    float[][] block = this.getDCTBlock(c[k], i, j);
                    block = DCT.forwardDCT(block);
                    int[] unzigzagBlock = new int[64];
                    int index = 0;
                    for (int l = 0; l < 8; ++l) {
                        int m = 0;
                        while (m < 8) {
                            unzigzagBlock[index] = (int)block[l][m] / q[index];
                            ++m;
                            ++index;
                        }
                    }
                    encoder.encode(unzigzagBlock, k);
                }
            }
        }
        encoder.finish();
    }

    private void writeJFIF(OutputStream os) throws Exception {
        byte[] JFIF2 = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        os.write(JFIF2);
    }

    public void writeDefaultJPEGTables(OutputStream os) throws Exception {
        if (this.imageParam == null) {
            this.processImageMeta();
        }
        this.writeSOI(os);
        this.writeDQT(os);
        this.writeDHT(os);
        this.writeEOI(os);
    }

    private void writeSOF0(OutputStream os, int imageWidth, int imageHeight) throws Exception {
        int length = 8 + 3 * this.numOfComponents;
        byte[] SOF = new byte[length + 2];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = (byte)(length >> 8);
        SOF[3] = (byte)length;
        SOF[4] = 8;
        SOF[5] = (byte)(imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(imageHeight & 0xFF);
        SOF[7] = (byte)(imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(imageWidth & 0xFF);
        SOF[9] = (byte)this.numOfComponents;
        int offset = 10;
        for (int i = 0; i < this.numOfComponents; ++i) {
            SOF[offset++] = (byte)(i + 1);
            SOF[offset++] = 17;
            SOF[offset++] = (byte)this.qTableSelector[i];
        }
        os.write(SOF);
    }

    private void writeSOI(OutputStream os) throws Exception {
        byte[] SOI = new byte[]{-1, -40};
        os.write(SOI);
    }

    private void writeSOS(OutputStream os) throws Exception {
        int length = 6 + 2 * this.numOfComponents;
        byte[] SOS = new byte[length + 2];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = (byte)(length >> 8);
        SOS[3] = (byte)length;
        SOS[4] = (byte)this.numOfComponents;
        int offset = 5;
        for (int i = 0; i < this.numOfComponents; ++i) {
            SOS[offset++] = (byte)(i + 1);
            SOS[offset++] = (byte)((this.qTableSelector[i] << 4) + this.qTableSelector[i]);
        }
        SOS[offset++] = 0;
        SOS[offset++] = 63;
        SOS[offset++] = 0;
        os.write(SOS);
    }
}

