/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.writer;

import guilibshadow.cafe4j.image.ImageColorType;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.options.ImageOptions;
import guilibshadow.cafe4j.image.options.PNGOptions;
import guilibshadow.cafe4j.image.png.Chunk;
import guilibshadow.cafe4j.image.png.ChunkType;
import guilibshadow.cafe4j.image.png.ColorType;
import guilibshadow.cafe4j.image.png.Filter;
import guilibshadow.cafe4j.image.png.IDATBuilder;
import guilibshadow.cafe4j.image.png.IENDBuilder;
import guilibshadow.cafe4j.image.png.IHDRBuilder;
import guilibshadow.cafe4j.image.png.PLTEBuilder;
import guilibshadow.cafe4j.image.png.PNGTweaker;
import guilibshadow.cafe4j.image.png.TIMEBuilder;
import guilibshadow.cafe4j.image.png.TRNSBuilder;
import guilibshadow.cafe4j.image.png.TextBuilder;
import guilibshadow.cafe4j.image.quant.DitherMethod;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.io.IOUtils;
import guilibshadow.cafe4j.util.ArrayUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class PNGWriter
extends ImageWriter {
    boolean isApplyAdaptiveFilter = false;
    int filterType = 0;
    int compressionLevel = 4;
    ImageParam imageParam;
    private List<Chunk> chunks = new ArrayList<Chunk>(10);
    private static final long SIGNATURE = -8552249625308161526L;

    public PNGWriter() {
    }

    public PNGWriter(ImageParam param) {
        super(param);
    }

    private static void apply_adaptive_filter(int[] filter_type, byte[] pixBytes, int height, int bytesPerPixel, int bytesPerScanLine) {
        byte[] tempRow = new byte[bytesPerScanLine];
        byte[] filteredRow = new byte[bytesPerScanLine];
        int j = height - 1;
        int offset = pixBytes.length - bytesPerScanLine;
        while (j >= 0) {
            System.arraycopy(pixBytes, offset, tempRow, 0, bytesPerScanLine);
            Filter.filter_sub(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
            int sum = PNGWriter.calculateMSAD(pixBytes, offset, bytesPerScanLine);
            filter_type[j] = 1;
            System.arraycopy(pixBytes, offset, filteredRow, 0, bytesPerScanLine);
            System.arraycopy(tempRow, 0, pixBytes, offset, bytesPerScanLine);
            Filter.filter_up(bytesPerScanLine, pixBytes, offset);
            int newSum = PNGWriter.calculateMSAD(pixBytes, offset, bytesPerScanLine);
            if (newSum < sum) {
                sum = newSum;
                filter_type[j] = 2;
                System.arraycopy(pixBytes, offset, filteredRow, 0, bytesPerScanLine);
            }
            System.arraycopy(tempRow, 0, pixBytes, offset, bytesPerScanLine);
            Filter.filter_average(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
            newSum = PNGWriter.calculateMSAD(pixBytes, offset, bytesPerScanLine);
            if (newSum < sum) {
                sum = newSum;
                filter_type[j] = 3;
                System.arraycopy(pixBytes, offset, filteredRow, 0, bytesPerScanLine);
            }
            System.arraycopy(tempRow, 0, pixBytes, offset, bytesPerScanLine);
            Filter.filter_paeth(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
            newSum = PNGWriter.calculateMSAD(pixBytes, offset, bytesPerScanLine);
            if (newSum < sum) {
                sum = newSum;
                filter_type[j] = 4;
                System.arraycopy(pixBytes, offset, filteredRow, 0, bytesPerScanLine);
            }
            System.arraycopy(filteredRow, 0, pixBytes, offset, bytesPerScanLine);
            --j;
            offset -= bytesPerScanLine;
        }
    }

    private static void apply_filter(int[] filter_type, byte[] pixBytes, int height, int bytesPerPixel, int bytesPerScanLine) {
        int j = height - 1;
        int offset = pixBytes.length - bytesPerScanLine;
        while (j >= 0) {
            switch (filter_type[j]) {
                case 0: {
                    break;
                }
                case 1: {
                    Filter.filter_sub(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
                    break;
                }
                case 2: {
                    Filter.filter_up(bytesPerScanLine, pixBytes, offset);
                    break;
                }
                case 3: {
                    Filter.filter_average(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
                    break;
                }
                case 4: {
                    Filter.filter_paeth(bytesPerPixel, bytesPerScanLine, pixBytes, offset);
                    break;
                }
            }
            --j;
            offset -= bytesPerScanLine;
        }
    }

    private static int calculateMSAD(byte[] input, int offset, int length) {
        int sum = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            sum += input[i] > 0 ? input[i] : -input[i];
        }
        return sum;
    }

    private static int getBytesPerScanLine(int bitsPerPixel, int imageWidth, boolean hasAlpha) {
        int bytesPerPixel = hasAlpha ? 2 : 1;
        int bytesPerScanLine = imageWidth * bytesPerPixel;
        switch (bitsPerPixel) {
            case 1: {
                bytesPerScanLine = (imageWidth >>> 3) + (imageWidth % 8 == 0 ? 0 : 1);
                break;
            }
            case 2: {
                bytesPerScanLine = (imageWidth >>> 2) + (imageWidth % 4 == 0 ? 0 : 1);
                break;
            }
            case 4: {
                bytesPerScanLine = (imageWidth >>> 1) + (imageWidth % 2 == 0 ? 0 : 1);
                break;
            }
        }
        return bytesPerScanLine;
    }

    private void addTextChunks(List<Chunk> chunks) {
        TextBuilder txtBuilder = new TextBuilder(ChunkType.TEXT);
        txtBuilder.keyword("Software").text("ICAFE - https://github.com/dragon66/icafe");
        chunks.add(txtBuilder.build());
    }

    private void addTimeChunk(List<Chunk> chunks) {
        TIMEBuilder timeBuilder = new TIMEBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        timeBuilder.calendar(calendar);
        chunks.add(timeBuilder.build());
    }

    @Override
    public ImageType getImageType() {
        return ImageType.PNG;
    }

    private void reset() {
        this.chunks.clear();
        this.isApplyAdaptiveFilter = false;
        this.filterType = 0;
        this.compressionLevel = 4;
    }

    @Override
    protected void write(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        boolean noAlpha;
        IOUtils.writeLongMM(os, -8552249625308161526L);
        this.reset();
        this.addTextChunks(this.chunks);
        this.addTimeChunk(this.chunks);
        this.imageParam = this.getImageParam();
        ImageOptions options = this.imageParam.getImageOptions();
        if (options instanceof PNGOptions) {
            PNGOptions pngOptions = (PNGOptions)options;
            this.isApplyAdaptiveFilter = pngOptions.isApplyAdaptiveFilter();
            this.filterType = pngOptions.getFilterType();
            this.compressionLevel = pngOptions.getCompressionLevel();
        }
        boolean bl = noAlpha = !this.imageParam.hasAlpha();
        if (this.imageParam.getColorType() == ImageColorType.INDEXED) {
            this.writeIndexed(pixels, imageWidth, imageHeight, os);
        } else if (this.imageParam.getColorType() == ImageColorType.GRAY_SCALE) {
            if (noAlpha) {
                this.writeGrayScale(IMGUtils.rgb2grayscale(pixels), imageWidth, imageHeight, false, os);
            } else {
                this.writeGrayScale(IMGUtils.rgb2grayscaleA(pixels), imageWidth, imageHeight, true, os);
            }
        } else {
            this.writeRGB(pixels, imageWidth, imageHeight, os);
        }
        new IENDBuilder().build().write(os);
    }

    private void writeGrayScale(byte[] pixels, int imageWidth, int imageHeight, boolean hasAlpha, OutputStream os) throws Exception {
        IHDRBuilder hdrBuilder = new IHDRBuilder().width(imageWidth).height(imageHeight).compressionMethod(0).filterMethod(0).interlaceMethod(0);
        if (hasAlpha) {
            hdrBuilder.colorType(ColorType.GRAY_SCALE_WITH_ALPHA);
        } else {
            hdrBuilder.colorType(ColorType.GRAY_SCALE);
        }
        int bitsPerPixel = 8;
        if (!hasAlpha) {
            bitsPerPixel = IMGUtils.getBitDepth(pixels, false);
            switch (bitsPerPixel) {
                case 3: {
                    bitsPerPixel = 4;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bitsPerPixel = 8;
                    break;
                }
            }
        }
        if (bitsPerPixel != 8) {
            for (int l = 0; l < pixels.length; ++l) {
                pixels[l] = (byte)(pixels[l] << bitsPerPixel >> 8);
            }
            pixels = ArrayUtils.packByteArray(pixels, imageWidth, 0, bitsPerPixel, imageWidth * imageHeight);
        }
        this.chunks.add(hdrBuilder.bitDepth(bitsPerPixel).build());
        if (!hasAlpha && this.imageParam.isTransparent()) {
            TRNSBuilder tBuilder = new TRNSBuilder(0);
            int transparentColor = this.imageParam.getTransparentColor();
            byte trans_color = (byte)((double)(transparentColor >> 16 & 0xFF) * 0.2126 + (double)(transparentColor >> 8 & 0xFF) * 0.7152 + (double)(transparentColor & 0xFF) * 0.0722);
            byte[] alpha = new byte[]{0, (byte)(trans_color << bitsPerPixel >> 8)};
            this.chunks.add(tBuilder.alpha(alpha).build());
        }
        PNGTweaker.serializeChunks(this.chunks, os);
        int[] filter_type = new int[imageHeight];
        Arrays.fill(filter_type, this.filterType);
        int bytesPerPixel = hasAlpha ? 2 : 1;
        int bytesPerScanLine = PNGWriter.getBytesPerScanLine(bitsPerPixel, imageWidth, hasAlpha);
        if (bitsPerPixel == 8) {
            if (this.isApplyAdaptiveFilter) {
                PNGWriter.apply_adaptive_filter(filter_type, pixels, imageHeight, bytesPerPixel, bytesPerScanLine);
            } else if (this.filterType != 0) {
                PNGWriter.apply_filter(filter_type, pixels, imageHeight, bytesPerPixel, bytesPerScanLine);
            }
        }
        byte[] buffer = new byte[bytesPerScanLine + 1];
        IDATBuilder builder = new IDATBuilder(this.compressionLevel);
        int bufferLen = bytesPerPixel * imageWidth * imageHeight / 5;
        int counter = 0;
        int i = 0;
        int j = 0;
        while (i < imageHeight) {
            buffer = new byte[bytesPerScanLine + 1];
            buffer[0] = (byte)filter_type[i];
            System.arraycopy(pixels, j, buffer, 1, bytesPerScanLine);
            builder.data(buffer);
            if ((counter += bytesPerScanLine) > bufferLen) {
                Chunk chunk = builder.build();
                if (chunk.getData().length > 0) {
                    chunk.write(os);
                }
                counter = 0;
            }
            ++i;
            j += bytesPerScanLine;
        }
        builder.setFinish(true);
        Chunk chunk = builder.build();
        if (chunk.getData().length > 0) {
            chunk.write(os);
        }
    }

    private void writeIndexed(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        ImageParam param = this.getImageParam();
        int[] filter_type = new int[imageHeight];
        int bytesPerScanLine = imageWidth * 1;
        byte[] bytePixels = new byte[imageHeight * bytesPerScanLine];
        int bitsPerPixel = 8;
        int[] colorPalette = new int[256];
        int[] colorInfo = IMGUtils.checkColorDepth(pixels, bytePixels, colorPalette);
        if (colorInfo[0] > 8) {
            bitsPerPixel = param.getBitsPerPixel();
            if (bitsPerPixel <= 0 || bitsPerPixel > 8) {
                bitsPerPixel = 8;
            }
            colorInfo = param.isApplyDither() ? (param.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.reduceColorsDiffusionDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, bitsPerPixel, bytePixels, colorPalette) : IMGUtils.reduceColorsOrderedDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, bitsPerPixel, bytePixels, colorPalette, param.getDitherMatrix())) : IMGUtils.reduceColors(param.getQuantMethod(), pixels, bitsPerPixel, bytePixels, colorPalette, true);
        }
        bitsPerPixel = colorInfo[0];
        switch (bitsPerPixel) {
            case 3: {
                bitsPerPixel = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bitsPerPixel = 8;
                break;
            }
        }
        bytesPerScanLine = PNGWriter.getBytesPerScanLine(bitsPerPixel, imageWidth, false);
        this.chunks.add(new IHDRBuilder().width(imageWidth).height(imageHeight).bitDepth(bitsPerPixel).colorType(ColorType.INDEX_COLOR).compressionMethod(0).filterMethod(0).interlaceMethod(0).build());
        int numOfColors = 1 << bitsPerPixel;
        byte[] redMap = new byte[numOfColors];
        byte[] greenMap = new byte[numOfColors];
        byte[] blueMap = new byte[numOfColors];
        for (int i = 0; i < numOfColors; ++i) {
            redMap[i] = (byte)(colorPalette[i] >> 16);
            greenMap[i] = (byte)(colorPalette[i] >> 8);
            blueMap[i] = (byte)colorPalette[i];
        }
        PLTEBuilder pBuilder = new PLTEBuilder();
        pBuilder.redMap(redMap).greenMap(greenMap).blueMap(blueMap);
        this.chunks.add(pBuilder.build());
        if (colorInfo[1] >= 0) {
            TRNSBuilder tBuilder = new TRNSBuilder(3);
            byte[] alpha = new byte[numOfColors];
            Arrays.fill(alpha, (byte)-1);
            for (int i = 0; i < numOfColors; ++i) {
                alpha[i] = (byte)(colorPalette[i] >>> 24);
            }
            this.chunks.add(tBuilder.alpha(alpha).build());
        }
        PNGTweaker.serializeChunks(this.chunks, os);
        Arrays.fill(filter_type, this.filterType);
        if (bitsPerPixel == 8) {
            if (this.isApplyAdaptiveFilter) {
                PNGWriter.apply_adaptive_filter(filter_type, bytePixels, imageHeight, 1, bytesPerScanLine);
            } else if (this.filterType != 0) {
                PNGWriter.apply_filter(filter_type, bytePixels, imageHeight, 1, bytesPerScanLine);
            }
        }
        byte[] buffer = new byte[bytesPerScanLine + 1];
        IDATBuilder builder = new IDATBuilder(this.compressionLevel);
        int bufferLen = imageWidth * imageHeight / 5;
        int counter = 0;
        if (bitsPerPixel != 8) {
            bytePixels = ArrayUtils.packByteArray(bytePixels, imageWidth, 0, bitsPerPixel, imageWidth * imageHeight);
        }
        int i = 0;
        int j = 0;
        while (i < imageHeight) {
            buffer = new byte[bytesPerScanLine + 1];
            buffer[0] = (byte)filter_type[i];
            System.arraycopy(bytePixels, j, buffer, 1, bytesPerScanLine);
            builder.data(buffer);
            if ((counter += bytesPerScanLine) > bufferLen) {
                Chunk chunk = builder.build();
                if (chunk.getData().length > 0) {
                    chunk.write(os);
                }
                counter = 0;
            }
            ++i;
            j += bytesPerScanLine;
        }
        builder.setFinish(true);
        Chunk chunk = builder.build();
        if (chunk.getData().length > 0) {
            chunk.write(os);
        }
    }

    private void writeRGB(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        int i;
        int j;
        boolean noAlpha = !this.imageParam.hasAlpha();
        IHDRBuilder hdrBuilder = new IHDRBuilder().width(imageWidth).height(imageHeight).bitDepth(8).compressionMethod(0).filterMethod(0).interlaceMethod(0);
        if (noAlpha) {
            hdrBuilder.colorType(ColorType.TRUE_COLOR);
        } else {
            hdrBuilder.colorType(ColorType.TRUE_COLOR_WITH_ALPHA);
        }
        this.chunks.add(hdrBuilder.build());
        int[] filter_type = new int[imageHeight];
        int bytesPerPixel = noAlpha ? 3 : 4;
        int bytesPerScanLine = imageWidth * bytesPerPixel;
        int imageSize = imageWidth * imageHeight;
        byte[] bytePixels = new byte[imageHeight * bytesPerScanLine];
        if (this.filterType == 0) {
            this.filterType = 4;
        }
        Arrays.fill(filter_type, this.filterType);
        if (noAlpha) {
            j = 0;
            for (i = 0; i < imageSize; ++i) {
                bytePixels[j++] = (byte)(pixels[i] >> 16 & 0xFF);
                bytePixels[j++] = (byte)(pixels[i] >> 8 & 0xFF);
                bytePixels[j++] = (byte)(pixels[i] & 0xFF);
            }
        } else {
            j = 0;
            for (i = 0; i < imageSize; ++i) {
                bytePixels[j++] = (byte)(pixels[i] >> 16 & 0xFF);
                bytePixels[j++] = (byte)(pixels[i] >> 8 & 0xFF);
                bytePixels[j++] = (byte)(pixels[i] & 0xFF);
                bytePixels[j++] = (byte)(pixels[i] >> 24 & 0xFF);
            }
        }
        if (noAlpha && this.imageParam.isTransparent()) {
            TRNSBuilder tBuilder = new TRNSBuilder(2);
            int transparentColor = this.imageParam.getTransparentColor();
            byte[] alpha = new byte[]{0, (byte)(transparentColor >>> 16), 0, (byte)(transparentColor >>> 8), 0, (byte)(transparentColor >>> 0)};
            this.chunks.add(tBuilder.alpha(alpha).build());
        }
        PNGTweaker.serializeChunks(this.chunks, os);
        if (this.isApplyAdaptiveFilter) {
            PNGWriter.apply_adaptive_filter(filter_type, bytePixels, imageHeight, bytesPerPixel, bytesPerScanLine);
        } else {
            PNGWriter.apply_filter(filter_type, bytePixels, imageHeight, bytesPerPixel, bytesPerScanLine);
        }
        byte[] buffer = new byte[bytesPerScanLine + 1];
        IDATBuilder builder = new IDATBuilder(this.compressionLevel);
        int bufferLen = bytesPerPixel * imageWidth * imageHeight / 5;
        int counter = 0;
        int i2 = 0;
        int j2 = 0;
        while (i2 < imageHeight) {
            buffer = new byte[bytesPerScanLine + 1];
            buffer[0] = (byte)filter_type[i2];
            System.arraycopy(bytePixels, j2, buffer, 1, bytesPerScanLine);
            builder.data(buffer);
            if ((counter += bytesPerScanLine) > bufferLen) {
                Chunk chunk = builder.build();
                if (chunk.getData().length > 0) {
                    chunk.write(os);
                }
                counter = 0;
            }
            ++i2;
            j2 += bytesPerScanLine;
        }
        builder.setFinish(true);
        Chunk chunk = builder.build();
        if (chunk.getData().length > 0) {
            chunk.write(os);
        }
    }
}

