/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.image.writer;

import guilibshadow.cafe4j.image.ImageColorType;
import guilibshadow.cafe4j.image.ImageParam;
import guilibshadow.cafe4j.image.ImageType;
import guilibshadow.cafe4j.image.compression.ImageEncoder;
import guilibshadow.cafe4j.image.compression.UnsupportedCompressionException;
import guilibshadow.cafe4j.image.compression.ccitt.G31DEncoder;
import guilibshadow.cafe4j.image.compression.ccitt.G32DEncoder;
import guilibshadow.cafe4j.image.compression.ccitt.G42DEncoder;
import guilibshadow.cafe4j.image.compression.deflate.DeflateEncoder;
import guilibshadow.cafe4j.image.compression.lzw.LZWTreeEncoder;
import guilibshadow.cafe4j.image.compression.packbits.Packbits;
import guilibshadow.cafe4j.image.options.ImageOptions;
import guilibshadow.cafe4j.image.options.JPGOptions;
import guilibshadow.cafe4j.image.options.TIFFOptions;
import guilibshadow.cafe4j.image.quant.DitherMethod;
import guilibshadow.cafe4j.image.tiff.ASCIIField;
import guilibshadow.cafe4j.image.tiff.IFD;
import guilibshadow.cafe4j.image.tiff.LongField;
import guilibshadow.cafe4j.image.tiff.RationalField;
import guilibshadow.cafe4j.image.tiff.ShortField;
import guilibshadow.cafe4j.image.tiff.TiffField;
import guilibshadow.cafe4j.image.tiff.TiffFieldEnum;
import guilibshadow.cafe4j.image.tiff.TiffTag;
import guilibshadow.cafe4j.image.tiff.UndefinedField;
import guilibshadow.cafe4j.image.util.IMGUtils;
import guilibshadow.cafe4j.image.writer.ImageWriter;
import guilibshadow.cafe4j.image.writer.JPGWriter;
import guilibshadow.cafe4j.io.ByteOrder;
import guilibshadow.cafe4j.io.FileCacheRandomAccessOutputStream;
import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import guilibshadow.cafe4j.io.WriteStrategyII;
import guilibshadow.cafe4j.io.WriteStrategyMM;
import guilibshadow.cafe4j.util.ArrayUtils;
import guilibshadow.cafe4j.util.CollectionUtils;
import guilibshadow.cafe4j.util.Updatable;
import guilibshadow.org.slf4j.Logger;
import guilibshadow.org.slf4j.LoggerFactory;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;

public class TIFFWriter
extends ImageWriter
implements Updatable<Integer> {
    private static final String pathToCMYKProfile = "/resources/CMYK Profiles/USWebCoatedSWOP.icc";
    private int stripOffset;
    private IFD ifd;
    private TIFFOptions tiffOptions;
    private ICC_ColorSpace cmykColorSpace;
    private List<Integer> stripOffsets = new ArrayList<Integer>();
    private List<Integer> stripByteCounts = new ArrayList<Integer>();
    private RandomAccessOutputStream randomOS;
    private static final Logger LOGGER = LoggerFactory.getLogger(TIFFWriter.class);
    public static final int OFFSET_TO_WRITE_FIRST_IFD_OFFSET = 4;
    public static final int FIRST_WRITE_OFFSET = 8;
    public static final int STREAM_HEAD = 0;

    public TIFFWriter() {
    }

    public TIFFWriter(ImageParam param) {
        super(param);
    }

    private static byte[] applyPredictor(int numOfSamples, byte[] input, int imageWidth, int imageHeight) {
        int inc = numOfSamples * imageWidth;
        int maxVal = inc - numOfSamples;
        int minVal = numOfSamples;
        for (int i = imageHeight - 1; i >= 0; --i) {
            for (int j = maxVal; j >= minVal; j -= numOfSamples) {
                for (int k = 0; k < numOfSamples; ++k) {
                    int n = j + k;
                    input[n] = (byte)(input[n] - input[j - numOfSamples + k]);
                }
            }
            maxVal += inc;
            minVal += inc;
        }
        return input;
    }

    private static byte[] applyPredictor2(byte[] input, int imageWidth, int imageHeight) {
        int inc = imageWidth;
        int maxVal = inc - 1;
        int minVal = 1;
        for (int i = imageHeight - 1; i >= 0; --i) {
            for (int j = maxVal; j >= minVal; --j) {
                int n = j;
                input[n] = (byte)(input[n] - input[j - 1]);
            }
            maxVal += inc;
            minVal += inc;
        }
        return input;
    }

    private void ccittCompress(byte[] input, int imageWidth, int imageHeight, ImageEncoder encoder) throws Exception {
        encoder.initialize();
        encoder.encode(input, 0, imageWidth * imageHeight);
        encoder.finish();
        ShortField tiffField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)imageHeight});
        this.ifd.addField(tiffField);
    }

    private void compressSample(byte[] samples, int imageWidth, int imageHeight, TiffFieldEnum.Compression compression, int bufferSize) throws Exception {
        int rowsPerStrip = imageHeight;
        switch (compression) {
            case LZW: {
                LZWTreeEncoder encoder = new LZWTreeEncoder(this.randomOS, 8, bufferSize, this);
                encoder.initialize();
                encoder.encode(samples, 0, samples.length);
                encoder.finish();
                break;
            }
            case DEFLATE: 
            case DEFLATE_ADOBE: {
                int compressionLevel = 4;
                if (this.tiffOptions != null) {
                    compressionLevel = this.tiffOptions.getDeflateCompressionLevel();
                }
                DeflateEncoder deflateEncoder = new DeflateEncoder(this.randomOS, bufferSize, compressionLevel, this);
                deflateEncoder.initialize();
                deflateEncoder.encode(samples, 0, samples.length);
                deflateEncoder.finish();
                break;
            }
            default: {
                compression = TiffFieldEnum.Compression.PACKBITS;
                boolean bytesOut = false;
                int offset = 0;
                byte[] buffer = new byte[imageWidth + (imageWidth + 127) / 128];
                for (int i = 0; i < imageHeight; ++i) {
                    int tempBytes = Packbits.packbits(ArrayUtils.subArray(samples, offset, imageWidth), buffer);
                    offset += imageWidth;
                    this.randomOS.write(buffer, 0, tempBytes);
                    this.update(tempBytes);
                }
                rowsPerStrip = 1;
            }
        }
        ShortField tiffField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)rowsPerStrip});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)compression.getValue()});
        this.ifd.addField(tiffField);
    }

    private void deflateCompress(int compressionLevel, byte[] inflated, int bitsPerPixel, int imageWidth, int imageHeight, byte[] buffer) throws Exception {
        byte[] temp;
        DeflateEncoder deflateEncoder = new DeflateEncoder(this.randomOS, buffer.length, compressionLevel, this);
        deflateEncoder.initialize();
        if (bitsPerPixel == 8) {
            deflateEncoder.encode(inflated, 0, imageWidth * (imageHeight / 2 + 1));
        } else {
            temp = ArrayUtils.packByteArray(inflated, imageWidth, 0, bitsPerPixel, imageWidth * (imageHeight / 2 + 1));
            deflateEncoder.encode(temp, 0, temp.length);
        }
        deflateEncoder.finish();
        deflateEncoder.initialize();
        if (bitsPerPixel == 8) {
            deflateEncoder.encode(inflated, imageWidth * (imageHeight / 2 + 1), inflated.length - imageWidth * (imageHeight / 2 + 1));
        } else {
            temp = ArrayUtils.packByteArray(inflated, imageWidth, imageWidth * (imageHeight / 2 + 1), bitsPerPixel, inflated.length - imageWidth * (imageHeight / 2 + 1));
            deflateEncoder.encode(temp, 0, temp.length);
        }
        deflateEncoder.finish();
        ShortField tiffField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)(imageHeight / 2 + 1)});
        this.ifd.addField(tiffField);
    }

    public IFD getIFD() {
        return new IFD(this.ifd);
    }

    @Override
    public ImageType getImageType() {
        return ImageType.TIFF;
    }

    private void jpegCompress(int[] pixels, int imageWidth, int imageHeight, boolean grayscale) throws Exception {
        byte[] icc_profile;
        int rowsPerStrip = imageHeight / 2 + 1;
        int jpegQuality = 90;
        boolean writeICCProfile = false;
        TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.YCbCr;
        if (this.tiffOptions != null) {
            jpegQuality = this.tiffOptions.getJPEGQuality();
            if (this.tiffOptions.getPhotoMetric() != TiffFieldEnum.PhotoMetric.UNKNOWN) {
                photoMetric = this.tiffOptions.getPhotoMetric();
            }
            writeICCProfile = this.tiffOptions.writeICCProfile();
        }
        int numOfSamples = 0;
        if (grayscale) {
            photoMetric = TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO;
            numOfSamples = 1;
        } else if (photoMetric == TiffFieldEnum.PhotoMetric.RGB || photoMetric == TiffFieldEnum.PhotoMetric.YCbCr) {
            numOfSamples = 3;
            this.ifd.addField(new RationalField(TiffTag.REFERENCE_BLACK_WHITE.getValue(), new int[]{0, 255, 128, 255, 128, 255}));
            if (photoMetric == TiffFieldEnum.PhotoMetric.YCbCr) {
                this.ifd.addField(new ShortField(TiffTag.YCbCr_SUB_SAMPLING.getValue(), new short[]{1, 1}));
            }
        } else if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED) {
            numOfSamples = 4;
        } else {
            throw new UnsupportedOperationException("Unsupported PHOTOMETRIC_INTERPRETATION!");
        }
        short[] bitsPerSample = new short[numOfSamples];
        Arrays.fill(bitsPerSample, (short)8);
        this.ifd.addField(new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)photoMetric.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{(short)numOfSamples}));
        this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), bitsPerSample));
        JPGWriter jpgWriter = new JPGWriter();
        ImageParam.ImageParamBuilder builder = ImageParam.getBuilder();
        if (grayscale) {
            builder.colorType(ImageColorType.GRAY_SCALE);
        }
        JPGOptions jpegOptions = new JPGOptions();
        jpegOptions.setQuality(jpegQuality);
        jpegOptions.setColorSpace(photoMetric.getValue());
        jpegOptions.setTiffFlavor(true);
        jpegOptions.setIncludeTables(false);
        builder.imageOptions(jpegOptions);
        jpgWriter.setImageParam(builder.build());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        jpgWriter.writeDefaultJPEGTables(bout);
        this.ifd.addField(new UndefinedField(TiffTag.JPEG_TABLES.getValue(), bout.toByteArray()));
        long startOffset = this.randomOS.getStreamPointer();
        jpgWriter.write(Arrays.copyOfRange(pixels, 0, imageWidth * (imageHeight / 2 + 1)), imageWidth, imageHeight / 2 + 1, this.randomOS);
        long finishOffset = this.randomOS.getStreamPointer();
        int totalOut = (int)(finishOffset - startOffset);
        this.update(totalOut);
        startOffset = finishOffset;
        jpgWriter.write(Arrays.copyOfRange(pixels, imageWidth * (imageHeight / 2 + 1), pixels.length), imageWidth, imageHeight - imageHeight / 2 - 1, this.randomOS);
        finishOffset = this.randomOS.getStreamPointer();
        totalOut = (int)(finishOffset - startOffset);
        this.update(totalOut);
        if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED && writeICCProfile && (icc_profile = jpgWriter.getCMYK_ICC_Profile()) != null) {
            this.ifd.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), icc_profile));
        }
        this.ifd.addField(new ShortField(TiffTag.PLANAR_CONFIGURATTION.getValue(), new short[]{(short)TiffFieldEnum.PlanarConfiguration.CONTIGUOUS.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)TiffFieldEnum.Compression.JPG.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)rowsPerStrip}));
    }

    private void lzwCompress(byte[] newPixels, int bitsPerPixel, int imageWidth, int imageHeight, int buffSize) throws Exception {
        byte[] temp;
        LZWTreeEncoder encoder = new LZWTreeEncoder(this.randomOS, 8, buffSize, this);
        encoder.initialize();
        if (bitsPerPixel == 8) {
            encoder.encode(newPixels, 0, imageWidth * (imageHeight / 2 + 1));
        } else {
            temp = ArrayUtils.packByteArray(newPixels, imageWidth, 0, bitsPerPixel, imageWidth * (imageHeight / 2 + 1));
            encoder.encode(temp, 0, temp.length);
        }
        encoder.finish();
        encoder.initialize();
        if (bitsPerPixel == 8) {
            encoder.encode(newPixels, imageWidth * (imageHeight / 2 + 1), newPixels.length - imageWidth * (imageHeight / 2 + 1));
        } else {
            temp = ArrayUtils.packByteArray(newPixels, imageWidth, imageWidth * (imageHeight / 2 + 1), bitsPerPixel, newPixels.length - imageWidth * (imageHeight / 2 + 1));
            encoder.encode(temp, 0, temp.length);
        }
        encoder.finish();
        ShortField tiffField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)(imageHeight / 2 + 1)});
        this.ifd.addField(tiffField);
    }

    private void packbitsCompress(byte[] input, int bitsPerPixel, int imageWidth, int imageHeight) throws Exception {
        int offset = 0;
        int bytesOut = 0;
        int rowsPerStrip = imageHeight % 2 == 0 ? imageHeight / 2 : imageHeight / 2 + 1;
        byte[] buffer = new byte[imageWidth + (imageWidth + 127) / 128];
        for (int i = 0; i < imageHeight; ++i) {
            byte[] temp = ArrayUtils.packByteArray(input, imageWidth, offset, bitsPerPixel, imageWidth);
            int tempBytes = Packbits.packbits(temp, buffer);
            offset += imageWidth;
            this.randomOS.write(buffer, 0, tempBytes);
            bytesOut += tempBytes;
            if (i != rowsPerStrip - 1 && i != imageHeight - 1) continue;
            this.update(bytesOut);
            bytesOut = 0;
        }
        ShortField tiffField = new ShortField(TiffTag.ROWS_PER_STRIP.getValue(), new short[]{(short)rowsPerStrip});
        this.ifd.addField(tiffField);
    }

    private void reset(int offset) {
        this.stripOffset = offset;
        this.stripOffsets.clear();
        this.stripByteCounts.clear();
    }

    @Override
    public void update(Integer stripLen) {
        this.stripByteCounts.add(stripLen);
        this.stripOffsets.add(this.stripOffset);
        this.stripOffset += stripLen.intValue();
    }

    @Override
    protected void write(int[] pixels, int imageWidth, int imageHeight, OutputStream os) throws Exception {
        ImageParam param = this.getImageParam();
        ImageOptions options = param.getImageOptions();
        if (options instanceof TIFFOptions) {
            this.tiffOptions = (TIFFOptions)options;
        }
        this.randomOS = new FileCacheRandomAccessOutputStream(os);
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        if (this.tiffOptions != null) {
            byteOrder = this.tiffOptions.getByteOrder();
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            this.randomOS.setWriteStrategy(WriteStrategyMM.getInstance());
            this.randomOS.writeShort(19789);
        } else {
            this.randomOS.setWriteStrategy(WriteStrategyII.getInstance());
            this.randomOS.writeShort(18761);
        }
        this.randomOS.writeShort(42);
        this.ifd = new IFD();
        TiffField tiffField = new LongField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new int[]{0});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_WIDTH.getValue(), new int[]{imageWidth});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_LENGTH.getValue(), new int[]{imageHeight});
        this.ifd.addField(tiffField);
        this.reset(8);
        this.randomOS.seek(this.stripOffset);
        this.writePageData(param, pixels, imageWidth, imageHeight);
        tiffField = new LongField(TiffTag.STRIP_OFFSETS.getValue(), CollectionUtils.integerListToIntArray(this.stripOffsets));
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.STRIP_BYTE_COUNTS.getValue(), CollectionUtils.integerListToIntArray(this.stripByteCounts));
        this.ifd.addField(tiffField);
        String softWare = "ICAFE - https://github.com/dragon66/icafe\u0000";
        tiffField = new ASCIIField(TiffTag.SOFTWARE.getValue(), softWare);
        this.ifd.addField(tiffField);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        tiffField = new ASCIIField(TiffTag.DATETIME.getValue(), formatter.format(new Date()) + '\u0000');
        this.ifd.addField(tiffField);
        int xResolution = 72;
        int yResolution = 72;
        int resolutionUnit = TiffFieldEnum.ResolutionUnit.RESUNIT_INCH.getValue();
        if (this.tiffOptions != null) {
            xResolution = this.tiffOptions.getXResolution();
            yResolution = this.tiffOptions.getYResolution();
            resolutionUnit = this.tiffOptions.getResolutionUnit().getValue();
        }
        this.ifd.addField(new RationalField(TiffTag.X_RESOLUTION.getValue(), new int[]{xResolution, 1}));
        this.ifd.addField(new RationalField(TiffTag.Y_RESOLUTION.getValue(), new int[]{yResolution, 1}));
        this.ifd.addField(new ShortField(TiffTag.RESOLUTION_UNIT.getValue(), new short[]{(short)resolutionUnit}));
        this.randomOS.seek(4L);
        this.randomOS.writeInt(this.stripOffset);
        this.ifd.write(this.randomOS, this.stripOffset);
        this.randomOS.seek(0L);
        this.randomOS.writeToStream(this.randomOS.getLength());
        this.randomOS.close();
    }

    private void writeBilevel(byte[] pixels, int imageWidth, int imageHeight, TiffFieldEnum.Compression compression) throws Exception {
        EnumSet<TiffFieldEnum.Compression> supportedCompressionTypes = TiffFieldEnum.Compression.forBilevel();
        if (!supportedCompressionTypes.contains((Object)compression)) {
            throw new UnsupportedCompressionException("Bilevel Image only supports the following compression types: " + supportedCompressionTypes);
        }
        TiffField tiffField = new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.WHITE_IS_ZERO.getValue()});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.FILL_ORDER.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        switch (compression) {
            case CCITTRLE: {
                G31DEncoder encoder = new G31DEncoder(this.randomOS, imageWidth, 1024, this);
                this.ccittCompress(ArrayUtils.packByteArray(pixels, 0, 1, pixels.length), imageWidth, imageHeight, encoder);
                break;
            }
            case CCITTFAX3: {
                G32DEncoder encoder = new G32DEncoder(this.randomOS, imageWidth, 1024, 4, this);
                this.ccittCompress(ArrayUtils.packByteArray(pixels, 0, 1, pixels.length), imageWidth, imageHeight, encoder);
                tiffField = new LongField(TiffTag.T4_OPTIONS.getValue(), new int[]{1});
                this.ifd.addField(tiffField);
                break;
            }
            case CCITTFAX4: {
                G42DEncoder encoder = new G42DEncoder(this.randomOS, imageWidth, 1024, this);
                this.ccittCompress(ArrayUtils.packByteArray(pixels, 0, 1, pixels.length), imageWidth, imageHeight, encoder);
                break;
            }
            case LZW: 
            case DEFLATE: {
                this.compressSample(ArrayUtils.packByteArray(pixels, imageWidth, 0, 1, pixels.length), imageWidth, imageHeight, compression, 1024);
                break;
            }
            default: {
                compression = TiffFieldEnum.Compression.PACKBITS;
                this.packbitsCompress(pixels, 1, imageWidth, imageHeight);
            }
        }
        tiffField = new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)compression.getValue()});
        this.ifd.addField(tiffField);
    }

    private void writeGrayScale(byte[] newPixels, int imageWidth, int imageHeight, TiffFieldEnum.Compression compression, boolean hasAlpha) throws Exception {
        boolean noAlpha;
        EnumSet<TiffFieldEnum.Compression> supportedCompressionTypes = TiffFieldEnum.Compression.forGrayScale();
        if (!supportedCompressionTypes.contains((Object)compression)) {
            throw new UnsupportedCompressionException("GrayScale Image only supports the following compression types: " + supportedCompressionTypes);
        }
        int bitsPerPixel = 8;
        boolean applyPredictor = true;
        if (this.tiffOptions != null) {
            applyPredictor = this.tiffOptions.isApplyPredictor();
        }
        switch (compression) {
            case LZW: 
            case DEFLATE: {
                break;
            }
            default: {
                applyPredictor = false;
            }
        }
        boolean bl = noAlpha = !hasAlpha;
        if (noAlpha) {
            bitsPerPixel = IMGUtils.getBitDepth(newPixels, false);
            switch (bitsPerPixel) {
                case 1: 
                case 2: 
                case 3: {
                    bitsPerPixel = 4;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bitsPerPixel = 8;
                    break;
                }
            }
        }
        if (bitsPerPixel != 8) {
            for (int l = 0; l < newPixels.length; ++l) {
                newPixels[l] = (byte)(newPixels[l] << bitsPerPixel >> 8);
            }
            newPixels = ArrayUtils.packByteArray(newPixels, imageWidth, 0, bitsPerPixel, imageWidth * imageHeight);
        }
        ShortField tiffField = new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.BLACK_IS_ZERO.getValue()});
        this.ifd.addField(tiffField);
        int samplesPerPixel = noAlpha ? 1 : 2;
        this.ifd.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{(short)samplesPerPixel}));
        if (noAlpha) {
            this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{(short)bitsPerPixel}));
        } else {
            this.ifd.addField(new ShortField(TiffTag.EXTRA_SAMPLES.getValue(), new short[]{2}));
            this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{(short)bitsPerPixel, (short)bitsPerPixel}));
        }
        if (bitsPerPixel == 8 && applyPredictor) {
            if (noAlpha) {
                TIFFWriter.applyPredictor2(newPixels, imageWidth, imageHeight);
            } else {
                int inc = 2 * imageWidth;
                int maxVal = inc - 2;
                int minVal = 2;
                for (int i = imageHeight - 1; i >= 0; --i) {
                    for (int j = maxVal; j >= minVal; j -= 2) {
                        int n = j;
                        newPixels[n] = (byte)(newPixels[n] - newPixels[j - 2]);
                        int n2 = j + 1;
                        newPixels[n2] = (byte)(newPixels[n2] - newPixels[j - 1]);
                    }
                    maxVal += inc;
                    minVal += inc;
                }
            }
            tiffField = new ShortField(TiffTag.PREDICTOR.getValue(), new short[]{2});
            this.ifd.addField(tiffField);
        }
        this.compressSample(newPixels, samplesPerPixel * imageWidth, imageHeight, compression, 1024);
    }

    private void writePageData(ImageParam param, int[] pixels, int imageWidth, int imageHeight) throws Exception {
        TiffFieldEnum.Compression compression = TiffFieldEnum.Compression.PACKBITS;
        if (this.tiffOptions != null) {
            compression = this.tiffOptions.getTiffCompression();
        }
        if (param.getColorType() == ImageColorType.INDEXED) {
            this.writeIndexed(pixels, imageWidth, imageHeight, compression);
        } else if (param.getColorType() == ImageColorType.BILEVEL) {
            if (param.isApplyDither()) {
                byte[] bilevelPixels = null;
                bilevelPixels = param.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.rgb2bilevelDiffusionDither(pixels, imageWidth, imageHeight) : IMGUtils.rgb2bilevelOrderedDither(pixels, imageWidth, imageHeight, param.getDitherMatrix());
                this.writeBilevel(bilevelPixels, imageWidth, imageHeight, compression);
            } else {
                this.writeBilevel(IMGUtils.rgb2bilevel(pixels), imageWidth, imageHeight, compression);
            }
        } else if (compression == TiffFieldEnum.Compression.JPG) {
            if (param.hasAlpha()) {
                LOGGER.warn("#Warning: JPEG compression does not support transparency (all transparency information will be lost!)");
            }
            this.jpegCompress(pixels, imageWidth, imageHeight, param.getColorType() == ImageColorType.GRAY_SCALE);
        } else if (param.getColorType() == ImageColorType.GRAY_SCALE) {
            if (param.hasAlpha()) {
                this.writeGrayScale(IMGUtils.rgb2grayscaleA(pixels), imageWidth, imageHeight, compression, true);
            } else {
                this.writeGrayScale(IMGUtils.rgb2grayscale(pixels), imageWidth, imageHeight, compression, false);
            }
        } else {
            this.writeTrueColor(pixels, imageWidth, imageHeight, compression);
        }
    }

    private void writeIndexed(int[] pixels, int imageWidth, int imageHeight, TiffFieldEnum.Compression compression) throws Exception {
        EnumSet<TiffFieldEnum.Compression> supportedCompressionTypes = TiffFieldEnum.Compression.forIndexed();
        if (!supportedCompressionTypes.contains((Object)compression)) {
            throw new UnsupportedCompressionException("Indexed Image only supports the following compression types: " + supportedCompressionTypes);
        }
        ImageParam param = this.getImageParam();
        byte[] newPixels = new byte[imageWidth * imageHeight];
        int bitsPerPixel = 8;
        int[] colorPalette = new int[256];
        int[] colorInfo = IMGUtils.checkColorDepth(pixels, newPixels, colorPalette);
        if (colorInfo[0] > 8) {
            bitsPerPixel = param.getBitsPerPixel();
            if (bitsPerPixel <= 0 || bitsPerPixel > 8) {
                bitsPerPixel = 8;
            }
            colorInfo = param.isApplyDither() ? (param.getDitherMethod() == DitherMethod.FLOYD_STEINBERG ? IMGUtils.reduceColorsDiffusionDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, bitsPerPixel, newPixels, colorPalette) : IMGUtils.reduceColorsOrderedDither(param.getQuantMethod(), pixels, imageWidth, imageHeight, bitsPerPixel, newPixels, colorPalette, param.getDitherMatrix())) : IMGUtils.reduceColors(param.getQuantMethod(), pixels, bitsPerPixel, newPixels, colorPalette, false);
        }
        bitsPerPixel = colorInfo[0];
        switch (bitsPerPixel) {
            case 3: {
                bitsPerPixel = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                bitsPerPixel = 8;
                break;
            }
        }
        int numOfColors = 1 << bitsPerPixel;
        int numOfColors2 = numOfColors << 1;
        short[] map = new short[3 * numOfColors];
        for (int i = 0; i < numOfColors; ++i) {
            map[i] = (short)((colorPalette[i] >> 16 & 0xFF) << 8);
            map[numOfColors + i] = (short)((colorPalette[i] >> 8 & 0xFF) << 8);
            map[numOfColors2 + i] = (short)((colorPalette[i] >> 0 & 0xFF) << 8);
        }
        ShortField tiffField = new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)TiffFieldEnum.PhotoMetric.PALETTE_COLOR.getValue()});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.COLORMAP.getValue(), map);
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{1});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), new short[]{(short)bitsPerPixel});
        this.ifd.addField(tiffField);
        if (compression == TiffFieldEnum.Compression.LZW) {
            this.lzwCompress(newPixels, bitsPerPixel, imageWidth, imageHeight, 4096);
        } else if (compression == TiffFieldEnum.Compression.DEFLATE_ADOBE || compression == TiffFieldEnum.Compression.DEFLATE) {
            byte[] buffer = new byte[4096];
            int compressionLevel = 4;
            if (this.tiffOptions != null) {
                compressionLevel = this.tiffOptions.getDeflateCompressionLevel();
            }
            this.deflateCompress(compressionLevel, newPixels, bitsPerPixel, imageWidth, imageHeight, buffer);
        } else {
            compression = TiffFieldEnum.Compression.PACKBITS;
            this.packbitsCompress(newPixels, bitsPerPixel, imageWidth, imageHeight);
        }
        tiffField = new ShortField(TiffTag.COMPRESSION.getValue(), new short[]{(short)compression.getValue()});
        this.ifd.addField(tiffField);
    }

    public int writePage(BufferedImage frame, int pageNumber, int maxNumber, RandomAccessOutputStream randomOutStream, int offset) throws Exception {
        int imageWidth = frame.getWidth();
        int imageHeight = frame.getHeight();
        int[] pixels = IMGUtils.getRGB(frame);
        this.ifd = new IFD();
        TiffField tiffField = new LongField(TiffTag.NEW_SUBFILE_TYPE.getValue(), new int[]{2});
        this.ifd.addField(tiffField);
        tiffField = new ShortField(TiffTag.PAGE_NUMBER.getValue(), new short[]{(short)pageNumber, (short)maxNumber});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_WIDTH.getValue(), new int[]{imageWidth});
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.IMAGE_LENGTH.getValue(), new int[]{imageHeight});
        this.ifd.addField(tiffField);
        this.reset(offset);
        this.randomOS = randomOutStream;
        this.randomOS.seek(this.stripOffset);
        ImageParam param = this.getImageParam();
        ImageOptions options = param.getImageOptions();
        if (options instanceof TIFFOptions) {
            this.tiffOptions = (TIFFOptions)options;
        }
        this.writePageData(param, pixels, imageWidth, imageHeight);
        tiffField = new LongField(TiffTag.STRIP_OFFSETS.getValue(), CollectionUtils.integerListToIntArray(this.stripOffsets));
        this.ifd.addField(tiffField);
        tiffField = new LongField(TiffTag.STRIP_BYTE_COUNTS.getValue(), CollectionUtils.integerListToIntArray(this.stripByteCounts));
        this.ifd.addField(tiffField);
        String softWare = "ICAFE - https://github.com/dragon66/icafe\u0000";
        tiffField = new ASCIIField(TiffTag.SOFTWARE.getValue(), softWare);
        this.ifd.addField(tiffField);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        tiffField = new ASCIIField(TiffTag.DATETIME.getValue(), formatter.format(new Date()) + '\u0000');
        this.ifd.addField(tiffField);
        int xResolution = 72;
        int yResolution = 72;
        int resolutionUnit = TiffFieldEnum.ResolutionUnit.RESUNIT_INCH.getValue();
        if (this.tiffOptions != null) {
            xResolution = this.tiffOptions.getXResolution();
            yResolution = this.tiffOptions.getYResolution();
            resolutionUnit = this.tiffOptions.getResolutionUnit().getValue();
        }
        this.ifd.addField(new RationalField(TiffTag.X_RESOLUTION.getValue(), new int[]{xResolution, 1}));
        this.ifd.addField(new RationalField(TiffTag.Y_RESOLUTION.getValue(), new int[]{yResolution, 1}));
        this.ifd.addField(new ShortField(TiffTag.RESOLUTION_UNIT.getValue(), new short[]{(short)resolutionUnit}));
        return this.ifd.write(this.randomOS, this.stripOffset);
    }

    private void writeTrueColor(int[] pixels, int imageWidth, int imageHeight, TiffFieldEnum.Compression compression) throws Exception {
        EnumSet<TiffFieldEnum.Compression> supportedCompressionTypes = TiffFieldEnum.Compression.forTrueColor();
        if (!supportedCompressionTypes.contains((Object)compression)) {
            throw new UnsupportedCompressionException("TrueColor Image only supports the following compression types: " + supportedCompressionTypes);
        }
        boolean applyPredictor = true;
        TiffFieldEnum.PhotoMetric photoMetric = TiffFieldEnum.PhotoMetric.RGB;
        boolean writeICCProfile = false;
        int numOfSamples = 3;
        if (this.tiffOptions != null) {
            applyPredictor = this.tiffOptions.isApplyPredictor();
            if (this.tiffOptions.getPhotoMetric() != TiffFieldEnum.PhotoMetric.UNKNOWN) {
                photoMetric = this.tiffOptions.getPhotoMetric();
            }
            if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED) {
                numOfSamples = 4;
                writeICCProfile = this.tiffOptions.writeICCProfile();
            }
        }
        switch (compression) {
            case LZW: 
            case DEFLATE: {
                break;
            }
            default: {
                applyPredictor = false;
            }
        }
        boolean hasAlpha = this.getImageParam().hasAlpha();
        int samplesPerPixel = hasAlpha ? numOfSamples + 1 : numOfSamples;
        this.ifd.addField(new ShortField(TiffTag.SAMPLES_PER_PIXEL.getValue(), new short[]{(short)samplesPerPixel}));
        short[] bitsPerSample = new short[samplesPerPixel];
        Arrays.fill(bitsPerSample, (short)8);
        this.ifd.addField(new ShortField(TiffTag.BITS_PER_SAMPLE.getValue(), bitsPerSample));
        if (hasAlpha) {
            this.ifd.addField(new ShortField(TiffTag.EXTRA_SAMPLES.getValue(), new short[]{2}));
        }
        byte[] samples = new byte[samplesPerPixel * pixels.length];
        if (photoMetric == TiffFieldEnum.PhotoMetric.RGB) {
            if (!hasAlpha) {
                int index = 0;
                for (int i = 0; i < pixels.length; ++i) {
                    samples[index++] = (byte)(pixels[i] >> 16 & 0xFF);
                    samples[index++] = (byte)(pixels[i] >> 8 & 0xFF);
                    samples[index++] = (byte)(pixels[i] & 0xFF);
                }
            } else {
                int index = 0;
                for (int i = 0; i < pixels.length; ++i) {
                    samples[index++] = (byte)(pixels[i] >> 16 & 0xFF);
                    samples[index++] = (byte)(pixels[i] >> 8 & 0xFF);
                    samples[index++] = (byte)(pixels[i] & 0xFF);
                    samples[index++] = (byte)(pixels[i] >> 24 & 0xFF);
                }
            }
        } else if (photoMetric == TiffFieldEnum.PhotoMetric.SEPARATED) {
            byte[] icc_profile;
            if (this.cmykColorSpace == null) {
                this.cmykColorSpace = IMGUtils.getICCColorSpace(pathToCMYKProfile);
            }
            samples = IMGUtils.RGB2CMYK(this.cmykColorSpace, pixels, imageWidth, imageHeight, hasAlpha);
            if (writeICCProfile && (icc_profile = this.cmykColorSpace.getProfile().getData()) != null) {
                this.ifd.addField(new UndefinedField(TiffTag.ICC_PROFILE.getValue(), icc_profile));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported TiffPhotoMetric: " + (Object)((Object)photoMetric));
        }
        if (applyPredictor) {
            TIFFWriter.applyPredictor(samplesPerPixel, samples, imageWidth, imageHeight);
            this.ifd.addField(new ShortField(TiffTag.PREDICTOR.getValue(), new short[]{2}));
        }
        this.compressSample(samples, samplesPerPixel * imageWidth, imageHeight, compression, 1024);
        this.ifd.addField(new ShortField(TiffTag.PLANAR_CONFIGURATTION.getValue(), new short[]{(short)TiffFieldEnum.PlanarConfiguration.CONTIGUOUS.getValue()}));
        this.ifd.addField(new ShortField(TiffTag.PHOTOMETRIC_INTERPRETATION.getValue(), new short[]{(short)photoMetric.getValue()}));
    }
}

