/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.ReadStrategy;
import guilibshadow.cafe4j.io.ReadStrategyMM;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class EndianAwareInputStream
extends InputStream
implements DataInput {
    private InputStream src;
    private ReadStrategy strategy = ReadStrategyMM.getInstance();

    public EndianAwareInputStream(InputStream is) {
        this.src = is;
    }

    @Override
    public int read() throws IOException {
        return this.src.read();
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        return (char)(this.readShort() & 0xFFFF);
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.src.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    @Override
    public int readInt() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return this.strategy.readInt(buf, 0);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine is not supported by RandomAccessInputStream.");
    }

    @Override
    public long readLong() throws IOException {
        byte[] buf = new byte[8];
        this.readFully(buf);
        return this.strategy.readLong(buf, 0);
    }

    public float readS15Fixed16Number() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return this.strategy.readS15Fixed16Number(buf, 0);
    }

    @Override
    public short readShort() throws IOException {
        byte[] buf = new byte[2];
        this.readFully(buf);
        return this.strategy.readShort(buf, 0);
    }

    public float readU16Fixed16Number() throws IOException {
        byte[] buf = new byte[4];
        this.readFully(buf);
        return this.strategy.readU16Fixed16Number(buf, 0);
    }

    public float readU8Fixed8Number() throws IOException {
        byte[] buf = new byte[2];
        this.readFully(buf);
        return this.strategy.readU8Fixed8Number(buf, 0);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        return new DataInputStream(this).readUTF();
    }

    public void setReadStrategy(ReadStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int bytes = this.src.read(new byte[n], 0, n);
        return bytes;
    }

    @Override
    public void close() throws IOException {
        this.src.close();
    }
}

