/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.WriteStrategy;
import guilibshadow.cafe4j.io.WriteStrategyMM;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianAwareOutputStream
extends OutputStream
implements DataOutput {
    private OutputStream out;
    private WriteStrategy strategy = WriteStrategyMM.getInstance();

    public EndianAwareOutputStream(OutputStream os) {
        this.out = os;
    }

    public void setWriteStrategy(WriteStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void write(int value) throws IOException {
        this.out.write(value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.write(value);
    }

    @Override
    public void writeBytes(String value) throws IOException {
        new DataOutputStream(this).writeBytes(value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.writeShort(value);
    }

    @Override
    public void writeChars(String value) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char v = value.charAt(i);
            this.writeShort(v);
        }
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeInt(int value) throws IOException {
        byte[] buf = new byte[4];
        this.strategy.writeInt(buf, 0, value);
        this.write(buf, 0, 4);
    }

    @Override
    public void writeLong(long value) throws IOException {
        byte[] buf = new byte[8];
        this.strategy.writeLong(buf, 0, value);
        this.write(buf, 0, 8);
    }

    public void writeS15Fixed16Number(float value) throws IOException {
        byte[] buf = new byte[4];
        this.strategy.writeS15Fixed16Number(buf, 0, value);
        this.write(buf, 0, 4);
    }

    @Override
    public void writeShort(int value) throws IOException {
        byte[] buf = new byte[2];
        this.strategy.writeShort(buf, 0, value);
        this.write(buf, 0, 2);
    }

    public void writeU16Fixed16Number(float value) throws IOException {
        byte[] buf = new byte[4];
        this.strategy.writeU16Fixed16Number(buf, 0, value);
        this.write(buf, 0, 4);
    }

    public void writeU8Fixed8Number(float value) throws IOException {
        byte[] buf = new byte[2];
        this.strategy.writeU8Fixed8Number(buf, 0, value);
        this.write(buf, 0, 2);
    }

    @Override
    public void writeUTF(String value) throws IOException {
        new DataOutputStream(this).writeUTF(value);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

