/*
 * Decompiled with CFR 0.152.
 */
package guilibshadow.cafe4j.io;

import guilibshadow.cafe4j.io.RandomAccessOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class FileCacheRandomAccessOutputStream
extends RandomAccessOutputStream {
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 4096;
    private long length = 0L;
    private long pointer = 0L;
    private long flushPos = 0L;

    public FileCacheRandomAccessOutputStream(OutputStream dist) throws IOException {
        super(dist);
        this.cacheFile = File.createTempFile("cafe-FCRAOS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    public FileCacheRandomAccessOutputStream(OutputStream dist, int bufLen) throws IOException {
        super(dist);
        this.bufLen = bufLen;
        this.cacheFile = File.createTempFile("cafe-FCRAOS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.dist.close();
        this.dist = null;
        this.closed = true;
    }

    @Override
    public void shallowClose() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.cache.close();
        this.cacheFile.delete();
        this.dist = null;
        this.closed = true;
    }

    @Override
    public void disposeBefore(long pos) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public long getFlushPos() {
        return this.flushPos;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getStreamPointer() {
        return this.pointer;
    }

    @Override
    public void reset() {
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ensureOpen();
        if (pos < 0L) {
            throw new IOException("Negtive seek position.");
        }
        this.pointer = pos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || this.pointer < 0L || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        long lastPos = this.pointer + (long)len - 1L;
        if (lastPos >= this.length) {
            this.length = lastPos + 1L;
        }
        this.cache.seek(this.pointer);
        this.cache.write(b, off, len);
        this.pointer += (long)len;
    }

    @Override
    public void write(int value) throws IOException {
        this.ensureOpen();
        if (this.pointer < 0L) {
            throw new IndexOutOfBoundsException("pointer < 0");
        }
        if (this.pointer >= this.length) {
            this.length = this.pointer + 1L;
        }
        this.cache.seek(this.pointer);
        this.cache.write(value);
        ++this.pointer;
    }

    @Override
    public void writeToStream(long len) throws IOException {
        this.ensureOpen();
        if (len == 0L) {
            return;
        }
        if (this.pointer + len > this.length) {
            throw new IndexOutOfBoundsException("Argument out of cache");
        }
        if (this.pointer < 0L || len < 0L) {
            throw new IndexOutOfBoundsException("Negative pointer or len");
        }
        this.cache.seek(this.pointer);
        while (len > 0L) {
            byte[] buf = new byte[this.bufLen];
            int nbytes = this.cache.read(buf);
            this.dist.write(buf, 0, nbytes);
            len -= (long)nbytes;
            this.flushPos += (long)nbytes;
        }
    }
}

